/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml.plantuml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.code.ArobaseStringCompressor;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;
import nl.talsmasoftware.umldoclet.uml.plantuml.PlantumlGenerator;

@SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="We only allow http(s) urls.")
public class RemotePlantumlGenerator
implements PlantumlGenerator {
    public static final Pattern HTTP_URLS = Pattern.compile("^https?://");
    private static final String DEFAULT_PLANTUML_BASE_URL = "https://www.plantuml.com/plantuml/";
    private static final Transcoder TRANSCODER = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionZlib());
    private final String baseUrl;

    public RemotePlantumlGenerator(String baseUrl) {
        Object url = Objects.toString(baseUrl, DEFAULT_PLANTUML_BASE_URL);
        if (!HTTP_URLS.matcher((CharSequence)url).find()) {
            throw new IllegalArgumentException("Unsupported PlantUML server base url: [" + (String)url + "].");
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.baseUrl = url;
    }

    @Override
    public void generatePlantumlDiagramFromSource(String plantumlSource, FileFormat format, OutputStream out) {
        String encodedDiagram = this.encodeDiagram(plantumlSource);
        String diagramUrl = this.baseUrl + format.name().toLowerCase() + "/" + encodedDiagram;
        try (InputStream in = new URL(diagramUrl).openConnection().getInputStream();){
            byte[] buf = new byte[4096];
            int read = in.read(buf);
            while (read >= 0) {
                out.write(buf, 0, read);
                read = in.read(buf);
            }
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("Error generating diagram: " + e.getMessage(), e);
        }
    }

    private String encodeDiagram(String diagramSource) {
        try {
            return TRANSCODER.encode(Objects.requireNonNull(diagramSource, "UML diagram source was <null>."));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error encoding diagram: " + ioe.getMessage(), ioe);
        }
    }
}

