/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.opensaml.util.storage.ExpiringObject;
import org.opensaml.util.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringObjectStorageServiceSweeper
extends TimerTask {
    private final Logger log = LoggerFactory.getLogger(ExpiringObjectStorageServiceSweeper.class);
    private StorageService store;
    private Set<String> partitions;

    public ExpiringObjectStorageServiceSweeper(Timer taskTimer, long sweepInterval, StorageService sweptStore) {
        this.store = sweptStore;
        taskTimer.schedule((TimerTask)this, sweepInterval, sweepInterval);
        this.partitions = null;
    }

    public ExpiringObjectStorageServiceSweeper(Timer taskTimer, long sweepInterval, StorageService sweptStore, Set<String> sweptPartitions) {
        this.store = sweptStore;
        this.partitions = sweptPartitions != null || sweptPartitions.isEmpty() ? sweptPartitions : null;
        taskTimer.schedule((TimerTask)this, sweepInterval, sweepInterval);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        sweepPartitions = this.partitions != null && !this.partitions.isEmpty() ? this.partitions.iterator() : this.store.getPartitions();
        while (sweepPartitions.hasNext()) {
            currentParition = sweepPartitions.next();
            this.log.trace("Sweeping storage service partition {}", (Object)currentParition);
            partitionKeys = this.store.getKeys(currentParition);
            if (partitionKeys != null) ** GOTO lbl13
            continue;
lbl-1000:
            // 1 sources

            {
                partitionKey = partitionKeys.next();
                partitionValue = this.store.get(currentParition, partitionKey);
                if (!(partitionValue instanceof ExpiringObject) || !((ExpiringObject)partitionValue).isExpired()) continue;
                this.log.trace("Removing expired object from storage service partition {}", (Object)currentParition);
                partitionKeys.remove();
lbl13:
                // 3 sources

                ** while (partitionKeys.hasNext())
            }
lbl14:
            // 1 sources

        }
    }
}

