/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatatypeHelper {
    private DatatypeHelper() {
    }

    public static boolean isEmpty(String s) {
        String sTrimmed;
        return s == null || (sTrimmed = s.trim()).length() <= 0;
    }

    public static <T> boolean safeEquals(T s1, T s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public static String safeTrim(String s) {
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public static String safeTrimOrNullString(String s) {
        String sTrimmed;
        if (s != null && (sTrimmed = s.trim()).length() > 0) {
            return sTrimmed;
        }
        return null;
    }

    public static byte[] intToByteArray(int integer) {
        byte[] intBytes = new byte[]{(byte)((integer & 0xFF000000) >>> 24), (byte)((integer & 0xFF0000) >>> 16), (byte)((integer & 0xFF00) >>> 8), (byte)(integer & 0xFF)};
        return intBytes;
    }

    public static byte[] fileToByteArray(File file) throws IOException {
        long numOfBytes = file.length();
        if (numOfBytes > Integer.MAX_VALUE) {
            throw new IOException("File is to large to be read in to a byte array");
        }
        byte[] bytes = new byte[(int)numOfBytes];
        FileInputStream ins = new FileInputStream(file);
        int offset = 0;
        int numRead = 0;
        while ((offset += (numRead = ins.read(bytes, offset, bytes.length - offset))) < bytes.length && numRead >= 0) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ins.close();
        return bytes;
    }

    public static String inputstreamToString(InputStream input, CharsetDecoder decoder) throws IOException {
        CharsetDecoder charsetDecoder = decoder;
        if (decoder == null) {
            charsetDecoder = Charset.defaultCharset().newDecoder();
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, charsetDecoder));
        char[] chars = new char[1024];
        while (reader.read(chars) > -1) {
            stringBuffer.append(String.valueOf(chars));
            chars = new char[1024];
        }
        reader.close();
        return stringBuffer.toString();
    }
}

