/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionDecorator;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceMapping;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterInvocationDefinitionSourceEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor == null ? (class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor = FilterInvocationDefinitionSourceEditor.class$("org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceEditor")) : class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor));
    public static final String DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON = "CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON";
    public static final String DIRECTIVE_PATTERN_TYPE_APACHE_ANT = "PATTERN_TYPE_APACHE_ANT";
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditor;

    public void setAsText(String s) throws IllegalArgumentException {
        FilterInvocationDefinitionDecorator source = new FilterInvocationDefinitionDecorator();
        source.setDecorated(new RegExpBasedFilterInvocationDefinitionMap());
        if (s != null && !"".equals(s)) {
            if (s.lastIndexOf(DIRECTIVE_PATTERN_TYPE_APACHE_ANT) != -1) {
                source.setDecorated(new PathBasedFilterInvocationDefinitionMap());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Detected PATTERN_TYPE_APACHE_ANT directive; using Apache Ant style path expressions");
                }
            }
            if (s.lastIndexOf(DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON) != -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Detected CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON directive; Instructing mapper to convert URLs to lowercase before comparison");
                }
                source.setConvertUrlToLowercaseBeforeComparison(true);
            }
            BufferedReader br = new BufferedReader(new StringReader(s));
            int counter = 0;
            ArrayList<FilterInvocationDefinitionSourceMapping> mappings = new ArrayList<FilterInvocationDefinitionSourceMapping>();
            while (true) {
                String line;
                ++counter;
                try {
                    line = br.readLine();
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe.getMessage());
                }
                if (line == null) break;
                line = line.trim();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Line " + counter + ": " + line));
                }
                if (line.startsWith("//")) continue;
                if (line.lastIndexOf(DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON) != -1 && (line.lastIndexOf(DIRECTIVE_PATTERN_TYPE_APACHE_ANT) != -1 || line.lastIndexOf("=") != -1)) {
                    throw new IllegalArgumentException("Line appears to be malformed: " + line);
                }
                if (line.lastIndexOf(DIRECTIVE_PATTERN_TYPE_APACHE_ANT) != -1 && (line.lastIndexOf(DIRECTIVE_CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON) != -1 || line.lastIndexOf("=") != -1)) {
                    throw new IllegalArgumentException("Line appears to be malformed: " + line);
                }
                if (line.lastIndexOf(61) == -1) continue;
                if (line.lastIndexOf("==") != -1) {
                    throw new IllegalArgumentException("Only single equals should be used in line " + line);
                }
                String name = StringUtils.substringBeforeLast((String)line, (String)"=");
                String value = StringUtils.substringAfterLast((String)line, (String)"=");
                if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)value)) {
                    throw new IllegalArgumentException("Failed to parse a valid name/value pair from " + line);
                }
                if (source.isConvertUrlToLowercaseBeforeComparison() && source.getDecorated() instanceof PathBasedFilterInvocationDefinitionMap) {
                    for (int i = 0; i < name.length(); ++i) {
                        String character = name.substring(i, i + 1);
                        if (character.toLowerCase().equals(character)) continue;
                        throw new IllegalArgumentException("You are using the CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON with Ant Paths, yet you have specified an uppercase character in line: " + line + " (character '" + character + "')");
                    }
                }
                FilterInvocationDefinitionSourceMapping mapping = new FilterInvocationDefinitionSourceMapping();
                mapping.setUrl(name);
                String[] tokens = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)value);
                for (int i = 0; i < tokens.length; ++i) {
                    mapping.addConfigAttribute(tokens[i].trim());
                }
                mappings.add(mapping);
            }
            source.setMappings(mappings);
        }
        this.setValue(source.getDecorated());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

