/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.digestauth;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.ui.digestauth.NonceExpiredException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;

public class DigestProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean,
Ordered {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPoint == null ? (class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPoint = DigestProcessingFilterEntryPoint.class$("org.acegisecurity.ui.digestauth.DigestProcessingFilterEntryPoint")) : class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPoint));
    private String key;
    private String realmName;
    private int nonceValiditySeconds = 300;
    private int order = Integer.MAX_VALUE;
    static /* synthetic */ Class class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPoint;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.realmName == null || "".equals(this.realmName)) {
            throw new IllegalArgumentException("realmName must be specified");
        }
        if (this.key == null || "".equals(this.key)) {
            throw new IllegalArgumentException("key must be specified");
        }
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        long expiryTime = System.currentTimeMillis() + (long)(this.nonceValiditySeconds * 1000);
        String signatureValue = new String(DigestUtils.md5Hex((String)(expiryTime + ":" + this.key)));
        String nonceValue = expiryTime + ":" + signatureValue;
        String nonceValueBase64 = new String(Base64.encodeBase64((byte[])nonceValue.getBytes()));
        String authenticateHeader = "Digest realm=\"" + this.realmName + "\", " + "qop=\"auth\", nonce=\"" + nonceValueBase64 + "\"";
        if (authException instanceof NonceExpiredException) {
            authenticateHeader = authenticateHeader + ", stale=\"true\"";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WWW-Authenticate header sent to user agent: " + authenticateHeader));
        }
        httpResponse.addHeader("WWW-Authenticate", authenticateHeader);
        httpResponse.sendError(401, authException.getMessage());
    }

    public String getKey() {
        return this.key;
    }

    public int getNonceValiditySeconds() {
        return this.nonceValiditySeconds;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setNonceValiditySeconds(int nonceValiditySeconds) {
        this.nonceValiditySeconds = nonceValiditySeconds;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

