/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acls.jdbc;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.UnloadedSidException;
import org.acegisecurity.acls.domain.AccessControlEntryImpl;
import org.acegisecurity.acls.domain.AclAuthorizationStrategy;
import org.acegisecurity.acls.domain.AclImpl;
import org.acegisecurity.acls.domain.AuditLogger;
import org.acegisecurity.acls.domain.BasePermission;
import org.acegisecurity.acls.jdbc.AclCache;
import org.acegisecurity.acls.jdbc.LookupStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityImpl;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.util.FieldUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.util.Assert;

public final class BasicLookupStrategy
implements LookupStrategy {
    private AclAuthorizationStrategy aclAuthorizationStrategy;
    private AclCache aclCache;
    private AuditLogger auditLogger;
    private JdbcTemplate jdbcTemplate;
    private int batchSize = 50;
    static /* synthetic */ Class class$org$acegisecurity$acls$domain$AclImpl;
    static /* synthetic */ Class class$java$lang$Long;

    public BasicLookupStrategy(DataSource dataSource, AclCache aclCache, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        Assert.notNull((Object)aclCache, (String)"AclCache required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)auditLogger, (String)"AuditLogger required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.aclCache = aclCache;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.auditLogger = auditLogger;
    }

    private static String computeRepeatingSql(String repeatingSql, int requiredRepetitions) {
        Assert.isTrue((requiredRepetitions >= 1 ? 1 : 0) != 0, (String)"Must be => 1");
        String startSql = "select ACL_OBJECT_IDENTITY.OBJECT_ID_IDENTITY, ACL_ENTRY.ACE_ORDER, ACL_OBJECT_IDENTITY.ID as ACL_ID, ACL_OBJECT_IDENTITY.PARENT_OBJECT, ACL_OBJECT_IDENTITY,ENTRIES_INHERITING, ACL_ENTRY.ID as ACE_ID, ACL_ENTRY.MASK, ACL_ENTRY.GRANTING, ACL_ENTRY.AUDIT_SUCCESS, ACL_ENTRY.AUDIT_FAILURE, ACL_SID.PRINCIPAL as ACE_PRINCIPAL, ACL_SID.SID as ACE_SID, ACLI_SID.PRINCIPAL as ACL_PRINCIPAL, ACLI_SID.SID as ACL_SID, ACL_CLASS.CLASS from ACL_OBJECT_IDENTITY, ACL_SID ACLI_SID, ACL_CLASS LEFT JOIN ACL_ENTRY ON ACL_OBJECT_IDENTITY.ID = ACL_ENTRY.ACL_OBJECT_IDENTITY LEFT JOIN ACL_SID ON ACL_ENTRY.SID = ACL_SID.ID where ACLI_SID.ID = ACL_OBJECT_IDENTITY.OWNER_SID and ACL_CLASS.ID = ACL_OBJECT_IDENTITY.OBJECT_ID_CLASS and ( ";
        String endSql = ") order by ACL_OBJECT_IDENTITY.OBJECT_ID_IDENTITY asc, ACL_ENTRY.ACE_ORDER asc";
        StringBuffer sqlStringBuffer = new StringBuffer();
        sqlStringBuffer.append(startSql);
        for (int i = 1; i <= requiredRepetitions; ++i) {
            sqlStringBuffer.append(repeatingSql);
            if (i == requiredRepetitions) continue;
            sqlStringBuffer.append(" or ");
        }
        sqlStringBuffer.append(endSql);
        return sqlStringBuffer.toString();
    }

    private AclImpl convert(Map inputMap, Long currentIdentity) {
        Assert.notEmpty((Map)inputMap, (String)"InputMap required");
        Assert.notNull((Object)currentIdentity, (String)"CurrentIdentity required");
        Acl uncastAcl = (Acl)inputMap.get(currentIdentity);
        Assert.isInstanceOf((Class)(class$org$acegisecurity$acls$domain$AclImpl == null ? (class$org$acegisecurity$acls$domain$AclImpl = BasicLookupStrategy.class$("org.acegisecurity.acls.domain.AclImpl")) : class$org$acegisecurity$acls$domain$AclImpl), (Object)uncastAcl, (String)"The inputMap contained a non-AclImpl");
        AclImpl inputAcl = (AclImpl)uncastAcl;
        Acl parent = inputAcl.getParentAcl();
        if (parent != null && parent instanceof StubAclParent) {
            StubAclParent stubAclParent = (StubAclParent)parent;
            parent = this.convert(inputMap, stubAclParent.getId());
        }
        AclImpl result = new AclImpl(inputAcl.getObjectIdentity(), (Long)inputAcl.getId(), this.aclAuthorizationStrategy, this.auditLogger, parent, null, inputAcl.isEntriesInheriting(), inputAcl.getOwner());
        Field field = FieldUtils.getField(class$org$acegisecurity$acls$domain$AclImpl == null ? (class$org$acegisecurity$acls$domain$AclImpl = BasicLookupStrategy.class$("org.acegisecurity.acls.domain.AclImpl")) : class$org$acegisecurity$acls$domain$AclImpl, "aces");
        try {
            field.setAccessible(true);
            field.set(result, field.get(inputAcl));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Could not obtain or set AclImpl.ace field");
        }
        return result;
    }

    private void convertCurrentResultIntoObject(Map acls, ResultSet rs) throws SQLException {
        Long id = new Long(rs.getLong("ACL_ID"));
        AclImpl acl = (AclImpl)acls.get(id);
        if (acl == null) {
            ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(rs.getString("CLASS"), (Serializable)new Long(rs.getLong("OBJECT_ID_IDENTITY")));
            StubAclParent parentAcl = null;
            long parentAclId = rs.getLong("PARENT_OBJECT");
            if (parentAclId != 0L) {
                parentAcl = new StubAclParent(new Long(parentAclId));
            }
            boolean entriesInheriting = rs.getBoolean("ENTRIES_INHERITING");
            Sid owner = rs.getBoolean("ACL_PRINCIPAL") ? new PrincipalSid(rs.getString("ACL_SID")) : new GrantedAuthoritySid(rs.getString("ACL_SID"));
            acl = new AclImpl(objectIdentity, id, this.aclAuthorizationStrategy, this.auditLogger, parentAcl, null, entriesInheriting, owner);
            acls.put(id, acl);
        }
        if (rs.getString("ACE_SID") != null) {
            List aces;
            Long aceId = new Long(rs.getLong("ACE_ID"));
            Sid recipient = rs.getBoolean("ACE_PRINCIPAL") ? new PrincipalSid(rs.getString("ACE_SID")) : new GrantedAuthoritySid(rs.getString("ACE_SID"));
            Permission permission = BasePermission.buildFromMask(rs.getInt("MASK"));
            boolean granting = rs.getBoolean("GRANTING");
            boolean auditSuccess = rs.getBoolean("AUDIT_SUCCESS");
            boolean auditFailure = rs.getBoolean("AUDIT_FAILURE");
            AccessControlEntryImpl ace = new AccessControlEntryImpl(aceId, acl, recipient, permission, granting, auditSuccess, auditFailure);
            Field acesField = FieldUtils.getField(class$org$acegisecurity$acls$domain$AclImpl == null ? (class$org$acegisecurity$acls$domain$AclImpl = BasicLookupStrategy.class$("org.acegisecurity.acls.domain.AclImpl")) : class$org$acegisecurity$acls$domain$AclImpl, "aces");
            try {
                acesField.setAccessible(true);
                aces = (List)acesField.get(acl);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Could not obtain AclImpl.ace field: cause[" + ex.getMessage() + "]");
            }
            if (!aces.contains(ace)) {
                aces.add(ace);
            }
        }
    }

    private Map lookupObjectIdentities(final ObjectIdentity[] objectIdentities, Sid[] sids) {
        Assert.notEmpty((Object[])objectIdentities, (String)"Must provide identities to lookup");
        HashMap acls = new HashMap();
        String sql = BasicLookupStrategy.computeRepeatingSql("(ACL_OBJECT_IDENTITY.OBJECT_ID_IDENTITY = ? and ACL_CLASS.CLASS = ?)", objectIdentities.length);
        this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                for (int i = 0; i < objectIdentities.length; ++i) {
                    String javaType = objectIdentities[i].getJavaType().getName();
                    Assert.isInstanceOf((Class)(class$java$lang$Long == null ? BasicLookupStrategy.class$("java.lang.Long") : class$java$lang$Long), (Object)objectIdentities[i].getIdentifier(), (String)"This class requires ObjectIdentity.getIdentifier() to be a Long");
                    long id = (Long)objectIdentities[i].getIdentifier();
                    ps.setLong(2 * i + 1, id);
                    ps.setString(2 * i + 2, javaType);
                }
            }
        }, (ResultSetExtractor)new ProcessResultSet(acls, sids));
        HashMap<ObjectIdentity, AclImpl> resultMap = new HashMap<ObjectIdentity, AclImpl>();
        Iterator iter = acls.values().iterator();
        while (iter.hasNext()) {
            Acl inputAcl = (Acl)iter.next();
            Assert.isInstanceOf((Class)(class$org$acegisecurity$acls$domain$AclImpl == null ? BasicLookupStrategy.class$("org.acegisecurity.acls.domain.AclImpl") : class$org$acegisecurity$acls$domain$AclImpl), (Object)inputAcl, (String)"Map should have contained an AclImpl");
            Assert.isInstanceOf((Class)(class$java$lang$Long == null ? BasicLookupStrategy.class$("java.lang.Long") : class$java$lang$Long), (Object)((AclImpl)inputAcl).getId(), (String)"Acl.getId() must be Long");
            AclImpl result = this.convert(acls, (Long)((AclImpl)inputAcl).getId());
            resultMap.put(result.getObjectIdentity(), result);
        }
        return resultMap;
    }

    private void lookupPrimaryKeys(Map acls, final Set findNow, Sid[] sids) {
        Assert.notNull((Object)acls, (String)"ACLs are required");
        Assert.notEmpty((Collection)findNow, (String)"Items to find now required");
        String sql = BasicLookupStrategy.computeRepeatingSql("(ACL_OBJECT_IDENTITY.ID = ?)", findNow.size());
        this.jdbcTemplate.query(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                Iterator iter = findNow.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    ps.setLong(++i, (Long)iter.next());
                }
            }
        }, (ResultSetExtractor)new ProcessResultSet(acls, sids));
    }

    public Map readAclsById(ObjectIdentity[] objects, Sid[] sids) throws NotFoundException {
        int i;
        Assert.isTrue((this.batchSize >= 1 ? 1 : 0) != 0, (String)"BatchSize must be >= 1");
        Assert.notEmpty((Object[])objects, (String)"Objects to lookup required");
        HashMap<ObjectIdentity, MutableAcl> result = new HashMap<ObjectIdentity, MutableAcl>();
        HashSet<ObjectIdentity> currentBatchToLoad = new HashSet<ObjectIdentity>();
        for (i = 0; i < objects.length; ++i) {
            if (result.containsKey(objects[i])) continue;
            MutableAcl acl = this.aclCache.getFromCache(objects[i]);
            if (acl != null) {
                if (acl.isSidLoaded(sids)) {
                    result.put(acl.getObjectIdentity(), acl);
                    continue;
                }
                throw new IllegalStateException("Error: SID-filtered element detected when implementation does not perform SID filtering - have you added something to the cache manually?");
            }
            currentBatchToLoad.add(objects[i]);
            if (currentBatchToLoad.size() != this.batchSize && i + 1 != objects.length) continue;
            Map loadedBatch = this.lookupObjectIdentities(currentBatchToLoad.toArray(new ObjectIdentity[0]), sids);
            result.putAll(loadedBatch);
            Iterator loadedAclIterator = loadedBatch.values().iterator();
            while (loadedAclIterator.hasNext()) {
                this.aclCache.putInCache((AclImpl)loadedAclIterator.next());
            }
            currentBatchToLoad.clear();
        }
        for (i = 0; i < objects.length; ++i) {
            if (result.containsKey(objects[i])) continue;
            throw new NotFoundException("Unable to find ACL information for object identity '" + objects[i].toString() + "'");
        }
        return result;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StubAclParent
    implements Acl {
        private Long id;

        public StubAclParent(Long id) {
            this.id = id;
        }

        public AccessControlEntry[] getEntries() {
            throw new UnsupportedOperationException("Stub only");
        }

        public Long getId() {
            return this.id;
        }

        public ObjectIdentity getObjectIdentity() {
            throw new UnsupportedOperationException("Stub only");
        }

        public Sid getOwner() {
            throw new UnsupportedOperationException("Stub only");
        }

        public Acl getParentAcl() {
            throw new UnsupportedOperationException("Stub only");
        }

        public boolean isEntriesInheriting() {
            throw new UnsupportedOperationException("Stub only");
        }

        public boolean isGranted(Permission[] permission, Sid[] sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
            throw new UnsupportedOperationException("Stub only");
        }

        public boolean isSidLoaded(Sid[] sids) {
            throw new UnsupportedOperationException("Stub only");
        }
    }

    private class ProcessResultSet
    implements ResultSetExtractor {
        private Map acls;
        private Sid[] sids;

        public ProcessResultSet(Map acls, Sid[] sids) {
            Assert.notNull((Object)acls, (String)"ACLs cannot be null");
            this.acls = acls;
            this.sids = sids;
        }

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            HashSet<Long> parentIdsToLookup = new HashSet<Long>();
            while (rs.next()) {
                BasicLookupStrategy.this.convertCurrentResultIntoObject(this.acls, rs);
                long parentId = rs.getLong("PARENT_OBJECT");
                if (parentId == 0L || this.acls.containsKey(new Long(parentId))) continue;
                MutableAcl cached = BasicLookupStrategy.this.aclCache.getFromCache(new Long(parentId));
                if (cached == null || !cached.isSidLoaded(this.sids)) {
                    parentIdsToLookup.add(new Long(parentId));
                    continue;
                }
                this.acls.put(cached.getId(), cached);
            }
            if (parentIdsToLookup.size() > 0) {
                BasicLookupStrategy.this.lookupPrimaryKeys(this.acls, parentIdsToLookup, this.sids);
            }
            return null;
        }
    }
}

