/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.deployer;

import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.util.CollectionUtil;

public class EventSubscriptionManager {
    protected void removeObsoleteEventSubscriptionsImpl(ProcessDefinitionEntity processDefinition, String eventHandlerType) {
        EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> subscriptionsToDelete = eventSubscriptionEntityManager.findEventSubscriptionsByTypeAndProcessDefinitionId(eventHandlerType, processDefinition.getId(), processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
            eventSubscriptionEntityManager.delete(eventSubscriptionEntity);
        }
    }

    protected void removeObsoleteMessageEventSubscriptions(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptionsImpl(previousProcessDefinition, "message");
        }
    }

    protected void removeObsoleteSignalEventSubScription(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptionsImpl(previousProcessDefinition, "signal");
        }
    }

    protected void addMessageEventSubscriptions(ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty(process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                this.insertMessageEvent(messageEventDefinition, startEvent, processDefinition, bpmnModel);
            }
        }
    }

    protected void insertMessageEvent(MessageEventDefinition messageEventDefinition, StartEvent startEvent, ProcessDefinitionEntity processDefinition, BpmnModel bpmnModel) {
        CommandContext commandContext = Context.getCommandContext();
        if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageEventDefinition.getMessageRef());
            messageEventDefinition.setMessageRef(message.getName());
        }
        List<EventSubscriptionEntity> subscriptionsForSameMessageName = commandContext.getEventSubscriptionEntityManager().findEventSubscriptionsByName("message", messageEventDefinition.getMessageRef(), processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsForSameMessageName) {
            if (eventSubscriptionEntity.getProcessInstanceId() != null && !eventSubscriptionEntity.getProcessInstanceId().isEmpty()) continue;
            throw new ActivitiException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there already is a message event subscription for the message with name '" + messageEventDefinition.getMessageRef() + "'.");
        }
        MessageEventSubscriptionEntity newSubscription = commandContext.getEventSubscriptionEntityManager().createMessageEventSubscription();
        newSubscription.setEventName(messageEventDefinition.getMessageRef());
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(processDefinition.getId());
        newSubscription.setProcessDefinitionId(processDefinition.getId());
        if (processDefinition.getTenantId() != null) {
            newSubscription.setTenantId(processDefinition.getTenantId());
        }
        commandContext.getEventSubscriptionEntityManager().insert(newSubscription);
    }

    protected void addSignalEventSubscriptions(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty(process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof SignalEventDefinition)) continue;
                SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
                SignalEventSubscriptionEntity subscriptionEntity = commandContext.getEventSubscriptionEntityManager().createSignalEventSubscription();
                Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
                if (signal != null) {
                    subscriptionEntity.setEventName(signal.getName());
                } else {
                    subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
                }
                subscriptionEntity.setActivityId(startEvent.getId());
                subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    subscriptionEntity.setTenantId(processDefinition.getTenantId());
                }
                Context.getCommandContext().getEventSubscriptionEntityManager().insert(subscriptionEntity);
            }
        }
    }
}

