// $ANTLR 3.5.2 org\\antlr\\v4\\parse\\ANTLRParser.g 2014-06-18 21:28:25

/*
 [The "BSD licence"]
 Copyright (c) 2005-20012 Terence Parr
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package org.antlr.v4.parse;

import org.antlr.v4.tool.*;
import org.antlr.v4.tool.ast.*;

import java.util.ArrayDeque;
import java.util.Deque;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/** The definitive ANTLR v3 grammar to parse ANTLR v4 grammars.
 *  The grammar builds ASTs that are sniffed by subsequent stages.
 */
@SuppressWarnings("all")
public class ANTLRParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ACTION", "ACTION_CHAR_LITERAL", 
		"ACTION_ESC", "ACTION_STRING_LITERAL", "ARG_ACTION", "ARG_OR_CHARSET", 
		"ASSIGN", "AT", "CATCH", "COLON", "COLONCOLON", "COMMA", "COMMENT", "DOC_COMMENT", 
		"DOLLAR", "DOT", "ERRCHAR", "ESC_SEQ", "FINALLY", "FRAGMENT", "GRAMMAR", 
		"GT", "HEX_DIGIT", "ID", "IMPORT", "INT", "LEXER", "LEXER_CHAR_SET", "LOCALS", 
		"LPAREN", "LT", "MODE", "NESTED_ACTION", "NLCHARS", "NOT", "NameChar", 
		"NameStartChar", "OPTIONS", "OR", "PARSER", "PLUS", "PLUS_ASSIGN", "POUND", 
		"PRIVATE", "PROTECTED", "PUBLIC", "QUESTION", "RANGE", "RARROW", "RBRACE", 
		"RETURNS", "RPAREN", "RULE_REF", "SEMI", "SEMPRED", "SRC", "STAR", "STRING_LITERAL", 
		"SYNPRED", "THROWS", "TOKENS_SPEC", "TOKEN_REF", "TREE_GRAMMAR", "UNICODE_ESC", 
		"UnicodeBOM", "WS", "WSCHARS", "WSNLCHARS", "ALT", "ALTLIST", "ARG", "ARGLIST", 
		"BLOCK", "CHAR_RANGE", "CLOSURE", "COMBINED", "ELEMENT_OPTIONS", "EPSILON", 
		"INITACTION", "LABEL", "LEXER_ACTION_CALL", "LEXER_ALT_ACTION", "LIST", 
		"OPTIONAL", "POSITIVE_CLOSURE", "PREC_RULE", "RESULT", "RET", "RULE", 
		"RULEACTIONS", "RULEMODIFIERS", "RULES", "SET", "TEMPLATE", "WILDCARD"
	};
	public static final int EOF=-1;
	public static final int ACTION=4;
	public static final int ACTION_CHAR_LITERAL=5;
	public static final int ACTION_ESC=6;
	public static final int ACTION_STRING_LITERAL=7;
	public static final int ARG_ACTION=8;
	public static final int ARG_OR_CHARSET=9;
	public static final int ASSIGN=10;
	public static final int AT=11;
	public static final int CATCH=12;
	public static final int COLON=13;
	public static final int COLONCOLON=14;
	public static final int COMMA=15;
	public static final int COMMENT=16;
	public static final int DOC_COMMENT=17;
	public static final int DOLLAR=18;
	public static final int DOT=19;
	public static final int ERRCHAR=20;
	public static final int ESC_SEQ=21;
	public static final int FINALLY=22;
	public static final int FRAGMENT=23;
	public static final int GRAMMAR=24;
	public static final int GT=25;
	public static final int HEX_DIGIT=26;
	public static final int ID=27;
	public static final int IMPORT=28;
	public static final int INT=29;
	public static final int LEXER=30;
	public static final int LEXER_CHAR_SET=31;
	public static final int LOCALS=32;
	public static final int LPAREN=33;
	public static final int LT=34;
	public static final int MODE=35;
	public static final int NESTED_ACTION=36;
	public static final int NLCHARS=37;
	public static final int NOT=38;
	public static final int NameChar=39;
	public static final int NameStartChar=40;
	public static final int OPTIONS=41;
	public static final int OR=42;
	public static final int PARSER=43;
	public static final int PLUS=44;
	public static final int PLUS_ASSIGN=45;
	public static final int POUND=46;
	public static final int PRIVATE=47;
	public static final int PROTECTED=48;
	public static final int PUBLIC=49;
	public static final int QUESTION=50;
	public static final int RANGE=51;
	public static final int RARROW=52;
	public static final int RBRACE=53;
	public static final int RETURNS=54;
	public static final int RPAREN=55;
	public static final int RULE_REF=56;
	public static final int SEMI=57;
	public static final int SEMPRED=58;
	public static final int SRC=59;
	public static final int STAR=60;
	public static final int STRING_LITERAL=61;
	public static final int SYNPRED=62;
	public static final int THROWS=63;
	public static final int TOKENS_SPEC=64;
	public static final int TOKEN_REF=65;
	public static final int TREE_GRAMMAR=66;
	public static final int UNICODE_ESC=67;
	public static final int UnicodeBOM=68;
	public static final int WS=69;
	public static final int WSCHARS=70;
	public static final int WSNLCHARS=71;
	public static final int ALT=72;
	public static final int ALTLIST=73;
	public static final int ARG=74;
	public static final int ARGLIST=75;
	public static final int BLOCK=76;
	public static final int CHAR_RANGE=77;
	public static final int CLOSURE=78;
	public static final int COMBINED=79;
	public static final int ELEMENT_OPTIONS=80;
	public static final int EPSILON=81;
	public static final int INITACTION=82;
	public static final int LABEL=83;
	public static final int LEXER_ACTION_CALL=84;
	public static final int LEXER_ALT_ACTION=85;
	public static final int LIST=86;
	public static final int OPTIONAL=87;
	public static final int POSITIVE_CLOSURE=88;
	public static final int PREC_RULE=89;
	public static final int RESULT=90;
	public static final int RET=91;
	public static final int RULE=92;
	public static final int RULEACTIONS=93;
	public static final int RULEMODIFIERS=94;
	public static final int RULES=95;
	public static final int SET=96;
	public static final int TEMPLATE=97;
	public static final int WILDCARD=98;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public ANTLRParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public ANTLRParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return ANTLRParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org\\antlr\\v4\\parse\\ANTLRParser.g"; }


	Deque<String> paraphrases = new ArrayDeque<String>();
	public void grammarError(ErrorType etype, org.antlr.runtime.Token token, Object... args) { }


	public static class grammarSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "grammarSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:146:1: grammarSpec : ( DOC_COMMENT )? grammarType id SEMI sync ( prequelConstruct sync )* rules ( modeSpec )* EOF -> ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* ) ;
	public final ANTLRParser.grammarSpec_return grammarSpec() throws RecognitionException {
		ANTLRParser.grammarSpec_return retval = new ANTLRParser.grammarSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOC_COMMENT1=null;
		Token SEMI4=null;
		Token EOF10=null;
		ParserRuleReturnScope grammarType2 =null;
		ParserRuleReturnScope id3 =null;
		ParserRuleReturnScope sync5 =null;
		ParserRuleReturnScope prequelConstruct6 =null;
		ParserRuleReturnScope sync7 =null;
		ParserRuleReturnScope rules8 =null;
		ParserRuleReturnScope modeSpec9 =null;

		GrammarAST DOC_COMMENT1_tree=null;
		GrammarAST SEMI4_tree=null;
		GrammarAST EOF10_tree=null;
		RewriteRuleTokenStream stream_DOC_COMMENT=new RewriteRuleTokenStream(adaptor,"token DOC_COMMENT");
		RewriteRuleTokenStream stream_EOF=new RewriteRuleTokenStream(adaptor,"token EOF");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");
		RewriteRuleSubtreeStream stream_modeSpec=new RewriteRuleSubtreeStream(adaptor,"rule modeSpec");
		RewriteRuleSubtreeStream stream_prequelConstruct=new RewriteRuleSubtreeStream(adaptor,"rule prequelConstruct");
		RewriteRuleSubtreeStream stream_grammarType=new RewriteRuleSubtreeStream(adaptor,"rule grammarType");
		RewriteRuleSubtreeStream stream_rules=new RewriteRuleSubtreeStream(adaptor,"rule rules");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:153:5: ( ( DOC_COMMENT )? grammarType id SEMI sync ( prequelConstruct sync )* rules ( modeSpec )* EOF -> ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:157:7: ( DOC_COMMENT )? grammarType id SEMI sync ( prequelConstruct sync )* rules ( modeSpec )* EOF
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:157:7: ( DOC_COMMENT )?
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==DOC_COMMENT) ) {
				alt1=1;
			}
			switch (alt1) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:157:7: DOC_COMMENT
					{
					DOC_COMMENT1=(Token)match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_grammarSpec402);  
					stream_DOC_COMMENT.add(DOC_COMMENT1);

					}
					break;

			}

			pushFollow(FOLLOW_grammarType_in_grammarSpec433);
			grammarType2=grammarType();
			state._fsp--;

			stream_grammarType.add(grammarType2.getTree());
			pushFollow(FOLLOW_id_in_grammarSpec435);
			id3=id();
			state._fsp--;

			stream_id.add(id3.getTree());
			SEMI4=(Token)match(input,SEMI,FOLLOW_SEMI_in_grammarSpec437);  
			stream_SEMI.add(SEMI4);

			pushFollow(FOLLOW_sync_in_grammarSpec475);
			sync5=sync();
			state._fsp--;

			stream_sync.add(sync5.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:175:12: ( prequelConstruct sync )*
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( (LA2_0==AT||LA2_0==IMPORT||LA2_0==OPTIONS||LA2_0==TOKENS_SPEC) ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:175:14: prequelConstruct sync
					{
					pushFollow(FOLLOW_prequelConstruct_in_grammarSpec479);
					prequelConstruct6=prequelConstruct();
					state._fsp--;

					stream_prequelConstruct.add(prequelConstruct6.getTree());
					pushFollow(FOLLOW_sync_in_grammarSpec481);
					sync7=sync();
					state._fsp--;

					stream_sync.add(sync7.getTree());
					}
					break;

				default :
					break loop2;
				}
			}

			pushFollow(FOLLOW_rules_in_grammarSpec506);
			rules8=rules();
			state._fsp--;

			stream_rules.add(rules8.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:183:4: ( modeSpec )*
			loop3:
			while (true) {
				int alt3=2;
				int LA3_0 = input.LA(1);
				if ( (LA3_0==MODE) ) {
					alt3=1;
				}

				switch (alt3) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:183:4: modeSpec
					{
					pushFollow(FOLLOW_modeSpec_in_grammarSpec512);
					modeSpec9=modeSpec();
					state._fsp--;

					stream_modeSpec.add(modeSpec9.getTree());
					}
					break;

				default :
					break loop3;
				}
			}

			EOF10=(Token)match(input,EOF,FOLLOW_EOF_in_grammarSpec550);  
			stream_EOF.add(EOF10);

			// AST REWRITE
			// elements: rules, DOC_COMMENT, grammarType, modeSpec, id, prequelConstruct
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 196:7: -> ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:196:10: ^( grammarType id ( DOC_COMMENT )? ( prequelConstruct )* rules ( modeSpec )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_grammarType.nextNode(), root_1);
				adaptor.addChild(root_1, stream_id.nextTree());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:198:14: ( DOC_COMMENT )?
				if ( stream_DOC_COMMENT.hasNext() ) {
					adaptor.addChild(root_1, stream_DOC_COMMENT.nextNode());
				}
				stream_DOC_COMMENT.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:199:14: ( prequelConstruct )*
				while ( stream_prequelConstruct.hasNext() ) {
					adaptor.addChild(root_1, stream_prequelConstruct.nextTree());
				}
				stream_prequelConstruct.reset();

				adaptor.addChild(root_1, stream_rules.nextTree());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:201:14: ( modeSpec )*
				while ( stream_modeSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_modeSpec.nextTree());
				}
				stream_modeSpec.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "grammarSpec"


	public static class grammarType_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "grammarType"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:205:1: grammarType : (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\", getTokenStream()] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\", getTokenStream()] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\", getTokenStream()] |tg= TREE_GRAMMAR ) ;
	public final ANTLRParser.grammarType_return grammarType() throws RecognitionException {
		ANTLRParser.grammarType_return retval = new ANTLRParser.grammarType_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token t=null;
		Token g=null;
		Token tg=null;

		GrammarAST t_tree=null;
		GrammarAST g_tree=null;
		GrammarAST tg_tree=null;
		RewriteRuleTokenStream stream_TREE_GRAMMAR=new RewriteRuleTokenStream(adaptor,"token TREE_GRAMMAR");
		RewriteRuleTokenStream stream_PARSER=new RewriteRuleTokenStream(adaptor,"token PARSER");
		RewriteRuleTokenStream stream_LEXER=new RewriteRuleTokenStream(adaptor,"token LEXER");
		RewriteRuleTokenStream stream_GRAMMAR=new RewriteRuleTokenStream(adaptor,"token GRAMMAR");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:211:5: ( (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\", getTokenStream()] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\", getTokenStream()] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\", getTokenStream()] |tg= TREE_GRAMMAR ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:211:7: (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\", getTokenStream()] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\", getTokenStream()] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\", getTokenStream()] |tg= TREE_GRAMMAR )
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:211:7: (t= LEXER g= GRAMMAR -> GRAMMAR[$g, \"LEXER_GRAMMAR\", getTokenStream()] |t= PARSER g= GRAMMAR -> GRAMMAR[$g, \"PARSER_GRAMMAR\", getTokenStream()] |g= GRAMMAR -> GRAMMAR[$g, \"COMBINED_GRAMMAR\", getTokenStream()] |tg= TREE_GRAMMAR )
			int alt4=4;
			switch ( input.LA(1) ) {
			case LEXER:
				{
				alt4=1;
				}
				break;
			case PARSER:
				{
				alt4=2;
				}
				break;
			case GRAMMAR:
				{
				alt4=3;
				}
				break;
			case TREE_GRAMMAR:
				{
				alt4=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:211:9: t= LEXER g= GRAMMAR
					{
					t=(Token)match(input,LEXER,FOLLOW_LEXER_in_grammarType740);  
					stream_LEXER.add(t);

					g=(Token)match(input,GRAMMAR,FOLLOW_GRAMMAR_in_grammarType744);  
					stream_GRAMMAR.add(g);

					// AST REWRITE
					// elements: GRAMMAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 211:28: -> GRAMMAR[$g, \"LEXER_GRAMMAR\", getTokenStream()]
					{
						adaptor.addChild(root_0, new GrammarRootAST(GRAMMAR, g, "LEXER_GRAMMAR", getTokenStream()));
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:213:6: t= PARSER g= GRAMMAR
					{
					t=(Token)match(input,PARSER,FOLLOW_PARSER_in_grammarType767);  
					stream_PARSER.add(t);

					g=(Token)match(input,GRAMMAR,FOLLOW_GRAMMAR_in_grammarType771);  
					stream_GRAMMAR.add(g);

					// AST REWRITE
					// elements: GRAMMAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 213:25: -> GRAMMAR[$g, \"PARSER_GRAMMAR\", getTokenStream()]
					{
						adaptor.addChild(root_0, new GrammarRootAST(GRAMMAR, g, "PARSER_GRAMMAR", getTokenStream()));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:216:6: g= GRAMMAR
					{
					g=(Token)match(input,GRAMMAR,FOLLOW_GRAMMAR_in_grammarType792);  
					stream_GRAMMAR.add(g);

					// AST REWRITE
					// elements: GRAMMAR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 216:25: -> GRAMMAR[$g, \"COMBINED_GRAMMAR\", getTokenStream()]
					{
						adaptor.addChild(root_0, new GrammarRootAST(GRAMMAR, g, "COMBINED_GRAMMAR", getTokenStream()));
					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:217:7: tg= TREE_GRAMMAR
					{
					tg=(Token)match(input,TREE_GRAMMAR,FOLLOW_TREE_GRAMMAR_in_grammarType819);  
					stream_TREE_GRAMMAR.add(tg);

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				if ( tg!=null ) throw new v3TreeGrammarException(tg);
				if ( t!=null ) ((GrammarRootAST)retval.tree).grammarType = (t!=null?t.getType():0);
				else ((GrammarRootAST)retval.tree).grammarType=COMBINED;

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "grammarType"


	public static class prequelConstruct_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "prequelConstruct"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:225:1: prequelConstruct : ( optionsSpec | delegateGrammars | tokensSpec | action );
	public final ANTLRParser.prequelConstruct_return prequelConstruct() throws RecognitionException {
		ANTLRParser.prequelConstruct_return retval = new ANTLRParser.prequelConstruct_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope optionsSpec11 =null;
		ParserRuleReturnScope delegateGrammars12 =null;
		ParserRuleReturnScope tokensSpec13 =null;
		ParserRuleReturnScope action14 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:226:2: ( optionsSpec | delegateGrammars | tokensSpec | action )
			int alt5=4;
			switch ( input.LA(1) ) {
			case OPTIONS:
				{
				alt5=1;
				}
				break;
			case IMPORT:
				{
				alt5=2;
				}
				break;
			case TOKENS_SPEC:
				{
				alt5=3;
				}
				break;
			case AT:
				{
				alt5=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}
			switch (alt5) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:227:4: optionsSpec
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_optionsSpec_in_prequelConstruct845);
					optionsSpec11=optionsSpec();
					state._fsp--;

					adaptor.addChild(root_0, optionsSpec11.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:231:7: delegateGrammars
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_delegateGrammars_in_prequelConstruct868);
					delegateGrammars12=delegateGrammars();
					state._fsp--;

					adaptor.addChild(root_0, delegateGrammars12.getTree());

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:238:7: tokensSpec
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_tokensSpec_in_prequelConstruct912);
					tokensSpec13=tokensSpec();
					state._fsp--;

					adaptor.addChild(root_0, tokensSpec13.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:244:7: action
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_action_in_prequelConstruct949);
					action14=action();
					state._fsp--;

					adaptor.addChild(root_0, action14.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prequelConstruct"


	public static class optionsSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "optionsSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:248:1: optionsSpec : OPTIONS ( option SEMI )* RBRACE -> ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )* ) ;
	public final ANTLRParser.optionsSpec_return optionsSpec() throws RecognitionException {
		ANTLRParser.optionsSpec_return retval = new ANTLRParser.optionsSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OPTIONS15=null;
		Token SEMI17=null;
		Token RBRACE18=null;
		ParserRuleReturnScope option16 =null;

		GrammarAST OPTIONS15_tree=null;
		GrammarAST SEMI17_tree=null;
		GrammarAST RBRACE18_tree=null;
		RewriteRuleTokenStream stream_RBRACE=new RewriteRuleTokenStream(adaptor,"token RBRACE");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_OPTIONS=new RewriteRuleTokenStream(adaptor,"token OPTIONS");
		RewriteRuleSubtreeStream stream_option=new RewriteRuleSubtreeStream(adaptor,"rule option");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:249:2: ( OPTIONS ( option SEMI )* RBRACE -> ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:249:4: OPTIONS ( option SEMI )* RBRACE
			{
			OPTIONS15=(Token)match(input,OPTIONS,FOLLOW_OPTIONS_in_optionsSpec964);  
			stream_OPTIONS.add(OPTIONS15);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:249:12: ( option SEMI )*
			loop6:
			while (true) {
				int alt6=2;
				int LA6_0 = input.LA(1);
				if ( (LA6_0==RULE_REF||LA6_0==TOKEN_REF) ) {
					alt6=1;
				}

				switch (alt6) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:249:13: option SEMI
					{
					pushFollow(FOLLOW_option_in_optionsSpec967);
					option16=option();
					state._fsp--;

					stream_option.add(option16.getTree());
					SEMI17=(Token)match(input,SEMI,FOLLOW_SEMI_in_optionsSpec969);  
					stream_SEMI.add(SEMI17);

					}
					break;

				default :
					break loop6;
				}
			}

			RBRACE18=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_optionsSpec973);  
			stream_RBRACE.add(RBRACE18);

			// AST REWRITE
			// elements: OPTIONS, option
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 249:34: -> ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:249:37: ^( OPTIONS[$OPTIONS, \"OPTIONS\"] ( option )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(OPTIONS, OPTIONS15, "OPTIONS"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:249:68: ( option )*
				while ( stream_option.hasNext() ) {
					adaptor.addChild(root_1, stream_option.nextTree());
				}
				stream_option.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionsSpec"


	public static class option_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "option"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:252:1: option : id ASSIGN ^ optionValue ;
	public final ANTLRParser.option_return option() throws RecognitionException {
		ANTLRParser.option_return retval = new ANTLRParser.option_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ASSIGN20=null;
		ParserRuleReturnScope id19 =null;
		ParserRuleReturnScope optionValue21 =null;

		GrammarAST ASSIGN20_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:253:5: ( id ASSIGN ^ optionValue )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:253:9: id ASSIGN ^ optionValue
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_id_in_option1002);
			id19=id();
			state._fsp--;

			adaptor.addChild(root_0, id19.getTree());

			ASSIGN20=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_option1004); 
			ASSIGN20_tree = (GrammarAST)adaptor.create(ASSIGN20);
			root_0 = (GrammarAST)adaptor.becomeRoot(ASSIGN20_tree, root_0);

			pushFollow(FOLLOW_optionValue_in_option1007);
			optionValue21=optionValue();
			state._fsp--;

			adaptor.addChild(root_0, optionValue21.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "option"


	public static class optionValue_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "optionValue"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:261:1: optionValue : ( qid | STRING_LITERAL | ACTION | INT );
	public final ANTLRParser.optionValue_return optionValue() throws RecognitionException {
		ANTLRParser.optionValue_return retval = new ANTLRParser.optionValue_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token STRING_LITERAL23=null;
		Token ACTION24=null;
		Token INT25=null;
		ParserRuleReturnScope qid22 =null;

		GrammarAST STRING_LITERAL23_tree=null;
		GrammarAST ACTION24_tree=null;
		GrammarAST INT25_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:262:5: ( qid | STRING_LITERAL | ACTION | INT )
			int alt7=4;
			switch ( input.LA(1) ) {
			case RULE_REF:
			case TOKEN_REF:
				{
				alt7=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt7=2;
				}
				break;
			case ACTION:
				{
				alt7=3;
				}
				break;
			case INT:
				{
				alt7=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 7, 0, input);
				throw nvae;
			}
			switch (alt7) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:265:7: qid
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_qid_in_optionValue1050);
					qid22=qid();
					state._fsp--;

					adaptor.addChild(root_0, qid22.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:266:7: STRING_LITERAL
					{
					root_0 = (GrammarAST)adaptor.nil();


					STRING_LITERAL23=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_optionValue1058); 
					STRING_LITERAL23_tree = (GrammarAST)adaptor.create(STRING_LITERAL23);
					adaptor.addChild(root_0, STRING_LITERAL23_tree);

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:267:4: ACTION
					{
					root_0 = (GrammarAST)adaptor.nil();


					ACTION24=(Token)match(input,ACTION,FOLLOW_ACTION_in_optionValue1063); 
					ACTION24_tree = new ActionAST(ACTION24) ;
					adaptor.addChild(root_0, ACTION24_tree);

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:268:7: INT
					{
					root_0 = (GrammarAST)adaptor.nil();


					INT25=(Token)match(input,INT,FOLLOW_INT_in_optionValue1074); 
					INT25_tree = (GrammarAST)adaptor.create(INT25);
					adaptor.addChild(root_0, INT25_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionValue"


	public static class delegateGrammars_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "delegateGrammars"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:273:1: delegateGrammars : IMPORT delegateGrammar ( COMMA delegateGrammar )* SEMI -> ^( IMPORT ( delegateGrammar )+ ) ;
	public final ANTLRParser.delegateGrammars_return delegateGrammars() throws RecognitionException {
		ANTLRParser.delegateGrammars_return retval = new ANTLRParser.delegateGrammars_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token IMPORT26=null;
		Token COMMA28=null;
		Token SEMI30=null;
		ParserRuleReturnScope delegateGrammar27 =null;
		ParserRuleReturnScope delegateGrammar29 =null;

		GrammarAST IMPORT26_tree=null;
		GrammarAST COMMA28_tree=null;
		GrammarAST SEMI30_tree=null;
		RewriteRuleTokenStream stream_IMPORT=new RewriteRuleTokenStream(adaptor,"token IMPORT");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleSubtreeStream stream_delegateGrammar=new RewriteRuleSubtreeStream(adaptor,"rule delegateGrammar");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:274:2: ( IMPORT delegateGrammar ( COMMA delegateGrammar )* SEMI -> ^( IMPORT ( delegateGrammar )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:274:4: IMPORT delegateGrammar ( COMMA delegateGrammar )* SEMI
			{
			IMPORT26=(Token)match(input,IMPORT,FOLLOW_IMPORT_in_delegateGrammars1090);  
			stream_IMPORT.add(IMPORT26);

			pushFollow(FOLLOW_delegateGrammar_in_delegateGrammars1092);
			delegateGrammar27=delegateGrammar();
			state._fsp--;

			stream_delegateGrammar.add(delegateGrammar27.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:274:27: ( COMMA delegateGrammar )*
			loop8:
			while (true) {
				int alt8=2;
				int LA8_0 = input.LA(1);
				if ( (LA8_0==COMMA) ) {
					alt8=1;
				}

				switch (alt8) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:274:28: COMMA delegateGrammar
					{
					COMMA28=(Token)match(input,COMMA,FOLLOW_COMMA_in_delegateGrammars1095);  
					stream_COMMA.add(COMMA28);

					pushFollow(FOLLOW_delegateGrammar_in_delegateGrammars1097);
					delegateGrammar29=delegateGrammar();
					state._fsp--;

					stream_delegateGrammar.add(delegateGrammar29.getTree());
					}
					break;

				default :
					break loop8;
				}
			}

			SEMI30=(Token)match(input,SEMI,FOLLOW_SEMI_in_delegateGrammars1101);  
			stream_SEMI.add(SEMI30);

			// AST REWRITE
			// elements: delegateGrammar, IMPORT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 274:57: -> ^( IMPORT ( delegateGrammar )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:274:60: ^( IMPORT ( delegateGrammar )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_IMPORT.nextNode(), root_1);
				if ( !(stream_delegateGrammar.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_delegateGrammar.hasNext() ) {
					adaptor.addChild(root_1, stream_delegateGrammar.nextTree());
				}
				stream_delegateGrammar.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delegateGrammars"


	public static class delegateGrammar_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "delegateGrammar"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:279:1: delegateGrammar : ( id ASSIGN ^ id | id );
	public final ANTLRParser.delegateGrammar_return delegateGrammar() throws RecognitionException {
		ANTLRParser.delegateGrammar_return retval = new ANTLRParser.delegateGrammar_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ASSIGN32=null;
		ParserRuleReturnScope id31 =null;
		ParserRuleReturnScope id33 =null;
		ParserRuleReturnScope id34 =null;

		GrammarAST ASSIGN32_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:280:5: ( id ASSIGN ^ id | id )
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==RULE_REF) ) {
				int LA9_1 = input.LA(2);
				if ( (LA9_1==ASSIGN) ) {
					alt9=1;
				}
				else if ( (LA9_1==COMMA||LA9_1==SEMI) ) {
					alt9=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 9, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA9_0==TOKEN_REF) ) {
				int LA9_2 = input.LA(2);
				if ( (LA9_2==ASSIGN) ) {
					alt9=1;
				}
				else if ( (LA9_2==COMMA||LA9_2==SEMI) ) {
					alt9=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 9, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 9, 0, input);
				throw nvae;
			}

			switch (alt9) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:280:9: id ASSIGN ^ id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_delegateGrammar1128);
					id31=id();
					state._fsp--;

					adaptor.addChild(root_0, id31.getTree());

					ASSIGN32=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_delegateGrammar1130); 
					ASSIGN32_tree = (GrammarAST)adaptor.create(ASSIGN32);
					root_0 = (GrammarAST)adaptor.becomeRoot(ASSIGN32_tree, root_0);

					pushFollow(FOLLOW_id_in_delegateGrammar1133);
					id33=id();
					state._fsp--;

					adaptor.addChild(root_0, id33.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:281:9: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_delegateGrammar1143);
					id34=id();
					state._fsp--;

					adaptor.addChild(root_0, id34.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delegateGrammar"


	public static class tokensSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "tokensSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:284:1: tokensSpec : ( TOKENS_SPEC id ( COMMA id )* RBRACE -> ^( TOKENS_SPEC ( id )+ ) | TOKENS_SPEC RBRACE ->| TOKENS_SPEC ^ ( v3tokenSpec )+ RBRACE !);
	public final ANTLRParser.tokensSpec_return tokensSpec() throws RecognitionException {
		ANTLRParser.tokensSpec_return retval = new ANTLRParser.tokensSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token TOKENS_SPEC35=null;
		Token COMMA37=null;
		Token RBRACE39=null;
		Token TOKENS_SPEC40=null;
		Token RBRACE41=null;
		Token TOKENS_SPEC42=null;
		Token RBRACE44=null;
		ParserRuleReturnScope id36 =null;
		ParserRuleReturnScope id38 =null;
		ParserRuleReturnScope v3tokenSpec43 =null;

		GrammarAST TOKENS_SPEC35_tree=null;
		GrammarAST COMMA37_tree=null;
		GrammarAST RBRACE39_tree=null;
		GrammarAST TOKENS_SPEC40_tree=null;
		GrammarAST RBRACE41_tree=null;
		GrammarAST TOKENS_SPEC42_tree=null;
		GrammarAST RBRACE44_tree=null;
		RewriteRuleTokenStream stream_RBRACE=new RewriteRuleTokenStream(adaptor,"token RBRACE");
		RewriteRuleTokenStream stream_TOKENS_SPEC=new RewriteRuleTokenStream(adaptor,"token TOKENS_SPEC");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:285:2: ( TOKENS_SPEC id ( COMMA id )* RBRACE -> ^( TOKENS_SPEC ( id )+ ) | TOKENS_SPEC RBRACE ->| TOKENS_SPEC ^ ( v3tokenSpec )+ RBRACE !)
			int alt12=3;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==TOKENS_SPEC) ) {
				switch ( input.LA(2) ) {
				case RBRACE:
					{
					alt12=2;
					}
					break;
				case RULE_REF:
					{
					int LA12_3 = input.LA(3);
					if ( (LA12_3==COMMA||LA12_3==RBRACE) ) {
						alt12=1;
					}
					else if ( (LA12_3==ASSIGN||LA12_3==SEMI) ) {
						alt12=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 12, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case TOKEN_REF:
					{
					int LA12_4 = input.LA(3);
					if ( (LA12_4==COMMA||LA12_4==RBRACE) ) {
						alt12=1;
					}
					else if ( (LA12_4==ASSIGN||LA12_4==SEMI) ) {
						alt12=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 12, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 12, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}

			switch (alt12) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:285:4: TOKENS_SPEC id ( COMMA id )* RBRACE
					{
					TOKENS_SPEC35=(Token)match(input,TOKENS_SPEC,FOLLOW_TOKENS_SPEC_in_tokensSpec1157);  
					stream_TOKENS_SPEC.add(TOKENS_SPEC35);

					pushFollow(FOLLOW_id_in_tokensSpec1159);
					id36=id();
					state._fsp--;

					stream_id.add(id36.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:285:19: ( COMMA id )*
					loop10:
					while (true) {
						int alt10=2;
						int LA10_0 = input.LA(1);
						if ( (LA10_0==COMMA) ) {
							alt10=1;
						}

						switch (alt10) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:285:20: COMMA id
							{
							COMMA37=(Token)match(input,COMMA,FOLLOW_COMMA_in_tokensSpec1162);  
							stream_COMMA.add(COMMA37);

							pushFollow(FOLLOW_id_in_tokensSpec1164);
							id38=id();
							state._fsp--;

							stream_id.add(id38.getTree());
							}
							break;

						default :
							break loop10;
						}
					}

					RBRACE39=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_tokensSpec1168);  
					stream_RBRACE.add(RBRACE39);

					// AST REWRITE
					// elements: TOKENS_SPEC, id
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 285:38: -> ^( TOKENS_SPEC ( id )+ )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:285:41: ^( TOKENS_SPEC ( id )+ )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_TOKENS_SPEC.nextNode(), root_1);
						if ( !(stream_id.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_id.hasNext() ) {
							adaptor.addChild(root_1, stream_id.nextTree());
						}
						stream_id.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:286:7: TOKENS_SPEC RBRACE
					{
					TOKENS_SPEC40=(Token)match(input,TOKENS_SPEC,FOLLOW_TOKENS_SPEC_in_tokensSpec1185);  
					stream_TOKENS_SPEC.add(TOKENS_SPEC40);

					RBRACE41=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_tokensSpec1187);  
					stream_RBRACE.add(RBRACE41);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 286:26: ->
					{
						root_0 = null;
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:287:7: TOKENS_SPEC ^ ( v3tokenSpec )+ RBRACE !
					{
					root_0 = (GrammarAST)adaptor.nil();


					TOKENS_SPEC42=(Token)match(input,TOKENS_SPEC,FOLLOW_TOKENS_SPEC_in_tokensSpec1197); 
					TOKENS_SPEC42_tree = (GrammarAST)adaptor.create(TOKENS_SPEC42);
					root_0 = (GrammarAST)adaptor.becomeRoot(TOKENS_SPEC42_tree, root_0);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:287:20: ( v3tokenSpec )+
					int cnt11=0;
					loop11:
					while (true) {
						int alt11=2;
						int LA11_0 = input.LA(1);
						if ( (LA11_0==RULE_REF||LA11_0==TOKEN_REF) ) {
							alt11=1;
						}

						switch (alt11) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:287:20: v3tokenSpec
							{
							pushFollow(FOLLOW_v3tokenSpec_in_tokensSpec1200);
							v3tokenSpec43=v3tokenSpec();
							state._fsp--;

							adaptor.addChild(root_0, v3tokenSpec43.getTree());

							}
							break;

						default :
							if ( cnt11 >= 1 ) break loop11;
							EarlyExitException eee = new EarlyExitException(11, input);
							throw eee;
						}
						cnt11++;
					}

					RBRACE44=(Token)match(input,RBRACE,FOLLOW_RBRACE_in_tokensSpec1203); 
					grammarError(ErrorType.V3_TOKENS_SYNTAX, TOKENS_SPEC42);
					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "tokensSpec"


	public static class v3tokenSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "v3tokenSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:291:1: v3tokenSpec : id ( ASSIGN lit= STRING_LITERAL -> id | -> id ) SEMI ;
	public final ANTLRParser.v3tokenSpec_return v3tokenSpec() throws RecognitionException {
		ANTLRParser.v3tokenSpec_return retval = new ANTLRParser.v3tokenSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token lit=null;
		Token ASSIGN46=null;
		Token SEMI47=null;
		ParserRuleReturnScope id45 =null;

		GrammarAST lit_tree=null;
		GrammarAST ASSIGN46_tree=null;
		GrammarAST SEMI47_tree=null;
		RewriteRuleTokenStream stream_STRING_LITERAL=new RewriteRuleTokenStream(adaptor,"token STRING_LITERAL");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_ASSIGN=new RewriteRuleTokenStream(adaptor,"token ASSIGN");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:292:2: ( id ( ASSIGN lit= STRING_LITERAL -> id | -> id ) SEMI )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:292:4: id ( ASSIGN lit= STRING_LITERAL -> id | -> id ) SEMI
			{
			pushFollow(FOLLOW_id_in_v3tokenSpec1223);
			id45=id();
			state._fsp--;

			stream_id.add(id45.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:293:3: ( ASSIGN lit= STRING_LITERAL -> id | -> id )
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==ASSIGN) ) {
				alt13=1;
			}
			else if ( (LA13_0==SEMI) ) {
				alt13=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}

			switch (alt13) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:293:5: ASSIGN lit= STRING_LITERAL
					{
					ASSIGN46=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_v3tokenSpec1229);  
					stream_ASSIGN.add(ASSIGN46);

					lit=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_v3tokenSpec1233);  
					stream_STRING_LITERAL.add(lit);


					            grammarError(ErrorType.V3_ASSIGN_IN_TOKENS, (id45!=null?(id45.start):null),
					                         (id45!=null?input.toString(id45.start,id45.stop):null), lit.getText());
					            
					// AST REWRITE
					// elements: id
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 298:20: -> id
					{
						adaptor.addChild(root_0, stream_id.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:299:12: 
					{
					// AST REWRITE
					// elements: id
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 299:12: -> id
					{
						adaptor.addChild(root_0, stream_id.nextTree());
					}


					retval.tree = root_0;

					}
					break;

			}

			SEMI47=(Token)match(input,SEMI,FOLLOW_SEMI_in_v3tokenSpec1294);  
			stream_SEMI.add(SEMI47);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "v3tokenSpec"


	public static class action_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "action"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:308:1: action : AT ( actionScopeName COLONCOLON )? id ACTION -> ^( AT ( actionScopeName )? id ACTION ) ;
	public final ANTLRParser.action_return action() throws RecognitionException {
		ANTLRParser.action_return retval = new ANTLRParser.action_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token AT48=null;
		Token COLONCOLON50=null;
		Token ACTION52=null;
		ParserRuleReturnScope actionScopeName49 =null;
		ParserRuleReturnScope id51 =null;

		GrammarAST AT48_tree=null;
		GrammarAST COLONCOLON50_tree=null;
		GrammarAST ACTION52_tree=null;
		RewriteRuleTokenStream stream_AT=new RewriteRuleTokenStream(adaptor,"token AT");
		RewriteRuleTokenStream stream_COLONCOLON=new RewriteRuleTokenStream(adaptor,"token COLONCOLON");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_actionScopeName=new RewriteRuleSubtreeStream(adaptor,"rule actionScopeName");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:309:2: ( AT ( actionScopeName COLONCOLON )? id ACTION -> ^( AT ( actionScopeName )? id ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:309:4: AT ( actionScopeName COLONCOLON )? id ACTION
			{
			AT48=(Token)match(input,AT,FOLLOW_AT_in_action1310);  
			stream_AT.add(AT48);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:309:7: ( actionScopeName COLONCOLON )?
			int alt14=2;
			switch ( input.LA(1) ) {
				case RULE_REF:
					{
					int LA14_1 = input.LA(2);
					if ( (LA14_1==COLONCOLON) ) {
						alt14=1;
					}
					}
					break;
				case TOKEN_REF:
					{
					int LA14_2 = input.LA(2);
					if ( (LA14_2==COLONCOLON) ) {
						alt14=1;
					}
					}
					break;
				case LEXER:
				case PARSER:
					{
					alt14=1;
					}
					break;
			}
			switch (alt14) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:309:8: actionScopeName COLONCOLON
					{
					pushFollow(FOLLOW_actionScopeName_in_action1313);
					actionScopeName49=actionScopeName();
					state._fsp--;

					stream_actionScopeName.add(actionScopeName49.getTree());
					COLONCOLON50=(Token)match(input,COLONCOLON,FOLLOW_COLONCOLON_in_action1315);  
					stream_COLONCOLON.add(COLONCOLON50);

					}
					break;

			}

			pushFollow(FOLLOW_id_in_action1319);
			id51=id();
			state._fsp--;

			stream_id.add(id51.getTree());
			ACTION52=(Token)match(input,ACTION,FOLLOW_ACTION_in_action1321);  
			stream_ACTION.add(ACTION52);

			// AST REWRITE
			// elements: id, ACTION, AT, actionScopeName
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 309:47: -> ^( AT ( actionScopeName )? id ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:309:50: ^( AT ( actionScopeName )? id ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_AT.nextNode(), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:309:55: ( actionScopeName )?
				if ( stream_actionScopeName.hasNext() ) {
					adaptor.addChild(root_1, stream_actionScopeName.nextTree());
				}
				stream_actionScopeName.reset();

				adaptor.addChild(root_1, stream_id.nextTree());
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "action"


	public static class actionScopeName_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "actionScopeName"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:315:1: actionScopeName : ( id | LEXER -> ID[$LEXER] | PARSER -> ID[$PARSER] );
	public final ANTLRParser.actionScopeName_return actionScopeName() throws RecognitionException {
		ANTLRParser.actionScopeName_return retval = new ANTLRParser.actionScopeName_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LEXER54=null;
		Token PARSER55=null;
		ParserRuleReturnScope id53 =null;

		GrammarAST LEXER54_tree=null;
		GrammarAST PARSER55_tree=null;
		RewriteRuleTokenStream stream_PARSER=new RewriteRuleTokenStream(adaptor,"token PARSER");
		RewriteRuleTokenStream stream_LEXER=new RewriteRuleTokenStream(adaptor,"token LEXER");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:316:2: ( id | LEXER -> ID[$LEXER] | PARSER -> ID[$PARSER] )
			int alt15=3;
			switch ( input.LA(1) ) {
			case RULE_REF:
			case TOKEN_REF:
				{
				alt15=1;
				}
				break;
			case LEXER:
				{
				alt15=2;
				}
				break;
			case PARSER:
				{
				alt15=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}
			switch (alt15) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:316:4: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_actionScopeName1350);
					id53=id();
					state._fsp--;

					adaptor.addChild(root_0, id53.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:317:4: LEXER
					{
					LEXER54=(Token)match(input,LEXER,FOLLOW_LEXER_in_actionScopeName1355);  
					stream_LEXER.add(LEXER54);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 317:10: -> ID[$LEXER]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, LEXER54));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:318:9: PARSER
					{
					PARSER55=(Token)match(input,PARSER,FOLLOW_PARSER_in_actionScopeName1370);  
					stream_PARSER.add(PARSER55);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 318:16: -> ID[$PARSER]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, PARSER55));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "actionScopeName"


	public static class modeSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "modeSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:321:1: modeSpec : MODE id SEMI sync ( lexerRule sync )* -> ^( MODE id ( lexerRule )* ) ;
	public final ANTLRParser.modeSpec_return modeSpec() throws RecognitionException {
		ANTLRParser.modeSpec_return retval = new ANTLRParser.modeSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token MODE56=null;
		Token SEMI58=null;
		ParserRuleReturnScope id57 =null;
		ParserRuleReturnScope sync59 =null;
		ParserRuleReturnScope lexerRule60 =null;
		ParserRuleReturnScope sync61 =null;

		GrammarAST MODE56_tree=null;
		GrammarAST SEMI58_tree=null;
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_MODE=new RewriteRuleTokenStream(adaptor,"token MODE");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");
		RewriteRuleSubtreeStream stream_lexerRule=new RewriteRuleSubtreeStream(adaptor,"rule lexerRule");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:322:5: ( MODE id SEMI sync ( lexerRule sync )* -> ^( MODE id ( lexerRule )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:322:7: MODE id SEMI sync ( lexerRule sync )*
			{
			MODE56=(Token)match(input,MODE,FOLLOW_MODE_in_modeSpec1389);  
			stream_MODE.add(MODE56);

			pushFollow(FOLLOW_id_in_modeSpec1391);
			id57=id();
			state._fsp--;

			stream_id.add(id57.getTree());
			SEMI58=(Token)match(input,SEMI,FOLLOW_SEMI_in_modeSpec1393);  
			stream_SEMI.add(SEMI58);

			pushFollow(FOLLOW_sync_in_modeSpec1395);
			sync59=sync();
			state._fsp--;

			stream_sync.add(sync59.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:322:25: ( lexerRule sync )*
			loop16:
			while (true) {
				int alt16=2;
				int LA16_0 = input.LA(1);
				if ( (LA16_0==DOC_COMMENT||LA16_0==FRAGMENT||LA16_0==TOKEN_REF) ) {
					alt16=1;
				}

				switch (alt16) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:322:26: lexerRule sync
					{
					pushFollow(FOLLOW_lexerRule_in_modeSpec1398);
					lexerRule60=lexerRule();
					state._fsp--;

					stream_lexerRule.add(lexerRule60.getTree());
					pushFollow(FOLLOW_sync_in_modeSpec1400);
					sync61=sync();
					state._fsp--;

					stream_sync.add(sync61.getTree());
					}
					break;

				default :
					break loop16;
				}
			}

			// AST REWRITE
			// elements: lexerRule, id, MODE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 322:44: -> ^( MODE id ( lexerRule )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:322:47: ^( MODE id ( lexerRule )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_MODE.nextNode(), root_1);
				adaptor.addChild(root_1, stream_id.nextTree());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:322:57: ( lexerRule )*
				while ( stream_lexerRule.hasNext() ) {
					adaptor.addChild(root_1, stream_lexerRule.nextTree());
				}
				stream_lexerRule.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "modeSpec"


	public static class rules_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rules"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:325:1: rules : sync ( rule sync )* -> ^( RULES ( rule )* ) ;
	public final ANTLRParser.rules_return rules() throws RecognitionException {
		ANTLRParser.rules_return retval = new ANTLRParser.rules_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope sync62 =null;
		ParserRuleReturnScope rule63 =null;
		ParserRuleReturnScope sync64 =null;

		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");
		RewriteRuleSubtreeStream stream_rule=new RewriteRuleSubtreeStream(adaptor,"rule rule");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:326:5: ( sync ( rule sync )* -> ^( RULES ( rule )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:326:7: sync ( rule sync )*
			{
			pushFollow(FOLLOW_sync_in_rules1431);
			sync62=sync();
			state._fsp--;

			stream_sync.add(sync62.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:326:12: ( rule sync )*
			loop17:
			while (true) {
				int alt17=2;
				int LA17_0 = input.LA(1);
				if ( (LA17_0==DOC_COMMENT||LA17_0==FRAGMENT||LA17_0==RULE_REF||LA17_0==TOKEN_REF) ) {
					alt17=1;
				}

				switch (alt17) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:326:13: rule sync
					{
					pushFollow(FOLLOW_rule_in_rules1434);
					rule63=rule();
					state._fsp--;

					stream_rule.add(rule63.getTree());
					pushFollow(FOLLOW_sync_in_rules1436);
					sync64=sync();
					state._fsp--;

					stream_sync.add(sync64.getTree());
					}
					break;

				default :
					break loop17;
				}
			}

			// AST REWRITE
			// elements: rule
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 330:7: -> ^( RULES ( rule )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:330:9: ^( RULES ( rule )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(RULES, "RULES"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:330:17: ( rule )*
				while ( stream_rule.hasNext() ) {
					adaptor.addChild(root_1, stream_rule.nextTree());
				}
				stream_rule.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rules"


	public static class sync_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "sync"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:333:1: sync :;
	public final ANTLRParser.sync_return sync() throws RecognitionException {
		ANTLRParser.sync_return retval = new ANTLRParser.sync_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;


			BitSet followSet = computeErrorRecoverySet();
			if ( input.LA(1)!=Token.EOF && !followSet.member(input.LA(1)) ) {
				reportError(new NoViableAltException("",0,0,input));
		       	beginResync();
		       	consumeUntil(input, followSet);
		       	endResync();
			}

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:342:3: ()
			// org\\antlr\\v4\\parse\\ANTLRParser.g:343:2: 
			{
			root_0 = (GrammarAST)adaptor.nil();


			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sync"


	public static class rule_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rule"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:345:1: rule : ( parserRule | lexerRule );
	public final ANTLRParser.rule_return rule() throws RecognitionException {
		ANTLRParser.rule_return retval = new ANTLRParser.rule_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope parserRule65 =null;
		ParserRuleReturnScope lexerRule66 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:345:5: ( parserRule | lexerRule )
			int alt18=2;
			switch ( input.LA(1) ) {
			case DOC_COMMENT:
				{
				int LA18_1 = input.LA(2);
				if ( (LA18_1==RULE_REF) ) {
					alt18=1;
				}
				else if ( (LA18_1==FRAGMENT||LA18_1==TOKEN_REF) ) {
					alt18=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 18, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case RULE_REF:
				{
				alt18=1;
				}
				break;
			case FRAGMENT:
			case TOKEN_REF:
				{
				alt18=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}
			switch (alt18) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:345:7: parserRule
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_parserRule_in_rule1498);
					parserRule65=parserRule();
					state._fsp--;

					adaptor.addChild(root_0, parserRule65.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:346:4: lexerRule
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_lexerRule_in_rule1503);
					lexerRule66=lexerRule();
					state._fsp--;

					adaptor.addChild(root_0, lexerRule66.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rule"


	public static class parserRule_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "parserRule"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:358:1: parserRule : ( DOC_COMMENT )? RULE_REF ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? rulePrequels COLON ruleBlock SEMI exceptionGroup -> ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* ) ;
	public final ANTLRParser.parserRule_return parserRule() throws RecognitionException {
		ANTLRParser.parserRule_return retval = new ANTLRParser.parserRule_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOC_COMMENT67=null;
		Token RULE_REF68=null;
		Token ARG_ACTION69=null;
		Token COLON74=null;
		Token SEMI76=null;
		ParserRuleReturnScope ruleReturns70 =null;
		ParserRuleReturnScope throwsSpec71 =null;
		ParserRuleReturnScope localsSpec72 =null;
		ParserRuleReturnScope rulePrequels73 =null;
		ParserRuleReturnScope ruleBlock75 =null;
		ParserRuleReturnScope exceptionGroup77 =null;

		GrammarAST DOC_COMMENT67_tree=null;
		GrammarAST RULE_REF68_tree=null;
		GrammarAST ARG_ACTION69_tree=null;
		GrammarAST COLON74_tree=null;
		GrammarAST SEMI76_tree=null;
		RewriteRuleTokenStream stream_DOC_COMMENT=new RewriteRuleTokenStream(adaptor,"token DOC_COMMENT");
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_RULE_REF=new RewriteRuleTokenStream(adaptor,"token RULE_REF");
		RewriteRuleTokenStream stream_ARG_ACTION=new RewriteRuleTokenStream(adaptor,"token ARG_ACTION");
		RewriteRuleSubtreeStream stream_rulePrequels=new RewriteRuleSubtreeStream(adaptor,"rule rulePrequels");
		RewriteRuleSubtreeStream stream_exceptionGroup=new RewriteRuleSubtreeStream(adaptor,"rule exceptionGroup");
		RewriteRuleSubtreeStream stream_ruleReturns=new RewriteRuleSubtreeStream(adaptor,"rule ruleReturns");
		RewriteRuleSubtreeStream stream_throwsSpec=new RewriteRuleSubtreeStream(adaptor,"rule throwsSpec");
		RewriteRuleSubtreeStream stream_ruleBlock=new RewriteRuleSubtreeStream(adaptor,"rule ruleBlock");
		RewriteRuleSubtreeStream stream_localsSpec=new RewriteRuleSubtreeStream(adaptor,"rule localsSpec");

		 paraphrases.push("matching a rule"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:367:5: ( ( DOC_COMMENT )? RULE_REF ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? rulePrequels COLON ruleBlock SEMI exceptionGroup -> ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:368:7: ( DOC_COMMENT )? RULE_REF ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? rulePrequels COLON ruleBlock SEMI exceptionGroup
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:368:7: ( DOC_COMMENT )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==DOC_COMMENT) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:368:7: DOC_COMMENT
					{
					DOC_COMMENT67=(Token)match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_parserRule1543);  
					stream_DOC_COMMENT.add(DOC_COMMENT67);

					}
					break;

			}

			RULE_REF68=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_parserRule1566);  
			stream_RULE_REF.add(RULE_REF68);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:382:4: ( ARG_ACTION )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==ARG_ACTION) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:382:4: ARG_ACTION
					{
					ARG_ACTION69=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_parserRule1596);  
					stream_ARG_ACTION.add(ARG_ACTION69);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:384:4: ( ruleReturns )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==RETURNS) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:384:4: ruleReturns
					{
					pushFollow(FOLLOW_ruleReturns_in_parserRule1603);
					ruleReturns70=ruleReturns();
					state._fsp--;

					stream_ruleReturns.add(ruleReturns70.getTree());
					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:386:4: ( throwsSpec )?
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==THROWS) ) {
				alt22=1;
			}
			switch (alt22) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:386:4: throwsSpec
					{
					pushFollow(FOLLOW_throwsSpec_in_parserRule1610);
					throwsSpec71=throwsSpec();
					state._fsp--;

					stream_throwsSpec.add(throwsSpec71.getTree());
					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:388:4: ( localsSpec )?
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( (LA23_0==LOCALS) ) {
				alt23=1;
			}
			switch (alt23) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:388:4: localsSpec
					{
					pushFollow(FOLLOW_localsSpec_in_parserRule1617);
					localsSpec72=localsSpec();
					state._fsp--;

					stream_localsSpec.add(localsSpec72.getTree());
					}
					break;

			}

			pushFollow(FOLLOW_rulePrequels_in_parserRule1655);
			rulePrequels73=rulePrequels();
			state._fsp--;

			stream_rulePrequels.add(rulePrequels73.getTree());
			COLON74=(Token)match(input,COLON,FOLLOW_COLON_in_parserRule1664);  
			stream_COLON.add(COLON74);

			pushFollow(FOLLOW_ruleBlock_in_parserRule1687);
			ruleBlock75=ruleBlock();
			state._fsp--;

			stream_ruleBlock.add(ruleBlock75.getTree());
			SEMI76=(Token)match(input,SEMI,FOLLOW_SEMI_in_parserRule1696);  
			stream_SEMI.add(SEMI76);

			pushFollow(FOLLOW_exceptionGroup_in_parserRule1705);
			exceptionGroup77=exceptionGroup();
			state._fsp--;

			stream_exceptionGroup.add(exceptionGroup77.getTree());
			// AST REWRITE
			// elements: throwsSpec, ruleBlock, ruleReturns, exceptionGroup, ARG_ACTION, RULE_REF, rulePrequels, DOC_COMMENT, localsSpec
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 415:7: -> ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:415:10: ^( RULE RULE_REF ( DOC_COMMENT )? ( ARG_ACTION )? ( ruleReturns )? ( throwsSpec )? ( localsSpec )? ( rulePrequels )? ruleBlock ( exceptionGroup )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new RuleAST(RULE), root_1);
				adaptor.addChild(root_1, stream_RULE_REF.nextNode());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:415:36: ( DOC_COMMENT )?
				if ( stream_DOC_COMMENT.hasNext() ) {
					adaptor.addChild(root_1, stream_DOC_COMMENT.nextNode());
				}
				stream_DOC_COMMENT.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:415:49: ( ARG_ACTION )?
				if ( stream_ARG_ACTION.hasNext() ) {
					adaptor.addChild(root_1, new ActionAST(stream_ARG_ACTION.nextToken()));
				}
				stream_ARG_ACTION.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:9: ( ruleReturns )?
				if ( stream_ruleReturns.hasNext() ) {
					adaptor.addChild(root_1, stream_ruleReturns.nextTree());
				}
				stream_ruleReturns.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:22: ( throwsSpec )?
				if ( stream_throwsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_throwsSpec.nextTree());
				}
				stream_throwsSpec.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:34: ( localsSpec )?
				if ( stream_localsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_localsSpec.nextTree());
				}
				stream_localsSpec.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:46: ( rulePrequels )?
				if ( stream_rulePrequels.hasNext() ) {
					adaptor.addChild(root_1, stream_rulePrequels.nextTree());
				}
				stream_rulePrequels.reset();

				adaptor.addChild(root_1, stream_ruleBlock.nextTree());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:416:70: ( exceptionGroup )*
				while ( stream_exceptionGroup.hasNext() ) {
					adaptor.addChild(root_1, stream_exceptionGroup.nextTree());
				}
				stream_exceptionGroup.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				paraphrases.pop();
				GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
				if ( options!=null ) {
					Grammar.setNodeOptions(retval.tree, options);
				}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parserRule"


	public static class exceptionGroup_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "exceptionGroup"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:426:1: exceptionGroup : ( exceptionHandler )* ( finallyClause )? ;
	public final ANTLRParser.exceptionGroup_return exceptionGroup() throws RecognitionException {
		ANTLRParser.exceptionGroup_return retval = new ANTLRParser.exceptionGroup_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope exceptionHandler78 =null;
		ParserRuleReturnScope finallyClause79 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:5: ( ( exceptionHandler )* ( finallyClause )? )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:7: ( exceptionHandler )* ( finallyClause )?
			{
			root_0 = (GrammarAST)adaptor.nil();


			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:7: ( exceptionHandler )*
			loop24:
			while (true) {
				int alt24=2;
				int LA24_0 = input.LA(1);
				if ( (LA24_0==CATCH) ) {
					alt24=1;
				}

				switch (alt24) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:427:7: exceptionHandler
					{
					pushFollow(FOLLOW_exceptionHandler_in_exceptionGroup1791);
					exceptionHandler78=exceptionHandler();
					state._fsp--;

					adaptor.addChild(root_0, exceptionHandler78.getTree());

					}
					break;

				default :
					break loop24;
				}
			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:427:25: ( finallyClause )?
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==FINALLY) ) {
				alt25=1;
			}
			switch (alt25) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:427:25: finallyClause
					{
					pushFollow(FOLLOW_finallyClause_in_exceptionGroup1794);
					finallyClause79=finallyClause();
					state._fsp--;

					adaptor.addChild(root_0, finallyClause79.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exceptionGroup"


	public static class exceptionHandler_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "exceptionHandler"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:432:1: exceptionHandler : CATCH ARG_ACTION ACTION -> ^( CATCH ARG_ACTION ACTION ) ;
	public final ANTLRParser.exceptionHandler_return exceptionHandler() throws RecognitionException {
		ANTLRParser.exceptionHandler_return retval = new ANTLRParser.exceptionHandler_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token CATCH80=null;
		Token ARG_ACTION81=null;
		Token ACTION82=null;

		GrammarAST CATCH80_tree=null;
		GrammarAST ARG_ACTION81_tree=null;
		GrammarAST ACTION82_tree=null;
		RewriteRuleTokenStream stream_CATCH=new RewriteRuleTokenStream(adaptor,"token CATCH");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleTokenStream stream_ARG_ACTION=new RewriteRuleTokenStream(adaptor,"token ARG_ACTION");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:433:2: ( CATCH ARG_ACTION ACTION -> ^( CATCH ARG_ACTION ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:433:4: CATCH ARG_ACTION ACTION
			{
			CATCH80=(Token)match(input,CATCH,FOLLOW_CATCH_in_exceptionHandler1811);  
			stream_CATCH.add(CATCH80);

			ARG_ACTION81=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_exceptionHandler1813);  
			stream_ARG_ACTION.add(ARG_ACTION81);

			ACTION82=(Token)match(input,ACTION,FOLLOW_ACTION_in_exceptionHandler1815);  
			stream_ACTION.add(ACTION82);

			// AST REWRITE
			// elements: ACTION, ARG_ACTION, CATCH
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 433:28: -> ^( CATCH ARG_ACTION ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:433:31: ^( CATCH ARG_ACTION ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_CATCH.nextNode(), root_1);
				adaptor.addChild(root_1, new ActionAST(stream_ARG_ACTION.nextToken()));
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exceptionHandler"


	public static class finallyClause_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "finallyClause"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:436:1: finallyClause : FINALLY ACTION -> ^( FINALLY ACTION ) ;
	public final ANTLRParser.finallyClause_return finallyClause() throws RecognitionException {
		ANTLRParser.finallyClause_return retval = new ANTLRParser.finallyClause_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token FINALLY83=null;
		Token ACTION84=null;

		GrammarAST FINALLY83_tree=null;
		GrammarAST ACTION84_tree=null;
		RewriteRuleTokenStream stream_FINALLY=new RewriteRuleTokenStream(adaptor,"token FINALLY");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:437:2: ( FINALLY ACTION -> ^( FINALLY ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:437:4: FINALLY ACTION
			{
			FINALLY83=(Token)match(input,FINALLY,FOLLOW_FINALLY_in_finallyClause1842);  
			stream_FINALLY.add(FINALLY83);

			ACTION84=(Token)match(input,ACTION,FOLLOW_ACTION_in_finallyClause1844);  
			stream_ACTION.add(ACTION84);

			// AST REWRITE
			// elements: FINALLY, ACTION
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 437:19: -> ^( FINALLY ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:437:22: ^( FINALLY ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_FINALLY.nextNode(), root_1);
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "finallyClause"


	public static class rulePrequels_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rulePrequels"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:440:1: rulePrequels : sync ( rulePrequel sync )* -> ( rulePrequel )* ;
	public final ANTLRParser.rulePrequels_return rulePrequels() throws RecognitionException {
		ANTLRParser.rulePrequels_return retval = new ANTLRParser.rulePrequels_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope sync85 =null;
		ParserRuleReturnScope rulePrequel86 =null;
		ParserRuleReturnScope sync87 =null;

		RewriteRuleSubtreeStream stream_rulePrequel=new RewriteRuleSubtreeStream(adaptor,"rule rulePrequel");
		RewriteRuleSubtreeStream stream_sync=new RewriteRuleSubtreeStream(adaptor,"rule sync");

		 paraphrases.push("matching rule preamble"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:443:2: ( sync ( rulePrequel sync )* -> ( rulePrequel )* )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:443:4: sync ( rulePrequel sync )*
			{
			pushFollow(FOLLOW_sync_in_rulePrequels1876);
			sync85=sync();
			state._fsp--;

			stream_sync.add(sync85.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:443:9: ( rulePrequel sync )*
			loop26:
			while (true) {
				int alt26=2;
				int LA26_0 = input.LA(1);
				if ( (LA26_0==AT||LA26_0==OPTIONS) ) {
					alt26=1;
				}

				switch (alt26) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:443:10: rulePrequel sync
					{
					pushFollow(FOLLOW_rulePrequel_in_rulePrequels1879);
					rulePrequel86=rulePrequel();
					state._fsp--;

					stream_rulePrequel.add(rulePrequel86.getTree());
					pushFollow(FOLLOW_sync_in_rulePrequels1881);
					sync87=sync();
					state._fsp--;

					stream_sync.add(sync87.getTree());
					}
					break;

				default :
					break loop26;
				}
			}

			// AST REWRITE
			// elements: rulePrequel
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 443:29: -> ( rulePrequel )*
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:443:32: ( rulePrequel )*
				while ( stream_rulePrequel.hasNext() ) {
					adaptor.addChild(root_0, stream_rulePrequel.nextTree());
				}
				stream_rulePrequel.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rulePrequels"


	public static class rulePrequel_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "rulePrequel"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:449:1: rulePrequel : ( optionsSpec | ruleAction );
	public final ANTLRParser.rulePrequel_return rulePrequel() throws RecognitionException {
		ANTLRParser.rulePrequel_return retval = new ANTLRParser.rulePrequel_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope optionsSpec88 =null;
		ParserRuleReturnScope ruleAction89 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:450:5: ( optionsSpec | ruleAction )
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==OPTIONS) ) {
				alt27=1;
			}
			else if ( (LA27_0==AT) ) {
				alt27=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 27, 0, input);
				throw nvae;
			}

			switch (alt27) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:450:7: optionsSpec
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_optionsSpec_in_rulePrequel1905);
					optionsSpec88=optionsSpec();
					state._fsp--;

					adaptor.addChild(root_0, optionsSpec88.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:451:7: ruleAction
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_ruleAction_in_rulePrequel1913);
					ruleAction89=ruleAction();
					state._fsp--;

					adaptor.addChild(root_0, ruleAction89.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rulePrequel"


	public static class ruleReturns_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleReturns"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:460:1: ruleReturns : RETURNS ^ ARG_ACTION ;
	public final ANTLRParser.ruleReturns_return ruleReturns() throws RecognitionException {
		ANTLRParser.ruleReturns_return retval = new ANTLRParser.ruleReturns_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RETURNS90=null;
		Token ARG_ACTION91=null;

		GrammarAST RETURNS90_tree=null;
		GrammarAST ARG_ACTION91_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:461:2: ( RETURNS ^ ARG_ACTION )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:461:4: RETURNS ^ ARG_ACTION
			{
			root_0 = (GrammarAST)adaptor.nil();


			RETURNS90=(Token)match(input,RETURNS,FOLLOW_RETURNS_in_ruleReturns1933); 
			RETURNS90_tree = (GrammarAST)adaptor.create(RETURNS90);
			root_0 = (GrammarAST)adaptor.becomeRoot(RETURNS90_tree, root_0);

			ARG_ACTION91=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_ruleReturns1936); 
			ARG_ACTION91_tree = new ActionAST(ARG_ACTION91) ;
			adaptor.addChild(root_0, ARG_ACTION91_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleReturns"


	public static class throwsSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "throwsSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:475:1: throwsSpec : THROWS qid ( COMMA qid )* -> ^( THROWS ( qid )+ ) ;
	public final ANTLRParser.throwsSpec_return throwsSpec() throws RecognitionException {
		ANTLRParser.throwsSpec_return retval = new ANTLRParser.throwsSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token THROWS92=null;
		Token COMMA94=null;
		ParserRuleReturnScope qid93 =null;
		ParserRuleReturnScope qid95 =null;

		GrammarAST THROWS92_tree=null;
		GrammarAST COMMA94_tree=null;
		RewriteRuleTokenStream stream_THROWS=new RewriteRuleTokenStream(adaptor,"token THROWS");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_qid=new RewriteRuleSubtreeStream(adaptor,"rule qid");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:476:5: ( THROWS qid ( COMMA qid )* -> ^( THROWS ( qid )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:476:7: THROWS qid ( COMMA qid )*
			{
			THROWS92=(Token)match(input,THROWS,FOLLOW_THROWS_in_throwsSpec1964);  
			stream_THROWS.add(THROWS92);

			pushFollow(FOLLOW_qid_in_throwsSpec1966);
			qid93=qid();
			state._fsp--;

			stream_qid.add(qid93.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:476:18: ( COMMA qid )*
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==COMMA) ) {
					alt28=1;
				}

				switch (alt28) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:476:19: COMMA qid
					{
					COMMA94=(Token)match(input,COMMA,FOLLOW_COMMA_in_throwsSpec1969);  
					stream_COMMA.add(COMMA94);

					pushFollow(FOLLOW_qid_in_throwsSpec1971);
					qid95=qid();
					state._fsp--;

					stream_qid.add(qid95.getTree());
					}
					break;

				default :
					break loop28;
				}
			}

			// AST REWRITE
			// elements: THROWS, qid
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 476:31: -> ^( THROWS ( qid )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:476:34: ^( THROWS ( qid )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_THROWS.nextNode(), root_1);
				if ( !(stream_qid.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_qid.hasNext() ) {
					adaptor.addChild(root_1, stream_qid.nextTree());
				}
				stream_qid.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "throwsSpec"


	public static class localsSpec_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "localsSpec"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:480:1: localsSpec : LOCALS ^ ARG_ACTION ;
	public final ANTLRParser.localsSpec_return localsSpec() throws RecognitionException {
		ANTLRParser.localsSpec_return retval = new ANTLRParser.localsSpec_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LOCALS96=null;
		Token ARG_ACTION97=null;

		GrammarAST LOCALS96_tree=null;
		GrammarAST ARG_ACTION97_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:480:12: ( LOCALS ^ ARG_ACTION )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:480:14: LOCALS ^ ARG_ACTION
			{
			root_0 = (GrammarAST)adaptor.nil();


			LOCALS96=(Token)match(input,LOCALS,FOLLOW_LOCALS_in_localsSpec1996); 
			LOCALS96_tree = (GrammarAST)adaptor.create(LOCALS96);
			root_0 = (GrammarAST)adaptor.becomeRoot(LOCALS96_tree, root_0);

			ARG_ACTION97=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_localsSpec1999); 
			ARG_ACTION97_tree = new ActionAST(ARG_ACTION97) ;
			adaptor.addChild(root_0, ARG_ACTION97_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "localsSpec"


	public static class ruleAction_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleAction"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:491:1: ruleAction : AT id ACTION -> ^( AT id ACTION ) ;
	public final ANTLRParser.ruleAction_return ruleAction() throws RecognitionException {
		ANTLRParser.ruleAction_return retval = new ANTLRParser.ruleAction_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token AT98=null;
		Token ACTION100=null;
		ParserRuleReturnScope id99 =null;

		GrammarAST AT98_tree=null;
		GrammarAST ACTION100_tree=null;
		RewriteRuleTokenStream stream_AT=new RewriteRuleTokenStream(adaptor,"token AT");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:492:2: ( AT id ACTION -> ^( AT id ACTION ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:492:4: AT id ACTION
			{
			AT98=(Token)match(input,AT,FOLLOW_AT_in_ruleAction2022);  
			stream_AT.add(AT98);

			pushFollow(FOLLOW_id_in_ruleAction2024);
			id99=id();
			state._fsp--;

			stream_id.add(id99.getTree());
			ACTION100=(Token)match(input,ACTION,FOLLOW_ACTION_in_ruleAction2026);  
			stream_ACTION.add(ACTION100);

			// AST REWRITE
			// elements: ACTION, id, AT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 492:17: -> ^( AT id ACTION )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:492:20: ^( AT id ACTION )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(stream_AT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_id.nextTree());
				adaptor.addChild(root_1, new ActionAST(stream_ACTION.nextToken()));
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleAction"


	public static class ruleBlock_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleBlock"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:501:1: ruleBlock : ruleAltList -> ^( BLOCK[colon,\"BLOCK\"] ruleAltList ) ;
	public final ANTLRParser.ruleBlock_return ruleBlock() throws RecognitionException {
		ANTLRParser.ruleBlock_return retval = new ANTLRParser.ruleBlock_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope ruleAltList101 =null;

		RewriteRuleSubtreeStream stream_ruleAltList=new RewriteRuleSubtreeStream(adaptor,"rule ruleAltList");

		Token colon = input.LT(-1);
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:503:5: ( ruleAltList -> ^( BLOCK[colon,\"BLOCK\"] ruleAltList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:503:7: ruleAltList
			{
			pushFollow(FOLLOW_ruleAltList_in_ruleBlock2064);
			ruleAltList101=ruleAltList();
			state._fsp--;

			stream_ruleAltList.add(ruleAltList101.getTree());
			// AST REWRITE
			// elements: ruleAltList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 503:19: -> ^( BLOCK[colon,\"BLOCK\"] ruleAltList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:503:22: ^( BLOCK[colon,\"BLOCK\"] ruleAltList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, colon, "BLOCK"), root_1);
				adaptor.addChild(root_1, stream_ruleAltList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (ResyncToEndOfRuleBlock e) {

			    	// just resyncing; ignore error
					retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), null);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleBlock"


	public static class ruleAltList_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleAltList"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:510:1: ruleAltList : labeledAlt ( OR labeledAlt )* -> ( labeledAlt )+ ;
	public final ANTLRParser.ruleAltList_return ruleAltList() throws RecognitionException {
		ANTLRParser.ruleAltList_return retval = new ANTLRParser.ruleAltList_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OR103=null;
		ParserRuleReturnScope labeledAlt102 =null;
		ParserRuleReturnScope labeledAlt104 =null;

		GrammarAST OR103_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_labeledAlt=new RewriteRuleSubtreeStream(adaptor,"rule labeledAlt");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:511:2: ( labeledAlt ( OR labeledAlt )* -> ( labeledAlt )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:511:4: labeledAlt ( OR labeledAlt )*
			{
			pushFollow(FOLLOW_labeledAlt_in_ruleAltList2100);
			labeledAlt102=labeledAlt();
			state._fsp--;

			stream_labeledAlt.add(labeledAlt102.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:511:15: ( OR labeledAlt )*
			loop29:
			while (true) {
				int alt29=2;
				int LA29_0 = input.LA(1);
				if ( (LA29_0==OR) ) {
					alt29=1;
				}

				switch (alt29) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:511:16: OR labeledAlt
					{
					OR103=(Token)match(input,OR,FOLLOW_OR_in_ruleAltList2103);  
					stream_OR.add(OR103);

					pushFollow(FOLLOW_labeledAlt_in_ruleAltList2105);
					labeledAlt104=labeledAlt();
					state._fsp--;

					stream_labeledAlt.add(labeledAlt104.getTree());
					}
					break;

				default :
					break loop29;
				}
			}

			// AST REWRITE
			// elements: labeledAlt
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 511:32: -> ( labeledAlt )+
			{
				if ( !(stream_labeledAlt.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_labeledAlt.hasNext() ) {
					adaptor.addChild(root_0, stream_labeledAlt.nextTree());
				}
				stream_labeledAlt.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleAltList"


	public static class labeledAlt_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "labeledAlt"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:514:1: labeledAlt : alternative ( POUND ! id !)? ;
	public final ANTLRParser.labeledAlt_return labeledAlt() throws RecognitionException {
		ANTLRParser.labeledAlt_return retval = new ANTLRParser.labeledAlt_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token POUND106=null;
		ParserRuleReturnScope alternative105 =null;
		ParserRuleReturnScope id107 =null;

		GrammarAST POUND106_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:515:2: ( alternative ( POUND ! id !)? )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:515:4: alternative ( POUND ! id !)?
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_alternative_in_labeledAlt2123);
			alternative105=alternative();
			state._fsp--;

			adaptor.addChild(root_0, alternative105.getTree());

			// org\\antlr\\v4\\parse\\ANTLRParser.g:516:3: ( POUND ! id !)?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==POUND) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:516:5: POUND ! id !
					{
					POUND106=(Token)match(input,POUND,FOLLOW_POUND_in_labeledAlt2129); 
					pushFollow(FOLLOW_id_in_labeledAlt2132);
					id107=id();
					state._fsp--;

					((AltAST)(alternative105!=null?((GrammarAST)alternative105.getTree()):null)).altLabel=(id107!=null?((GrammarAST)id107.getTree()):null);
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledAlt"


	public static class lexerRule_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerRule"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:520:1: lexerRule : ( DOC_COMMENT )? ( FRAGMENT )? TOKEN_REF COLON lexerRuleBlock SEMI -> ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock ) ;
	public final ANTLRParser.lexerRule_return lexerRule() throws RecognitionException {
		ANTLRParser.lexerRule_return retval = new ANTLRParser.lexerRule_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOC_COMMENT108=null;
		Token FRAGMENT109=null;
		Token TOKEN_REF110=null;
		Token COLON111=null;
		Token SEMI113=null;
		ParserRuleReturnScope lexerRuleBlock112 =null;

		GrammarAST DOC_COMMENT108_tree=null;
		GrammarAST FRAGMENT109_tree=null;
		GrammarAST TOKEN_REF110_tree=null;
		GrammarAST COLON111_tree=null;
		GrammarAST SEMI113_tree=null;
		RewriteRuleTokenStream stream_DOC_COMMENT=new RewriteRuleTokenStream(adaptor,"token DOC_COMMENT");
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
		RewriteRuleTokenStream stream_FRAGMENT=new RewriteRuleTokenStream(adaptor,"token FRAGMENT");
		RewriteRuleTokenStream stream_TOKEN_REF=new RewriteRuleTokenStream(adaptor,"token TOKEN_REF");
		RewriteRuleSubtreeStream stream_lexerRuleBlock=new RewriteRuleSubtreeStream(adaptor,"rule lexerRuleBlock");

		 paraphrases.push("matching a lexer rule"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:5: ( ( DOC_COMMENT )? ( FRAGMENT )? TOKEN_REF COLON lexerRuleBlock SEMI -> ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:7: ( DOC_COMMENT )? ( FRAGMENT )? TOKEN_REF COLON lexerRuleBlock SEMI
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:7: ( DOC_COMMENT )?
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==DOC_COMMENT) ) {
				alt31=1;
			}
			switch (alt31) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:525:7: DOC_COMMENT
					{
					DOC_COMMENT108=(Token)match(input,DOC_COMMENT,FOLLOW_DOC_COMMENT_in_lexerRule2164);  
					stream_DOC_COMMENT.add(DOC_COMMENT108);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:525:20: ( FRAGMENT )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==FRAGMENT) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:525:20: FRAGMENT
					{
					FRAGMENT109=(Token)match(input,FRAGMENT,FOLLOW_FRAGMENT_in_lexerRule2167);  
					stream_FRAGMENT.add(FRAGMENT109);

					}
					break;

			}

			TOKEN_REF110=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_lexerRule2173);  
			stream_TOKEN_REF.add(TOKEN_REF110);

			COLON111=(Token)match(input,COLON,FOLLOW_COLON_in_lexerRule2175);  
			stream_COLON.add(COLON111);

			pushFollow(FOLLOW_lexerRuleBlock_in_lexerRule2177);
			lexerRuleBlock112=lexerRuleBlock();
			state._fsp--;

			stream_lexerRuleBlock.add(lexerRuleBlock112.getTree());
			SEMI113=(Token)match(input,SEMI,FOLLOW_SEMI_in_lexerRule2179);  
			stream_SEMI.add(SEMI113);

			// AST REWRITE
			// elements: DOC_COMMENT, TOKEN_REF, lexerRuleBlock, FRAGMENT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 527:7: -> ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:527:10: ^( RULE TOKEN_REF ( DOC_COMMENT )? ( ^( RULEMODIFIERS FRAGMENT ) )? lexerRuleBlock )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new RuleAST(RULE), root_1);
				adaptor.addChild(root_1, stream_TOKEN_REF.nextNode());
				// org\\antlr\\v4\\parse\\ANTLRParser.g:527:37: ( DOC_COMMENT )?
				if ( stream_DOC_COMMENT.hasNext() ) {
					adaptor.addChild(root_1, stream_DOC_COMMENT.nextNode());
				}
				stream_DOC_COMMENT.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:528:9: ( ^( RULEMODIFIERS FRAGMENT ) )?
				if ( stream_FRAGMENT.hasNext() ) {
					// org\\antlr\\v4\\parse\\ANTLRParser.g:528:9: ^( RULEMODIFIERS FRAGMENT )
					{
					GrammarAST root_2 = (GrammarAST)adaptor.nil();
					root_2 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(RULEMODIFIERS, "RULEMODIFIERS"), root_2);
					adaptor.addChild(root_2, stream_FRAGMENT.nextNode());
					adaptor.addChild(root_1, root_2);
					}

				}
				stream_FRAGMENT.reset();

				adaptor.addChild(root_1, stream_lexerRuleBlock.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				paraphrases.pop();

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerRule"


	public static class lexerRuleBlock_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerRuleBlock"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:532:1: lexerRuleBlock : lexerAltList -> ^( BLOCK[colon,\"BLOCK\"] lexerAltList ) ;
	public final ANTLRParser.lexerRuleBlock_return lexerRuleBlock() throws RecognitionException {
		ANTLRParser.lexerRuleBlock_return retval = new ANTLRParser.lexerRuleBlock_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope lexerAltList114 =null;

		RewriteRuleSubtreeStream stream_lexerAltList=new RewriteRuleSubtreeStream(adaptor,"rule lexerAltList");

		Token colon = input.LT(-1);
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:534:5: ( lexerAltList -> ^( BLOCK[colon,\"BLOCK\"] lexerAltList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:534:7: lexerAltList
			{
			pushFollow(FOLLOW_lexerAltList_in_lexerRuleBlock2246);
			lexerAltList114=lexerAltList();
			state._fsp--;

			stream_lexerAltList.add(lexerAltList114.getTree());
			// AST REWRITE
			// elements: lexerAltList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 534:20: -> ^( BLOCK[colon,\"BLOCK\"] lexerAltList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:534:23: ^( BLOCK[colon,\"BLOCK\"] lexerAltList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, colon, "BLOCK"), root_1);
				adaptor.addChild(root_1, stream_lexerAltList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (ResyncToEndOfRuleBlock e) {

			    	// just resyncing; ignore error
					retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), null);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerRuleBlock"


	public static class lexerAltList_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerAltList"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:541:1: lexerAltList : lexerAlt ( OR lexerAlt )* -> ( lexerAlt )+ ;
	public final ANTLRParser.lexerAltList_return lexerAltList() throws RecognitionException {
		ANTLRParser.lexerAltList_return retval = new ANTLRParser.lexerAltList_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OR116=null;
		ParserRuleReturnScope lexerAlt115 =null;
		ParserRuleReturnScope lexerAlt117 =null;

		GrammarAST OR116_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_lexerAlt=new RewriteRuleSubtreeStream(adaptor,"rule lexerAlt");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:542:2: ( lexerAlt ( OR lexerAlt )* -> ( lexerAlt )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:542:4: lexerAlt ( OR lexerAlt )*
			{
			pushFollow(FOLLOW_lexerAlt_in_lexerAltList2282);
			lexerAlt115=lexerAlt();
			state._fsp--;

			stream_lexerAlt.add(lexerAlt115.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:542:13: ( OR lexerAlt )*
			loop33:
			while (true) {
				int alt33=2;
				int LA33_0 = input.LA(1);
				if ( (LA33_0==OR) ) {
					alt33=1;
				}

				switch (alt33) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:542:14: OR lexerAlt
					{
					OR116=(Token)match(input,OR,FOLLOW_OR_in_lexerAltList2285);  
					stream_OR.add(OR116);

					pushFollow(FOLLOW_lexerAlt_in_lexerAltList2287);
					lexerAlt117=lexerAlt();
					state._fsp--;

					stream_lexerAlt.add(lexerAlt117.getTree());
					}
					break;

				default :
					break loop33;
				}
			}

			// AST REWRITE
			// elements: lexerAlt
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 542:28: -> ( lexerAlt )+
			{
				if ( !(stream_lexerAlt.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_lexerAlt.hasNext() ) {
					adaptor.addChild(root_0, stream_lexerAlt.nextTree());
				}
				stream_lexerAlt.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAltList"


	public static class lexerAlt_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerAlt"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:545:1: lexerAlt : ( lexerElements ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements ) | -> ^( ALT EPSILON ) );
	public final ANTLRParser.lexerAlt_return lexerAlt() throws RecognitionException {
		ANTLRParser.lexerAlt_return retval = new ANTLRParser.lexerAlt_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope lexerElements118 =null;
		ParserRuleReturnScope lexerCommands119 =null;

		RewriteRuleSubtreeStream stream_lexerElements=new RewriteRuleSubtreeStream(adaptor,"rule lexerElements");
		RewriteRuleSubtreeStream stream_lexerCommands=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommands");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:546:2: ( lexerElements ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements ) | -> ^( ALT EPSILON ) )
			int alt35=2;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==ACTION||LA35_0==DOT||LA35_0==LEXER_CHAR_SET||LA35_0==LPAREN||LA35_0==NOT||LA35_0==RULE_REF||LA35_0==SEMPRED||LA35_0==STRING_LITERAL||LA35_0==TOKEN_REF) ) {
				alt35=1;
			}
			else if ( (LA35_0==OR||LA35_0==RPAREN||LA35_0==SEMI) ) {
				alt35=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 35, 0, input);
				throw nvae;
			}

			switch (alt35) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:546:4: lexerElements ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements )
					{
					pushFollow(FOLLOW_lexerElements_in_lexerAlt2305);
					lexerElements118=lexerElements();
					state._fsp--;

					stream_lexerElements.add(lexerElements118.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:547:3: ( lexerCommands -> ^( LEXER_ALT_ACTION lexerElements lexerCommands ) | -> lexerElements )
					int alt34=2;
					int LA34_0 = input.LA(1);
					if ( (LA34_0==RARROW) ) {
						alt34=1;
					}
					else if ( (LA34_0==OR||LA34_0==RPAREN||LA34_0==SEMI) ) {
						alt34=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 34, 0, input);
						throw nvae;
					}

					switch (alt34) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:547:5: lexerCommands
							{
							pushFollow(FOLLOW_lexerCommands_in_lexerAlt2311);
							lexerCommands119=lexerCommands();
							state._fsp--;

							stream_lexerCommands.add(lexerCommands119.getTree());
							// AST REWRITE
							// elements: lexerElements, lexerCommands
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 547:19: -> ^( LEXER_ALT_ACTION lexerElements lexerCommands )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:547:22: ^( LEXER_ALT_ACTION lexerElements lexerCommands )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(LEXER_ALT_ACTION), root_1);
								adaptor.addChild(root_1, stream_lexerElements.nextTree());
								adaptor.addChild(root_1, stream_lexerCommands.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:548:9: 
							{
							// AST REWRITE
							// elements: lexerElements
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 548:9: -> lexerElements
							{
								adaptor.addChild(root_0, stream_lexerElements.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:550:9: 
					{
					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 550:9: -> ^( ALT EPSILON )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:550:12: ^( ALT EPSILON )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_1);
						adaptor.addChild(root_1, (GrammarAST)adaptor.create(EPSILON, "EPSILON"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAlt"


	public static class lexerElements_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerElements"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:553:1: lexerElements : ( lexerElement )+ -> ^( ALT ( lexerElement )+ ) ;
	public final ANTLRParser.lexerElements_return lexerElements() throws RecognitionException {
		ANTLRParser.lexerElements_return retval = new ANTLRParser.lexerElements_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope lexerElement120 =null;

		RewriteRuleSubtreeStream stream_lexerElement=new RewriteRuleSubtreeStream(adaptor,"rule lexerElement");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:554:5: ( ( lexerElement )+ -> ^( ALT ( lexerElement )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:554:7: ( lexerElement )+
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:554:7: ( lexerElement )+
			int cnt36=0;
			loop36:
			while (true) {
				int alt36=2;
				int LA36_0 = input.LA(1);
				if ( (LA36_0==ACTION||LA36_0==DOT||LA36_0==LEXER_CHAR_SET||LA36_0==LPAREN||LA36_0==NOT||LA36_0==RULE_REF||LA36_0==SEMPRED||LA36_0==STRING_LITERAL||LA36_0==TOKEN_REF) ) {
					alt36=1;
				}

				switch (alt36) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:554:7: lexerElement
					{
					pushFollow(FOLLOW_lexerElement_in_lexerElements2374);
					lexerElement120=lexerElement();
					state._fsp--;

					stream_lexerElement.add(lexerElement120.getTree());
					}
					break;

				default :
					if ( cnt36 >= 1 ) break loop36;
					EarlyExitException eee = new EarlyExitException(36, input);
					throw eee;
				}
				cnt36++;
			}

			// AST REWRITE
			// elements: lexerElement
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 554:21: -> ^( ALT ( lexerElement )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:554:24: ^( ALT ( lexerElement )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_1);
				if ( !(stream_lexerElement.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_lexerElement.hasNext() ) {
					adaptor.addChild(root_1, stream_lexerElement.nextTree());
				}
				stream_lexerElement.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerElements"


	public static class lexerElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:557:1: lexerElement : ( labeledLexerElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement ) | lexerAtom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom ) | lexerBlock ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock ) | actionElement );
	public final ANTLRParser.lexerElement_return lexerElement() throws RecognitionException {
		ANTLRParser.lexerElement_return retval = new ANTLRParser.lexerElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope labeledLexerElement121 =null;
		ParserRuleReturnScope ebnfSuffix122 =null;
		ParserRuleReturnScope lexerAtom123 =null;
		ParserRuleReturnScope ebnfSuffix124 =null;
		ParserRuleReturnScope lexerBlock125 =null;
		ParserRuleReturnScope ebnfSuffix126 =null;
		ParserRuleReturnScope actionElement127 =null;

		RewriteRuleSubtreeStream stream_ebnfSuffix=new RewriteRuleSubtreeStream(adaptor,"rule ebnfSuffix");
		RewriteRuleSubtreeStream stream_lexerBlock=new RewriteRuleSubtreeStream(adaptor,"rule lexerBlock");
		RewriteRuleSubtreeStream stream_labeledLexerElement=new RewriteRuleSubtreeStream(adaptor,"rule labeledLexerElement");
		RewriteRuleSubtreeStream stream_lexerAtom=new RewriteRuleSubtreeStream(adaptor,"rule lexerAtom");


			paraphrases.push("looking for lexer rule element");
			int m = input.mark();

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:563:2: ( labeledLexerElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement ) | lexerAtom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom ) | lexerBlock ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock ) | actionElement )
			int alt40=4;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				int LA40_1 = input.LA(2);
				if ( (LA40_1==ASSIGN||LA40_1==PLUS_ASSIGN) ) {
					alt40=1;
				}
				else if ( (LA40_1==ACTION||LA40_1==DOT||LA40_1==LEXER_CHAR_SET||LA40_1==LPAREN||LA40_1==NOT||LA40_1==OR||LA40_1==PLUS||LA40_1==QUESTION||LA40_1==RARROW||(LA40_1 >= RPAREN && LA40_1 <= SEMPRED)||(LA40_1 >= STAR && LA40_1 <= STRING_LITERAL)||LA40_1==TOKEN_REF) ) {
					alt40=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 40, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TOKEN_REF:
				{
				int LA40_2 = input.LA(2);
				if ( (LA40_2==ASSIGN||LA40_2==PLUS_ASSIGN) ) {
					alt40=1;
				}
				else if ( (LA40_2==ACTION||LA40_2==DOT||LA40_2==LEXER_CHAR_SET||(LA40_2 >= LPAREN && LA40_2 <= LT)||LA40_2==NOT||LA40_2==OR||LA40_2==PLUS||LA40_2==QUESTION||LA40_2==RARROW||(LA40_2 >= RPAREN && LA40_2 <= SEMPRED)||(LA40_2 >= STAR && LA40_2 <= STRING_LITERAL)||LA40_2==TOKEN_REF) ) {
					alt40=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 40, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DOT:
			case LEXER_CHAR_SET:
			case NOT:
			case STRING_LITERAL:
				{
				alt40=2;
				}
				break;
			case LPAREN:
				{
				alt40=3;
				}
				break;
			case ACTION:
			case SEMPRED:
				{
				alt40=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}
			switch (alt40) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:563:4: labeledLexerElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement )
					{
					pushFollow(FOLLOW_labeledLexerElement_in_lexerElement2411);
					labeledLexerElement121=labeledLexerElement();
					state._fsp--;

					stream_labeledLexerElement.add(labeledLexerElement121.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:564:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) ) | -> labeledLexerElement )
					int alt37=2;
					int LA37_0 = input.LA(1);
					if ( (LA37_0==PLUS||LA37_0==QUESTION||LA37_0==STAR) ) {
						alt37=1;
					}
					else if ( (LA37_0==ACTION||LA37_0==DOT||LA37_0==LEXER_CHAR_SET||LA37_0==LPAREN||LA37_0==NOT||LA37_0==OR||LA37_0==RARROW||(LA37_0 >= RPAREN && LA37_0 <= SEMPRED)||LA37_0==STRING_LITERAL||LA37_0==TOKEN_REF) ) {
						alt37=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 37, 0, input);
						throw nvae;
					}

					switch (alt37) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:564:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_lexerElement2417);
							ebnfSuffix122=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix122.getTree());
							// AST REWRITE
							// elements: labeledLexerElement, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 564:16: -> ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:564:19: ^( ebnfSuffix ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:564:33: ^( BLOCK[$labeledLexerElement.start,\"BLOCK\"] ^( ALT labeledLexerElement ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (labeledLexerElement121!=null?(labeledLexerElement121.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:564:87: ^( ALT labeledLexerElement )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_labeledLexerElement.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:565:8: 
							{
							// AST REWRITE
							// elements: labeledLexerElement
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 565:8: -> labeledLexerElement
							{
								adaptor.addChild(root_0, stream_labeledLexerElement.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:567:4: lexerAtom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom )
					{
					pushFollow(FOLLOW_lexerAtom_in_lexerElement2463);
					lexerAtom123=lexerAtom();
					state._fsp--;

					stream_lexerAtom.add(lexerAtom123.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:568:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) ) | -> lexerAtom )
					int alt38=2;
					int LA38_0 = input.LA(1);
					if ( (LA38_0==PLUS||LA38_0==QUESTION||LA38_0==STAR) ) {
						alt38=1;
					}
					else if ( (LA38_0==ACTION||LA38_0==DOT||LA38_0==LEXER_CHAR_SET||LA38_0==LPAREN||LA38_0==NOT||LA38_0==OR||LA38_0==RARROW||(LA38_0 >= RPAREN && LA38_0 <= SEMPRED)||LA38_0==STRING_LITERAL||LA38_0==TOKEN_REF) ) {
						alt38=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 38, 0, input);
						throw nvae;
					}

					switch (alt38) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:568:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_lexerElement2469);
							ebnfSuffix124=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix124.getTree());
							// AST REWRITE
							// elements: lexerAtom, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 568:16: -> ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:568:19: ^( ebnfSuffix ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:568:33: ^( BLOCK[$lexerAtom.start,\"BLOCK\"] ^( ALT lexerAtom ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (lexerAtom123!=null?(lexerAtom123.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:568:77: ^( ALT lexerAtom )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_lexerAtom.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:569:8: 
							{
							// AST REWRITE
							// elements: lexerAtom
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 569:8: -> lexerAtom
							{
								adaptor.addChild(root_0, stream_lexerAtom.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:571:4: lexerBlock ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock )
					{
					pushFollow(FOLLOW_lexerBlock_in_lexerElement2515);
					lexerBlock125=lexerBlock();
					state._fsp--;

					stream_lexerBlock.add(lexerBlock125.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:572:3: ( ebnfSuffix -> ^( ebnfSuffix lexerBlock ) | -> lexerBlock )
					int alt39=2;
					int LA39_0 = input.LA(1);
					if ( (LA39_0==PLUS||LA39_0==QUESTION||LA39_0==STAR) ) {
						alt39=1;
					}
					else if ( (LA39_0==ACTION||LA39_0==DOT||LA39_0==LEXER_CHAR_SET||LA39_0==LPAREN||LA39_0==NOT||LA39_0==OR||LA39_0==RARROW||(LA39_0 >= RPAREN && LA39_0 <= SEMPRED)||LA39_0==STRING_LITERAL||LA39_0==TOKEN_REF) ) {
						alt39=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 39, 0, input);
						throw nvae;
					}

					switch (alt39) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:572:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_lexerElement2521);
							ebnfSuffix126=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix126.getTree());
							// AST REWRITE
							// elements: lexerBlock, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 572:16: -> ^( ebnfSuffix lexerBlock )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:572:19: ^( ebnfSuffix lexerBlock )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								adaptor.addChild(root_1, stream_lexerBlock.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:573:8: 
							{
							// AST REWRITE
							// elements: lexerBlock
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 573:8: -> lexerBlock
							{
								adaptor.addChild(root_0, stream_lexerBlock.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:575:4: actionElement
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_actionElement_in_lexerElement2549);
					actionElement127=actionElement();
					state._fsp--;

					adaptor.addChild(root_0, actionElement127.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {

			    	retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
			    	int ttype = input.get(input.range()).getType(); // seems to be next token
				    // look for anything that really belongs at the start of the rule minus the initial ID
			    	if ( ttype==COLON || ttype==RETURNS || ttype==CATCH || ttype==FINALLY || ttype==AT || ttype==EOF ) {
						RecognitionException missingSemi =
							new v4ParserException("unterminated rule (missing ';') detected at '"+
												  input.LT(1).getText()+" "+input.LT(2).getText()+"'", input);
						reportError(missingSemi);
						if ( ttype==EOF ) {
							input.seek(input.index()+1);
						}
						else if ( ttype==CATCH || ttype==FINALLY ) {
							input.seek(input.range()); // ignore what's before rule trailer stuff
						}
						else if ( ttype==RETURNS || ttype==AT ) { // scan back looking for ID of rule header
							int p = input.index();
							Token t = input.get(p);
							while ( t.getType()!=RULE_REF && t.getType()!=TOKEN_REF ) {
								p--;
								t = input.get(p);
							}
							input.seek(p);
						}
						throw new ResyncToEndOfRuleBlock(); // make sure it goes back to rule block level to recover
					}
			        reportError(re);
			        recover(input,re);
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerElement"


	public static class labeledLexerElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "labeledLexerElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:608:1: labeledLexerElement : id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) ) ;
	public final ANTLRParser.labeledLexerElement_return labeledLexerElement() throws RecognitionException {
		ANTLRParser.labeledLexerElement_return retval = new ANTLRParser.labeledLexerElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ass=null;
		ParserRuleReturnScope id128 =null;
		ParserRuleReturnScope lexerAtom129 =null;
		ParserRuleReturnScope lexerBlock130 =null;

		GrammarAST ass_tree=null;
		RewriteRuleTokenStream stream_ASSIGN=new RewriteRuleTokenStream(adaptor,"token ASSIGN");
		RewriteRuleTokenStream stream_PLUS_ASSIGN=new RewriteRuleTokenStream(adaptor,"token PLUS_ASSIGN");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_lexerBlock=new RewriteRuleSubtreeStream(adaptor,"rule lexerBlock");
		RewriteRuleSubtreeStream stream_lexerAtom=new RewriteRuleSubtreeStream(adaptor,"rule lexerAtom");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:609:2: ( id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:609:4: id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) )
			{
			pushFollow(FOLLOW_id_in_labeledLexerElement2579);
			id128=id();
			state._fsp--;

			stream_id.add(id128.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:609:7: (ass= ASSIGN |ass= PLUS_ASSIGN )
			int alt41=2;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==ASSIGN) ) {
				alt41=1;
			}
			else if ( (LA41_0==PLUS_ASSIGN) ) {
				alt41=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 41, 0, input);
				throw nvae;
			}

			switch (alt41) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:609:8: ass= ASSIGN
					{
					ass=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_labeledLexerElement2584);  
					stream_ASSIGN.add(ass);

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:609:19: ass= PLUS_ASSIGN
					{
					ass=(Token)match(input,PLUS_ASSIGN,FOLLOW_PLUS_ASSIGN_in_labeledLexerElement2588);  
					stream_PLUS_ASSIGN.add(ass);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:610:3: ( lexerAtom -> ^( $ass id lexerAtom ) | lexerBlock -> ^( $ass id lexerBlock ) )
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==DOT||LA42_0==LEXER_CHAR_SET||LA42_0==NOT||LA42_0==RULE_REF||LA42_0==STRING_LITERAL||LA42_0==TOKEN_REF) ) {
				alt42=1;
			}
			else if ( (LA42_0==LPAREN) ) {
				alt42=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:610:5: lexerAtom
					{
					pushFollow(FOLLOW_lexerAtom_in_labeledLexerElement2595);
					lexerAtom129=lexerAtom();
					state._fsp--;

					stream_lexerAtom.add(lexerAtom129.getTree());
					// AST REWRITE
					// elements: id, ass, lexerAtom
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 610:15: -> ^( $ass id lexerAtom )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:610:18: ^( $ass id lexerAtom )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_lexerAtom.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:611:5: lexerBlock
					{
					pushFollow(FOLLOW_lexerBlock_in_labeledLexerElement2612);
					lexerBlock130=lexerBlock();
					state._fsp--;

					stream_lexerBlock.add(lexerBlock130.getTree());
					// AST REWRITE
					// elements: id, lexerBlock, ass
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 611:16: -> ^( $ass id lexerBlock )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:611:19: ^( $ass id lexerBlock )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_lexerBlock.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledLexerElement"


	public static class lexerBlock_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerBlock"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:616:1: lexerBlock : LPAREN ( optionsSpec COLON )? lexerAltList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList ) ;
	public final ANTLRParser.lexerBlock_return lexerBlock() throws RecognitionException {
		ANTLRParser.lexerBlock_return retval = new ANTLRParser.lexerBlock_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN131=null;
		Token COLON133=null;
		Token RPAREN135=null;
		ParserRuleReturnScope optionsSpec132 =null;
		ParserRuleReturnScope lexerAltList134 =null;

		GrammarAST LPAREN131_tree=null;
		GrammarAST COLON133_tree=null;
		GrammarAST RPAREN135_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleSubtreeStream stream_optionsSpec=new RewriteRuleSubtreeStream(adaptor,"rule optionsSpec");
		RewriteRuleSubtreeStream stream_lexerAltList=new RewriteRuleSubtreeStream(adaptor,"rule lexerAltList");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:623:3: ( LPAREN ( optionsSpec COLON )? lexerAltList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:623:5: LPAREN ( optionsSpec COLON )? lexerAltList RPAREN
			{
			LPAREN131=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_lexerBlock2645);  
			stream_LPAREN.add(LPAREN131);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:624:9: ( optionsSpec COLON )?
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==OPTIONS) ) {
				alt43=1;
			}
			switch (alt43) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:624:11: optionsSpec COLON
					{
					pushFollow(FOLLOW_optionsSpec_in_lexerBlock2657);
					optionsSpec132=optionsSpec();
					state._fsp--;

					stream_optionsSpec.add(optionsSpec132.getTree());
					COLON133=(Token)match(input,COLON,FOLLOW_COLON_in_lexerBlock2659);  
					stream_COLON.add(COLON133);

					}
					break;

			}

			pushFollow(FOLLOW_lexerAltList_in_lexerBlock2672);
			lexerAltList134=lexerAltList();
			state._fsp--;

			stream_lexerAltList.add(lexerAltList134.getTree());
			RPAREN135=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_lexerBlock2682);  
			stream_RPAREN.add(RPAREN135);

			// AST REWRITE
			// elements: lexerAltList, optionsSpec
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 627:7: -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:627:10: ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? lexerAltList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, LPAREN131, "BLOCK"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:627:45: ( optionsSpec )?
				if ( stream_optionsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_optionsSpec.nextTree());
				}
				stream_optionsSpec.reset();

				adaptor.addChild(root_1, stream_lexerAltList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerBlock"


	public static class lexerCommands_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommands"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:631:1: lexerCommands : RARROW lexerCommand ( COMMA lexerCommand )* -> ( lexerCommand )+ ;
	public final ANTLRParser.lexerCommands_return lexerCommands() throws RecognitionException {
		ANTLRParser.lexerCommands_return retval = new ANTLRParser.lexerCommands_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RARROW136=null;
		Token COMMA138=null;
		ParserRuleReturnScope lexerCommand137 =null;
		ParserRuleReturnScope lexerCommand139 =null;

		GrammarAST RARROW136_tree=null;
		GrammarAST COMMA138_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_RARROW=new RewriteRuleTokenStream(adaptor,"token RARROW");
		RewriteRuleSubtreeStream stream_lexerCommand=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommand");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:632:2: ( RARROW lexerCommand ( COMMA lexerCommand )* -> ( lexerCommand )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:632:4: RARROW lexerCommand ( COMMA lexerCommand )*
			{
			RARROW136=(Token)match(input,RARROW,FOLLOW_RARROW_in_lexerCommands2719);  
			stream_RARROW.add(RARROW136);

			pushFollow(FOLLOW_lexerCommand_in_lexerCommands2721);
			lexerCommand137=lexerCommand();
			state._fsp--;

			stream_lexerCommand.add(lexerCommand137.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:632:24: ( COMMA lexerCommand )*
			loop44:
			while (true) {
				int alt44=2;
				int LA44_0 = input.LA(1);
				if ( (LA44_0==COMMA) ) {
					alt44=1;
				}

				switch (alt44) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:632:25: COMMA lexerCommand
					{
					COMMA138=(Token)match(input,COMMA,FOLLOW_COMMA_in_lexerCommands2724);  
					stream_COMMA.add(COMMA138);

					pushFollow(FOLLOW_lexerCommand_in_lexerCommands2726);
					lexerCommand139=lexerCommand();
					state._fsp--;

					stream_lexerCommand.add(lexerCommand139.getTree());
					}
					break;

				default :
					break loop44;
				}
			}

			// AST REWRITE
			// elements: lexerCommand
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 632:46: -> ( lexerCommand )+
			{
				if ( !(stream_lexerCommand.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_lexerCommand.hasNext() ) {
					adaptor.addChild(root_0, stream_lexerCommand.nextTree());
				}
				stream_lexerCommand.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommands"


	public static class lexerCommand_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommand"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:635:1: lexerCommand : ( lexerCommandName LPAREN lexerCommandExpr RPAREN -> ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr ) | lexerCommandName );
	public final ANTLRParser.lexerCommand_return lexerCommand() throws RecognitionException {
		ANTLRParser.lexerCommand_return retval = new ANTLRParser.lexerCommand_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN141=null;
		Token RPAREN143=null;
		ParserRuleReturnScope lexerCommandName140 =null;
		ParserRuleReturnScope lexerCommandExpr142 =null;
		ParserRuleReturnScope lexerCommandName144 =null;

		GrammarAST LPAREN141_tree=null;
		GrammarAST RPAREN143_tree=null;
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleSubtreeStream stream_lexerCommandName=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommandName");
		RewriteRuleSubtreeStream stream_lexerCommandExpr=new RewriteRuleSubtreeStream(adaptor,"rule lexerCommandExpr");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:636:2: ( lexerCommandName LPAREN lexerCommandExpr RPAREN -> ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr ) | lexerCommandName )
			int alt45=2;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				int LA45_1 = input.LA(2);
				if ( (LA45_1==LPAREN) ) {
					alt45=1;
				}
				else if ( (LA45_1==COMMA||LA45_1==OR||LA45_1==RPAREN||LA45_1==SEMI) ) {
					alt45=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 45, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TOKEN_REF:
				{
				int LA45_2 = input.LA(2);
				if ( (LA45_2==LPAREN) ) {
					alt45=1;
				}
				else if ( (LA45_2==COMMA||LA45_2==OR||LA45_2==RPAREN||LA45_2==SEMI) ) {
					alt45=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 45, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case MODE:
				{
				int LA45_3 = input.LA(2);
				if ( (LA45_3==LPAREN) ) {
					alt45=1;
				}
				else if ( (LA45_3==COMMA||LA45_3==OR||LA45_3==RPAREN||LA45_3==SEMI) ) {
					alt45=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 45, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 45, 0, input);
				throw nvae;
			}
			switch (alt45) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:636:4: lexerCommandName LPAREN lexerCommandExpr RPAREN
					{
					pushFollow(FOLLOW_lexerCommandName_in_lexerCommand2744);
					lexerCommandName140=lexerCommandName();
					state._fsp--;

					stream_lexerCommandName.add(lexerCommandName140.getTree());
					LPAREN141=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_lexerCommand2746);  
					stream_LPAREN.add(LPAREN141);

					pushFollow(FOLLOW_lexerCommandExpr_in_lexerCommand2748);
					lexerCommandExpr142=lexerCommandExpr();
					state._fsp--;

					stream_lexerCommandExpr.add(lexerCommandExpr142.getTree());
					RPAREN143=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_lexerCommand2750);  
					stream_RPAREN.add(RPAREN143);

					// AST REWRITE
					// elements: lexerCommandName, lexerCommandExpr
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 636:52: -> ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:636:55: ^( LEXER_ACTION_CALL lexerCommandName lexerCommandExpr )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(LEXER_ACTION_CALL, "LEXER_ACTION_CALL"), root_1);
						adaptor.addChild(root_1, stream_lexerCommandName.nextTree());
						adaptor.addChild(root_1, stream_lexerCommandExpr.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:637:4: lexerCommandName
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_lexerCommandName_in_lexerCommand2765);
					lexerCommandName144=lexerCommandName();
					state._fsp--;

					adaptor.addChild(root_0, lexerCommandName144.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommand"


	public static class lexerCommandExpr_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommandExpr"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:640:1: lexerCommandExpr : ( id | INT );
	public final ANTLRParser.lexerCommandExpr_return lexerCommandExpr() throws RecognitionException {
		ANTLRParser.lexerCommandExpr_return retval = new ANTLRParser.lexerCommandExpr_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token INT146=null;
		ParserRuleReturnScope id145 =null;

		GrammarAST INT146_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:641:2: ( id | INT )
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==RULE_REF||LA46_0==TOKEN_REF) ) {
				alt46=1;
			}
			else if ( (LA46_0==INT) ) {
				alt46=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 46, 0, input);
				throw nvae;
			}

			switch (alt46) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:641:4: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_lexerCommandExpr2776);
					id145=id();
					state._fsp--;

					adaptor.addChild(root_0, id145.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:642:4: INT
					{
					root_0 = (GrammarAST)adaptor.nil();


					INT146=(Token)match(input,INT,FOLLOW_INT_in_lexerCommandExpr2781); 
					INT146_tree = (GrammarAST)adaptor.create(INT146);
					adaptor.addChild(root_0, INT146_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommandExpr"


	public static class lexerCommandName_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerCommandName"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:645:1: lexerCommandName : ( id | MODE -> ID[$MODE] );
	public final ANTLRParser.lexerCommandName_return lexerCommandName() throws RecognitionException {
		ANTLRParser.lexerCommandName_return retval = new ANTLRParser.lexerCommandName_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token MODE148=null;
		ParserRuleReturnScope id147 =null;

		GrammarAST MODE148_tree=null;
		RewriteRuleTokenStream stream_MODE=new RewriteRuleTokenStream(adaptor,"token MODE");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:646:9: ( id | MODE -> ID[$MODE] )
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==RULE_REF||LA47_0==TOKEN_REF) ) {
				alt47=1;
			}
			else if ( (LA47_0==MODE) ) {
				alt47=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 47, 0, input);
				throw nvae;
			}

			switch (alt47) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:646:17: id
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_lexerCommandName2805);
					id147=id();
					state._fsp--;

					adaptor.addChild(root_0, id147.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:647:17: MODE
					{
					MODE148=(Token)match(input,MODE,FOLLOW_MODE_in_lexerCommandName2823);  
					stream_MODE.add(MODE148);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 647:25: -> ID[$MODE]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, MODE148));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerCommandName"


	public static class altList_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "altList"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:650:1: altList : alternative ( OR alternative )* -> ( alternative )+ ;
	public final ANTLRParser.altList_return altList() throws RecognitionException {
		ANTLRParser.altList_return retval = new ANTLRParser.altList_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token OR150=null;
		ParserRuleReturnScope alternative149 =null;
		ParserRuleReturnScope alternative151 =null;

		GrammarAST OR150_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_alternative=new RewriteRuleSubtreeStream(adaptor,"rule alternative");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:651:5: ( alternative ( OR alternative )* -> ( alternative )+ )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:651:7: alternative ( OR alternative )*
			{
			pushFollow(FOLLOW_alternative_in_altList2851);
			alternative149=alternative();
			state._fsp--;

			stream_alternative.add(alternative149.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:651:19: ( OR alternative )*
			loop48:
			while (true) {
				int alt48=2;
				int LA48_0 = input.LA(1);
				if ( (LA48_0==OR) ) {
					alt48=1;
				}

				switch (alt48) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:651:20: OR alternative
					{
					OR150=(Token)match(input,OR,FOLLOW_OR_in_altList2854);  
					stream_OR.add(OR150);

					pushFollow(FOLLOW_alternative_in_altList2856);
					alternative151=alternative();
					state._fsp--;

					stream_alternative.add(alternative151.getTree());
					}
					break;

				default :
					break loop48;
				}
			}

			// AST REWRITE
			// elements: alternative
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 651:37: -> ( alternative )+
			{
				if ( !(stream_alternative.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_alternative.hasNext() ) {
					adaptor.addChild(root_0, stream_alternative.nextTree());
				}
				stream_alternative.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "altList"


	public static class alternative_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "alternative"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:655:1: alternative : (o= elementOptions )? ( (e+= element )+ -> ^( ALT ( elementOptions )? ( $e)+ ) | -> ^( ALT ( elementOptions )? EPSILON ) ) ;
	public final ANTLRParser.alternative_return alternative() throws RecognitionException {
		ANTLRParser.alternative_return retval = new ANTLRParser.alternative_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		List<Object> list_e=null;
		ParserRuleReturnScope o =null;
		RuleReturnScope e = null;
		RewriteRuleSubtreeStream stream_element=new RewriteRuleSubtreeStream(adaptor,"rule element");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		 paraphrases.push("matching alternative"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:661:2: ( (o= elementOptions )? ( (e+= element )+ -> ^( ALT ( elementOptions )? ( $e)+ ) | -> ^( ALT ( elementOptions )? EPSILON ) ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:661:4: (o= elementOptions )? ( (e+= element )+ -> ^( ALT ( elementOptions )? ( $e)+ ) | -> ^( ALT ( elementOptions )? EPSILON ) )
			{
			// org\\antlr\\v4\\parse\\ANTLRParser.g:661:5: (o= elementOptions )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==LT) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:661:5: o= elementOptions
					{
					pushFollow(FOLLOW_elementOptions_in_alternative2890);
					o=elementOptions();
					state._fsp--;

					stream_elementOptions.add(o.getTree());
					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:662:3: ( (e+= element )+ -> ^( ALT ( elementOptions )? ( $e)+ ) | -> ^( ALT ( elementOptions )? EPSILON ) )
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==ACTION||LA51_0==DOT||LA51_0==LPAREN||LA51_0==NOT||LA51_0==RULE_REF||LA51_0==SEMPRED||LA51_0==STRING_LITERAL||LA51_0==TOKEN_REF) ) {
				alt51=1;
			}
			else if ( (LA51_0==EOF||LA51_0==OR||LA51_0==POUND||LA51_0==RPAREN||LA51_0==SEMI) ) {
				alt51=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 51, 0, input);
				throw nvae;
			}

			switch (alt51) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:662:5: (e+= element )+
					{
					// org\\antlr\\v4\\parse\\ANTLRParser.g:662:6: (e+= element )+
					int cnt50=0;
					loop50:
					while (true) {
						int alt50=2;
						int LA50_0 = input.LA(1);
						if ( (LA50_0==ACTION||LA50_0==DOT||LA50_0==LPAREN||LA50_0==NOT||LA50_0==RULE_REF||LA50_0==SEMPRED||LA50_0==STRING_LITERAL||LA50_0==TOKEN_REF) ) {
							alt50=1;
						}

						switch (alt50) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:662:6: e+= element
							{
							pushFollow(FOLLOW_element_in_alternative2899);
							e=element();
							state._fsp--;

							stream_element.add(e.getTree());
							if (list_e==null) list_e=new ArrayList<Object>();
							list_e.add(e.getTree());
							}
							break;

						default :
							if ( cnt50 >= 1 ) break loop50;
							EarlyExitException eee = new EarlyExitException(50, input);
							throw eee;
						}
						cnt50++;
					}

					// AST REWRITE
					// elements: e, elementOptions
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: e
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_e=new RewriteRuleSubtreeStream(adaptor,"token e",list_e);
					root_0 = (GrammarAST)adaptor.nil();
					// 662:37: -> ^( ALT ( elementOptions )? ( $e)+ )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:662:40: ^( ALT ( elementOptions )? ( $e)+ )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:662:54: ( elementOptions )?
						if ( stream_elementOptions.hasNext() ) {
							adaptor.addChild(root_1, stream_elementOptions.nextTree());
						}
						stream_elementOptions.reset();

						if ( !(stream_e.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_e.hasNext() ) {
							adaptor.addChild(root_1, stream_e.nextTree());
						}
						stream_e.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:663:39: 
					{
					// AST REWRITE
					// elements: elementOptions
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 663:39: -> ^( ALT ( elementOptions )? EPSILON )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:663:42: ^( ALT ( elementOptions )? EPSILON )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:663:56: ( elementOptions )?
						if ( stream_elementOptions.hasNext() ) {
							adaptor.addChild(root_1, stream_elementOptions.nextTree());
						}
						stream_elementOptions.reset();

						adaptor.addChild(root_1, (GrammarAST)adaptor.create(EPSILON, "EPSILON"));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			    paraphrases.pop();
			    Grammar.setNodeOptions(retval.tree, (o!=null?((GrammarAST)o.getTree()):null));

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "alternative"


	public static class element_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "element"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:667:1: element : ( labeledElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement ) | atom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom ) | ebnf | actionElement );
	public final ANTLRParser.element_return element() throws RecognitionException {
		ANTLRParser.element_return retval = new ANTLRParser.element_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope labeledElement152 =null;
		ParserRuleReturnScope ebnfSuffix153 =null;
		ParserRuleReturnScope atom154 =null;
		ParserRuleReturnScope ebnfSuffix155 =null;
		ParserRuleReturnScope ebnf156 =null;
		ParserRuleReturnScope actionElement157 =null;

		RewriteRuleSubtreeStream stream_atom=new RewriteRuleSubtreeStream(adaptor,"rule atom");
		RewriteRuleSubtreeStream stream_ebnfSuffix=new RewriteRuleSubtreeStream(adaptor,"rule ebnfSuffix");
		RewriteRuleSubtreeStream stream_labeledElement=new RewriteRuleSubtreeStream(adaptor,"rule labeledElement");


			paraphrases.push("looking for rule element");
			int m = input.mark();

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:673:2: ( labeledElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement ) | atom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom ) | ebnf | actionElement )
			int alt54=4;
			switch ( input.LA(1) ) {
			case RULE_REF:
				{
				int LA54_1 = input.LA(2);
				if ( (LA54_1==ASSIGN||LA54_1==PLUS_ASSIGN) ) {
					alt54=1;
				}
				else if ( (LA54_1==EOF||LA54_1==ACTION||LA54_1==ARG_ACTION||LA54_1==DOT||(LA54_1 >= LPAREN && LA54_1 <= LT)||LA54_1==NOT||LA54_1==OR||LA54_1==PLUS||LA54_1==POUND||LA54_1==QUESTION||(LA54_1 >= RPAREN && LA54_1 <= SEMPRED)||(LA54_1 >= STAR && LA54_1 <= STRING_LITERAL)||LA54_1==TOKEN_REF) ) {
					alt54=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 54, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TOKEN_REF:
				{
				int LA54_2 = input.LA(2);
				if ( (LA54_2==ASSIGN||LA54_2==PLUS_ASSIGN) ) {
					alt54=1;
				}
				else if ( (LA54_2==EOF||LA54_2==ACTION||LA54_2==DOT||(LA54_2 >= LPAREN && LA54_2 <= LT)||LA54_2==NOT||LA54_2==OR||LA54_2==PLUS||LA54_2==POUND||LA54_2==QUESTION||(LA54_2 >= RPAREN && LA54_2 <= SEMPRED)||(LA54_2 >= STAR && LA54_2 <= STRING_LITERAL)||LA54_2==TOKEN_REF) ) {
					alt54=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 54, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DOT:
			case NOT:
			case STRING_LITERAL:
				{
				alt54=2;
				}
				break;
			case LPAREN:
				{
				alt54=3;
				}
				break;
			case ACTION:
			case SEMPRED:
				{
				alt54=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 54, 0, input);
				throw nvae;
			}
			switch (alt54) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:673:4: labeledElement ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement )
					{
					pushFollow(FOLLOW_labeledElement_in_element3014);
					labeledElement152=labeledElement();
					state._fsp--;

					stream_labeledElement.add(labeledElement152.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:674:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) ) | -> labeledElement )
					int alt52=2;
					int LA52_0 = input.LA(1);
					if ( (LA52_0==PLUS||LA52_0==QUESTION||LA52_0==STAR) ) {
						alt52=1;
					}
					else if ( (LA52_0==EOF||LA52_0==ACTION||LA52_0==DOT||LA52_0==LPAREN||LA52_0==NOT||LA52_0==OR||LA52_0==POUND||(LA52_0 >= RPAREN && LA52_0 <= SEMPRED)||LA52_0==STRING_LITERAL||LA52_0==TOKEN_REF) ) {
						alt52=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 52, 0, input);
						throw nvae;
					}

					switch (alt52) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:674:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_element3020);
							ebnfSuffix153=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix153.getTree());
							// AST REWRITE
							// elements: ebnfSuffix, labeledElement
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 674:16: -> ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:674:19: ^( ebnfSuffix ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:674:33: ^( BLOCK[$labeledElement.start,\"BLOCK\"] ^( ALT labeledElement ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (labeledElement152!=null?(labeledElement152.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:674:82: ^( ALT labeledElement )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_labeledElement.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:675:8: 
							{
							// AST REWRITE
							// elements: labeledElement
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 675:8: -> labeledElement
							{
								adaptor.addChild(root_0, stream_labeledElement.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:677:4: atom ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom )
					{
					pushFollow(FOLLOW_atom_in_element3066);
					atom154=atom();
					state._fsp--;

					stream_atom.add(atom154.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:678:3: ( ebnfSuffix -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) ) | -> atom )
					int alt53=2;
					int LA53_0 = input.LA(1);
					if ( (LA53_0==PLUS||LA53_0==QUESTION||LA53_0==STAR) ) {
						alt53=1;
					}
					else if ( (LA53_0==EOF||LA53_0==ACTION||LA53_0==DOT||LA53_0==LPAREN||LA53_0==NOT||LA53_0==OR||LA53_0==POUND||(LA53_0 >= RPAREN && LA53_0 <= SEMPRED)||LA53_0==STRING_LITERAL||LA53_0==TOKEN_REF) ) {
						alt53=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 53, 0, input);
						throw nvae;
					}

					switch (alt53) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:678:5: ebnfSuffix
							{
							pushFollow(FOLLOW_ebnfSuffix_in_element3072);
							ebnfSuffix155=ebnfSuffix();
							state._fsp--;

							stream_ebnfSuffix.add(ebnfSuffix155.getTree());
							// AST REWRITE
							// elements: atom, ebnfSuffix
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 678:16: -> ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) )
							{
								// org\\antlr\\v4\\parse\\ANTLRParser.g:678:19: ^( ebnfSuffix ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) ) )
								{
								GrammarAST root_1 = (GrammarAST)adaptor.nil();
								root_1 = (GrammarAST)adaptor.becomeRoot(stream_ebnfSuffix.nextNode(), root_1);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:678:33: ^( BLOCK[$atom.start,\"BLOCK\"] ^( ALT atom ) )
								{
								GrammarAST root_2 = (GrammarAST)adaptor.nil();
								root_2 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, (atom154!=null?(atom154.start):null), "BLOCK"), root_2);
								// org\\antlr\\v4\\parse\\ANTLRParser.g:678:72: ^( ALT atom )
								{
								GrammarAST root_3 = (GrammarAST)adaptor.nil();
								root_3 = (GrammarAST)adaptor.becomeRoot(new AltAST(ALT), root_3);
								adaptor.addChild(root_3, stream_atom.nextTree());
								adaptor.addChild(root_2, root_3);
								}

								adaptor.addChild(root_1, root_2);
								}

								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:679:8: 
							{
							// AST REWRITE
							// elements: atom
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (GrammarAST)adaptor.nil();
							// 679:8: -> atom
							{
								adaptor.addChild(root_0, stream_atom.nextTree());
							}


							retval.tree = root_0;

							}
							break;

					}

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:681:4: ebnf
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_ebnf_in_element3118);
					ebnf156=ebnf();
					state._fsp--;

					adaptor.addChild(root_0, ebnf156.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:682:4: actionElement
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_actionElement_in_element3123);
					actionElement157=actionElement();
					state._fsp--;

					adaptor.addChild(root_0, actionElement157.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {

			    	retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
			    	int ttype = input.get(input.range()).getType();
				    // look for anything that really belongs at the start of the rule minus the initial ID
			    	if ( ttype==COLON || ttype==RETURNS || ttype==CATCH || ttype==FINALLY || ttype==AT ) {
						RecognitionException missingSemi =
							new v4ParserException("unterminated rule (missing ';') detected at '"+
												  input.LT(1).getText()+" "+input.LT(2).getText()+"'", input);
						reportError(missingSemi);
						if ( ttype==CATCH || ttype==FINALLY ) {
							input.seek(input.range()); // ignore what's before rule trailer stuff
						}
						if ( ttype==RETURNS || ttype==AT ) { // scan back looking for ID of rule header
							int p = input.index();
							Token t = input.get(p);
							while ( t.getType()!=RULE_REF && t.getType()!=TOKEN_REF ) {
								p--;
								t = input.get(p);
							}
							input.seek(p);
						}
						throw new ResyncToEndOfRuleBlock(); // make sure it goes back to rule block level to recover
					}
			        reportError(re);
			        recover(input,re);
				
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "element"


	public static class actionElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "actionElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:711:1: actionElement : ( ACTION | ACTION elementOptions -> ^( ACTION elementOptions ) | SEMPRED | SEMPRED elementOptions -> ^( SEMPRED elementOptions ) );
	public final ANTLRParser.actionElement_return actionElement() throws RecognitionException {
		ANTLRParser.actionElement_return retval = new ANTLRParser.actionElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ACTION158=null;
		Token ACTION159=null;
		Token SEMPRED161=null;
		Token SEMPRED162=null;
		ParserRuleReturnScope elementOptions160 =null;
		ParserRuleReturnScope elementOptions163 =null;

		GrammarAST ACTION158_tree=null;
		GrammarAST ACTION159_tree=null;
		GrammarAST SEMPRED161_tree=null;
		GrammarAST SEMPRED162_tree=null;
		RewriteRuleTokenStream stream_SEMPRED=new RewriteRuleTokenStream(adaptor,"token SEMPRED");
		RewriteRuleTokenStream stream_ACTION=new RewriteRuleTokenStream(adaptor,"token ACTION");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:718:2: ( ACTION | ACTION elementOptions -> ^( ACTION elementOptions ) | SEMPRED | SEMPRED elementOptions -> ^( SEMPRED elementOptions ) )
			int alt55=4;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==ACTION) ) {
				int LA55_1 = input.LA(2);
				if ( (LA55_1==EOF||LA55_1==ACTION||LA55_1==DOT||LA55_1==LEXER_CHAR_SET||LA55_1==LPAREN||LA55_1==NOT||LA55_1==OR||LA55_1==POUND||LA55_1==RARROW||(LA55_1 >= RPAREN && LA55_1 <= SEMPRED)||LA55_1==STRING_LITERAL||LA55_1==TOKEN_REF) ) {
					alt55=1;
				}
				else if ( (LA55_1==LT) ) {
					alt55=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 55, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA55_0==SEMPRED) ) {
				int LA55_2 = input.LA(2);
				if ( (LA55_2==EOF||LA55_2==ACTION||LA55_2==DOT||LA55_2==LEXER_CHAR_SET||LA55_2==LPAREN||LA55_2==NOT||LA55_2==OR||LA55_2==POUND||LA55_2==RARROW||(LA55_2 >= RPAREN && LA55_2 <= SEMPRED)||LA55_2==STRING_LITERAL||LA55_2==TOKEN_REF) ) {
					alt55=3;
				}
				else if ( (LA55_2==LT) ) {
					alt55=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 55, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 55, 0, input);
				throw nvae;
			}

			switch (alt55) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:718:4: ACTION
					{
					root_0 = (GrammarAST)adaptor.nil();


					ACTION158=(Token)match(input,ACTION,FOLLOW_ACTION_in_actionElement3149); 
					ACTION158_tree = new ActionAST(ACTION158) ;
					adaptor.addChild(root_0, ACTION158_tree);

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:719:6: ACTION elementOptions
					{
					ACTION159=(Token)match(input,ACTION,FOLLOW_ACTION_in_actionElement3159);  
					stream_ACTION.add(ACTION159);

					pushFollow(FOLLOW_elementOptions_in_actionElement3161);
					elementOptions160=elementOptions();
					state._fsp--;

					stream_elementOptions.add(elementOptions160.getTree());
					// AST REWRITE
					// elements: ACTION, elementOptions
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 719:28: -> ^( ACTION elementOptions )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:719:31: ^( ACTION elementOptions )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new ActionAST(stream_ACTION.nextToken()), root_1);
						adaptor.addChild(root_1, stream_elementOptions.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:720:6: SEMPRED
					{
					root_0 = (GrammarAST)adaptor.nil();


					SEMPRED161=(Token)match(input,SEMPRED,FOLLOW_SEMPRED_in_actionElement3179); 
					SEMPRED161_tree = new PredAST(SEMPRED161) ;
					adaptor.addChild(root_0, SEMPRED161_tree);

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:721:6: SEMPRED elementOptions
					{
					SEMPRED162=(Token)match(input,SEMPRED,FOLLOW_SEMPRED_in_actionElement3189);  
					stream_SEMPRED.add(SEMPRED162);

					pushFollow(FOLLOW_elementOptions_in_actionElement3191);
					elementOptions163=elementOptions();
					state._fsp--;

					stream_elementOptions.add(elementOptions163.getTree());
					// AST REWRITE
					// elements: SEMPRED, elementOptions
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 721:29: -> ^( SEMPRED elementOptions )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:721:32: ^( SEMPRED elementOptions )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new PredAST(stream_SEMPRED.nextToken()), root_1);
						adaptor.addChild(root_1, stream_elementOptions.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.ELEMENT_OPTIONS);
				if ( options!=null ) {
					Grammar.setNodeOptions(retval.tree, options);
				}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "actionElement"


	public static class labeledElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "labeledElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:724:1: labeledElement : id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) ) ;
	public final ANTLRParser.labeledElement_return labeledElement() throws RecognitionException {
		ANTLRParser.labeledElement_return retval = new ANTLRParser.labeledElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ass=null;
		ParserRuleReturnScope id164 =null;
		ParserRuleReturnScope atom165 =null;
		ParserRuleReturnScope block166 =null;

		GrammarAST ass_tree=null;
		RewriteRuleTokenStream stream_ASSIGN=new RewriteRuleTokenStream(adaptor,"token ASSIGN");
		RewriteRuleTokenStream stream_PLUS_ASSIGN=new RewriteRuleTokenStream(adaptor,"token PLUS_ASSIGN");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");
		RewriteRuleSubtreeStream stream_atom=new RewriteRuleSubtreeStream(adaptor,"rule atom");
		RewriteRuleSubtreeStream stream_block=new RewriteRuleSubtreeStream(adaptor,"rule block");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:725:2: ( id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:725:4: id (ass= ASSIGN |ass= PLUS_ASSIGN ) ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) )
			{
			pushFollow(FOLLOW_id_in_labeledElement3213);
			id164=id();
			state._fsp--;

			stream_id.add(id164.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:725:7: (ass= ASSIGN |ass= PLUS_ASSIGN )
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==ASSIGN) ) {
				alt56=1;
			}
			else if ( (LA56_0==PLUS_ASSIGN) ) {
				alt56=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 56, 0, input);
				throw nvae;
			}

			switch (alt56) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:725:8: ass= ASSIGN
					{
					ass=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_labeledElement3218);  
					stream_ASSIGN.add(ass);

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:725:19: ass= PLUS_ASSIGN
					{
					ass=(Token)match(input,PLUS_ASSIGN,FOLLOW_PLUS_ASSIGN_in_labeledElement3222);  
					stream_PLUS_ASSIGN.add(ass);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:726:3: ( atom -> ^( $ass id atom ) | block -> ^( $ass id block ) )
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==DOT||LA57_0==NOT||LA57_0==RULE_REF||LA57_0==STRING_LITERAL||LA57_0==TOKEN_REF) ) {
				alt57=1;
			}
			else if ( (LA57_0==LPAREN) ) {
				alt57=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 57, 0, input);
				throw nvae;
			}

			switch (alt57) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:726:5: atom
					{
					pushFollow(FOLLOW_atom_in_labeledElement3229);
					atom165=atom();
					state._fsp--;

					stream_atom.add(atom165.getTree());
					// AST REWRITE
					// elements: id, ass, atom
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 726:15: -> ^( $ass id atom )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:726:18: ^( $ass id atom )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_atom.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:727:5: block
					{
					pushFollow(FOLLOW_block_in_labeledElement3251);
					block166=block();
					state._fsp--;

					stream_block.add(block166.getTree());
					// AST REWRITE
					// elements: ass, id, block
					// token labels: ass
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleTokenStream stream_ass=new RewriteRuleTokenStream(adaptor,"token ass",ass);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 727:16: -> ^( $ass id block )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:727:19: ^( $ass id block )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_ass.nextNode(), root_1);
						adaptor.addChild(root_1, stream_id.nextTree());
						adaptor.addChild(root_1, stream_block.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "labeledElement"


	public static class ebnf_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ebnf"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:733:1: ebnf : block ( blockSuffix -> ^( blockSuffix block ) | -> block ) ;
	public final ANTLRParser.ebnf_return ebnf() throws RecognitionException {
		ANTLRParser.ebnf_return retval = new ANTLRParser.ebnf_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope block167 =null;
		ParserRuleReturnScope blockSuffix168 =null;

		RewriteRuleSubtreeStream stream_block=new RewriteRuleSubtreeStream(adaptor,"rule block");
		RewriteRuleSubtreeStream stream_blockSuffix=new RewriteRuleSubtreeStream(adaptor,"rule blockSuffix");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:734:5: ( block ( blockSuffix -> ^( blockSuffix block ) | -> block ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:734:7: block ( blockSuffix -> ^( blockSuffix block ) | -> block )
			{
			pushFollow(FOLLOW_block_in_ebnf3287);
			block167=block();
			state._fsp--;

			stream_block.add(block167.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:737:7: ( blockSuffix -> ^( blockSuffix block ) | -> block )
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==PLUS||LA58_0==QUESTION||LA58_0==STAR) ) {
				alt58=1;
			}
			else if ( (LA58_0==EOF||LA58_0==ACTION||LA58_0==DOT||LA58_0==LPAREN||LA58_0==NOT||LA58_0==OR||LA58_0==POUND||(LA58_0 >= RPAREN && LA58_0 <= SEMPRED)||LA58_0==STRING_LITERAL||LA58_0==TOKEN_REF) ) {
				alt58=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}

			switch (alt58) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:737:9: blockSuffix
					{
					pushFollow(FOLLOW_blockSuffix_in_ebnf3311);
					blockSuffix168=blockSuffix();
					state._fsp--;

					stream_blockSuffix.add(blockSuffix168.getTree());
					// AST REWRITE
					// elements: blockSuffix, block
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 737:21: -> ^( blockSuffix block )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:737:24: ^( blockSuffix block )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(stream_blockSuffix.nextNode(), root_1);
						adaptor.addChild(root_1, stream_block.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:738:12: 
					{
					// AST REWRITE
					// elements: block
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 738:12: -> block
					{
						adaptor.addChild(root_0, stream_block.nextTree());
					}


					retval.tree = root_0;

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ebnf"


	public static class blockSuffix_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "blockSuffix"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:744:1: blockSuffix : ebnfSuffix ;
	public final ANTLRParser.blockSuffix_return blockSuffix() throws RecognitionException {
		ANTLRParser.blockSuffix_return retval = new ANTLRParser.blockSuffix_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope ebnfSuffix169 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:745:5: ( ebnfSuffix )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:745:7: ebnfSuffix
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_ebnfSuffix_in_blockSuffix3361);
			ebnfSuffix169=ebnfSuffix();
			state._fsp--;

			adaptor.addChild(root_0, ebnfSuffix169.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockSuffix"


	public static class ebnfSuffix_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ebnfSuffix"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:748:1: ebnfSuffix : ( QUESTION (nongreedy= QUESTION )? -> OPTIONAL[$start, $nongreedy] | STAR (nongreedy= QUESTION )? -> CLOSURE[$start, $nongreedy] | PLUS (nongreedy= QUESTION )? -> POSITIVE_CLOSURE[$start, $nongreedy] );
	public final ANTLRParser.ebnfSuffix_return ebnfSuffix() throws RecognitionException {
		ANTLRParser.ebnfSuffix_return retval = new ANTLRParser.ebnfSuffix_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token nongreedy=null;
		Token QUESTION170=null;
		Token STAR171=null;
		Token PLUS172=null;

		GrammarAST nongreedy_tree=null;
		GrammarAST QUESTION170_tree=null;
		GrammarAST STAR171_tree=null;
		GrammarAST PLUS172_tree=null;
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_STAR=new RewriteRuleTokenStream(adaptor,"token STAR");
		RewriteRuleTokenStream stream_QUESTION=new RewriteRuleTokenStream(adaptor,"token QUESTION");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:749:2: ( QUESTION (nongreedy= QUESTION )? -> OPTIONAL[$start, $nongreedy] | STAR (nongreedy= QUESTION )? -> CLOSURE[$start, $nongreedy] | PLUS (nongreedy= QUESTION )? -> POSITIVE_CLOSURE[$start, $nongreedy] )
			int alt62=3;
			switch ( input.LA(1) ) {
			case QUESTION:
				{
				alt62=1;
				}
				break;
			case STAR:
				{
				alt62=2;
				}
				break;
			case PLUS:
				{
				alt62=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}
			switch (alt62) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:749:4: QUESTION (nongreedy= QUESTION )?
					{
					QUESTION170=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3376);  
					stream_QUESTION.add(QUESTION170);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:749:22: (nongreedy= QUESTION )?
					int alt59=2;
					int LA59_0 = input.LA(1);
					if ( (LA59_0==QUESTION) ) {
						alt59=1;
					}
					switch (alt59) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:749:22: nongreedy= QUESTION
							{
							nongreedy=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3380);  
							stream_QUESTION.add(nongreedy);

							}
							break;

					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 749:33: -> OPTIONAL[$start, $nongreedy]
					{
						adaptor.addChild(root_0, new OptionalBlockAST(OPTIONAL, (retval.start), nongreedy));
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:750:6: STAR (nongreedy= QUESTION )?
					{
					STAR171=(Token)match(input,STAR,FOLLOW_STAR_in_ebnfSuffix3396);  
					stream_STAR.add(STAR171);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:750:20: (nongreedy= QUESTION )?
					int alt60=2;
					int LA60_0 = input.LA(1);
					if ( (LA60_0==QUESTION) ) {
						alt60=1;
					}
					switch (alt60) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:750:20: nongreedy= QUESTION
							{
							nongreedy=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3400);  
							stream_QUESTION.add(nongreedy);

							}
							break;

					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 750:32: -> CLOSURE[$start, $nongreedy]
					{
						adaptor.addChild(root_0, new StarBlockAST(CLOSURE, (retval.start), nongreedy));
					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:751:7: PLUS (nongreedy= QUESTION )?
					{
					PLUS172=(Token)match(input,PLUS,FOLLOW_PLUS_in_ebnfSuffix3418);  
					stream_PLUS.add(PLUS172);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:751:21: (nongreedy= QUESTION )?
					int alt61=2;
					int LA61_0 = input.LA(1);
					if ( (LA61_0==QUESTION) ) {
						alt61=1;
					}
					switch (alt61) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:751:21: nongreedy= QUESTION
							{
							nongreedy=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_ebnfSuffix3422);  
							stream_QUESTION.add(nongreedy);

							}
							break;

					}

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 751:33: -> POSITIVE_CLOSURE[$start, $nongreedy]
					{
						adaptor.addChild(root_0, new PlusBlockAST(POSITIVE_CLOSURE, (retval.start), nongreedy));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ebnfSuffix"


	public static class lexerAtom_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "lexerAtom"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:754:1: lexerAtom : ( range | terminal | RULE_REF | notSet | wildcard | LEXER_CHAR_SET );
	public final ANTLRParser.lexerAtom_return lexerAtom() throws RecognitionException {
		ANTLRParser.lexerAtom_return retval = new ANTLRParser.lexerAtom_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RULE_REF175=null;
		Token LEXER_CHAR_SET178=null;
		ParserRuleReturnScope range173 =null;
		ParserRuleReturnScope terminal174 =null;
		ParserRuleReturnScope notSet176 =null;
		ParserRuleReturnScope wildcard177 =null;

		GrammarAST RULE_REF175_tree=null;
		GrammarAST LEXER_CHAR_SET178_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:755:2: ( range | terminal | RULE_REF | notSet | wildcard | LEXER_CHAR_SET )
			int alt63=6;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				int LA63_1 = input.LA(2);
				if ( (LA63_1==RANGE) ) {
					alt63=1;
				}
				else if ( (LA63_1==ACTION||LA63_1==DOT||LA63_1==LEXER_CHAR_SET||(LA63_1 >= LPAREN && LA63_1 <= LT)||LA63_1==NOT||LA63_1==OR||LA63_1==PLUS||LA63_1==QUESTION||LA63_1==RARROW||(LA63_1 >= RPAREN && LA63_1 <= SEMPRED)||(LA63_1 >= STAR && LA63_1 <= STRING_LITERAL)||LA63_1==TOKEN_REF) ) {
					alt63=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 63, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TOKEN_REF:
				{
				alt63=2;
				}
				break;
			case RULE_REF:
				{
				alt63=3;
				}
				break;
			case NOT:
				{
				alt63=4;
				}
				break;
			case DOT:
				{
				alt63=5;
				}
				break;
			case LEXER_CHAR_SET:
				{
				alt63=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 63, 0, input);
				throw nvae;
			}
			switch (alt63) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:755:4: range
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_range_in_lexerAtom3443);
					range173=range();
					state._fsp--;

					adaptor.addChild(root_0, range173.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:756:4: terminal
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_terminal_in_lexerAtom3448);
					terminal174=terminal();
					state._fsp--;

					adaptor.addChild(root_0, terminal174.getTree());

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:757:9: RULE_REF
					{
					root_0 = (GrammarAST)adaptor.nil();


					RULE_REF175=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_lexerAtom3458); 
					RULE_REF175_tree = new RuleRefAST(RULE_REF175) ;
					adaptor.addChild(root_0, RULE_REF175_tree);

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:758:7: notSet
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_notSet_in_lexerAtom3469);
					notSet176=notSet();
					state._fsp--;

					adaptor.addChild(root_0, notSet176.getTree());

					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:759:7: wildcard
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_wildcard_in_lexerAtom3477);
					wildcard177=wildcard();
					state._fsp--;

					adaptor.addChild(root_0, wildcard177.getTree());

					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:760:7: LEXER_CHAR_SET
					{
					root_0 = (GrammarAST)adaptor.nil();


					LEXER_CHAR_SET178=(Token)match(input,LEXER_CHAR_SET,FOLLOW_LEXER_CHAR_SET_in_lexerAtom3485); 
					LEXER_CHAR_SET178_tree = (GrammarAST)adaptor.create(LEXER_CHAR_SET178);
					adaptor.addChild(root_0, LEXER_CHAR_SET178_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lexerAtom"


	public static class atom_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "atom"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:763:1: atom : ( range | terminal | ruleref | notSet | wildcard );
	public final ANTLRParser.atom_return atom() throws RecognitionException {
		ANTLRParser.atom_return retval = new ANTLRParser.atom_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		ParserRuleReturnScope range179 =null;
		ParserRuleReturnScope terminal180 =null;
		ParserRuleReturnScope ruleref181 =null;
		ParserRuleReturnScope notSet182 =null;
		ParserRuleReturnScope wildcard183 =null;


		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:764:2: ( range | terminal | ruleref | notSet | wildcard )
			int alt64=5;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				int LA64_1 = input.LA(2);
				if ( (LA64_1==RANGE) ) {
					alt64=1;
				}
				else if ( (LA64_1==EOF||LA64_1==ACTION||LA64_1==DOT||(LA64_1 >= LPAREN && LA64_1 <= LT)||LA64_1==NOT||LA64_1==OR||LA64_1==PLUS||LA64_1==POUND||LA64_1==QUESTION||(LA64_1 >= RPAREN && LA64_1 <= SEMPRED)||(LA64_1 >= STAR && LA64_1 <= STRING_LITERAL)||LA64_1==TOKEN_REF) ) {
					alt64=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 64, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case TOKEN_REF:
				{
				alt64=2;
				}
				break;
			case RULE_REF:
				{
				alt64=3;
				}
				break;
			case NOT:
				{
				alt64=4;
				}
				break;
			case DOT:
				{
				alt64=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}
			switch (alt64) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:778:9: range
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_range_in_atom3530);
					range179=range();
					state._fsp--;

					adaptor.addChild(root_0, range179.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:779:4: terminal
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_terminal_in_atom3537);
					terminal180=terminal();
					state._fsp--;

					adaptor.addChild(root_0, terminal180.getTree());

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:780:9: ruleref
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_ruleref_in_atom3547);
					ruleref181=ruleref();
					state._fsp--;

					adaptor.addChild(root_0, ruleref181.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:781:7: notSet
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_notSet_in_atom3555);
					notSet182=notSet();
					state._fsp--;

					adaptor.addChild(root_0, notSet182.getTree());

					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:782:7: wildcard
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_wildcard_in_atom3563);
					wildcard183=wildcard();
					state._fsp--;

					adaptor.addChild(root_0, wildcard183.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			 throw re; 
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "atom"


	public static class wildcard_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "wildcard"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:786:1: wildcard : DOT ( elementOptions )? -> ^( WILDCARD[$DOT] ( elementOptions )? ) ;
	public final ANTLRParser.wildcard_return wildcard() throws RecognitionException {
		ANTLRParser.wildcard_return retval = new ANTLRParser.wildcard_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOT184=null;
		ParserRuleReturnScope elementOptions185 =null;

		GrammarAST DOT184_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:793:2: ( DOT ( elementOptions )? -> ^( WILDCARD[$DOT] ( elementOptions )? ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:798:6: DOT ( elementOptions )?
			{
			DOT184=(Token)match(input,DOT,FOLLOW_DOT_in_wildcard3611);  
			stream_DOT.add(DOT184);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:798:10: ( elementOptions )?
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==LT) ) {
				alt65=1;
			}
			switch (alt65) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:798:10: elementOptions
					{
					pushFollow(FOLLOW_elementOptions_in_wildcard3613);
					elementOptions185=elementOptions();
					state._fsp--;

					stream_elementOptions.add(elementOptions185.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: elementOptions
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 799:6: -> ^( WILDCARD[$DOT] ( elementOptions )? )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:799:9: ^( WILDCARD[$DOT] ( elementOptions )? )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new TerminalAST(WILDCARD, DOT184), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:799:39: ( elementOptions )?
				if ( stream_elementOptions.hasNext() ) {
					adaptor.addChild(root_1, stream_elementOptions.nextTree());
				}
				stream_elementOptions.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


				GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.ELEMENT_OPTIONS);
				if ( options!=null ) {
					Grammar.setNodeOptions(retval.tree, options);
				}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "wildcard"


	public static class notSet_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "notSet"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:807:1: notSet : ( NOT setElement -> ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) ) | NOT blockSet -> ^( NOT[$NOT] blockSet ) );
	public final ANTLRParser.notSet_return notSet() throws RecognitionException {
		ANTLRParser.notSet_return retval = new ANTLRParser.notSet_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token NOT186=null;
		Token NOT188=null;
		ParserRuleReturnScope setElement187 =null;
		ParserRuleReturnScope blockSet189 =null;

		GrammarAST NOT186_tree=null;
		GrammarAST NOT188_tree=null;
		RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
		RewriteRuleSubtreeStream stream_setElement=new RewriteRuleSubtreeStream(adaptor,"rule setElement");
		RewriteRuleSubtreeStream stream_blockSet=new RewriteRuleSubtreeStream(adaptor,"rule blockSet");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:808:5: ( NOT setElement -> ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) ) | NOT blockSet -> ^( NOT[$NOT] blockSet ) )
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==NOT) ) {
				int LA66_1 = input.LA(2);
				if ( (LA66_1==LEXER_CHAR_SET||LA66_1==STRING_LITERAL||LA66_1==TOKEN_REF) ) {
					alt66=1;
				}
				else if ( (LA66_1==LPAREN) ) {
					alt66=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 66, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 66, 0, input);
				throw nvae;
			}

			switch (alt66) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:808:7: NOT setElement
					{
					NOT186=(Token)match(input,NOT,FOLLOW_NOT_in_notSet3651);  
					stream_NOT.add(NOT186);

					pushFollow(FOLLOW_setElement_in_notSet3653);
					setElement187=setElement();
					state._fsp--;

					stream_setElement.add(setElement187.getTree());
					// AST REWRITE
					// elements: setElement, NOT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 808:22: -> ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:808:25: ^( NOT[$NOT] ^( SET[$setElement.start,\"SET\"] setElement ) )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new NotAST(NOT, NOT186), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:808:45: ^( SET[$setElement.start,\"SET\"] setElement )
						{
						GrammarAST root_2 = (GrammarAST)adaptor.nil();
						root_2 = (GrammarAST)adaptor.becomeRoot(new SetAST(SET, (setElement187!=null?(setElement187.start):null), "SET"), root_2);
						adaptor.addChild(root_2, stream_setElement.nextTree());
						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:809:7: NOT blockSet
					{
					NOT188=(Token)match(input,NOT,FOLLOW_NOT_in_notSet3681);  
					stream_NOT.add(NOT188);

					pushFollow(FOLLOW_blockSet_in_notSet3683);
					blockSet189=blockSet();
					state._fsp--;

					stream_blockSet.add(blockSet189.getTree());
					// AST REWRITE
					// elements: blockSet, NOT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 809:21: -> ^( NOT[$NOT] blockSet )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:809:24: ^( NOT[$NOT] blockSet )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new NotAST(NOT, NOT188), root_1);
						adaptor.addChild(root_1, stream_blockSet.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "notSet"


	public static class blockSet_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "blockSet"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:812:1: blockSet : LPAREN setElement ( OR setElement )* RPAREN -> ^( SET[$LPAREN,\"SET\"] ( setElement )+ ) ;
	public final ANTLRParser.blockSet_return blockSet() throws RecognitionException {
		ANTLRParser.blockSet_return retval = new ANTLRParser.blockSet_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN190=null;
		Token OR192=null;
		Token RPAREN194=null;
		ParserRuleReturnScope setElement191 =null;
		ParserRuleReturnScope setElement193 =null;

		GrammarAST LPAREN190_tree=null;
		GrammarAST OR192_tree=null;
		GrammarAST RPAREN194_tree=null;
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_setElement=new RewriteRuleSubtreeStream(adaptor,"rule setElement");


			Token t;
			boolean ebnf = false;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:817:5: ( LPAREN setElement ( OR setElement )* RPAREN -> ^( SET[$LPAREN,\"SET\"] ( setElement )+ ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:817:7: LPAREN setElement ( OR setElement )* RPAREN
			{
			LPAREN190=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_blockSet3718);  
			stream_LPAREN.add(LPAREN190);

			pushFollow(FOLLOW_setElement_in_blockSet3720);
			setElement191=setElement();
			state._fsp--;

			stream_setElement.add(setElement191.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:817:25: ( OR setElement )*
			loop67:
			while (true) {
				int alt67=2;
				int LA67_0 = input.LA(1);
				if ( (LA67_0==OR) ) {
					alt67=1;
				}

				switch (alt67) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:817:26: OR setElement
					{
					OR192=(Token)match(input,OR,FOLLOW_OR_in_blockSet3723);  
					stream_OR.add(OR192);

					pushFollow(FOLLOW_setElement_in_blockSet3725);
					setElement193=setElement();
					state._fsp--;

					stream_setElement.add(setElement193.getTree());
					}
					break;

				default :
					break loop67;
				}
			}

			RPAREN194=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_blockSet3729);  
			stream_RPAREN.add(RPAREN194);

			// AST REWRITE
			// elements: setElement
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 818:3: -> ^( SET[$LPAREN,\"SET\"] ( setElement )+ )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:818:6: ^( SET[$LPAREN,\"SET\"] ( setElement )+ )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new SetAST(SET, LPAREN190, "SET"), root_1);
				if ( !(stream_setElement.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_setElement.hasNext() ) {
					adaptor.addChild(root_1, stream_setElement.nextTree());
				}
				stream_setElement.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockSet"


	public static class setElement_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "setElement"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:821:1: setElement : ( TOKEN_REF ^ ( elementOptions )? | STRING_LITERAL ^ ( elementOptions )? | range | LEXER_CHAR_SET );
	public final ANTLRParser.setElement_return setElement() throws RecognitionException {
		ANTLRParser.setElement_return retval = new ANTLRParser.setElement_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token TOKEN_REF195=null;
		Token STRING_LITERAL197=null;
		Token LEXER_CHAR_SET200=null;
		ParserRuleReturnScope elementOptions196 =null;
		ParserRuleReturnScope elementOptions198 =null;
		ParserRuleReturnScope range199 =null;

		GrammarAST TOKEN_REF195_tree=null;
		GrammarAST STRING_LITERAL197_tree=null;
		GrammarAST LEXER_CHAR_SET200_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:822:2: ( TOKEN_REF ^ ( elementOptions )? | STRING_LITERAL ^ ( elementOptions )? | range | LEXER_CHAR_SET )
			int alt70=4;
			switch ( input.LA(1) ) {
			case TOKEN_REF:
				{
				alt70=1;
				}
				break;
			case STRING_LITERAL:
				{
				int LA70_2 = input.LA(2);
				if ( (LA70_2==RANGE) ) {
					alt70=3;
				}
				else if ( (LA70_2==EOF||LA70_2==ACTION||LA70_2==DOT||LA70_2==LEXER_CHAR_SET||(LA70_2 >= LPAREN && LA70_2 <= LT)||LA70_2==NOT||LA70_2==OR||LA70_2==PLUS||LA70_2==POUND||LA70_2==QUESTION||LA70_2==RARROW||(LA70_2 >= RPAREN && LA70_2 <= SEMPRED)||(LA70_2 >= STAR && LA70_2 <= STRING_LITERAL)||LA70_2==TOKEN_REF) ) {
					alt70=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 70, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case LEXER_CHAR_SET:
				{
				alt70=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 70, 0, input);
				throw nvae;
			}
			switch (alt70) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:822:4: TOKEN_REF ^ ( elementOptions )?
					{
					root_0 = (GrammarAST)adaptor.nil();


					TOKEN_REF195=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_setElement3759); 
					TOKEN_REF195_tree = new TerminalAST(TOKEN_REF195) ;
					root_0 = (GrammarAST)adaptor.becomeRoot(TOKEN_REF195_tree, root_0);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:822:28: ( elementOptions )?
					int alt68=2;
					int LA68_0 = input.LA(1);
					if ( (LA68_0==LT) ) {
						alt68=1;
					}
					switch (alt68) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:822:28: elementOptions
							{
							pushFollow(FOLLOW_elementOptions_in_setElement3765);
							elementOptions196=elementOptions();
							state._fsp--;

							adaptor.addChild(root_0, elementOptions196.getTree());

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:823:4: STRING_LITERAL ^ ( elementOptions )?
					{
					root_0 = (GrammarAST)adaptor.nil();


					STRING_LITERAL197=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_setElement3771); 
					STRING_LITERAL197_tree = new TerminalAST(STRING_LITERAL197) ;
					root_0 = (GrammarAST)adaptor.becomeRoot(STRING_LITERAL197_tree, root_0);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:823:33: ( elementOptions )?
					int alt69=2;
					int LA69_0 = input.LA(1);
					if ( (LA69_0==LT) ) {
						alt69=1;
					}
					switch (alt69) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:823:33: elementOptions
							{
							pushFollow(FOLLOW_elementOptions_in_setElement3777);
							elementOptions198=elementOptions();
							state._fsp--;

							adaptor.addChild(root_0, elementOptions198.getTree());

							}
							break;

					}

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:824:4: range
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_range_in_setElement3783);
					range199=range();
					state._fsp--;

					adaptor.addChild(root_0, range199.getTree());

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:825:9: LEXER_CHAR_SET
					{
					root_0 = (GrammarAST)adaptor.nil();


					LEXER_CHAR_SET200=(Token)match(input,LEXER_CHAR_SET,FOLLOW_LEXER_CHAR_SET_in_setElement3793); 
					LEXER_CHAR_SET200_tree = (GrammarAST)adaptor.create(LEXER_CHAR_SET200);
					adaptor.addChild(root_0, LEXER_CHAR_SET200_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "setElement"


	public static class block_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "block"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:835:1: block : LPAREN ( ( optionsSpec )? (ra+= ruleAction )* COLON )? altList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList ) ;
	public final ANTLRParser.block_return block() throws RecognitionException {
		ANTLRParser.block_return retval = new ANTLRParser.block_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LPAREN201=null;
		Token COLON203=null;
		Token RPAREN205=null;
		List<Object> list_ra=null;
		ParserRuleReturnScope optionsSpec202 =null;
		ParserRuleReturnScope altList204 =null;
		RuleReturnScope ra = null;
		GrammarAST LPAREN201_tree=null;
		GrammarAST COLON203_tree=null;
		GrammarAST RPAREN205_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleSubtreeStream stream_optionsSpec=new RewriteRuleSubtreeStream(adaptor,"rule optionsSpec");
		RewriteRuleSubtreeStream stream_altList=new RewriteRuleSubtreeStream(adaptor,"rule altList");
		RewriteRuleSubtreeStream stream_ruleAction=new RewriteRuleSubtreeStream(adaptor,"rule ruleAction");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:842:3: ( LPAREN ( ( optionsSpec )? (ra+= ruleAction )* COLON )? altList RPAREN -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:842:5: LPAREN ( ( optionsSpec )? (ra+= ruleAction )* COLON )? altList RPAREN
			{
			LPAREN201=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_block3817);  
			stream_LPAREN.add(LPAREN201);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:843:9: ( ( optionsSpec )? (ra+= ruleAction )* COLON )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==AT||LA73_0==COLON||LA73_0==OPTIONS) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:843:11: ( optionsSpec )? (ra+= ruleAction )* COLON
					{
					// org\\antlr\\v4\\parse\\ANTLRParser.g:843:11: ( optionsSpec )?
					int alt71=2;
					int LA71_0 = input.LA(1);
					if ( (LA71_0==OPTIONS) ) {
						alt71=1;
					}
					switch (alt71) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:843:11: optionsSpec
							{
							pushFollow(FOLLOW_optionsSpec_in_block3829);
							optionsSpec202=optionsSpec();
							state._fsp--;

							stream_optionsSpec.add(optionsSpec202.getTree());
							}
							break;

					}

					// org\\antlr\\v4\\parse\\ANTLRParser.g:843:26: (ra+= ruleAction )*
					loop72:
					while (true) {
						int alt72=2;
						int LA72_0 = input.LA(1);
						if ( (LA72_0==AT) ) {
							alt72=1;
						}

						switch (alt72) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:843:26: ra+= ruleAction
							{
							pushFollow(FOLLOW_ruleAction_in_block3834);
							ra=ruleAction();
							state._fsp--;

							stream_ruleAction.add(ra.getTree());
							if (list_ra==null) list_ra=new ArrayList<Object>();
							list_ra.add(ra.getTree());
							}
							break;

						default :
							break loop72;
						}
					}

					COLON203=(Token)match(input,COLON,FOLLOW_COLON_in_block3837);  
					stream_COLON.add(COLON203);

					}
					break;

			}

			pushFollow(FOLLOW_altList_in_block3850);
			altList204=altList();
			state._fsp--;

			stream_altList.add(altList204.getTree());
			RPAREN205=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_block3854);  
			stream_RPAREN.add(RPAREN205);

			// AST REWRITE
			// elements: altList, optionsSpec, ra
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: ra
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_ra=new RewriteRuleSubtreeStream(adaptor,"token ra",list_ra);
			root_0 = (GrammarAST)adaptor.nil();
			// 846:7: -> ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:846:10: ^( BLOCK[$LPAREN,\"BLOCK\"] ( optionsSpec )? ( $ra)* altList )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new BlockAST(BLOCK, LPAREN201, "BLOCK"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:846:45: ( optionsSpec )?
				if ( stream_optionsSpec.hasNext() ) {
					adaptor.addChild(root_1, stream_optionsSpec.nextTree());
				}
				stream_optionsSpec.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:846:59: ( $ra)*
				while ( stream_ra.hasNext() ) {
					adaptor.addChild(root_1, stream_ra.nextTree());
				}
				stream_ra.reset();

				adaptor.addChild(root_1, stream_altList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "block"


	public static class ruleref_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleref"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:855:1: ruleref : RULE_REF ( ARG_ACTION )? ( elementOptions )? -> ^( RULE_REF ( ARG_ACTION )? ( elementOptions )? ) ;
	public final ANTLRParser.ruleref_return ruleref() throws RecognitionException {
		ANTLRParser.ruleref_return retval = new ANTLRParser.ruleref_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RULE_REF206=null;
		Token ARG_ACTION207=null;
		ParserRuleReturnScope elementOptions208 =null;

		GrammarAST RULE_REF206_tree=null;
		GrammarAST ARG_ACTION207_tree=null;
		RewriteRuleTokenStream stream_RULE_REF=new RewriteRuleTokenStream(adaptor,"token RULE_REF");
		RewriteRuleTokenStream stream_ARG_ACTION=new RewriteRuleTokenStream(adaptor,"token ARG_ACTION");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:862:5: ( RULE_REF ( ARG_ACTION )? ( elementOptions )? -> ^( RULE_REF ( ARG_ACTION )? ( elementOptions )? ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:862:7: RULE_REF ( ARG_ACTION )? ( elementOptions )?
			{
			RULE_REF206=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_ruleref3908);  
			stream_RULE_REF.add(RULE_REF206);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:862:16: ( ARG_ACTION )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==ARG_ACTION) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:862:16: ARG_ACTION
					{
					ARG_ACTION207=(Token)match(input,ARG_ACTION,FOLLOW_ARG_ACTION_in_ruleref3910);  
					stream_ARG_ACTION.add(ARG_ACTION207);

					}
					break;

			}

			// org\\antlr\\v4\\parse\\ANTLRParser.g:862:28: ( elementOptions )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==LT) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:862:28: elementOptions
					{
					pushFollow(FOLLOW_elementOptions_in_ruleref3913);
					elementOptions208=elementOptions();
					state._fsp--;

					stream_elementOptions.add(elementOptions208.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: elementOptions, ARG_ACTION, RULE_REF
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 862:44: -> ^( RULE_REF ( ARG_ACTION )? ( elementOptions )? )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:862:47: ^( RULE_REF ( ARG_ACTION )? ( elementOptions )? )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot(new RuleRefAST(stream_RULE_REF.nextToken()), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:862:70: ( ARG_ACTION )?
				if ( stream_ARG_ACTION.hasNext() ) {
					adaptor.addChild(root_1, new ActionAST(stream_ARG_ACTION.nextToken()));
				}
				stream_ARG_ACTION.reset();

				// org\\antlr\\v4\\parse\\ANTLRParser.g:862:93: ( elementOptions )?
				if ( stream_elementOptions.hasNext() ) {
					adaptor.addChild(root_1, stream_elementOptions.nextTree());
				}
				stream_elementOptions.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.ELEMENT_OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			 throw re; 
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleref"


	public static class range_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "range"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:875:1: range : STRING_LITERAL RANGE ^ STRING_LITERAL ;
	public final ANTLRParser.range_return range() throws RecognitionException {
		ANTLRParser.range_return retval = new ANTLRParser.range_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token STRING_LITERAL209=null;
		Token RANGE210=null;
		Token STRING_LITERAL211=null;

		GrammarAST STRING_LITERAL209_tree=null;
		GrammarAST RANGE210_tree=null;
		GrammarAST STRING_LITERAL211_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:876:5: ( STRING_LITERAL RANGE ^ STRING_LITERAL )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:876:7: STRING_LITERAL RANGE ^ STRING_LITERAL
			{
			root_0 = (GrammarAST)adaptor.nil();


			STRING_LITERAL209=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_range3969); 
			STRING_LITERAL209_tree = new TerminalAST(STRING_LITERAL209) ;
			adaptor.addChild(root_0, STRING_LITERAL209_tree);

			RANGE210=(Token)match(input,RANGE,FOLLOW_RANGE_in_range3974); 
			RANGE210_tree = new RangeAST(RANGE210) ;
			root_0 = (GrammarAST)adaptor.becomeRoot(RANGE210_tree, root_0);

			STRING_LITERAL211=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_range3980); 
			STRING_LITERAL211_tree = new TerminalAST(STRING_LITERAL211) ;
			adaptor.addChild(root_0, STRING_LITERAL211_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "range"


	public static class terminal_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "terminal"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:879:1: terminal : ( TOKEN_REF ( elementOptions )? -> ^( TOKEN_REF ( elementOptions )? ) | STRING_LITERAL ( elementOptions )? -> ^( STRING_LITERAL ( elementOptions )? ) );
	public final ANTLRParser.terminal_return terminal() throws RecognitionException {
		ANTLRParser.terminal_return retval = new ANTLRParser.terminal_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token TOKEN_REF212=null;
		Token STRING_LITERAL214=null;
		ParserRuleReturnScope elementOptions213 =null;
		ParserRuleReturnScope elementOptions215 =null;

		GrammarAST TOKEN_REF212_tree=null;
		GrammarAST STRING_LITERAL214_tree=null;
		RewriteRuleTokenStream stream_STRING_LITERAL=new RewriteRuleTokenStream(adaptor,"token STRING_LITERAL");
		RewriteRuleTokenStream stream_TOKEN_REF=new RewriteRuleTokenStream(adaptor,"token TOKEN_REF");
		RewriteRuleSubtreeStream stream_elementOptions=new RewriteRuleSubtreeStream(adaptor,"rule elementOptions");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:886:2: ( TOKEN_REF ( elementOptions )? -> ^( TOKEN_REF ( elementOptions )? ) | STRING_LITERAL ( elementOptions )? -> ^( STRING_LITERAL ( elementOptions )? ) )
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==TOKEN_REF) ) {
				alt78=1;
			}
			else if ( (LA78_0==STRING_LITERAL) ) {
				alt78=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 78, 0, input);
				throw nvae;
			}

			switch (alt78) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:886:6: TOKEN_REF ( elementOptions )?
					{
					TOKEN_REF212=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_terminal4004);  
					stream_TOKEN_REF.add(TOKEN_REF212);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:886:16: ( elementOptions )?
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==LT) ) {
						alt76=1;
					}
					switch (alt76) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:886:16: elementOptions
							{
							pushFollow(FOLLOW_elementOptions_in_terminal4006);
							elementOptions213=elementOptions();
							state._fsp--;

							stream_elementOptions.add(elementOptions213.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: elementOptions, TOKEN_REF
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 886:33: -> ^( TOKEN_REF ( elementOptions )? )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:886:36: ^( TOKEN_REF ( elementOptions )? )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new TerminalAST(stream_TOKEN_REF.nextToken()), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:886:61: ( elementOptions )?
						if ( stream_elementOptions.hasNext() ) {
							adaptor.addChild(root_1, stream_elementOptions.nextTree());
						}
						stream_elementOptions.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:887:6: STRING_LITERAL ( elementOptions )?
					{
					STRING_LITERAL214=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_terminal4027);  
					stream_STRING_LITERAL.add(STRING_LITERAL214);

					// org\\antlr\\v4\\parse\\ANTLRParser.g:887:21: ( elementOptions )?
					int alt77=2;
					int LA77_0 = input.LA(1);
					if ( (LA77_0==LT) ) {
						alt77=1;
					}
					switch (alt77) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:887:21: elementOptions
							{
							pushFollow(FOLLOW_elementOptions_in_terminal4029);
							elementOptions215=elementOptions();
							state._fsp--;

							stream_elementOptions.add(elementOptions215.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: elementOptions, STRING_LITERAL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 887:37: -> ^( STRING_LITERAL ( elementOptions )? )
					{
						// org\\antlr\\v4\\parse\\ANTLRParser.g:887:40: ^( STRING_LITERAL ( elementOptions )? )
						{
						GrammarAST root_1 = (GrammarAST)adaptor.nil();
						root_1 = (GrammarAST)adaptor.becomeRoot(new TerminalAST(stream_STRING_LITERAL.nextToken()), root_1);
						// org\\antlr\\v4\\parse\\ANTLRParser.g:887:70: ( elementOptions )?
						if ( stream_elementOptions.hasNext() ) {
							adaptor.addChild(root_1, stream_elementOptions.nextTree());
						}
						stream_elementOptions.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);


			GrammarAST options = (GrammarAST)retval.tree.getFirstChildWithType(ANTLRParser.ELEMENT_OPTIONS);
			if ( options!=null ) {
				Grammar.setNodeOptions(retval.tree, options);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "terminal"


	public static class elementOptions_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "elementOptions"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:892:1: elementOptions : LT ( elementOption ( COMMA elementOption )* )? GT -> ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )* ) ;
	public final ANTLRParser.elementOptions_return elementOptions() throws RecognitionException {
		ANTLRParser.elementOptions_return retval = new ANTLRParser.elementOptions_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token LT216=null;
		Token COMMA218=null;
		Token GT220=null;
		ParserRuleReturnScope elementOption217 =null;
		ParserRuleReturnScope elementOption219 =null;

		GrammarAST LT216_tree=null;
		GrammarAST COMMA218_tree=null;
		GrammarAST GT220_tree=null;
		RewriteRuleTokenStream stream_GT=new RewriteRuleTokenStream(adaptor,"token GT");
		RewriteRuleTokenStream stream_LT=new RewriteRuleTokenStream(adaptor,"token LT");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_elementOption=new RewriteRuleSubtreeStream(adaptor,"rule elementOption");

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:893:5: ( LT ( elementOption ( COMMA elementOption )* )? GT -> ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )* ) )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:893:9: LT ( elementOption ( COMMA elementOption )* )? GT
			{
			LT216=(Token)match(input,LT,FOLLOW_LT_in_elementOptions4060);  
			stream_LT.add(LT216);

			// org\\antlr\\v4\\parse\\ANTLRParser.g:893:12: ( elementOption ( COMMA elementOption )* )?
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==RULE_REF||LA80_0==TOKEN_REF) ) {
				alt80=1;
			}
			switch (alt80) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:893:13: elementOption ( COMMA elementOption )*
					{
					pushFollow(FOLLOW_elementOption_in_elementOptions4063);
					elementOption217=elementOption();
					state._fsp--;

					stream_elementOption.add(elementOption217.getTree());
					// org\\antlr\\v4\\parse\\ANTLRParser.g:893:27: ( COMMA elementOption )*
					loop79:
					while (true) {
						int alt79=2;
						int LA79_0 = input.LA(1);
						if ( (LA79_0==COMMA) ) {
							alt79=1;
						}

						switch (alt79) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRParser.g:893:28: COMMA elementOption
							{
							COMMA218=(Token)match(input,COMMA,FOLLOW_COMMA_in_elementOptions4066);  
							stream_COMMA.add(COMMA218);

							pushFollow(FOLLOW_elementOption_in_elementOptions4068);
							elementOption219=elementOption();
							state._fsp--;

							stream_elementOption.add(elementOption219.getTree());
							}
							break;

						default :
							break loop79;
						}
					}

					}
					break;

			}

			GT220=(Token)match(input,GT,FOLLOW_GT_in_elementOptions4074);  
			stream_GT.add(GT220);

			// AST REWRITE
			// elements: elementOption
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 894:13: -> ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )* )
			{
				// org\\antlr\\v4\\parse\\ANTLRParser.g:894:16: ^( ELEMENT_OPTIONS[$LT,\"ELEMENT_OPTIONS\"] ( elementOption )* )
				{
				GrammarAST root_1 = (GrammarAST)adaptor.nil();
				root_1 = (GrammarAST)adaptor.becomeRoot((GrammarAST)adaptor.create(ELEMENT_OPTIONS, LT216, "ELEMENT_OPTIONS"), root_1);
				// org\\antlr\\v4\\parse\\ANTLRParser.g:894:57: ( elementOption )*
				while ( stream_elementOption.hasNext() ) {
					adaptor.addChild(root_1, stream_elementOption.nextTree());
				}
				stream_elementOption.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementOptions"


	public static class elementOption_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "elementOption"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:899:1: elementOption : ( qid | id ASSIGN ^ optionValue );
	public final ANTLRParser.elementOption_return elementOption() throws RecognitionException {
		ANTLRParser.elementOption_return retval = new ANTLRParser.elementOption_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token ASSIGN223=null;
		ParserRuleReturnScope qid221 =null;
		ParserRuleReturnScope id222 =null;
		ParserRuleReturnScope optionValue224 =null;

		GrammarAST ASSIGN223_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:900:5: ( qid | id ASSIGN ^ optionValue )
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==RULE_REF) ) {
				int LA81_1 = input.LA(2);
				if ( (LA81_1==COMMA||LA81_1==DOT||LA81_1==GT) ) {
					alt81=1;
				}
				else if ( (LA81_1==ASSIGN) ) {
					alt81=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 81, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA81_0==TOKEN_REF) ) {
				int LA81_2 = input.LA(2);
				if ( (LA81_2==COMMA||LA81_2==DOT||LA81_2==GT) ) {
					alt81=1;
				}
				else if ( (LA81_2==ASSIGN) ) {
					alt81=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 81, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 81, 0, input);
				throw nvae;
			}

			switch (alt81) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:901:7: qid
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_qid_in_elementOption4122);
					qid221=qid();
					state._fsp--;

					adaptor.addChild(root_0, qid221.getTree());

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:902:7: id ASSIGN ^ optionValue
					{
					root_0 = (GrammarAST)adaptor.nil();


					pushFollow(FOLLOW_id_in_elementOption4130);
					id222=id();
					state._fsp--;

					adaptor.addChild(root_0, id222.getTree());

					ASSIGN223=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_elementOption4132); 
					ASSIGN223_tree = (GrammarAST)adaptor.create(ASSIGN223);
					root_0 = (GrammarAST)adaptor.becomeRoot(ASSIGN223_tree, root_0);

					pushFollow(FOLLOW_optionValue_in_elementOption4135);
					optionValue224=optionValue();
					state._fsp--;

					adaptor.addChild(root_0, optionValue224.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementOption"


	public static class id_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "id"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:909:1: id : ( RULE_REF -> ID[$RULE_REF] | TOKEN_REF -> ID[$TOKEN_REF] );
	public final ANTLRParser.id_return id() throws RecognitionException {
		ANTLRParser.id_return retval = new ANTLRParser.id_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token RULE_REF225=null;
		Token TOKEN_REF226=null;

		GrammarAST RULE_REF225_tree=null;
		GrammarAST TOKEN_REF226_tree=null;
		RewriteRuleTokenStream stream_RULE_REF=new RewriteRuleTokenStream(adaptor,"token RULE_REF");
		RewriteRuleTokenStream stream_TOKEN_REF=new RewriteRuleTokenStream(adaptor,"token TOKEN_REF");

		 paraphrases.push("looking for an identifier"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:912:5: ( RULE_REF -> ID[$RULE_REF] | TOKEN_REF -> ID[$TOKEN_REF] )
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==RULE_REF) ) {
				alt82=1;
			}
			else if ( (LA82_0==TOKEN_REF) ) {
				alt82=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 82, 0, input);
				throw nvae;
			}

			switch (alt82) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:912:7: RULE_REF
					{
					RULE_REF225=(Token)match(input,RULE_REF,FOLLOW_RULE_REF_in_id4166);  
					stream_RULE_REF.add(RULE_REF225);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 912:17: -> ID[$RULE_REF]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, RULE_REF225));
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:913:7: TOKEN_REF
					{
					TOKEN_REF226=(Token)match(input,TOKEN_REF,FOLLOW_TOKEN_REF_in_id4179);  
					stream_TOKEN_REF.add(TOKEN_REF226);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (GrammarAST)adaptor.nil();
					// 913:17: -> ID[$TOKEN_REF]
					{
						adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, TOKEN_REF226));
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "id"


	public static class qid_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "qid"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:916:1: qid : id ( DOT id )* -> ID[$qid.start, $text] ;
	public final ANTLRParser.qid_return qid() throws RecognitionException {
		ANTLRParser.qid_return retval = new ANTLRParser.qid_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token DOT228=null;
		ParserRuleReturnScope id227 =null;
		ParserRuleReturnScope id229 =null;

		GrammarAST DOT228_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_id=new RewriteRuleSubtreeStream(adaptor,"rule id");

		 paraphrases.push("looking for a qualified identifier"); 
		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:919:2: ( id ( DOT id )* -> ID[$qid.start, $text] )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:919:4: id ( DOT id )*
			{
			pushFollow(FOLLOW_id_in_qid4207);
			id227=id();
			state._fsp--;

			stream_id.add(id227.getTree());
			// org\\antlr\\v4\\parse\\ANTLRParser.g:919:7: ( DOT id )*
			loop83:
			while (true) {
				int alt83=2;
				int LA83_0 = input.LA(1);
				if ( (LA83_0==DOT) ) {
					alt83=1;
				}

				switch (alt83) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRParser.g:919:8: DOT id
					{
					DOT228=(Token)match(input,DOT,FOLLOW_DOT_in_qid4210);  
					stream_DOT.add(DOT228);

					pushFollow(FOLLOW_id_in_qid4212);
					id229=id();
					state._fsp--;

					stream_id.add(id229.getTree());
					}
					break;

				default :
					break loop83;
				}
			}

			// AST REWRITE
			// elements: 
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (GrammarAST)adaptor.nil();
			// 919:17: -> ID[$qid.start, $text]
			{
				adaptor.addChild(root_0, (GrammarAST)adaptor.create(ID, (retval.start), input.toString(retval.start,input.LT(-1))));
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

			 paraphrases.pop(); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "qid"


	public static class alternativeEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "alternativeEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:922:1: alternativeEntry : alternative EOF ;
	public final ANTLRParser.alternativeEntry_return alternativeEntry() throws RecognitionException {
		ANTLRParser.alternativeEntry_return retval = new ANTLRParser.alternativeEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF231=null;
		ParserRuleReturnScope alternative230 =null;

		GrammarAST EOF231_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:922:18: ( alternative EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:922:20: alternative EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_alternative_in_alternativeEntry4229);
			alternative230=alternative();
			state._fsp--;

			adaptor.addChild(root_0, alternative230.getTree());

			EOF231=(Token)match(input,EOF,FOLLOW_EOF_in_alternativeEntry4231); 
			EOF231_tree = (GrammarAST)adaptor.create(EOF231);
			adaptor.addChild(root_0, EOF231_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "alternativeEntry"


	public static class elementEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "elementEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:923:1: elementEntry : element EOF ;
	public final ANTLRParser.elementEntry_return elementEntry() throws RecognitionException {
		ANTLRParser.elementEntry_return retval = new ANTLRParser.elementEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF233=null;
		ParserRuleReturnScope element232 =null;

		GrammarAST EOF233_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:923:14: ( element EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:923:16: element EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_element_in_elementEntry4240);
			element232=element();
			state._fsp--;

			adaptor.addChild(root_0, element232.getTree());

			EOF233=(Token)match(input,EOF,FOLLOW_EOF_in_elementEntry4242); 
			EOF233_tree = (GrammarAST)adaptor.create(EOF233);
			adaptor.addChild(root_0, EOF233_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elementEntry"


	public static class ruleEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "ruleEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:924:1: ruleEntry : rule EOF ;
	public final ANTLRParser.ruleEntry_return ruleEntry() throws RecognitionException {
		ANTLRParser.ruleEntry_return retval = new ANTLRParser.ruleEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF235=null;
		ParserRuleReturnScope rule234 =null;

		GrammarAST EOF235_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:924:11: ( rule EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:924:13: rule EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_rule_in_ruleEntry4250);
			rule234=rule();
			state._fsp--;

			adaptor.addChild(root_0, rule234.getTree());

			EOF235=(Token)match(input,EOF,FOLLOW_EOF_in_ruleEntry4252); 
			EOF235_tree = (GrammarAST)adaptor.create(EOF235);
			adaptor.addChild(root_0, EOF235_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "ruleEntry"


	public static class blockEntry_return extends ParserRuleReturnScope {
		GrammarAST tree;
		@Override
		public GrammarAST getTree() { return tree; }
	};


	// $ANTLR start "blockEntry"
	// org\\antlr\\v4\\parse\\ANTLRParser.g:925:1: blockEntry : block EOF ;
	public final ANTLRParser.blockEntry_return blockEntry() throws RecognitionException {
		ANTLRParser.blockEntry_return retval = new ANTLRParser.blockEntry_return();
		retval.start = input.LT(1);

		GrammarAST root_0 = null;

		Token EOF237=null;
		ParserRuleReturnScope block236 =null;

		GrammarAST EOF237_tree=null;

		try {
			// org\\antlr\\v4\\parse\\ANTLRParser.g:925:12: ( block EOF )
			// org\\antlr\\v4\\parse\\ANTLRParser.g:925:14: block EOF
			{
			root_0 = (GrammarAST)adaptor.nil();


			pushFollow(FOLLOW_block_in_blockEntry4260);
			block236=block();
			state._fsp--;

			adaptor.addChild(root_0, block236.getTree());

			EOF237=(Token)match(input,EOF,FOLLOW_EOF_in_blockEntry4262); 
			EOF237_tree = (GrammarAST)adaptor.create(EOF237);
			adaptor.addChild(root_0, EOF237_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (GrammarAST)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (GrammarAST)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blockEntry"

	// Delegated rules



	public static final BitSet FOLLOW_DOC_COMMENT_in_grammarSpec402 = new BitSet(new long[]{0x0000080041000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_grammarType_in_grammarSpec433 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_grammarSpec435 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_grammarSpec437 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_sync_in_grammarSpec475 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_prequelConstruct_in_grammarSpec479 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_sync_in_grammarSpec481 = new BitSet(new long[]{0x0100020010820800L,0x0000000000000003L});
	public static final BitSet FOLLOW_rules_in_grammarSpec506 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_modeSpec_in_grammarSpec512 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_EOF_in_grammarSpec550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_in_grammarType740 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_GRAMMAR_in_grammarType744 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARSER_in_grammarType767 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_GRAMMAR_in_grammarType771 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAMMAR_in_grammarType792 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TREE_GRAMMAR_in_grammarType819 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_optionsSpec_in_prequelConstruct845 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delegateGrammars_in_prequelConstruct868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tokensSpec_in_prequelConstruct912 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_action_in_prequelConstruct949 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONS_in_optionsSpec964 = new BitSet(new long[]{0x0120000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_option_in_optionsSpec967 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_optionsSpec969 = new BitSet(new long[]{0x0120000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_RBRACE_in_optionsSpec973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_option1002 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_option1004 = new BitSet(new long[]{0x2100000020000010L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionValue_in_option1007 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_optionValue1050 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_optionValue1058 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_optionValue1063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INT_in_optionValue1074 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_delegateGrammars1090 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_delegateGrammar_in_delegateGrammars1092 = new BitSet(new long[]{0x0200000000008000L});
	public static final BitSet FOLLOW_COMMA_in_delegateGrammars1095 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_delegateGrammar_in_delegateGrammars1097 = new BitSet(new long[]{0x0200000000008000L});
	public static final BitSet FOLLOW_SEMI_in_delegateGrammars1101 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_delegateGrammar1128 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_delegateGrammar1130 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_delegateGrammar1133 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_delegateGrammar1143 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKENS_SPEC_in_tokensSpec1157 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_tokensSpec1159 = new BitSet(new long[]{0x0020000000008000L});
	public static final BitSet FOLLOW_COMMA_in_tokensSpec1162 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_tokensSpec1164 = new BitSet(new long[]{0x0020000000008000L});
	public static final BitSet FOLLOW_RBRACE_in_tokensSpec1168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKENS_SPEC_in_tokensSpec1185 = new BitSet(new long[]{0x0020000000000000L});
	public static final BitSet FOLLOW_RBRACE_in_tokensSpec1187 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKENS_SPEC_in_tokensSpec1197 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_v3tokenSpec_in_tokensSpec1200 = new BitSet(new long[]{0x0120000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_RBRACE_in_tokensSpec1203 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_v3tokenSpec1223 = new BitSet(new long[]{0x0200000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_v3tokenSpec1229 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_v3tokenSpec1233 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_v3tokenSpec1294 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_action1310 = new BitSet(new long[]{0x0100080040000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_actionScopeName_in_action1313 = new BitSet(new long[]{0x0000000000004000L});
	public static final BitSet FOLLOW_COLONCOLON_in_action1315 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_action1319 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_action1321 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_actionScopeName1350 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_in_actionScopeName1355 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARSER_in_actionScopeName1370 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MODE_in_modeSpec1389 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_modeSpec1391 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_modeSpec1393 = new BitSet(new long[]{0x0000000000820000L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_modeSpec1395 = new BitSet(new long[]{0x0000000000820002L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerRule_in_modeSpec1398 = new BitSet(new long[]{0x0000000000820000L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_modeSpec1400 = new BitSet(new long[]{0x0000000000820002L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_rules1431 = new BitSet(new long[]{0x0100000000820002L,0x0000000000000002L});
	public static final BitSet FOLLOW_rule_in_rules1434 = new BitSet(new long[]{0x0100000000820000L,0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_rules1436 = new BitSet(new long[]{0x0100000000820002L,0x0000000000000002L});
	public static final BitSet FOLLOW_parserRule_in_rule1498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerRule_in_rule1503 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOC_COMMENT_in_parserRule1543 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_RULE_REF_in_parserRule1566 = new BitSet(new long[]{0x8040020100000900L});
	public static final BitSet FOLLOW_ARG_ACTION_in_parserRule1596 = new BitSet(new long[]{0x8040020100000800L});
	public static final BitSet FOLLOW_ruleReturns_in_parserRule1603 = new BitSet(new long[]{0x8000020100000800L});
	public static final BitSet FOLLOW_throwsSpec_in_parserRule1610 = new BitSet(new long[]{0x0000020100000800L});
	public static final BitSet FOLLOW_localsSpec_in_parserRule1617 = new BitSet(new long[]{0x0000020000000800L});
	public static final BitSet FOLLOW_rulePrequels_in_parserRule1655 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_COLON_in_parserRule1664 = new BitSet(new long[]{0x2500404600080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_ruleBlock_in_parserRule1687 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_parserRule1696 = new BitSet(new long[]{0x0000000000401000L});
	public static final BitSet FOLLOW_exceptionGroup_in_parserRule1705 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_exceptionHandler_in_exceptionGroup1791 = new BitSet(new long[]{0x0000000000401002L});
	public static final BitSet FOLLOW_finallyClause_in_exceptionGroup1794 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CATCH_in_exceptionHandler1811 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_ARG_ACTION_in_exceptionHandler1813 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_exceptionHandler1815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FINALLY_in_finallyClause1842 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_finallyClause1844 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_sync_in_rulePrequels1876 = new BitSet(new long[]{0x0000020000000802L});
	public static final BitSet FOLLOW_rulePrequel_in_rulePrequels1879 = new BitSet(new long[]{0x0000020000000800L});
	public static final BitSet FOLLOW_sync_in_rulePrequels1881 = new BitSet(new long[]{0x0000020000000802L});
	public static final BitSet FOLLOW_optionsSpec_in_rulePrequel1905 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ruleAction_in_rulePrequel1913 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RETURNS_in_ruleReturns1933 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_ARG_ACTION_in_ruleReturns1936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_THROWS_in_throwsSpec1964 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_throwsSpec1966 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_COMMA_in_throwsSpec1969 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_throwsSpec1971 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_LOCALS_in_localsSpec1996 = new BitSet(new long[]{0x0000000000000100L});
	public static final BitSet FOLLOW_ARG_ACTION_in_localsSpec1999 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_ruleAction2022 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_ruleAction2024 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_ACTION_in_ruleAction2026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ruleAltList_in_ruleBlock2064 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_labeledAlt_in_ruleAltList2100 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_OR_in_ruleAltList2103 = new BitSet(new long[]{0x2500404600080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_labeledAlt_in_ruleAltList2105 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_alternative_in_labeledAlt2123 = new BitSet(new long[]{0x0000400000000002L});
	public static final BitSet FOLLOW_POUND_in_labeledAlt2129 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_labeledAlt2132 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOC_COMMENT_in_lexerRule2164 = new BitSet(new long[]{0x0000000000800000L,0x0000000000000002L});
	public static final BitSet FOLLOW_FRAGMENT_in_lexerRule2167 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_lexerRule2173 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_COLON_in_lexerRule2175 = new BitSet(new long[]{0x2500044280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerRuleBlock_in_lexerRule2177 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_SEMI_in_lexerRule2179 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAltList_in_lexerRuleBlock2246 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAlt_in_lexerAltList2282 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_OR_in_lexerAltList2285 = new BitSet(new long[]{0x2500044280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAlt_in_lexerAltList2287 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_lexerElements_in_lexerAlt2305 = new BitSet(new long[]{0x0010000000000002L});
	public static final BitSet FOLLOW_lexerCommands_in_lexerAlt2311 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerElement_in_lexerElements2374 = new BitSet(new long[]{0x2500004280080012L,0x0000000000000002L});
	public static final BitSet FOLLOW_labeledLexerElement_in_lexerElement2411 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_lexerElement2417 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAtom_in_lexerElement2463 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_lexerElement2469 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerBlock_in_lexerElement2515 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_lexerElement2521 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_actionElement_in_lexerElement2549 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_labeledLexerElement2579 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_labeledLexerElement2584 = new BitSet(new long[]{0x2100004280080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_ASSIGN_in_labeledLexerElement2588 = new BitSet(new long[]{0x2100004280080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAtom_in_labeledLexerElement2595 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerBlock_in_labeledLexerElement2612 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_lexerBlock2645 = new BitSet(new long[]{0x2500064280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionsSpec_in_lexerBlock2657 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_COLON_in_lexerBlock2659 = new BitSet(new long[]{0x2500044280080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerAltList_in_lexerBlock2672 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_lexerBlock2682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RARROW_in_lexerCommands2719 = new BitSet(new long[]{0x0100000800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommand_in_lexerCommands2721 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_COMMA_in_lexerCommands2724 = new BitSet(new long[]{0x0100000800000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommand_in_lexerCommands2726 = new BitSet(new long[]{0x0000000000008002L});
	public static final BitSet FOLLOW_lexerCommandName_in_lexerCommand2744 = new BitSet(new long[]{0x0000000200000000L});
	public static final BitSet FOLLOW_LPAREN_in_lexerCommand2746 = new BitSet(new long[]{0x0100000020000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommandExpr_in_lexerCommand2748 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_lexerCommand2750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lexerCommandName_in_lexerCommand2765 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_lexerCommandExpr2776 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INT_in_lexerCommandExpr2781 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_lexerCommandName2805 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MODE_in_lexerCommandName2823 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alternative_in_altList2851 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_OR_in_altList2854 = new BitSet(new long[]{0x2500044600080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_alternative_in_altList2856 = new BitSet(new long[]{0x0000040000000002L});
	public static final BitSet FOLLOW_elementOptions_in_alternative2890 = new BitSet(new long[]{0x2500004200080012L,0x0000000000000002L});
	public static final BitSet FOLLOW_element_in_alternative2899 = new BitSet(new long[]{0x2500004200080012L,0x0000000000000002L});
	public static final BitSet FOLLOW_labeledElement_in_element3014 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_element3020 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atom_in_element3066 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_element3072 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ebnf_in_element3118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_actionElement_in_element3123 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_actionElement3149 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ACTION_in_actionElement3159 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_elementOptions_in_actionElement3161 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMPRED_in_actionElement3179 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SEMPRED_in_actionElement3189 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_elementOptions_in_actionElement3191 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_labeledElement3213 = new BitSet(new long[]{0x0000200000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_labeledElement3218 = new BitSet(new long[]{0x2100004200080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_ASSIGN_in_labeledElement3222 = new BitSet(new long[]{0x2100004200080000L,0x0000000000000002L});
	public static final BitSet FOLLOW_atom_in_labeledElement3229 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_block_in_labeledElement3251 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_block_in_ebnf3287 = new BitSet(new long[]{0x1004100000000002L});
	public static final BitSet FOLLOW_blockSuffix_in_ebnf3311 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ebnfSuffix_in_blockSuffix3361 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3376 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3380 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_ebnfSuffix3396 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3400 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_ebnfSuffix3418 = new BitSet(new long[]{0x0004000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_ebnfSuffix3422 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_range_in_lexerAtom3443 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_terminal_in_lexerAtom3448 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RULE_REF_in_lexerAtom3458 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notSet_in_lexerAtom3469 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_wildcard_in_lexerAtom3477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_CHAR_SET_in_lexerAtom3485 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_range_in_atom3530 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_terminal_in_atom3537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ruleref_in_atom3547 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notSet_in_atom3555 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_wildcard_in_atom3563 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_wildcard3611 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_wildcard3613 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_notSet3651 = new BitSet(new long[]{0x2000000080000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_setElement_in_notSet3653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_notSet3681 = new BitSet(new long[]{0x0000000200000000L});
	public static final BitSet FOLLOW_blockSet_in_notSet3683 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_blockSet3718 = new BitSet(new long[]{0x2000000080000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_setElement_in_blockSet3720 = new BitSet(new long[]{0x0080040000000000L});
	public static final BitSet FOLLOW_OR_in_blockSet3723 = new BitSet(new long[]{0x2000000080000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_setElement_in_blockSet3725 = new BitSet(new long[]{0x0080040000000000L});
	public static final BitSet FOLLOW_RPAREN_in_blockSet3729 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_setElement3759 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_setElement3765 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_setElement3771 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_setElement3777 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_range_in_setElement3783 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEXER_CHAR_SET_in_setElement3793 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_block3817 = new BitSet(new long[]{0x2500064600082810L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionsSpec_in_block3829 = new BitSet(new long[]{0x0000000000002800L});
	public static final BitSet FOLLOW_ruleAction_in_block3834 = new BitSet(new long[]{0x0000000000002800L});
	public static final BitSet FOLLOW_COLON_in_block3837 = new BitSet(new long[]{0x2500044600080010L,0x0000000000000002L});
	public static final BitSet FOLLOW_altList_in_block3850 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_RPAREN_in_block3854 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RULE_REF_in_ruleref3908 = new BitSet(new long[]{0x0000000400000102L});
	public static final BitSet FOLLOW_ARG_ACTION_in_ruleref3910 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_ruleref3913 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_range3969 = new BitSet(new long[]{0x0008000000000000L});
	public static final BitSet FOLLOW_RANGE_in_range3974 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_range3980 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_terminal4004 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_terminal4006 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_terminal4027 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_elementOptions_in_terminal4029 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LT_in_elementOptions4060 = new BitSet(new long[]{0x0100000002000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_elementOption_in_elementOptions4063 = new BitSet(new long[]{0x0000000002008000L});
	public static final BitSet FOLLOW_COMMA_in_elementOptions4066 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_elementOption_in_elementOptions4068 = new BitSet(new long[]{0x0000000002008000L});
	public static final BitSet FOLLOW_GT_in_elementOptions4074 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_qid_in_elementOption4122 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_elementOption4130 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_elementOption4132 = new BitSet(new long[]{0x2100000020000010L,0x0000000000000002L});
	public static final BitSet FOLLOW_optionValue_in_elementOption4135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RULE_REF_in_id4166 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TOKEN_REF_in_id4179 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_qid4207 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_DOT_in_qid4210 = new BitSet(new long[]{0x0100000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_id_in_qid4212 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_alternative_in_alternativeEntry4229 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_alternativeEntry4231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_element_in_elementEntry4240 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_elementEntry4242 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rule_in_ruleEntry4250 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_ruleEntry4252 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_block_in_blockEntry4260 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_blockEntry4262 = new BitSet(new long[]{0x0000000000000002L});
}
