/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.RestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouteBuilder
extends BuilderSupport
implements RoutesBuilder {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private RestsDefinition restCollection = new RestsDefinition();
    private Map<String, RestConfigurationDefinition> restConfigurations;
    private RoutesDefinition routeCollection = new RoutesDefinition();

    public RouteBuilder() {
        this(null);
    }

    public RouteBuilder(CamelContext context) {
        super(context);
    }

    public String toString() {
        return this.getRouteCollection().toString();
    }

    public abstract void configure() throws Exception;

    public RestConfigurationDefinition restConfiguration() {
        return this.restConfiguration("");
    }

    public RestConfigurationDefinition restConfiguration(String component) {
        RestConfigurationDefinition restConfiguration;
        if (this.restConfigurations == null) {
            this.restConfigurations = new HashMap<String, RestConfigurationDefinition>();
        }
        if ((restConfiguration = this.restConfigurations.get(component)) == null) {
            restConfiguration = new RestConfigurationDefinition();
            if (!component.isEmpty()) {
                restConfiguration.component(component);
            }
            this.restConfigurations.put(component, restConfiguration);
        }
        return restConfiguration;
    }

    public RestDefinition rest() {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest();
        this.configureRest(answer);
        return answer;
    }

    public RestDefinition rest(String path) {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest(path);
        this.configureRest(answer);
        return answer;
    }

    public RouteDefinition from(String uri) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(uri);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition fromF(String uri, Object ... args) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(String.format(uri, args));
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpoint);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(String ... uris) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(uris);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint ... endpoints) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpoints);
        this.configureRoute(answer);
        return answer;
    }

    public void errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        this.setErrorHandlerBuilder(errorHandlerBuilder);
    }

    public InterceptDefinition intercept() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().intercept();
    }

    public InterceptFromDefinition interceptFrom() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom();
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom(uri);
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptSendToEndpoint(uri);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exception) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onException(exception);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> ... exceptions) {
        OnExceptionDefinition last = null;
        for (Class<? extends Throwable> ex : exceptions) {
            last = last == null ? this.onException(ex) : last.onException(ex);
        }
        return last != null ? last : this.onException((Class<? extends Throwable>)Exception.class);
    }

    public OnCompletionDefinition onCompletion() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onCompletion();
    }

    @Override
    public ModelCamelContext getContext() {
        ModelCamelContext context = super.getContext();
        if (context == null) {
            context = this.createContainer();
            this.setContext(context);
        }
        return context;
    }

    @Override
    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        this.configureRoutes((ModelCamelContext)context);
        this.configureRests((ModelCamelContext)context);
        this.populateRests();
        this.populateRoutes();
    }

    public RoutesDefinition configureRoutes(ModelCamelContext context) throws Exception {
        this.setContext(context);
        this.checkInitialized();
        this.routeCollection.setCamelContext(context);
        return this.routeCollection;
    }

    public RestsDefinition configureRests(ModelCamelContext context) throws Exception {
        this.setContext(context);
        this.restCollection.setCamelContext(context);
        return this.restCollection;
    }

    public void includeRoutes(RoutesBuilder routes) throws Exception {
        if (routes instanceof RouteBuilder) {
            RouteBuilder builder = (RouteBuilder)routes;
            builder.setContext(this.getContext());
            builder.setRouteCollection(this.getRouteCollection());
            builder.setRestCollection(this.getRestCollection());
            builder.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
            builder.configure();
        } else {
            this.getContext().addRoutes(routes);
        }
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        super.setErrorHandlerBuilder(errorHandlerBuilder);
        this.getRouteCollection().setErrorHandlerBuilder(this.getErrorHandlerBuilder());
    }

    protected void checkInitialized() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            ModelCamelContext camelContext = this.getContext();
            if (camelContext.getErrorHandlerBuilder() != null) {
                this.setErrorHandlerBuilder(camelContext.getErrorHandlerBuilder());
            }
            this.configure();
            for (RouteDefinition route : this.getRouteCollection().getRoutes()) {
                route.markPrepared();
            }
        }
    }

    protected void populateRoutes() throws Exception {
        ModelCamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRouteCollection().setCamelContext(camelContext);
        camelContext.addRouteDefinitions(this.getRouteCollection().getRoutes());
    }

    protected void populateRests() throws Exception {
        ModelCamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRestCollection().setCamelContext(camelContext);
        if (this.getRestConfigurations() != null) {
            for (Map.Entry<String, RestConfigurationDefinition> entry : this.getRestConfigurations().entrySet()) {
                RestConfiguration config = entry.getValue().asRestConfiguration(this.getContext());
                if ("".equals(entry.getKey())) {
                    camelContext.setRestConfiguration(config);
                    continue;
                }
                camelContext.addRestConfiguration(config);
            }
        }
        camelContext.addRestDefinitions(this.getRestCollection().getRests());
        ArrayList<RouteDefinition> routes = new ArrayList<RouteDefinition>();
        for (RestDefinition rest : this.getRestCollection().getRests()) {
            List<RouteDefinition> list = rest.asRouteDefinition(this.getContext());
            routes.addAll(list);
        }
        for (RestConfiguration config : camelContext.getRestConfigurations()) {
            if (config.getApiContextPath() == null) continue;
            boolean hasRestApi = false;
            for (RouteDefinition route : camelContext.getRouteDefinitions()) {
                FromDefinition from = route.getInputs().get(0);
                if (from.getUri() == null || !from.getUri().startsWith("rest-api:")) continue;
                hasRestApi = true;
            }
            if (hasRestApi) continue;
            RouteDefinition route = RestDefinition.asRouteApiDefinition(camelContext, config);
            this.log.debug("Adding routeId: {} as rest-api route", (Object)route.getId());
            routes.add(route);
        }
        for (RouteDefinition route : routes) {
            this.getRouteCollection().route(route);
        }
    }

    public RestsDefinition getRestCollection() {
        return this.restCollection;
    }

    public Map<String, RestConfigurationDefinition> getRestConfigurations() {
        return this.restConfigurations;
    }

    public void setRestCollection(RestsDefinition restCollection) {
        this.restCollection = restCollection;
    }

    public void setRouteCollection(RoutesDefinition routeCollection) {
        this.routeCollection = routeCollection;
    }

    public RoutesDefinition getRouteCollection() {
        return this.routeCollection;
    }

    protected ModelCamelContext createContainer() {
        return new DefaultCamelContext();
    }

    protected void configureRest(RestDefinition rest) {
    }

    protected void configureRoute(RouteDefinition route) {
    }

    @Deprecated
    protected void addRoutes(RoutesBuilder routes) throws Exception {
        this.includeRoutes(routes);
    }
}

