/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.http.BlockingQueueTransport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpTunnelServlet
extends HttpServlet {
    private static final long serialVersionUID = -3826714430767484333L;
    private static final Log LOG = LogFactory.getLog(HttpTunnelServlet.class);
    private TransportAcceptListener listener;
    private TextWireFormat wireFormat;
    private final Map<String, BlockingQueueTransport> clients = new HashMap<String, BlockingQueueTransport>();
    private final long requestTimeout = 30000L;

    public void init() throws ServletException {
        super.init();
        this.listener = (TransportAcceptListener)this.getServletContext().getAttribute("acceptListener");
        if (this.listener == null) {
            throw new ServletException("No such attribute 'acceptListener' available in the ServletContext");
        }
        this.wireFormat = (TextWireFormat)this.getServletContext().getAttribute("wireFormat");
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.createTransportChannel(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Command packet = null;
        int count = 0;
        try {
            BlockingQueueTransport transportChannel = this.getTransportChannel(request, response);
            if (transportChannel == null) {
                return;
            }
            packet = (Command)transportChannel.getQueue().poll(30000L, TimeUnit.MILLISECONDS);
            DataOutputStream stream = new DataOutputStream((OutputStream)response.getOutputStream());
            this.wireFormat.marshal(packet, stream);
            ++count;
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        if (count == 0) {
            response.setStatus(408);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream sis = request.getInputStream();
        Command command = (Command)this.wireFormat.unmarshalText(new InputStreamReader((InputStream)sis, "UTF-8"));
        if (command instanceof WireFormatInfo) {
            WireFormatInfo info = (WireFormatInfo)command;
            if (!this.canProcessWireFormatVersion(info.getVersion())) {
                response.sendError(404, "Cannot process wire format of version: " + info.getVersion());
            }
        } else {
            BlockingQueueTransport transport = this.getTransportChannel(request, response);
            if (transport == null) {
                return;
            }
            transport.doConsume(command);
        }
    }

    private boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    protected String readRequestBody(HttpServletRequest request) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockingQueueTransport getTransportChannel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String clientID = request.getHeader("clientID");
        if (clientID == null) {
            response.sendError(400, "No clientID header specified");
            LOG.warn("No clientID header specified");
            return null;
        }
        HttpTunnelServlet httpTunnelServlet = this;
        synchronized (httpTunnelServlet) {
            BlockingQueueTransport answer = this.clients.get(clientID);
            if (answer == null) {
                LOG.warn("The clientID header specified is invalid. Client sesion has not yet been established for it: " + clientID);
                return null;
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockingQueueTransport createTransportChannel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String clientID = request.getHeader("clientID");
        if (clientID == null) {
            response.sendError(400, "No clientID header specified");
            LOG.warn("No clientID header specified");
            return null;
        }
        HttpTunnelServlet httpTunnelServlet = this;
        synchronized (httpTunnelServlet) {
            BlockingQueueTransport answer = this.clients.get(clientID);
            if (answer != null) {
                response.sendError(400, "A session for clientID '" + clientID + "' has allready been established");
                LOG.warn("A session for clientID '" + clientID + "' has allready been established");
                return null;
            }
            answer = this.createTransportChannel();
            this.clients.put(clientID, answer);
            this.listener.onAccept(answer);
            while (!answer.isConnected()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {}
            }
            return answer;
        }
    }

    protected BlockingQueueTransport createTransportChannel() {
        return new BlockingQueueTransport(new LinkedBlockingQueue<Object>());
    }

    protected TextWireFormat createWireFormat() {
        return new XStreamWireFormat();
    }
}

