/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class Decimal32Element
extends AtomicElement<Decimal32> {
    private final Decimal32 _value;

    Decimal32Element(Element parent, Element prev, Decimal32 d) {
        super(parent, prev);
        this._value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 4 : 5;
    }

    @Override
    public Decimal32 getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.DECIMAL32;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (b.remaining() >= size2) {
            if (size2 == 5) {
                b.put((byte)116);
            }
            b.putInt(this._value.getBits());
            return size2;
        }
        return 0;
    }
}

