/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.authc;

import java.util.Collection;
import org.apache.activemq.shiro.ConnectionReference;
import org.apache.activemq.shiro.authc.AuthenticationPolicy;
import org.apache.activemq.shiro.subject.SubjectConnectionReference;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;

public class DefaultAuthenticationPolicy
implements AuthenticationPolicy {
    private boolean vmConnectionAuthenticationRequired = false;
    private String systemAccountUsername = "system";
    private String systemAccountRealmName = "iniRealm";
    private boolean anonymousAccessAllowed = false;
    private String anonymousAccountUsername = "anonymous";
    private String anonymousAccountRealmName = "iniRealm";

    public boolean isVmConnectionAuthenticationRequired() {
        return this.vmConnectionAuthenticationRequired;
    }

    public void setVmConnectionAuthenticationRequired(boolean vmConnectionAuthenticationRequired) {
        this.vmConnectionAuthenticationRequired = vmConnectionAuthenticationRequired;
    }

    public String getSystemAccountUsername() {
        return this.systemAccountUsername;
    }

    public void setSystemAccountUsername(String systemAccountUsername) {
        this.systemAccountUsername = systemAccountUsername;
    }

    public String getSystemAccountRealmName() {
        return this.systemAccountRealmName;
    }

    public void setSystemAccountRealmName(String systemAccountRealmName) {
        this.systemAccountRealmName = systemAccountRealmName;
    }

    public boolean isAnonymousAccessAllowed() {
        return this.anonymousAccessAllowed;
    }

    public void setAnonymousAccessAllowed(boolean anonymousAccessAllowed) {
        this.anonymousAccessAllowed = anonymousAccessAllowed;
    }

    public String getAnonymousAccountUsername() {
        return this.anonymousAccountUsername;
    }

    public void setAnonymousAccountUsername(String anonymousAccountUsername) {
        this.anonymousAccountUsername = anonymousAccountUsername;
    }

    public String getAnonymousAccountRealmName() {
        return this.anonymousAccountRealmName;
    }

    public void setAnonymousAccountRealmName(String anonymousAccountRealmName) {
        this.anonymousAccountRealmName = anonymousAccountRealmName;
    }

    protected boolean credentialsAvailable(ConnectionReference conn) {
        return conn.getConnectionInfo().getUserName() != null || conn.getConnectionInfo().getPassword() != null;
    }

    @Override
    public boolean isAuthenticationRequired(SubjectConnectionReference conn) {
        Subject subject = conn.getSubject();
        if (subject.isAuthenticated()) {
            return false;
        }
        if (this.isAnonymousAccessAllowed() && this.isAnonymousAccount(subject)) {
            return false;
        }
        return this.isVmConnectionAuthenticationRequired() || !this.isSystemAccount(subject);
    }

    protected boolean isAnonymousAccount(Subject subject) {
        PrincipalCollection pc = subject.getPrincipals();
        return pc != null && this.matches(pc, this.anonymousAccountUsername, this.anonymousAccountRealmName);
    }

    protected boolean isSystemAccount(Subject subject) {
        PrincipalCollection pc = subject.getPrincipals();
        return pc != null && this.matches(pc, this.systemAccountUsername, this.systemAccountRealmName);
    }

    protected boolean matches(PrincipalCollection principals, String username, String realmName) {
        Collection realmPrincipals = principals.fromRealm(realmName);
        return realmPrincipals != null && !realmPrincipals.isEmpty() && realmPrincipals.iterator().next().equals(username);
    }

    protected boolean isSystemConnection(ConnectionReference conn) {
        String remoteAddress = conn.getConnectionContext().getConnection().getRemoteAddress();
        return remoteAddress.startsWith("vm:");
    }

    @Override
    public void customizeSubject(Subject.Builder subjectBuilder, ConnectionReference conn) {
        if (this.credentialsAvailable(conn)) {
            return;
        }
        if (this.isAssumeIdentity(conn)) {
            PrincipalCollection assumedIdentity = this.createAssumedIdentity(conn);
            subjectBuilder.principals(assumedIdentity);
        }
    }

    protected boolean isAssumeIdentity(ConnectionReference conn) {
        return this.isAnonymousAccessAllowed() || this.isSystemConnection(conn) && !this.isVmConnectionAuthenticationRequired();
    }

    protected PrincipalCollection createAssumedIdentity(ConnectionReference conn) {
        String username = this.anonymousAccountUsername;
        String realmName = this.anonymousAccountRealmName;
        if (this.isSystemConnection(conn)) {
            username = this.systemAccountUsername;
            realmName = this.systemAccountRealmName;
        }
        return new SimplePrincipalCollection((Object)username, realmName);
    }
}

