/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.advisory.ConsumerEvent;
import org.apache.activemq.advisory.ConsumerEventSource;
import org.apache.activemq.advisory.ConsumerListener;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempDestDeleteTest
extends EmbeddedBrokerTestSupport
implements ConsumerListener {
    private static final Logger LOG = LoggerFactory.getLogger(TempDestDeleteTest.class);
    protected int consumerCounter;
    protected ConsumerEventSource topicConsumerEventSource;
    protected BlockingQueue<ConsumerEvent> eventQueue = new ArrayBlockingQueue<ConsumerEvent>(1000);
    private ConsumerEventSource queueConsumerEventSource;
    private Connection connection;
    private Session session;
    private ActiveMQTempTopic tempTopic;
    private ActiveMQTempQueue tempQueue;

    public void testDeleteTempTopicDeletesAvisoryTopics() throws Exception {
        this.topicConsumerEventSource.start();
        MessageConsumer consumer = this.createConsumer((Destination)this.tempTopic);
        this.assertConsumerEvent(1, true);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)this.tempTopic);
        TempDestDeleteTest.assertTrue((boolean)this.destinationExists((Destination)advisoryTopic));
        consumer.close();
        this.tempTopic.delete();
        TempDestDeleteTest.assertFalse((boolean)this.destinationExists((Destination)advisoryTopic));
    }

    public void testDeleteTempQueueDeletesAvisoryTopics() throws Exception {
        this.queueConsumerEventSource.start();
        MessageConsumer consumer = this.createConsumer((Destination)this.tempQueue);
        this.assertConsumerEvent(1, true);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)this.tempQueue);
        TempDestDeleteTest.assertTrue((boolean)this.destinationExists((Destination)advisoryTopic));
        consumer.close();
        this.tempQueue.delete();
        TempDestDeleteTest.assertFalse((boolean)this.destinationExists((Destination)advisoryTopic));
    }

    private boolean destinationExists(Destination dest) throws Exception {
        RegionBroker rb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        return rb.getTopicRegion().getDestinationMap().containsKey(dest) || rb.getQueueRegion().getDestinationMap().containsKey(dest) || rb.getTempTopicRegion().getDestinationMap().containsKey(dest) || rb.getTempQueueRegion().getDestinationMap().containsKey(dest);
    }

    public void onConsumerEvent(ConsumerEvent event) {
        this.eventQueue.add(event);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.tempTopic = (ActiveMQTempTopic)this.session.createTemporaryTopic();
        this.topicConsumerEventSource = new ConsumerEventSource(this.connection, (Destination)this.tempTopic);
        this.topicConsumerEventSource.setConsumerListener((ConsumerListener)this);
        this.tempQueue = (ActiveMQTempQueue)this.session.createTemporaryQueue();
        this.queueConsumerEventSource = new ConsumerEventSource(this.connection, (Destination)this.tempQueue);
        this.queueConsumerEventSource.setConsumerListener((ConsumerListener)this);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected void assertConsumerEvent(int count, boolean started) throws InterruptedException {
        ConsumerEvent event = this.waitForConsumerEvent();
        TempDestDeleteTest.assertEquals((String)"Consumer count", (int)count, (int)event.getConsumerCount());
        TempDestDeleteTest.assertEquals((String)"started", (boolean)started, (boolean)event.isStarted());
    }

    protected MessageConsumer createConsumer(Destination dest) throws JMSException {
        final String consumerText = "Consumer: " + ++this.consumerCounter;
        LOG.info("Creating consumer: " + consumerText + " on destination: " + dest);
        MessageConsumer consumer = this.session.createConsumer(dest);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.info("Received message by: " + consumerText + " message: " + message);
            }
        });
        return consumer;
    }

    protected ConsumerEvent waitForConsumerEvent() throws InterruptedException {
        ConsumerEvent answer = this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
        TempDestDeleteTest.assertTrue((String)"Should have received a consumer event!", (answer != null ? 1 : 0) != 0);
        return answer;
    }
}

