/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.blob.BlobDownloadStrategy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.BlobUploadStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.command.MessageId;

public class BlobTransferPolicyUriTest
extends TestCase {
    public void testBlobTransferPolicyIsConfiguredViaUri() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?jms.blobTransferPolicy.defaultUploadUrl=http://foo.com");
        BlobTransferPolicy policy = factory.getBlobTransferPolicy();
        BlobTransferPolicyUriTest.assertEquals((String)"http://foo.com", (String)policy.getDefaultUploadUrl());
        BlobTransferPolicyUriTest.assertEquals((String)"http://foo.com", (String)policy.getUploadUrl());
    }

    public void testDefaultUploadStrategySensibleError() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        BlobTransferPolicy policy = factory.getBlobTransferPolicy();
        BlobUploadStrategy strategy = policy.getUploadStrategy();
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        message.setMessageId(new MessageId("1:0:0:0"));
        try {
            strategy.uploadStream(message, message.getInputStream());
        }
        catch (IOException expected) {
            BlobTransferPolicyUriTest.assertTrue((boolean)expected.getMessage().contains("8080"));
            expected.printStackTrace();
        }
    }

    public void testDefaultDownlaodStrategySensibleError() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        BlobTransferPolicy policy = factory.getBlobTransferPolicy();
        BlobDownloadStrategy strategy = policy.getDownloadStrategy();
        ActiveMQBlobMessage message = new ActiveMQBlobMessage();
        message.setMessageId(new MessageId("1:0:0:0"));
        try {
            strategy.deleteFile(message);
        }
        catch (IOException expected) {
            BlobTransferPolicyUriTest.assertTrue((boolean)expected.getMessage().contains("8080"));
            expected.printStackTrace();
        }
    }
}

