/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Arrays;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class RedeliveryRestartTest
extends TestSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(RedeliveryRestartTest.class);
    ActiveMQConnection connection;
    BrokerService broker = null;
    String queueName = "redeliveryRestartQ";
    @Parameterized.Parameter
    public TestSupport.PersistenceAdapterChoice persistenceAdapterChoice = TestSupport.PersistenceAdapterChoice.KahaDB;

    @Parameterized.Parameters(name="Store={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({TestSupport.PersistenceAdapterChoice.KahaDB}, {TestSupport.PersistenceAdapterChoice.JDBC});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.configureBroker(this.broker);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.broker.stop();
        super.tearDown();
    }

    protected void configureBroker(BrokerService broker) throws Exception {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setPersistJMSRedelivered(true);
        policyMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(policyMap);
        RedeliveryRestartTest.setPersistenceAdapter(broker, this.persistenceAdapterChoice);
        broker.addConnector("tcp://0.0.0.0:0");
    }

    @Test
    public void testValidateRedeliveryFlagAfterRestartNoTx() throws Exception {
        int i;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + ")?jms.prefetchPolicy.all=0");
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue destination = session.createQueue(this.queueName);
        this.populateDestination(10, (Destination)destination, (Connection)this.connection);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        TextMessage msg = null;
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(20000L);
            LOG.info("not redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        }
        consumer.close();
        this.restartBroker();
        ((FailoverTransport)this.connection.getTransport().narrow(FailoverTransport.class)).add(true, ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(4000L);
            LOG.info("redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message again", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"re delivery flag", (boolean)true, (boolean)msg.getJMSRedelivered());
            RedeliveryRestartTest.assertEquals((String)"redelivery count survives restart", (long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            msg.acknowledge();
        }
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(20000L);
            LOG.info("not redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
            RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            msg.acknowledge();
        }
        this.connection.close();
    }

    @Test
    public void testDurableSubRedeliveryFlagAfterRestartNotSupported() throws Exception {
        int i;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + ")?jms.prefetchPolicy.all=0");
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.setClientID("id");
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        ActiveMQTopic destination = new ActiveMQTopic(this.queueName);
        TopicSubscriber durableSub = session.createDurableSubscriber((Topic)destination, "id");
        this.populateDestination(10, (Destination)destination, (Connection)this.connection);
        TextMessage msg = null;
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)durableSub.receive(20000L);
            LOG.info("not redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        }
        durableSub.close();
        this.restartBroker();
        ((FailoverTransport)this.connection.getTransport().narrow(FailoverTransport.class)).add(true, ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        durableSub = session.createDurableSubscriber((Topic)destination, "id");
        for (i = 0; i < 10; ++i) {
            msg = (TextMessage)durableSub.receive(4000L);
            LOG.info("redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message again", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"no reDelivery flag", (boolean)false, (boolean)msg.getJMSRedelivered());
            msg.acknowledge();
        }
        this.connection.close();
    }

    @Test
    public void testValidateRedeliveryFlagAfterRestart() throws Exception {
        int i;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + ")?jms.prefetchPolicy.all=0");
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        Queue destination = session.createQueue(this.queueName);
        this.populateDestination(10, (Destination)destination, (Connection)this.connection);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        TextMessage msg = null;
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(20000L);
            LOG.info("not redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        }
        session.rollback();
        consumer.close();
        this.restartBroker();
        ((FailoverTransport)this.connection.getTransport().narrow(FailoverTransport.class)).add(true, ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(4000L);
            LOG.info("redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message again", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"redelivery count survives restart", (long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"re delivery flag", (boolean)true, (boolean)msg.getJMSRedelivered());
        }
        session.commit();
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(20000L);
            LOG.info("not redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        }
        session.commit();
        this.connection.close();
    }

    @Test
    public void testValidateRedeliveryFlagAfterRecovery() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + "?jms.prefetchPolicy.all=0");
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        Queue destination = session.createQueue(this.queueName);
        this.populateDestination(1, (Destination)destination, (Connection)this.connection);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        TextMessage msg = (TextMessage)consumer.receive(5000L);
        LOG.info("got: " + msg);
        RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
        RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        this.stopBrokerWithStoreFailure(this.broker, this.persistenceAdapterChoice);
        this.broker = this.createRestartedBroker();
        this.broker.start();
        this.connection.close();
        connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        session = this.connection.createSession(true, 0);
        consumer = session.createConsumer((Destination)destination);
        msg = (TextMessage)consumer.receive(10000L);
        RedeliveryRestartTest.assertNotNull((String)"got the message again", (Object)msg);
        RedeliveryRestartTest.assertEquals((String)"redelivery count survives restart", (long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        RedeliveryRestartTest.assertEquals((String)"re delivery flag", (boolean)true, (boolean)msg.getJMSRedelivered());
        session.commit();
        this.connection.close();
    }

    private void restartBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createRestartedBroker();
        this.broker.start();
    }

    private BrokerService createRestartedBroker() throws Exception {
        this.broker = new BrokerService();
        this.configureBroker(this.broker);
        return this.broker;
    }

    private void populateDestination(int nbMessages, Destination destination, Connection connection) throws JMSException {
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(destination);
        for (int i = 1; i <= nbMessages; ++i) {
            producer.send((Message)session.createTextMessage("<hello id='" + i + "'/>"));
        }
        producer.close();
        session.close();
    }
}

