/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanOperationTimeoutTest {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanOperationTimeoutTest.class);
    private ActiveMQConnectionFactory connectionFactory;
    private BrokerService broker;
    private String connectionUri;
    private static final String destinationName = "MBeanOperationTimeoutTestQ";
    private static final String moveToDestinationName = "MBeanOperationTimeoutTestQ.Moved";
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected int messageCount = 50000;

    @Test(expected=TimeoutException.class)
    public void testLongOperationTimesOut() throws Exception {
        this.sendMessages(this.messageCount);
        LOG.info("Produced " + this.messageCount + " messages to the broker.");
        Object objectNameStr = this.broker.getBrokerObjectName().toString();
        objectNameStr = (String)objectNameStr + ",destinationType=Queue,destinationName=MBeanOperationTimeoutTestQ";
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName((String)objectNameStr);
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long count = proxy.getQueueSize();
        Assert.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        LOG.info("Attempting to move one message, TimeoutException expected");
        proxy.moveMatchingMessagesTo(null, moveToDestinationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages(int count) throws Exception {
        try (Connection connection = this.connectionFactory.createConnection();){
            Session session = connection.createSession(true, 0);
            Queue destination = session.createQueue(destinationName);
            MessageProducer producer = session.createProducer((Destination)destination);
            for (int i = 0; i < this.messageCount; ++i) {
                Message message = session.createMessage();
                message.setIntProperty("id", i);
                producer.send(message);
            }
            session.commit();
        }
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            LOG.info("Bean Registered: " + objectName);
        } else {
            Assert.fail((String)("Could not find MBean!: " + objectName));
        }
        return objectName;
    }

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    @After
    public void tearDown() throws Exception {
        Thread.sleep(500L);
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
            this.broker = null;
        }
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setMbeanInvocationTimeout(TimeUnit.SECONDS.toMillis(1L));
        answer.setUseJmx(true);
        answer.addConnector("vm://localhost");
        answer.setDeleteAllMessagesOnStartup(true);
        return answer;
    }
}

