/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.policy.DeadLetterTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListenerDeadLetterTest
extends DeadLetterTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MessageListenerDeadLetterTest.class);
    private int rollbackCount;
    private Session dlqSession;
    private final Error[] error = new Error[1];

    @Override
    protected void doTest() throws Exception {
        this.messageCount = 200;
        this.connection.start();
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.connection;
        this.rollbackCount = amqConnection.getRedeliveryPolicy().getMaximumRedeliveries() + 1;
        LOG.info("Will redeliver messages: " + this.rollbackCount + " times");
        this.makeConsumer();
        this.makeDlqConsumer();
        this.sendMessages();
        int maxRollbacks = this.messageCount * this.rollbackCount;
        this.consumer.setMessageListener((MessageListener)new RollbackMessageListener(maxRollbacks, this.rollbackCount));
        for (int i = 0; i < this.messageCount; ++i) {
            Message msg = this.dlqConsumer.receive(4000L);
            if (this.error[0] != null) {
                throw this.error[0];
            }
            this.assertMessage(msg, i);
            MessageListenerDeadLetterTest.assertNotNull((String)("Should be a DLQ message for loop: " + i), (Object)msg);
        }
        if (this.error[0] != null) {
            throw this.error[0];
        }
    }

    @Override
    protected void makeDlqConsumer() throws JMSException {
        this.dlqDestination = this.createDlqDestination();
        LOG.info("Consuming from dead letter on: " + this.dlqDestination);
        this.dlqConsumer = this.dlqSession.createConsumer(this.dlqDestination);
    }

    @Override
    protected void setUp() throws Exception {
        this.transactedMode = true;
        super.setUp();
        this.dlqSession = this.connection.createSession(this.transactedMode, this.acknowledgeMode);
    }

    @Override
    protected void tearDown() throws Exception {
        this.dlqConsumer.close();
        this.dlqSession.close();
        this.session.close();
        super.tearDown();
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = super.createConnectionFactory();
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setMaximumRedeliveries(3);
        policy.setBackOffMultiplier(1.0);
        policy.setRedeliveryDelay(0L);
        policy.setInitialRedeliveryDelay(0L);
        policy.setUseExponentialBackOff(false);
        answer.setRedeliveryPolicy(policy);
        return answer;
    }

    @Override
    protected Destination createDlqDestination() {
        return new ActiveMQQueue("ActiveMQ.DLQ");
    }

    class RollbackMessageListener
    implements MessageListener {
        final int maxRollbacks;
        final int deliveryCount;
        AtomicInteger rollbacks = new AtomicInteger();

        RollbackMessageListener(int c, int delvery) {
            this.maxRollbacks = c;
            this.deliveryCount = delvery;
        }

        public void onMessage(Message message) {
            try {
                int expectedMessageId = this.rollbacks.get() / this.deliveryCount;
                LOG.info("expecting messageId: " + expectedMessageId);
                MessageListenerDeadLetterTest.this.assertMessage(message, expectedMessageId);
                if (this.rollbacks.incrementAndGet() > this.maxRollbacks) {
                    TestCase.fail((String)("received too many messages, already done too many rollbacks: " + this.rollbacks));
                }
                MessageListenerDeadLetterTest.this.session.rollback();
            }
            catch (Throwable e) {
                LOG.error("unexpected exception:" + e, e);
                if (e instanceof Error) {
                    MessageListenerDeadLetterTest.this.error[0] = (Error)e;
                }
                TestCase.fail((String)("unexpected exception: " + e));
            }
        }
    }
}

