/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.group;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageGroupTest
extends JmsTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CombinationTestSupport.class);

    public void testGroupedMessagesDeliveredToOnlyOneConsumer() throws Exception {
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer1 = session.createConsumer((Destination)destination);
        MessageProducer producer = session.createProducer((Destination)destination);
        for (i = 0; i < 4; ++i) {
            TextMessage message = session.createTextMessage("message " + i);
            message.setStringProperty("JMSXGroupID", "TEST-GROUP");
            message.setIntProperty("JMSXGroupSeq", i + 1);
            LOG.info("sending message: " + message);
            producer.send((Message)message);
        }
        for (i = 0; i < 3; ++i) {
            TextMessage m1 = (TextMessage)consumer1.receive(500L);
            MessageGroupTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            MessageGroupTest.assertEquals((int)m1.getIntProperty("JMSXGroupSeq"), (int)(i + 1));
        }
        Connection connection1 = this.factory.createConnection(this.userName, this.password);
        connection1.start();
        Session session2 = connection1.createSession(false, 1);
        MessageConsumer consumer2 = session2.createConsumer((Destination)destination);
        consumer1.close();
        for (int i2 = 0; i2 < 1; ++i2) {
            TextMessage m1 = (TextMessage)consumer2.receive(500L);
            MessageGroupTest.assertNotNull((String)("m1 is null for index: " + i2), (Object)m1);
            MessageGroupTest.assertEquals((int)m1.getIntProperty("JMSXGroupSeq"), (int)(4 + i2));
        }
        Message m = consumer2.receive(100L);
        MessageGroupTest.assertNull((String)"consumer 2 has some messages left", (Object)m);
    }

    public void testAddingConsumer() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage message = session.createTextMessage("message");
        message.setStringProperty("JMSXGroupID", "TEST-GROUP");
        LOG.info("sending message: " + message);
        producer.send((Message)message);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        TextMessage msg = (TextMessage)consumer.receive();
        MessageGroupTest.assertNotNull((Object)msg);
        boolean first = msg.getBooleanProperty("JMSXGroupFirstForConsumer");
        MessageGroupTest.assertTrue((boolean)first);
    }

    public void testClosingMessageGroup() throws Exception {
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer1 = session.createConsumer((Destination)destination);
        MessageProducer producer = session.createProducer((Destination)destination);
        for (i = 0; i < 4; ++i) {
            TextMessage message = session.createTextMessage("message " + i);
            message.setStringProperty("JMSXGroupID", "TEST-GROUP");
            LOG.info("sending message: " + message);
            producer.send((Message)message);
        }
        for (i = 0; i < 3; ++i) {
            TextMessage m1 = (TextMessage)consumer1.receive(500L);
            MessageGroupTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
        }
        Connection connection1 = this.factory.createConnection(this.userName, this.password);
        connection1.start();
        Session session2 = connection1.createSession(false, 1);
        MessageConsumer consumer2 = session2.createConsumer((Destination)destination);
        Message m = consumer2.receive(100L);
        MessageGroupTest.assertNull((String)"consumer 2 has some messages", (Object)m);
        TextMessage message = session.createTextMessage("message 5");
        message.setStringProperty("JMSXGroupID", "TEST-GROUP");
        message.setIntProperty("JMSXGroupSeq", -1);
        LOG.info("sending message: " + message);
        producer.send((Message)message);
        for (int i2 = 0; i2 < 4; ++i2) {
            message = session.createTextMessage("message " + i2);
            message.setStringProperty("JMSXGroupID", "TEST-GROUP");
            LOG.info("sending message: " + message);
            producer.send((Message)message);
        }
        TextMessage m1 = (TextMessage)consumer1.receive(500L);
        MessageGroupTest.assertNotNull((String)"m1 is null for index: 4", (Object)m1);
        m1 = (TextMessage)consumer1.receive(500L);
        MessageGroupTest.assertNotNull((String)"m1 is null for index: 5", (Object)m1);
        m = consumer1.receive(100L);
        MessageGroupTest.assertNull((String)"consumer 1 has some messages left", (Object)m);
        for (int i3 = 0; i3 < 4; ++i3) {
            m1 = (TextMessage)consumer2.receive(500L);
            MessageGroupTest.assertNotNull((String)("m1 is null for index: " + i3), (Object)m1);
        }
    }
}

