/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirroredQueueTest
extends EmbeddedBrokerTestSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(MirroredQueueTest.class);
    private Connection connection;

    public void testSendingToQueueIsMirrored() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList = new ConsumerBean();
        messageList.setVerbose(true);
        Destination consumeDestination = this.createConsumeDestination();
        Session session = this.connection.createSession(false, 1);
        LOG.info("Consuming from: " + consumeDestination);
        MessageConsumer c1 = session.createConsumer(consumeDestination);
        c1.setMessageListener((MessageListener)messageList);
        ActiveMQQueue sendDestination = new ActiveMQQueue(this.getQueueName());
        LOG.info("Sending to: " + sendDestination);
        MessageProducer producer = session.createProducer((Destination)sendDestination);
        MirroredQueueTest.assertNotNull((Object)producer);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            producer.send((Message)session.createTextMessage("message: " + i));
        }
        messageList.assertMessagesArrived(total);
        LOG.info("Received: " + messageList);
    }

    public void testTempMirroredQueuesClearDown() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue tempQueue = session.createTemporaryQueue();
        RegionBroker rb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        MirroredQueueTest.assertTrue((rb.getDestinationMap().size() == 5 ? 1 : 0) != 0);
        tempQueue.delete();
        MirroredQueueTest.assertTrue((rb.getDestinationMap().size() == 4 ? 1 : 0) != 0);
    }

    protected Destination createConsumeDestination() {
        return new ActiveMQTopic("VirtualTopic.Mirror." + this.getQueueName());
    }

    protected String getQueueName() {
        return "My.Queue";
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseMirroredQueues(true);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

