/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2580Test
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2580Test.class);
    private static final String TOPIC_NAME = "topicName";
    private static final String CLIENT_ID = "client_id";
    private static final String textOfSelectedMsg = "good_message";
    protected TopicConnection connection;
    private Topic topic;
    private Session session;
    private MessageProducer producer;
    private ConnectionFactory connectionFactory;
    private BrokerService service;

    public static Test suite() {
        return AMQ2580Test.suite(AMQ2580Test.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.initDurableBroker();
        this.initConnectionFactory();
        this.initTopic();
    }

    protected void tearDown() throws Exception {
        this.shutdownClient();
        this.service.stop();
        super.tearDown();
    }

    private void initConnection() throws JMSException {
        if (this.connection == null) {
            LOG.info("Initializing connection");
            this.connection = (TopicConnection)this.connectionFactory.createConnection();
            this.connection.start();
        }
    }

    public void initCombosForTestTopicIsDurableSmokeTest() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", (Object[])TestSupport.PersistenceAdapterChoice.values());
    }

    public void testTopicIsDurableSmokeTest() throws Exception {
        this.initClient();
        MessageConsumer consumer = this.createMessageConsumer();
        LOG.info("Consuming message");
        AMQ2580Test.assertNull((Object)consumer.receive(1L));
        this.shutdownClient();
        consumer.close();
        this.sendMessages();
        this.shutdownClient();
        this.initClient();
        consumer = this.createMessageConsumer();
        LOG.info("Consuming message");
        TextMessage answer1 = (TextMessage)consumer.receive(1000L);
        AMQ2580Test.assertNotNull((String)"we got our message", (Object)answer1);
        consumer.close();
    }

    private MessageConsumer createMessageConsumer() throws JMSException {
        LOG.info("creating durable subscriber");
        return this.session.createDurableSubscriber(this.topic, TOPIC_NAME, "name='value'", false);
    }

    private void initClient() throws JMSException {
        LOG.info("Initializing client");
        this.initConnection();
        this.initSession();
    }

    private void shutdownClient() throws JMSException {
        LOG.info("Closing session and connection");
        this.session.close();
        this.connection.close();
        this.session = null;
        this.connection = null;
    }

    private void sendMessages() throws JMSException {
        this.initConnection();
        this.initSession();
        LOG.info("Creating producer");
        this.producer = this.session.createProducer((Destination)this.topic);
        this.sendMessageThatFailsSelection();
        this.sendMessage(textOfSelectedMsg, "value");
    }

    private void initSession() throws JMSException {
        LOG.info("Initializing session");
        this.session = this.connection.createTopicSession(false, 1);
    }

    private void sendMessageThatFailsSelection() throws JMSException {
        for (int i = 0; i < 5; ++i) {
            String textOfNotSelectedMsg = "Msg_" + i;
            this.sendMessage(textOfNotSelectedMsg, "not_value");
            LOG.info("#");
        }
    }

    private void sendMessage(String msgText, String propertyValue) throws JMSException {
        LOG.info("Creating message: " + msgText);
        TextMessage messageToSelect = this.session.createTextMessage(msgText);
        messageToSelect.setStringProperty("name", propertyValue);
        LOG.info("Sending message");
        this.producer.send((Message)messageToSelect);
    }

    protected void initConnectionFactory() throws Exception {
        ActiveMQConnectionFactory activeMqConnectionFactory = this.createActiveMqConnectionFactory();
        this.connectionFactory = activeMqConnectionFactory;
    }

    private ActiveMQConnectionFactory createActiveMqConnectionFactory() throws Exception {
        ActiveMQConnectionFactory activeMqConnectionFactory = new ActiveMQConnectionFactory("failover:" + ((TransportConnector)this.service.getTransportConnectors().get(0)).getConnectUri().toString());
        activeMqConnectionFactory.setWatchTopicAdvisories(false);
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setDurableTopicPrefetch(2);
        prefetchPolicy.setOptimizeDurableTopicPrefetch(2);
        activeMqConnectionFactory.setPrefetchPolicy(prefetchPolicy);
        activeMqConnectionFactory.setClientID(CLIENT_ID);
        return activeMqConnectionFactory;
    }

    private void initDurableBroker() throws Exception {
        this.service = new BrokerService();
        this.setDefaultPersistenceAdapter(this.service);
        this.service.setDeleteAllMessagesOnStartup(true);
        this.service.setAdvisorySupport(false);
        this.service.setTransportConnectorURIs(new String[]{"tcp://localhost:0"});
        this.service.setPersistent(true);
        this.service.setUseJmx(false);
        this.service.start();
    }

    private void initTopic() throws JMSException {
        this.initConnection();
        TopicSession topicSession = this.connection.createTopicSession(false, 1);
        this.topic = topicSession.createTopic(TOPIC_NAME);
    }
}

