/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3454Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ3454Test.class);
    private static final int MESSAGES_COUNT = 10000;

    public void testSendWithLotsOfDestinations() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(false);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.addConnector("tcp://localhost:0");
        ActiveMQDestination[] destinations = new ActiveMQDestination[10000];
        for (int idx = 0; idx < 10000; ++idx) {
            destinations[idx] = new ActiveMQQueue(this.getDestinationName() + "-" + idx);
        }
        broker.setDestinations(destinations);
        broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(((TransportConnector)broker.getTransportConnectors().get(0)).getPublishableConnectString());
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(this.getDestinationName()));
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 10000; ++idx) {
            TextMessage message = session.createTextMessage("" + idx);
            producer.send((Message)message);
        }
        LOG.info("Duration: " + (System.currentTimeMillis() - start) + " millis");
        producer.close();
        session.close();
    }

    protected String getDestinationName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }
}

