/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.plist.PListStoreImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempStorageConfigBrokerTest {
    public int deliveryMode = 2;
    private static final Logger LOG = LoggerFactory.getLogger(TempStorageConfigBrokerTest.class);
    private static byte[] buf = new byte[4096];
    private BrokerService broker;
    private AtomicInteger messagesSent = new AtomicInteger(0);
    private AtomicInteger messagesConsumed = new AtomicInteger(0);
    private String brokerUri;
    private long messageReceiveTimeout = 10000L;
    private Destination destination = new ActiveMQTopic("FooTwo");

    @Test(timeout=360000L)
    @Ignore(value="blocks in hudson, needs investigation")
    public void testFillTempAndConsumeWithBadTempStoreConfig() throws Exception {
        this.createBrokerWithInvalidTempStoreConfig();
        this.broker.getSystemUsage().setSendFailIfNoSpace(true);
        this.destination = new ActiveMQQueue("Foo");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerUri);
        ActiveMQConnection producerConnection = (ActiveMQConnection)factory.createConnection();
        producerConnection.setAlwaysSyncSend(true);
        producerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer(this.destination);
        producer.setDeliveryMode(1);
        try {
            while (true) {
                TextMessage message = session.createTextMessage(new String(buf) + this.messagesSent.toString());
                producer.send((Message)message);
                this.messagesSent.incrementAndGet();
                if (this.messagesSent.get() % 100 != 0) continue;
                LOG.info("Sent Message " + this.messagesSent.get());
                LOG.info("Temp Store Usage " + this.broker.getSystemUsage().getTempUsage().getUsage());
            }
        }
        catch (ResourceAllocationException ex) {
            Assert.assertTrue((String)"Should not be able to send 100 messages: ", (this.messagesSent.get() < 100 ? 1 : 0) != 0);
            LOG.info("Got resource exception : " + ex + ", after sent: " + this.messagesSent.get());
            return;
        }
    }

    @Test(timeout=360000L)
    @Ignore(value="blocks in hudson, needs investigation")
    public void testFillTempAndConsumeWithGoodTempStoreConfig() throws Exception {
        this.createBrokerWithValidTempStoreConfig();
        this.broker.getSystemUsage().setSendFailIfNoSpace(true);
        this.destination = new ActiveMQQueue("Foo");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerUri);
        ActiveMQConnection producerConnection = (ActiveMQConnection)factory.createConnection();
        producerConnection.setAlwaysSyncSend(true);
        producerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer(this.destination);
        producer.setDeliveryMode(1);
        try {
            while (true) {
                TextMessage message = session.createTextMessage(new String(buf) + this.messagesSent.toString());
                producer.send((Message)message);
                this.messagesSent.incrementAndGet();
                if (this.messagesSent.get() % 100 != 0) continue;
                LOG.info("Sent Message " + this.messagesSent.get());
                LOG.info("Temp Store Usage " + this.broker.getSystemUsage().getTempUsage().getUsage());
            }
        }
        catch (ResourceAllocationException ex) {
            Assert.assertTrue((String)("Should be able to send at least 200 messages but was: " + this.messagesSent.get()), (this.messagesSent.get() > 200 ? 1 : 0) != 0);
            LOG.info("Got resource exception : " + ex + ", after sent: " + this.messagesSent.get());
            Connection consumerConnection = factory.createConnection();
            consumerConnection.start();
            Session consumerSession = consumerConnection.createSession(false, 1);
            MessageConsumer consumer = consumerSession.createConsumer(this.destination);
            while (consumer.receive(this.messageReceiveTimeout) != null) {
                this.messagesConsumed.incrementAndGet();
                if (this.messagesConsumed.get() % 1000 != 0) continue;
                LOG.info("received Message " + this.messagesConsumed.get());
                LOG.info("Temp Store Usage " + this.broker.getSystemUsage().getTempUsage().getUsage());
            }
            Assert.assertEquals((String)("Incorrect number of Messages Consumed: " + this.messagesConsumed.get()), (long)this.messagesConsumed.get(), (long)this.messagesSent.get());
            return;
        }
    }

    private void createBrokerWithValidTempStoreConfig() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistenceAdapter((PersistenceAdapter)new KahaDBPersistenceAdapter());
        this.broker.getSystemUsage().setSendFailIfNoSpace(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x100000L);
        this.broker.getSystemUsage().getTempUsage().setLimit(0x200000L);
        ((PListStoreImpl)this.broker.getSystemUsage().getTempUsage().getStore()).setJournalMaxFileLength(0x200000);
        this.broker.getSystemUsage().getStoreUsage().setLimit(0x1400000L);
        PolicyEntry defaultPolicy = new PolicyEntry();
        defaultPolicy.setProducerFlowControl(false);
        defaultPolicy.setMemoryLimit(10240L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(defaultPolicy);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.addConnector("tcp://localhost:0").setName("Default");
        this.broker.start();
        this.brokerUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    private void createBrokerWithInvalidTempStoreConfig() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistenceAdapter((PersistenceAdapter)new KahaDBPersistenceAdapter());
        this.broker.getSystemUsage().setSendFailIfNoSpace(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x100000L);
        this.broker.getSystemUsage().getTempUsage().setLimit(0x200000L);
        this.broker.getSystemUsage().getStoreUsage().setLimit(0x200000L);
        PolicyEntry defaultPolicy = new PolicyEntry();
        defaultPolicy.setProducerFlowControl(false);
        defaultPolicy.setMemoryLimit(10240L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(defaultPolicy);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.addConnector("tcp://localhost:0").setName("Default");
        this.broker.start();
        this.brokerUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }
}

