/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberOfDestinationsTest
extends TestCase {
    protected static final int MESSAGE_COUNT = 1;
    protected static final int NUMBER_OF_DESTINATIONS = 100000;
    private static final Logger LOG = LoggerFactory.getLogger(NumberOfDestinationsTest.class);
    protected BrokerService broker;
    protected String bindAddress = "vm://localhost";
    protected int destinationCount;

    public void testDestinations() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer mp = session.createProducer(null);
        for (int j = 0; j < 100000; ++j) {
            Destination dest = this.getDestination(session);
            for (int i = 0; i < 1; ++i) {
                TextMessage msg = session.createTextMessage("test" + i);
                mp.send(dest, (Message)msg);
            }
            if (j % 500 != 0) continue;
            LOG.info("Iterator " + j);
        }
        connection.close();
    }

    protected Destination getDestination(Session session) throws JMSException {
        String topicName = ((Object)((Object)this)).getClass().getName() + "." + this.destinationCount++;
        return session.createTopic(topicName);
    }

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.bindAddress);
        return cf;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        File dataFileDir = new File("target/test-amq-data/perfTest/kahadb");
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        kaha.setDirectory(dataFileDir);
        answer.setPersistenceAdapter((PersistenceAdapter)kaha);
        answer.setAdvisorySupport(false);
        answer.setEnableStatistics(false);
        answer.addConnector(this.bindAddress);
        answer.setDeleteAllMessagesOnStartup(true);
    }
}

