/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import jakarta.jms.QueueConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"org/apache/activemq/security/activemq.ldif"})
public class LDAPAuthenticationTest
extends AbstractLdapTestUnit {
    public BrokerService broker;
    public static LdapServer ldapServer;

    @Before
    public void setup() throws Exception {
        System.setProperty("ldapPort", String.valueOf(LDAPAuthenticationTest.getLdapServer().getPort()));
        this.broker = BrokerFactory.createBroker((String)"xbean:org/apache/activemq/security/activemq-ldap-auth.xml");
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void shutdown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testWildcard() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        QueueConnection conn = factory.createQueueConnection("*", "sunflower");
        try {
            conn.createSession(false, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Assert.fail((String)"Should have failed connecting");
    }
}

