/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.TransactionId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverConsumerOutstandingCommitTest {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverConsumerOutstandingCommitTest.class);
    private static final String QUEUE_NAME = "FailoverWithOutstandingCommit";
    private static final String MESSAGE_TEXT = "Test message ";
    private static final String TRANSPORT_URI = "tcp://localhost:0";
    private String url;
    final int prefetch = 10;
    BrokerService broker;

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void startBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup);
        this.broker.start();
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        return this.createBroker(deleteAllMessagesOnStartup, TRANSPORT_URI);
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup, String bindAddress) throws Exception {
        this.broker = new BrokerService();
        this.broker.addConnector(bindAddress);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setOptimizedDispatch(true);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.url = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString();
        return this.broker;
    }

    @Test
    public void testFailoverConsumerDups() throws Exception {
        this.doTestFailoverConsumerDups(true);
    }

    public void doTestFailoverConsumerDups(boolean watchTopicAdvisories) throws Exception {
        this.broker = this.createBroker(true);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
                context.setDontSendReponse(true);
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        LOG.info("Stopping broker before commit...");
                        try {
                            FailoverConsumerOutstandingCommitTest.this.broker.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(watchTopicAdvisories);
        cf.setDispatchAsync(false);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session producerSession = connection.createSession(false, 1);
        final Queue destination = producerSession.createQueue("FailoverWithOutstandingCommit?consumer.prefetchSize=10");
        final Session consumerSession = connection.createSession(true, 1);
        final CountDownLatch commitDoneLatch = new CountDownLatch(1);
        final CountDownLatch messagesReceived = new CountDownLatch(2);
        MessageConsumer testConsumer = consumerSession.createConsumer((Destination)destination);
        testConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.info("consume one and commit");
                Assert.assertNotNull((String)"got message", (Object)message);
                try {
                    consumerSession.commit();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                commitDoneLatch.countDown();
                messagesReceived.countDown();
                LOG.info("done commit");
            }
        });
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                LOG.info("producer started");
                try {
                    FailoverConsumerOutstandingCommitTest.this.produceMessage(producerSession, destination, 20L);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    Assert.fail((String)("unexpceted ex on producer: " + e));
                }
                LOG.info("producer done");
            }
        });
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false, this.url);
        this.broker.start();
        Assert.assertTrue((String)"consumer added through failover", (boolean)commitDoneLatch.await(20L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"another message was recieved after failover", (boolean)messagesReceived.await(20L, TimeUnit.SECONDS));
        connection.close();
    }

    @Test
    public void TestFailoverConsumerOutstandingSendTxIncomplete() throws Exception {
        this.doTestFailoverConsumerOutstandingSendTx(false);
    }

    @Test
    public void TestFailoverConsumerOutstandingSendTxComplete() throws Exception {
        this.doTestFailoverConsumerOutstandingSendTx(true);
    }

    public void doTestFailoverConsumerOutstandingSendTx(final boolean doActualBrokerCommit) throws Exception {
        boolean watchTopicAdvisories = true;
        this.broker = this.createBroker(true);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
                if (doActualBrokerCommit) {
                    LOG.info("doing actual broker commit...");
                    super.commitTransaction(context, xid, onePhase);
                }
                context.setDontSendReponse(true);
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        LOG.info("Stopping broker before commit...");
                        try {
                            FailoverConsumerOutstandingCommitTest.this.broker.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(true);
        cf.setDispatchAsync(false);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session producerSession = connection.createSession(false, 1);
        final Queue destination = producerSession.createQueue("FailoverWithOutstandingCommit?consumer.prefetchSize=10");
        final Queue signalDestination = producerSession.createQueue("FailoverWithOutstandingCommit.signal?consumer.prefetchSize=10");
        final Session consumerSession = connection.createSession(true, 0);
        final CountDownLatch commitDoneLatch = new CountDownLatch(1);
        final CountDownLatch messagesReceived = new CountDownLatch(3);
        final AtomicBoolean gotCommitException = new AtomicBoolean(false);
        final ArrayList receivedMessages = new ArrayList();
        MessageConsumer testConsumer = consumerSession.createConsumer((Destination)destination);
        testConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.info("consume one and commit: " + message);
                Assert.assertNotNull((String)"got message", (Object)message);
                receivedMessages.add((TextMessage)message);
                try {
                    FailoverConsumerOutstandingCommitTest.this.produceMessage(consumerSession, signalDestination, 1L);
                    consumerSession.commit();
                }
                catch (JMSException e) {
                    LOG.info("commit exception", (Throwable)e);
                    gotCommitException.set(true);
                }
                commitDoneLatch.countDown();
                messagesReceived.countDown();
                LOG.info("done commit");
            }
        });
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                LOG.info("producer started");
                try {
                    FailoverConsumerOutstandingCommitTest.this.produceMessage(producerSession, destination, 20L);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    Assert.fail((String)("unexpceted ex on producer: " + e));
                }
                LOG.info("producer done");
            }
        });
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false, this.url);
        this.broker.start();
        Assert.assertTrue((String)"commit done through failover", (boolean)commitDoneLatch.await(20L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"commit failed", (boolean)gotCommitException.get());
        Assert.assertTrue((String)"another message was received after failover", (boolean)messagesReceived.await(20L, TimeUnit.SECONDS));
        int receivedIndex = 0;
        Assert.assertEquals((String)"get message 0 first", (Object)"Test message 0", (Object)((TextMessage)receivedMessages.get(receivedIndex++)).getText());
        if (!doActualBrokerCommit) {
            Assert.assertEquals((String)"get message 0 second", (Object)"Test message 0", (Object)((TextMessage)receivedMessages.get(receivedIndex++)).getText());
        }
        Assert.assertTrue((String)"another message was received", (boolean)messagesReceived.await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"get message 1 eventually", (Object)"Test message 1", (Object)((TextMessage)receivedMessages.get(receivedIndex++)).getText());
        connection.close();
    }

    @Test
    public void testRollbackFailoverConsumerTx() throws Exception {
        this.broker = this.createBroker(true);
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setConsumerFailoverRedeliveryWaitPeriod(10000L);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        Session producerSession = connection.createSession(false, 1);
        Queue destination = producerSession.createQueue(QUEUE_NAME);
        Session consumerSession = connection.createSession(true, 0);
        MessageConsumer testConsumer = consumerSession.createConsumer((Destination)destination);
        Assert.assertNull((String)"no message yet", (Object)testConsumer.receiveNoWait());
        this.produceMessage(producerSession, destination, 1L);
        producerSession.close();
        Message msg = testConsumer.receive(5000L);
        Assert.assertNotNull((Object)msg);
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false, this.url);
        this.broker.start();
        consumerSession.rollback();
        msg = testConsumer.receive(10000L);
        Assert.assertNotNull((String)"got message again after rollback", (Object)msg);
        consumerSession.commit();
        consumerSession.close();
        msg = this.receiveMessage(cf, destination);
        Assert.assertNull((String)"should be nothing left after commit", (Object)msg);
        connection.close();
    }

    private Message receiveMessage(ActiveMQConnectionFactory cf, Queue destination) throws Exception {
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        Session consumerSession = connection.createSession(true, 0);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)destination);
        Message msg = consumer.receive(5000L);
        consumerSession.commit();
        connection.close();
        return msg;
    }

    private void produceMessage(Session producerSession, Queue destination, long count) throws JMSException {
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        int i = 0;
        while ((long)i < count) {
            TextMessage message = producerSession.createTextMessage(MESSAGE_TEXT + i);
            producer.send((Message)message);
            ++i;
        }
        producer.close();
    }
}

