/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.transport.failover.FailoverTransactionTest;

public class FailoverRedeliveryTransactionTest
extends FailoverTransactionTest {
    public static Test suite() {
        return FailoverRedeliveryTransactionTest.suite(FailoverRedeliveryTransactionTest.class);
    }

    @Override
    public void configureConnectionFactory(ActiveMQConnectionFactory factory) {
        super.configureConnectionFactory(factory);
        factory.setTransactedIndividualAck(true);
    }

    @Override
    public BrokerService createBroker(boolean deleteAllMessagesOnStartup, String bindAddress) throws Exception {
        BrokerService brokerService = super.createBroker(deleteAllMessagesOnStartup, bindAddress);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setPersistJMSRedelivered(true);
        policyMap.setDefaultEntry(defaultEntry);
        brokerService.setDestinationPolicy(policyMap);
        return brokerService;
    }

    @Override
    public void testFailoverProducerCloseBeforeTransaction() throws Exception {
    }

    @Override
    public void initCombosForTestFailoverCommitReplyLost() {
    }

    @Override
    public void testFailoverCommitReplyLost() throws Exception {
    }

    @Override
    public void testFailoverCommitReplyLostWithDestinationPathSeparator() throws Exception {
    }

    @Override
    public void initCombosForTestFailoverSendReplyLost() {
    }

    @Override
    public void testFailoverSendReplyLost() throws Exception {
    }

    @Override
    public void initCombosForTestFailoverConnectionSendReplyLost() {
    }

    @Override
    public void testFailoverConnectionSendReplyLost() throws Exception {
    }

    @Override
    public void testFailoverProducerCloseBeforeTransactionFailWhenDisabled() throws Exception {
    }

    @Override
    public void testFailoverMultipleProducerCloseBeforeTransaction() throws Exception {
    }
}

