/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationView;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.apache.activemq.broker.jmx.QueueView;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOAsyncSendWithPFCTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(NIOAsyncSendWithPFCTest.class);
    private static String TRANSPORT_URL = "nio://0.0.0.0:0";
    private static final String DESTINATION_ONE = "testQ1";
    private static final String DESTINATION_TWO = "testQ2";
    private static final int MESSAGES_TO_SEND = 100;
    private static int NUMBER_OF_PRODUCERS = 10;

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setMemoryLimit(256000L);
        pe.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        pe.setQueue(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        broker.setDestinationPolicy(policyMap);
        broker.addConnector(TRANSPORT_URL);
        broker.setDestinations(new ActiveMQDestination[]{new ActiveMQQueue(DESTINATION_ONE)});
        broker.start();
        TRANSPORT_URL = broker.getTransportConnectorByScheme("nio").getPublishableConnectString();
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncSendPFCNewConnection() throws Exception {
        BrokerService broker = this.createBroker();
        broker.waitUntilStarted();
        ExecutorService executorService = Executors.newFixedThreadPool(NUMBER_OF_PRODUCERS);
        QueueView queueView = this.getQueueView(broker, DESTINATION_ONE);
        try {
            for (int i = 0; i < NUMBER_OF_PRODUCERS; ++i) {
                executorService.submit(new ProducerTask());
            }
            this.waitForProducerFlowControl(broker, queueView);
            try {
                this.sendMessages(1, DESTINATION_TWO, false);
            }
            catch (Exception ex) {
                LOG.error("Ex on send  new connection", (Throwable)ex);
                NIOAsyncSendWithPFCTest.fail((String)("*** received the following exception when creating addition producer new connection:" + ex));
            }
        }
        finally {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncSendPFCExistingConnection() throws Exception {
        BrokerService broker = this.createBroker();
        broker.waitUntilStarted();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", TRANSPORT_URL + "?wireFormat.maxInactivityDuration=5000");
        ActiveMQConnection exisitngConnection = (ActiveMQConnection)connectionFactory.createConnection();
        ExecutorService executorService = Executors.newFixedThreadPool(NUMBER_OF_PRODUCERS);
        QueueView queueView = this.getQueueView(broker, DESTINATION_ONE);
        try {
            for (int i = 0; i < NUMBER_OF_PRODUCERS; ++i) {
                executorService.submit(new ProducerTask());
            }
            this.waitForProducerFlowControl(broker, queueView);
            NIOAsyncSendWithPFCTest.assertTrue((String)"Producer view blocked", (boolean)this.getProducerView(broker, DESTINATION_ONE).isProducerBlocked());
            try {
                Session i = exisitngConnection.createSession(false, 1);
            }
            catch (Exception ex) {
                LOG.error("Ex on create session", (Throwable)ex);
                NIOAsyncSendWithPFCTest.fail((String)("*** received the following exception when creating producer session:" + ex));
            }
        }
        finally {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncSendPFCExistingConnection() throws Exception {
        BrokerService broker = this.createBroker();
        broker.waitUntilStarted();
        ExecutorService executorService = Executors.newFixedThreadPool(NUMBER_OF_PRODUCERS);
        QueueView queueView = this.getQueueView(broker, DESTINATION_ONE);
        try {
            for (int i = 0; i < NUMBER_OF_PRODUCERS; ++i) {
                executorService.submit(new ProducerTask(true));
            }
            this.waitForProducerFlowControl(broker, queueView);
            NIOAsyncSendWithPFCTest.assertTrue((String)"Producer view blocked", (boolean)this.getProducerView(broker, DESTINATION_ONE).isProducerBlocked());
        }
        finally {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    private void waitForProducerFlowControl(BrokerService broker, QueueView queueView) throws Exception {
        boolean blockingAllSends;
        do {
            blockingAllSends = queueView.getBlockedSends() >= 10L;
            LOG.info("Blocking all sends:" + queueView.getBlockedSends());
            Thread.sleep(1000L);
        } while (!blockingAllSends);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long sendMessages(int messageCount, String destination, boolean sync) throws Exception {
        long numberOfMessageSent = 0L;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", TRANSPORT_URL);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        if (sync) {
            connection.setUseAsyncSend(false);
            connection.setAlwaysSyncSend(true);
        } else {
            connection.setUseAsyncSend(true);
        }
        connection.start();
        try {
            Session producerSession = connection.createSession(false, 1);
            MessageProducer jmsProducer = producerSession.createProducer((Destination)producerSession.createQueue(destination));
            TextMessage sendMessage = this.createTextMessage(producerSession);
            for (int i = 0; i < messageCount; ++i) {
                jmsProducer.send((Message)sendMessage);
                ++numberOfMessageSent;
            }
            LOG.info(" Finished after producing : " + numberOfMessageSent);
            Long l = numberOfMessageSent;
            return l;
        }
        catch (JMSException expected) {
            LOG.debug("Exception received producing ", (Throwable)expected);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
        return numberOfMessageSent;
    }

    private TextMessage createTextMessage(Session session) throws JMSException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            buffer.append("1234567890");
        }
        return session.createTextMessage(buffer.toString());
    }

    private QueueView getQueueView(BrokerService broker, String queueName) throws Exception {
        Map queueViews = broker.getAdminView().getBroker().getQueueViews();
        for (ObjectName key : queueViews.keySet()) {
            QueueView queueView;
            DestinationView destinationView = (DestinationView)queueViews.get(key);
            if (!(destinationView instanceof QueueView) || !(queueView = (QueueView)destinationView).getName().equals(queueName)) continue;
            return queueView;
        }
        return null;
    }

    private ProducerViewMBean getProducerView(BrokerService broker, String qName) throws Exception {
        ObjectName[] qProducers;
        for (ObjectName name : qProducers = broker.getAdminView().getQueueProducers()) {
            ProducerViewMBean proxy = (ProducerViewMBean)broker.getManagementContext().newProxyInstance(name, ProducerViewMBean.class, true);
            LOG.info(proxy.getProducerId() + ", dest: " + proxy.getDestinationName() + ", blocked: " + proxy.isProducerBlocked());
            if (!proxy.getDestinationName().contains(qName)) continue;
            return proxy;
        }
        return null;
    }

    class ProducerTask
    implements Runnable {
        boolean sync = false;

        ProducerTask() {
            this(false);
        }

        ProducerTask(boolean sync) {
            this.sync = sync;
        }

        @Override
        public void run() {
            try {
                NIOAsyncSendWithPFCTest.this.sendMessages(100, NIOAsyncSendWithPFCTest.DESTINATION_ONE, this.sync);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

