/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.io.File;
import org.apache.activemq.ConfigurationException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.usage.StoreUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.TempUsage;
import org.apache.activemq.util.StoreUtil;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PercentDiskUsageLimitTest {
    protected static final Logger LOG = LoggerFactory.getLogger(PercentDiskUsageLimitTest.class);
    @Rule
    public TemporaryFolder dataFileDir = new TemporaryFolder(new File("target"));
    private BrokerService broker;
    private PersistenceAdapter adapter;
    private TempUsage tempUsage;
    private StoreUsage storeUsage;
    private File storeDir;

    @Before
    public void setUpBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(true);
        this.broker.setDataDirectoryFile(this.dataFileDir.getRoot());
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.adapter = this.broker.getPersistenceAdapter();
        FileUtils.forceMkdir((File)this.adapter.getDirectory());
        FileUtils.forceMkdir((File)this.broker.getTempDataStore().getDirectory());
        this.storeDir = StoreUtil.findParentDirectory((File)this.adapter.getDirectory());
        SystemUsage systemUsage = this.broker.getSystemUsage();
        this.tempUsage = systemUsage.getTempUsage();
        this.storeUsage = systemUsage.getStoreUsage();
    }

    protected void startBroker() throws Exception {
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test(timeout=30000L)
    public void testDiskLimit() throws Exception {
        int freePercent = this.getFreePercentage();
        if (freePercent >= 2) {
            int maxUsage = freePercent / 2;
            this.storeUsage.setPercentLimit(maxUsage);
            this.tempUsage.setPercentLimit(maxUsage);
            this.startBroker();
            long diskLimit = this.broker.getSystemUsage().getStoreUsage().getLimit();
            Assert.assertEquals((float)diskLimit, (float)(this.storeDir.getTotalSpace() * (long)maxUsage / 100L), (float)1000000.0f);
        }
    }

    @Test(timeout=30000L)
    public void testDiskLimitOverMaxFree() throws Exception {
        int freePercent = this.getFreePercentage();
        if (freePercent > 1) {
            this.storeUsage.setPercentLimit(freePercent + 1);
            this.startBroker();
            long diskLimit = this.broker.getSystemUsage().getStoreUsage().getLimit();
            Assert.assertEquals((float)diskLimit, (float)this.storeDir.getUsableSpace(), (float)1000000.0f);
        }
    }

    @Test(timeout=30000L)
    public void testStartFailDiskLimitOverMaxFree() throws Exception {
        this.broker.setAdjustUsageLimits(false);
        int freePercent = this.getFreePercentage();
        if (freePercent > 1) {
            this.storeUsage.setPercentLimit(freePercent + 1);
            try {
                this.startBroker();
                Assert.fail((String)"Expect ex");
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
    }

    @Test(timeout=30000L)
    public void testDiskLimitOver100Percent() throws Exception {
        int freePercent = this.getFreePercentage();
        if (freePercent > 1) {
            this.storeUsage.setPercentLimit(110);
            this.startBroker();
            long diskLimit = this.broker.getSystemUsage().getStoreUsage().getLimit();
            Assert.assertEquals((float)diskLimit, (float)this.storeDir.getUsableSpace(), (float)1000000.0f);
        }
    }

    protected int getFreePercentage() {
        File storeDir = StoreUtil.findParentDirectory((File)this.adapter.getDirectory());
        return (int)((double)storeDir.getUsableSpace() / (double)storeDir.getTotalSpace() * 100.0);
    }
}

