/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableRedeliveryTest {
    static final Logger LOG = LoggerFactory.getLogger(DurableRedeliveryTest.class);
    BrokerService broker = null;
    String topicName = "testTopic";

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.configureBroker(this.broker);
        this.broker.start();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    protected void configureBroker(BrokerService broker) throws Exception {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policyMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(policyMap);
        broker.setPersistent(false);
        broker.addConnector("tcp://0.0.0.0:0");
    }

    @Test
    public void testRedeliveryFlagAfterConnectionKill() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        ActiveMQConnection producerConnection = (ActiveMQConnection)connectionFactory.createConnection();
        ActiveMQConnection durableConnection = (ActiveMQConnection)connectionFactory.createConnection();
        durableConnection.setClientID("clientId");
        producerConnection.start();
        durableConnection.start();
        Session session = durableConnection.createSession(false, 1);
        Topic topic = session.createTopic(this.topicName);
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        this.populateDestination(1, (Destination)topic, (Connection)producerConnection);
        producerConnection.close();
        Wait.waitFor(() -> this.broker.getBroker().getClients().length == 1);
        TransportConnector connector = (TransportConnector)this.broker.getTransportConnectors().get(0);
        TransportConnection connection = (TransportConnection)connector.getConnections().stream().findFirst().get();
        connection.stop();
        Wait.waitFor(() -> this.broker.getBroker().getClients().length == 0);
        durableConnection = (ActiveMQConnection)connectionFactory.createConnection();
        durableConnection.setClientID("clientId");
        durableConnection.start();
        session = durableConnection.createSession(false, 1);
        topic = session.createTopic(this.topicName);
        consumer = session.createDurableSubscriber(topic, "sub1");
        Message msg = consumer.receive(2000L);
        LOG.info("got: " + msg);
        Assert.assertNotNull((String)"got the message", (Object)msg);
        Assert.assertTrue((String)"got the message has redelivered flag", (boolean)msg.getJMSRedelivered());
        producerConnection.close();
        durableConnection.close();
    }

    private void populateDestination(int nbMessages, Destination destination, Connection connection) throws JMSException {
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(destination);
        for (int i = 1; i <= nbMessages; ++i) {
            producer.send((Message)session.createTextMessage("test: " + i));
        }
        producer.close();
        session.close();
    }
}

