/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Queue;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeQueueSparseDeleteTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(LargeQueueSparseDeleteTest.class);

    @Override
    protected void setUp() throws Exception {
        this.useTopic = false;
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveMessages() throws Exception {
        int QUEUE_SIZE = 30000;
        String MOVE_TO_DESTINATION_NAME = this.getDestinationString() + ".dest";
        long TEST_TIMEOUT = 20000L;
        try (Connection conn = this.createConnection();){
            conn.start();
            Session session = conn.createSession(true, 0);
            MessageProducer producer = session.createProducer((Destination)this.destination);
            for (int i = 0; i < 30000; ++i) {
                Message message = session.createMessage();
                message.setIntProperty("id", i);
                producer.send(message);
            }
            session.commit();
        }
        Queue queue = (Queue)this.broker.getRegionBroker().getDestinationMap().get(this.destination);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker.getBroker());
        context.getMessageEvaluationContext().setDestination(this.destination);
        long startTimeMillis = System.currentTimeMillis();
        Assert.assertEquals((long)1L, (long)queue.moveMatchingMessagesTo(context, "id=29999", this.createDestination(MOVE_TO_DESTINATION_NAME)));
        long durationMillis = System.currentTimeMillis() - startTimeMillis;
        LOG.info("It took " + durationMillis + "ms to move the last message from a queue a 30000 messages.");
        Assert.assertTrue((String)("Moving the message took too long: " + durationMillis + "ms"), (durationMillis < 20000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyMessages() throws Exception {
        int QUEUE_SIZE = 30000;
        String MOVE_TO_DESTINATION_NAME = this.getDestinationString() + ".dest";
        long TEST_TIMEOUT = 10000L;
        try (Connection conn = this.createConnection();){
            conn.start();
            Session session = conn.createSession(true, 0);
            MessageProducer producer = session.createProducer((Destination)this.destination);
            for (int i = 0; i < 30000; ++i) {
                Message message = session.createMessage();
                message.setIntProperty("id", i);
                producer.send(message);
            }
            session.commit();
        }
        Queue queue = (Queue)this.broker.getRegionBroker().getDestinationMap().get(this.destination);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker.getBroker());
        context.getMessageEvaluationContext().setDestination(this.destination);
        long startTimeMillis = System.currentTimeMillis();
        Assert.assertEquals((long)1L, (long)queue.copyMatchingMessagesTo(context, "id=29999", this.createDestination(MOVE_TO_DESTINATION_NAME)));
        long durationMillis = System.currentTimeMillis() - startTimeMillis;
        LOG.info("It took " + durationMillis + "ms to copy the last message from a queue a 30000 messages.");
        Assert.assertTrue((String)("Copying the message took too long: " + durationMillis + "ms"), (durationMillis < 10000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveMessages() throws Exception {
        int QUEUE_SIZE = 30000;
        long TEST_TIMEOUT = 20000L;
        try (Connection conn = this.createConnection();){
            conn.start();
            Session session = conn.createSession(true, 0);
            MessageProducer producer = session.createProducer((Destination)this.destination);
            for (int i = 0; i < 30000; ++i) {
                Message message = session.createMessage();
                message.setIntProperty("id", i);
                producer.send(message);
            }
            session.commit();
        }
        Queue queue = (Queue)this.broker.getRegionBroker().getDestinationMap().get(this.destination);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker.getBroker());
        context.getMessageEvaluationContext().setDestination(this.destination);
        long startTimeMillis = System.currentTimeMillis();
        Assert.assertEquals((long)1L, (long)queue.removeMatchingMessages("id=29999"));
        long durationMillis = System.currentTimeMillis() - startTimeMillis;
        LOG.info("It took " + durationMillis + "ms to remove the last message from a queue a 30000 messages.");
        Assert.assertTrue((String)("Removing the message took too long: " + durationMillis + "ms"), (durationMillis < 20000L ? 1 : 0) != 0);
    }
}

