/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.TextMessage;
import java.net.URI;
import java.util.List;
import junit.framework.Test;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.MessageIdList;

public class MulticastDiscoveryOnFaultyNetworkTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 200;
    private static final String HUB = "HubBroker";
    private static final String SPOKE = "SpokeBroker";
    public boolean useDuplexNetworkBridge = true;
    public boolean useStaticDiscovery = false;

    public void initCombosForTestSendOnAFaultyTransport() {
        this.addCombinationValues("useDuplexNetworkBridge", new Object[]{Boolean.TRUE, Boolean.FALSE});
        this.addCombinationValues("useStaticDiscovery", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testSendOnAFaultyTransport() throws Exception {
        this.bridgeBrokers(SPOKE, HUB);
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer client = this.createConsumer(HUB, (Destination)dest);
        this.sleep(600);
        this.sendMessages(SPOKE, (Destination)dest, 200);
        MessageIdList msgs = this.getConsumerMessages(HUB, client);
        msgs.setMaximumDuration(200000L);
        msgs.waitForMessagesToArrive(200);
        MulticastDiscoveryOnFaultyNetworkTest.assertTrue((String)("At least message 200 must be recieved, duplicates are expected, count=" + msgs.getMessageCount()), (200 <= msgs.getMessageCount() ? 1 : 0) != 0);
    }

    @Override
    protected void startAllBrokers() throws Exception {
        JmsMultipleBrokersTestSupport.BrokerItem brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get(HUB);
        brokerItem.broker.start();
        brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get(SPOKE);
        brokerItem.broker.start();
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        String options = "?persistent=false&useJmx=false&deleteAllMessagesOnStartup=true";
        this.createBroker(new URI("broker:(tcpfaulty://localhost:61617)/HubBroker?persistent=false&useJmx=false&deleteAllMessagesOnStartup=true"));
        this.createBroker(new URI("broker:(tcpfaulty://localhost:61616)/SpokeBroker?persistent=false&useJmx=false&deleteAllMessagesOnStartup=true"));
    }

    public static Test suite() {
        return MulticastDiscoveryOnFaultyNetworkTest.suite(MulticastDiscoveryOnFaultyNetworkTest.class);
    }

    @Override
    protected void onSend(int i, TextMessage msg) {
        this.sleep(50);
    }

    private void sleep(int milliSecondTime) {
        try {
            Thread.sleep(milliSecondTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected NetworkConnector bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker, boolean dynamicOnly, int networkTTL, boolean conduit, boolean failover) throws Exception {
        List transportConnectors;
        String networkDisoveryUrlString = this.useStaticDiscovery ? "static:(" + ((TransportConnector)remoteBroker.getTransportConnectors().get(0)).getPublishableConnectString() + ")?useExponentialBackOff=false" : "multicast://default?group=TESTERIC&useLocalHost=false";
        DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(networkDisoveryUrlString));
        connector.setDynamicOnly(dynamicOnly);
        connector.setNetworkTTL(networkTTL);
        connector.setDuplex(this.useDuplexNetworkBridge);
        maxSetupTime = 2000;
        if (!this.useStaticDiscovery && !(transportConnectors = remoteBroker.getTransportConnectors()).isEmpty()) {
            TransportConnector mCastTrpConnector = (TransportConnector)transportConnectors.get(0);
            mCastTrpConnector.setDiscoveryUri(new URI("multicast://default?group=TESTERIC"));
        }
        localBroker.addNetworkConnector((NetworkConnector)connector);
        return connector;
    }
}

