/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.spring.SpringSslContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAsyncStartSslTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkAsyncStartSslTest.class);
    private String brokerBDomain = "localhost:61617";
    private String brokerCDomain = "localhost:61618";
    int bridgeCount = 0;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";

    public void testSslPerConnectorConfig() throws Exception {
        String transport = "ssl";
        String brokerBUri = transport + "://" + this.brokerBDomain;
        String brokerCUri = transport + "://" + this.brokerCDomain;
        SpringSslContext brokerSslContext = new SpringSslContext();
        brokerSslContext.setKeyStore(SERVER_KEYSTORE);
        brokerSslContext.setKeyStorePassword(PASSWORD);
        brokerSslContext.setKeyStoreType(KEYSTORE_TYPE);
        brokerSslContext.setTrustStore(TRUST_KEYSTORE);
        brokerSslContext.setTrustStorePassword(PASSWORD);
        brokerSslContext.afterPropertiesSet();
        BrokerService brokerC = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerC")).broker;
        brokerC.setSslContext((SslContext)brokerSslContext);
        brokerC.addConnector(brokerCUri);
        brokerC.start();
        BrokerService brokerB = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker;
        brokerB.setSslContext((SslContext)brokerSslContext);
        brokerB.addConnector(brokerBUri);
        brokerB.start();
        BrokerService brokerA = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker;
        brokerA.setNetworkConnectorStartAsync(true);
        NetworkConnector networkConnector = this.bridgeBroker(brokerA, brokerBUri);
        networkConnector.setSslContext((SslContext)brokerSslContext);
        LOG.info("Added bridge to: " + brokerBUri);
        this.bridgeBroker(brokerA, brokerCUri);
        LOG.info("Added bridge to: " + brokerCUri);
        LOG.info("starting A..");
        brokerA.start();
        this.waitForBridgeFormation(brokerA, 1, 0);
        NetworkAsyncStartSslTest.assertTrue((String)"one worked", (boolean)this.hasBridge("BrokerA", "BrokerB"));
        NetworkAsyncStartSslTest.assertFalse((String)"one failed", (boolean)this.hasBridge("BrokerA", "BrokerC"));
    }

    private NetworkConnector bridgeBroker(BrokerService localBroker, String remoteURI) throws Exception {
        String uri = "static:(" + remoteURI + ")";
        DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(uri));
        connector.setName("bridge-" + this.bridgeCount++);
        localBroker.addNetworkConnector((NetworkConnector)connector);
        return connector;
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:()BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:()BrokerB?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:()BrokerC?persistent=false&useJmx=false"));
    }
}

