/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;

public class TwoBrokersStopSlaveTest
extends TestCase {
    private static final File KahaDbDirectory = new File("target/TwoBrokersStopSlaveTest");

    public void testStartMasterAndSlaveShutdownSlaveFirst() throws Exception {
        BrokerService masterBroker = this.createBroker("masterBroker", 9100);
        BrokerService slaveBroker = this.createBroker("slaveBroker", 9101);
        Thread.sleep(1000L);
        TwoBrokersStopSlaveTest.assertTrue((boolean)masterBroker.isPersistent());
        TwoBrokersStopSlaveTest.assertTrue((boolean)slaveBroker.isPersistent());
        TwoBrokersStopSlaveTest.assertFalse((boolean)masterBroker.isSlave());
        TwoBrokersStopSlaveTest.assertTrue((boolean)slaveBroker.isSlave());
        slaveBroker.stop();
        slaveBroker.waitUntilStopped();
        masterBroker.stop();
    }

    protected BrokerService createBroker(String brokerName, int port) throws Exception {
        String connectorUrl = "tcp://localhost:" + port;
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker://()/localhost"));
        broker.setBrokerName(brokerName);
        broker.addConnector(connectorUrl);
        broker.setUseShutdownHook(false);
        broker.setPersistent(true);
        KahaDBPersistenceAdapter adapter = new KahaDBPersistenceAdapter();
        adapter.setDirectory(KahaDbDirectory);
        broker.setPersistenceAdapter((PersistenceAdapter)adapter);
        broker.setStartAsync(true);
        broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(connectorUrl);
        factory.createConnection();
        if (!broker.isSlave()) {
            broker.waitUntilStarted();
        }
        return broker;
    }
}

