/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import junit.framework.TestCase;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.LastImageSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.RetainedMessageSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.broker.region.policy.StrictOrderDispatchPolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.TimedSubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeanConfigTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(XBeanConfigTest.class);
    protected BrokerService brokerService;
    protected Broker broker;
    protected ConnectionContext context;
    protected ConnectionInfo info;

    public void testBrokerConfiguredCorrectly() throws Exception {
        XBeanConfigTest.assertEquals((String)"testbroker", (String)this.brokerService.getBrokerName());
        Topic topic = (Topic)this.broker.addDestination(this.context, (ActiveMQDestination)new ActiveMQTopic("FOO.BAR"), true);
        DispatchPolicy dispatchPolicy = topic.getDispatchPolicy();
        XBeanConfigTest.assertTrue((String)("dispatchPolicy should be RoundRobinDispatchPolicy: " + dispatchPolicy), (boolean)(dispatchPolicy instanceof RoundRobinDispatchPolicy));
        SubscriptionRecoveryPolicy subscriptionRecoveryPolicy = topic.getSubscriptionRecoveryPolicy();
        subscriptionRecoveryPolicy = ((RetainedMessageSubscriptionRecoveryPolicy)subscriptionRecoveryPolicy).getWrapped();
        XBeanConfigTest.assertTrue((String)("subscriptionRecoveryPolicy should be LastImageSubscriptionRecoveryPolicy: " + subscriptionRecoveryPolicy), (boolean)(subscriptionRecoveryPolicy instanceof LastImageSubscriptionRecoveryPolicy));
        LOG.info("destination: " + topic);
        LOG.info("dispatchPolicy: " + dispatchPolicy);
        LOG.info("subscriptionRecoveryPolicy: " + subscriptionRecoveryPolicy);
        topic = (Topic)this.broker.addDestination(this.context, (ActiveMQDestination)new ActiveMQTopic("ORDERS.BOOKS"), true);
        dispatchPolicy = topic.getDispatchPolicy();
        XBeanConfigTest.assertTrue((String)("dispatchPolicy should be StrictOrderDispatchPolicy: " + dispatchPolicy), (boolean)(dispatchPolicy instanceof StrictOrderDispatchPolicy));
        subscriptionRecoveryPolicy = topic.getSubscriptionRecoveryPolicy();
        subscriptionRecoveryPolicy = ((RetainedMessageSubscriptionRecoveryPolicy)subscriptionRecoveryPolicy).getWrapped();
        XBeanConfigTest.assertTrue((String)("subscriptionRecoveryPolicy should be TimedSubscriptionRecoveryPolicy: " + subscriptionRecoveryPolicy), (boolean)(subscriptionRecoveryPolicy instanceof TimedSubscriptionRecoveryPolicy));
        TimedSubscriptionRecoveryPolicy timedSubscriptionPolicy = (TimedSubscriptionRecoveryPolicy)subscriptionRecoveryPolicy;
        XBeanConfigTest.assertEquals((String)"getRecoverDuration()", (long)60000L, (long)timedSubscriptionPolicy.getRecoverDuration());
        LOG.info("destination: " + topic);
        LOG.info("dispatchPolicy: " + dispatchPolicy);
        LOG.info("subscriptionRecoveryPolicy: " + subscriptionRecoveryPolicy);
    }

    protected void setUp() throws Exception {
        System.setProperty("brokername", "testbroker");
        this.brokerService = this.createBroker();
        this.broker = this.brokerService.getBroker();
        this.context = new ConnectionContext();
        this.context.setBroker(this.broker);
        this.info = new ConnectionInfo();
        this.info.setClientId("James");
        this.info.setUserName("James");
        this.info.setConnectionId(new ConnectionId("1234"));
        try {
            this.broker.addConnection(this.context, this.info);
        }
        catch (Throwable e) {
            e.printStackTrace();
            XBeanConfigTest.fail((String)e.getMessage());
        }
        XBeanConfigTest.assertNotNull((Object)"No broker created!");
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        String uri = "org/apache/activemq/xbean/activemq-policy.xml";
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

