/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConsumerThread;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;

@Command(name="browser", description="Browse messages on a queue.")
public class Browse
extends DestAbstract {
    @Option(name={"--filter"}, description="The message filter.")
    String filter;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        context.out.println("Consumer:: filter = " + this.filter);
        ConnectionFactory factory = this.createConnectionFactory();
        try (Connection connection = factory.createConnection();){
            ConsumerThread[] threadsArray = new ConsumerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                void var6_10;
                if (this.txBatchSize > 0) {
                    Session session = connection.createSession(true, 0);
                } else {
                    Session object = connection.createSession(false, 1);
                }
                Destination dest = this.getDestination((Session)var6_10);
                threadsArray[i] = new ConsumerThread((Session)var6_10, dest, i);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setMessageCount(this.messageCount).setFilter(this.filter).setBrowse(true);
            }
            for (ConsumerThread thread : threadsArray) {
                thread.start();
            }
            connection.start();
            int received = 0;
            for (ConsumerThread thread : threadsArray) {
                thread.join();
                received += thread.getReceived();
            }
            Integer n = received;
            return n;
        }
    }
}

