/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Option;
import java.util.Scanner;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.commands.ActionContext;

public class InputAbstract
extends ActionAbstract {
    private Scanner scanner;
    private static boolean inputEnabled = false;
    @Option(name={"--silent"}, description="Disable all the inputs, and make a best guess for any required input.")
    private boolean silentInput = false;

    public static void enableInput() {
        inputEnabled = true;
    }

    public boolean isSilentInput() {
        return this.silentInput || !inputEnabled;
    }

    public void setSilentInput(boolean isSilent) {
        this.silentInput = isSilent;
    }

    protected boolean inputBoolean(String propertyName, String prompt, boolean silentDefault) {
        if (this.isSilentInput()) {
            return silentDefault;
        }
        Boolean booleanValue = null;
        do {
            String value = this.input(propertyName, prompt + ", valid values are Y, N, True, False", Boolean.toString(silentDefault));
            switch (value.toUpperCase().trim()) {
                case "TRUE": 
                case "Y": {
                    booleanValue = Boolean.TRUE;
                    break;
                }
                case "FALSE": 
                case "N": {
                    booleanValue = Boolean.FALSE;
                }
            }
        } while (booleanValue == null);
        return booleanValue;
    }

    public int inputInteger(String propertyName, String prompt, String silentDefault) {
        Integer value = null;
        do {
            String input;
            if ((input = this.input(propertyName, prompt, silentDefault)) == null || input.trim().equals("")) {
                input = "0";
            }
            try {
                value = Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                value = null;
            }
        } while (value == null);
        return value;
    }

    protected String input(String propertyName, String prompt, String silentDefault) {
        return this.input(propertyName, prompt, silentDefault, false);
    }

    protected String input(String propertyName, String prompt, String silentDefault, boolean acceptNull) {
        String inputStr;
        if (this.isSilentInput()) {
            return silentDefault;
        }
        boolean valid = false;
        this.getActionContext().out.println();
        do {
            this.getActionContext().out.println(propertyName + ":");
            this.getActionContext().out.println(prompt);
            inputStr = this.scanner.nextLine();
            if (!acceptNull && inputStr.trim().equals("")) {
                this.getActionContext().out.println("Invalid Entry!");
                continue;
            }
            valid = true;
        } while (!valid);
        return inputStr.trim();
    }

    protected String inputPassword(String propertyName, String prompt, String silentDefault) {
        if (this.isSilentInput()) {
            return silentDefault;
        }
        String inputStr = "";
        boolean valid = false;
        this.getActionContext().out.println();
        do {
            this.getActionContext().out.println(propertyName + ": is mandatory with this configuration:");
            this.getActionContext().out.println(prompt);
            char[] chars = System.console().readPassword();
            if (chars == null) {
                this.getActionContext().out.println("Invalid Entry!");
                continue;
            }
            inputStr = new String(chars);
            if (inputStr.trim().equals("")) {
                this.getActionContext().out.println("Invalid Entry!");
                continue;
            }
            valid = true;
        } while (!valid);
        return inputStr.trim();
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.scanner = new Scanner(context.in);
        return null;
    }
}

