/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.Cache;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.MethodCall;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestOptions;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.ResponseMode;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RpcDispatcher;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Rsp;
import org.apache.activemq.artemis.shaded.org.jgroups.util.RspList;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeScheduler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ReplCache<K, V>
implements Receiver,
Cache.ChangeListener {
    private Cache<K, Value<V>> l2_cache = new Cache();
    private Cache<K, V> l1_cache = null;
    private static final Log log = LogFactory.getLog(ReplCache.class);
    private JChannel ch = null;
    private Address local_addr;
    private View view;
    private RpcDispatcher disp;
    @ManagedAttribute(writable=true)
    private String props = "udp.xml";
    @ManagedAttribute(writable=true)
    private String cluster_name = "ReplCache-Cluster";
    @ManagedAttribute(writable=true)
    private long call_timeout = 1000L;
    @ManagedAttribute(writable=true)
    private long caching_time = 30000L;
    @ManagedAttribute
    private short default_replication_count = 1;
    private HashFunction<K> hash_function = null;
    private HashFunctionFactory<K> hash_function_factory = ConsistentHashFunction::new;
    private final Set<Receiver> receivers = new HashSet<Receiver>();
    private final Set<ChangeListener> change_listeners = new HashSet<ChangeListener>();
    @ManagedAttribute(writable=true)
    private boolean migrate_data = true;
    private static final short PUT = 1;
    private static final short PUT_FORCE = 2;
    private static final short GET = 3;
    private static final short REMOVE = 4;
    private static final short REMOVE_MANY = 5;
    protected static final Map<Short, Method> methods = Util.createConcurrentMap(8);
    private TimeScheduler timer;

    public ReplCache(String props, String cluster_name) {
        this.props = props;
        this.cluster_name = cluster_name;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    @ManagedAttribute
    public String getLocalAddressAsString() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : "null";
    }

    @ManagedAttribute
    public int getClusterSize() {
        return this.view != null ? this.view.size() : 0;
    }

    @ManagedAttribute
    public boolean isL1CacheEnabled() {
        return this.l1_cache != null;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public void setClusterName(String cluster_name) {
        this.cluster_name = cluster_name;
    }

    public long getCallTimeout() {
        return this.call_timeout;
    }

    public void setCallTimeout(long call_timeout) {
        this.call_timeout = call_timeout;
    }

    public long getCachingTime() {
        return this.caching_time;
    }

    public void setCachingTime(long caching_time) {
        this.caching_time = caching_time;
    }

    public boolean isMigrateData() {
        return this.migrate_data;
    }

    public void setMigrateData(boolean migrate_data) {
        this.migrate_data = migrate_data;
    }

    public short getDefaultReplicationCount() {
        return this.default_replication_count;
    }

    public void setDefaultReplicationCount(short default_replication_count) {
        this.default_replication_count = default_replication_count;
    }

    public HashFunction getHashFunction() {
        return this.hash_function;
    }

    public void setHashFunction(HashFunction<K> hash_function) {
        this.hash_function = hash_function;
    }

    public HashFunctionFactory getHashFunctionFactory() {
        return this.hash_function_factory;
    }

    public void setHashFunctionFactory(HashFunctionFactory<K> hash_function_factory) {
        this.hash_function_factory = hash_function_factory;
    }

    public void addReceiver(Receiver r) {
        this.receivers.add(r);
    }

    public void removeMembershipListener(Receiver r) {
        this.receivers.remove(r);
    }

    public void addChangeListener(ChangeListener l) {
        this.change_listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.change_listeners.remove(l);
    }

    public Cache<K, V> getL1Cache() {
        return this.l1_cache;
    }

    public void setL1Cache(Cache<K, V> cache) {
        if (this.l1_cache != null) {
            this.l1_cache.stop();
        }
        this.l1_cache = cache;
    }

    public Cache<K, Value<V>> getL2Cache() {
        return this.l2_cache;
    }

    public void setL2Cache(Cache<K, Value<V>> cache) {
        if (cache != null) {
            this.l2_cache.stop();
            this.l2_cache = cache;
        }
    }

    @ManagedOperation
    public void start() throws Exception {
        if (this.hash_function_factory != null) {
            this.hash_function = this.hash_function_factory.create();
        }
        if (this.hash_function == null) {
            this.hash_function = new ConsistentHashFunction();
        }
        this.ch = new JChannel(this.props);
        this.disp = new RpcDispatcher(this.ch, this).setMethodLookup(methods::get).setReceiver(this);
        this.ch.connect(this.cluster_name);
        this.local_addr = this.ch.getAddress();
        this.view = this.ch.getView();
        this.timer = this.ch.getProtocolStack().getTransport().getTimer();
        this.l2_cache.addChangeListener(this);
    }

    @ManagedOperation
    public void stop() {
        if (this.l1_cache != null) {
            this.l1_cache.stop();
        }
        if (this.migrate_data) {
            ArrayList<Address> members_without_me = new ArrayList<Address>(this.view.getMembers());
            members_without_me.remove(this.local_addr);
            HashFunction<K> tmp_hash_function = this.hash_function_factory.create();
            tmp_hash_function.installNodes(members_without_me);
            for (Map.Entry<K, Cache.Value<Value<V>>> entry : this.l2_cache.entrySet()) {
                List<Address> nodes;
                short repl_count;
                Value<V> tmp;
                K key = entry.getKey();
                Cache.Value<Value<V>> val = entry.getValue();
                if (val == null || (tmp = val.getValue()) == null || (repl_count = tmp.getReplicationCount()) != 1 || (nodes = tmp_hash_function.hash(key, repl_count)) == null || nodes.isEmpty() || nodes.contains(this.local_addr)) continue;
                Address dest = nodes.get(0);
                this.move(dest, key, tmp.getVal(), repl_count, val.getTimeout(), true);
                this._remove(key);
            }
        }
        this.l2_cache.removeChangeListener(this);
        this.l2_cache.stop();
        this.disp.stop();
        this.ch.close();
    }

    @ManagedOperation
    public void put(K key, V val, short repl_count, long timeout, boolean synchronous) {
        if (repl_count == 0) {
            if (log.isWarnEnabled()) {
                log.warn("repl_count of 0 is invalid, data will not be stored in the cluster");
            }
            return;
        }
        this.mcastPut(key, val, repl_count, timeout, synchronous);
        if (this.l1_cache != null && timeout >= 0L) {
            this.l1_cache.put(key, val, timeout);
        }
    }

    @ManagedOperation
    public void put(K key, V val, short repl_count, long timeout) {
        this.put(key, val, repl_count, timeout, false);
    }

    @ManagedOperation
    public void put(K key, V val) {
        this.put(key, val, this.default_replication_count, this.caching_time);
    }

    @ManagedOperation
    public V get(K key) {
        Value tmp;
        Object val;
        if (this.l1_cache != null && (val = this.l1_cache.get(key)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("returned value " + String.valueOf(val) + " for " + String.valueOf(key) + " from L1 cache");
            }
            return (V)val;
        }
        val = this.l2_cache.getEntry(key);
        if (val != null && (tmp = (Value)((Cache.Value)val).getValue()) != null) {
            Object real_value = tmp.getVal();
            if (real_value != null && this.l1_cache != null && ((Cache.Value)val).getTimeout() >= 0L) {
                this.l1_cache.put(key, real_value, ((Cache.Value)val).getTimeout());
            }
            return tmp.getVal();
        }
        try {
            RspList rsps = this.disp.callRemoteMethods(null, new MethodCall(3, key), new RequestOptions(ResponseMode.GET_ALL, this.call_timeout));
            for (Rsp rsp : rsps.values()) {
                Object obj = rsp.getValue();
                if (obj == null || obj instanceof Throwable || (val = (Cache.Value)rsp.getValue()) == null || (tmp = (Value)((Cache.Value)val).getValue()) == null) continue;
                Object real_value = tmp.getVal();
                if (real_value != null && this.l1_cache != null && ((Cache.Value)val).getTimeout() >= 0L) {
                    this.l1_cache.put(key, real_value, ((Cache.Value)val).getTimeout());
                }
                return real_value;
            }
            return null;
        }
        catch (Throwable t) {
            if (log.isWarnEnabled()) {
                log.warn("get() failed", t);
            }
            return null;
        }
    }

    @ManagedOperation
    public void remove(K key) {
        this.remove(key, false);
    }

    @ManagedOperation
    public void remove(K key, boolean synchronous) {
        block3: {
            try {
                this.disp.callRemoteMethods(null, new MethodCall(4, key), new RequestOptions(synchronous ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, this.call_timeout));
                if (this.l1_cache != null) {
                    this.l1_cache.remove(key);
                }
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("remove() failed", t);
            }
        }
    }

    @ManagedOperation
    public void clear() {
        HashSet keys = new HashSet(this.l2_cache.getInternalMap().keySet());
        this.mcastClear(keys, false);
    }

    public V _put(K key, V val, short repl_count, long timeout) {
        return this._put(key, val, repl_count, timeout, false);
    }

    public V _put(K key, V val, short repl_count, long timeout, boolean force) {
        if (!force) {
            boolean accept;
            boolean bl = accept = repl_count == -1;
            if (!accept) {
                if (this.view != null && repl_count >= this.view.size()) {
                    accept = true;
                } else {
                    List<Address> selected_hosts;
                    List<Address> list = selected_hosts = this.hash_function != null ? this.hash_function.hash(key, repl_count) : null;
                    if (selected_hosts != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("local=" + String.valueOf(this.local_addr) + ", hosts=" + String.valueOf(selected_hosts));
                        }
                        for (Address addr : selected_hosts) {
                            if (!addr.equals(this.local_addr)) continue;
                            accept = true;
                            break;
                        }
                    }
                    if (!accept) {
                        return null;
                    }
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("_put(" + String.valueOf(key) + ", " + String.valueOf(val) + ", " + repl_count + ", " + timeout + ")");
        }
        Value<V> value = new Value<V>(val, repl_count);
        Value<V> retval = this.l2_cache.put(key, value, timeout);
        if (this.l1_cache != null) {
            this.l1_cache.remove(key);
        }
        this.notifyChangeListeners();
        return retval != null ? (V)retval.getVal() : null;
    }

    public Cache.Value<Value<V>> _get(K key) {
        if (log.isTraceEnabled()) {
            log.trace("_get(" + String.valueOf(key) + ")");
        }
        return this.l2_cache.getEntry(key);
    }

    public V _remove(K key) {
        if (log.isTraceEnabled()) {
            log.trace("_remove(" + String.valueOf(key) + ")");
        }
        Value<V> retval = this.l2_cache.remove(key);
        if (this.l1_cache != null) {
            this.l1_cache.remove(key);
        }
        this.notifyChangeListeners();
        return retval != null ? (V)retval.getVal() : null;
    }

    public void _removeMany(Set<K> keys) {
        if (log.isTraceEnabled()) {
            log.trace("_removeMany(): " + keys.size() + " entries");
        }
        keys.forEach(this::_remove);
    }

    @Override
    public void viewAccepted(View new_view) {
        ArrayList<Address> old_nodes = this.view != null ? new ArrayList<Address>(this.view.getMembers()) : null;
        this.view = new_view;
        if (log.isDebugEnabled()) {
            log.debug("new view: " + String.valueOf(new_view));
        }
        if (this.hash_function != null) {
            this.hash_function.installNodes(new_view.getMembers());
        }
        for (Receiver r : this.receivers) {
            r.viewAccepted(new_view);
        }
        if (old_nodes != null) {
            this.timer.schedule(() -> this.rebalance(old_nodes, new ArrayList<Address>(new_view.getMembers())), 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void changed() {
        this.notifyChangeListeners();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.l1_cache != null) {
            sb.append("L1 cache: " + this.l1_cache.getSize() + " entries");
        }
        sb.append("\nL2 cache: " + this.l2_cache.getSize() + " entries()");
        return sb.toString();
    }

    @ManagedOperation
    public String dump() {
        StringBuilder sb = new StringBuilder();
        if (this.l1_cache != null) {
            sb.append("L1 cache:\n").append(this.l1_cache.dump());
        }
        sb.append("\nL2 cache:\n").append(this.l2_cache.dump());
        return sb.toString();
    }

    private void notifyChangeListeners() {
        for (ChangeListener l : this.change_listeners) {
            try {
                l.changed();
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) continue;
                log.error("failed notifying change listener", t);
            }
        }
    }

    private void rebalance(List<Address> old_nodes, List<Address> new_nodes) {
        HashFunction old_func = this.hash_function_factory.create();
        old_func.installNodes(old_nodes);
        HashFunction new_func = this.hash_function_factory.create();
        new_func.installNodes(new_nodes);
        boolean is_coord = Util.isCoordinator(this.ch);
        ArrayList keys = new ArrayList(this.l2_cache.getInternalMap().keySet());
        for (Object key : keys) {
            Cache.Value<Value<V>> val = this.l2_cache.getEntry(key);
            if (log.isTraceEnabled()) {
                log.trace("==== rebalancing " + String.valueOf(key));
            }
            if (val == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(String.valueOf(key) + " has no value associated; ignoring");
                continue;
            }
            Value<V> tmp = val.getValue();
            if (tmp == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(String.valueOf(key) + " has no value associated; ignoring");
                continue;
            }
            V real_value = tmp.getVal();
            short repl_count = tmp.getReplicationCount();
            List<Address> new_mbrs = Util.newMembers(old_nodes, new_nodes);
            if (repl_count == -1) {
                if (!is_coord) continue;
                for (Address new_mbr : new_mbrs) {
                    this.move(new_mbr, key, real_value, repl_count, val.getTimeout(), false);
                }
                continue;
            }
            if (repl_count == 1) {
                Address mbr;
                List<Address> tmp_nodes = new_func.hash(key, repl_count);
                if (tmp_nodes.isEmpty() || (mbr = tmp_nodes.get(0)).equals(this.local_addr)) continue;
                this.move(mbr, key, real_value, repl_count, val.getTimeout(), false);
                this._remove(key);
                continue;
            }
            if (repl_count > 1) {
                List<Address> tmp_old = old_func.hash(key, repl_count);
                List<Address> tmp_new = new_func.hash(key, repl_count);
                if (log.isTraceEnabled()) {
                    log.trace("old nodes: " + String.valueOf(tmp_old) + "\nnew nodes: " + String.valueOf(tmp_new));
                }
                if (Objects.equals(tmp_old, tmp_new)) continue;
                this.mcastPut(key, real_value, repl_count, val.getTimeout(), false);
                if (tmp_new == null || tmp_new.contains(this.local_addr)) continue;
                this._remove(key);
                continue;
            }
            throw new IllegalStateException("replication count is invalid (" + repl_count + ")");
        }
    }

    public void mcastEntries() {
        for (Map.Entry<K, Cache.Value<Value<V>>> entry : this.l2_cache.entrySet()) {
            K key = entry.getKey();
            Cache.Value<Value<V>> val = entry.getValue();
            if (val == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(String.valueOf(key) + " has no value associated; ignoring");
                continue;
            }
            Value<V> tmp = val.getValue();
            if (tmp == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(String.valueOf(key) + " has no value associated; ignoring");
                continue;
            }
            V real_value = tmp.getVal();
            short repl_count = tmp.getReplicationCount();
            if (repl_count <= 1) continue;
            this._remove(key);
            this.mcastPut(key, real_value, repl_count, val.getTimeout(), false);
        }
    }

    private void mcastPut(K key, V val, short repl_count, long caching_time, boolean synchronous) {
        block2: {
            try {
                ResponseMode mode = synchronous ? ResponseMode.GET_ALL : ResponseMode.GET_NONE;
                this.disp.callRemoteMethods(null, new MethodCall(1, key, val, repl_count, caching_time), new RequestOptions(mode, this.call_timeout));
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("put() failed", t);
            }
        }
    }

    private void mcastClear(Set<K> keys, boolean synchronous) {
        block2: {
            try {
                ResponseMode mode = synchronous ? ResponseMode.GET_ALL : ResponseMode.GET_NONE;
                this.disp.callRemoteMethods(null, new MethodCall(5, keys), new RequestOptions(mode, this.call_timeout));
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("clear() failed", t);
            }
        }
    }

    private void move(Address dest, K key, V val, short repl_count, long caching_time, boolean synchronous) {
        block2: {
            try {
                ResponseMode mode = synchronous ? ResponseMode.GET_ALL : ResponseMode.GET_NONE;
                this.disp.callRemoteMethod(dest, new MethodCall(2, key, val, repl_count, caching_time, true), new RequestOptions(mode, this.call_timeout));
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("move() failed", t);
            }
        }
    }

    static {
        try {
            methods.put((short)1, ReplCache.class.getMethod("_put", Object.class, Object.class, Short.TYPE, Long.TYPE));
            methods.put((short)2, ReplCache.class.getMethod("_put", Object.class, Object.class, Short.TYPE, Long.TYPE, Boolean.TYPE));
            methods.put((short)3, ReplCache.class.getMethod("_get", Object.class));
            methods.put((short)4, ReplCache.class.getMethod("_remove", Object.class));
            methods.put((short)5, ReplCache.class.getMethod("_removeMany", Set.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface HashFunction<K> {
        public List<Address> hash(K var1, short var2);

        public void installNodes(List<Address> var1);
    }

    public static interface HashFunctionFactory<K> {
        public HashFunction<K> create();
    }

    public static class ConsistentHashFunction<K>
    implements HashFunction<K> {
        private final SortedMap<Short, Address> nodes = new TreeMap<Short, Address>();
        private static final int HASH_SPACE = 2048;
        private static final int FACTOR = 3737;

        @Override
        public List<Address> hash(K key, short replication_count) {
            Address val;
            int index = Math.abs(key.hashCode() & 0x7FF);
            LinkedHashSet<Address> results = new LinkedHashSet<Address>();
            SortedMap<Short, Address> tailmap = this.nodes.tailMap((short)index);
            int count = 0;
            for (Map.Entry<Short, Address> entry : tailmap.entrySet()) {
                val = entry.getValue();
                results.add(val);
                if (++count < replication_count) continue;
                break;
            }
            if (count < replication_count) {
                for (Map.Entry<Short, Address> entry : this.nodes.entrySet()) {
                    val = entry.getValue();
                    results.add(val);
                    if (++count < replication_count) continue;
                    break;
                }
            }
            return new ArrayList<Address>(results);
        }

        @Override
        public void installNodes(List<Address> new_nodes) {
            this.nodes.clear();
            block0: for (Address node : new_nodes) {
                int hash;
                for (int i = hash = Math.abs(node.hashCode() * 3737 & 0x7FF); i < hash + 2048; ++i) {
                    short new_index = (short)(i & 0x7FF);
                    if (this.nodes.containsKey(new_index)) continue;
                    this.nodes.put(new_index, node);
                    continue block0;
                }
            }
            if (log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("node mappings:\n");
                for (Map.Entry<Short, Address> entry : this.nodes.entrySet()) {
                    sb.append(String.valueOf(entry.getKey()) + ": " + String.valueOf(entry.getValue())).append("\n");
                }
                log.trace(sb);
            }
        }
    }

    public static class Value<V>
    implements Serializable {
        private final V val;
        private final short replication_count;
        private static final long serialVersionUID = -2892941069742740027L;

        public Value(V val, short replication_count) {
            this.val = val;
            this.replication_count = replication_count;
        }

        public V getVal() {
            return this.val;
        }

        public short getReplicationCount() {
            return this.replication_count;
        }

        public String toString() {
            return String.valueOf(this.val) + " (" + this.replication_count + ")";
        }
    }

    public static interface ChangeListener {
        public void changed();
    }
}

