/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GMS;
import org.apache.activemq.artemis.shaded.org.jgroups.util.BoundedList;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ViewHandler<R> {
    protected final Collection<R> requests = new ConcurrentLinkedQueue<R>();
    protected final Lock lock = new ReentrantLock();
    protected final AtomicBoolean suspended = new AtomicBoolean(false);
    protected final AtomicBoolean processing = new AtomicBoolean(false);
    protected final Condition processing_done = this.lock.newCondition();
    protected final GMS gms;
    protected Consumer<Collection<R>> req_processor;
    protected BiPredicate<R, R> req_matcher;
    protected final BoundedList<String> history = new BoundedList(20);

    public ViewHandler(GMS gms, Consumer<Collection<R>> req_processor, BiPredicate<R, R> req_matcher) {
        if (req_processor == null) {
            throw new IllegalArgumentException("request processor cannot be null");
        }
        this.gms = gms;
        this.req_processor = req_processor;
        this.req_matcher = req_matcher != null ? req_matcher : (a, b) -> true;
    }

    public boolean suspended() {
        return this.suspended.get();
    }

    public boolean processing() {
        return this.processing.get();
    }

    public int size() {
        return this.requests.size();
    }

    public ViewHandler<R> reqProcessor(Consumer<Collection<R>> p) {
        this.req_processor = p;
        return this;
    }

    public Consumer<Collection<R>> reqProcessor() {
        return this.req_processor;
    }

    public ViewHandler<R> reqMatcher(BiPredicate<R, R> m) {
        this.req_matcher = m;
        return this;
    }

    public BiPredicate<R, R> reqMatcher() {
        return this.req_matcher;
    }

    public ViewHandler<R> add(R req) {
        if (this._add(req)) {
            this.process();
        }
        return this;
    }

    public ViewHandler<R> add(R ... reqs) {
        if (this._add(reqs)) {
            this.process();
        }
        return this;
    }

    public ViewHandler<R> add(Collection<R> reqs) {
        if (this._add(reqs)) {
            this.process();
        }
        return this;
    }

    public void suspend() {
        if (this.suspended.compareAndSet(false, true)) {
            this.lock.lock();
            try {
                this.requests.clear();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void resume() {
        this.suspended.compareAndSet(true, false);
    }

    public void waitUntilComplete() {
        this.lock.lock();
        try {
            while (this.processing.get()) {
                try {
                    this.processing_done.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilComplete(long timeout) {
        block8: {
            long base = System.currentTimeMillis();
            long now = 0L;
            this.lock.lock();
            block5: while (true) {
                while (this.processing.get()) {
                    long delay = timeout - now;
                    if (delay <= 0L) {
                        break block8;
                    }
                    try {
                        this.processing_done.await(delay, TimeUnit.MILLISECONDS);
                        now = System.currentTimeMillis() - base;
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public <T extends ViewHandler<R>> T processing(boolean flag) {
        this.lock.lock();
        try {
            this.processing.set(flag);
            if (!flag) {
                this.processing_done.signalAll();
            }
            ViewHandler viewHandler = this;
            return (T)viewHandler;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String dumpQueue() {
        return this.requests.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    public String dumpHistory() {
        return String.join((CharSequence)"\n", this.history);
    }

    public String toString() {
        return Util.printListWithDelimiter(this.requests, ", ");
    }

    protected Log log() {
        return this.gms.getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _add(R req) {
        if (req == null) {
            return false;
        }
        if (this.suspended.get()) {
            this.log().trace("%s: queue is suspended; request %s is discarded", this.gms.getAddress(), req);
            return false;
        }
        String log = Util.utcNow() + ": " + String.valueOf(req);
        this.lock.lock();
        try {
            if (!this.requests.contains(req)) {
                this.requests.add(req);
                this.history.add(log);
            }
            boolean bl = this.processing.compareAndSet(false, true);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean _add(R ... reqs) {
        if (reqs == null || reqs.length == 0) {
            return false;
        }
        return this._add((Collection<R>)Arrays.asList(reqs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _add(Collection<R> reqs) {
        if (reqs == null || reqs.isEmpty()) {
            return false;
        }
        if (this.suspended.get()) {
            this.log().trace("%s: queue is suspended; requests %s are discarded", this.gms.getAddress(), reqs);
            return false;
        }
        this.lock.lock();
        try {
            for (R req : reqs) {
                if (req == null || this.requests.contains(req)) continue;
                this.requests.add(req);
                this.history.add(Util.utcNow() + ": " + String.valueOf(req));
            }
            boolean bl = this.processing.compareAndSet(false, true);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        while (true) {
            if (!this.requests.isEmpty()) {
                Collection<R> reqs = null;
                this.lock.lock();
                try {
                    reqs = this.remove(this.requests);
                }
                finally {
                    this.lock.unlock();
                }
                if (reqs == null || reqs.isEmpty()) continue;
                try {
                    this.req_processor.accept(reqs);
                }
                catch (Throwable t) {
                    this.log().error("%s: failed processsing requests: %s", this.gms.addr(), t);
                    this.lock.lock();
                    try {
                        if (this.processing.compareAndSet(true, false)) {
                            this.processing_done.signalAll();
                        }
                        throw t;
                    }
                    catch (Throwable throwable) {
                        this.lock.unlock();
                        throw throwable;
                    }
                }
            }
            this.lock.lock();
            try {
                if (!this.requests.isEmpty()) continue;
                if (this.processing.compareAndSet(true, false)) {
                    this.processing_done.signalAll();
                }
                return;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    protected Collection<R> remove(Collection<R> requests) {
        ArrayList<Object> removed = new ArrayList<Object>();
        Object first_req = null;
        Iterator<R> it = requests.iterator();
        try {
            R next;
            if (it.hasNext()) {
                first_req = it.next();
                removed.add(first_req);
                it.remove();
            }
            while (it.hasNext() && this.req_matcher.test(first_req, next = it.next())) {
                removed.add(next);
                it.remove();
            }
        }
        catch (Throwable t) {
            this.log().error("failed processing requests", t);
        }
        return removed;
    }
}

