/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.BaseMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RELAY;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RELAY3;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RelayHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Headers;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Route
implements Comparable<Route> {
    protected final Address site_master;
    protected final JChannel bridge;
    protected final RELAY relay;
    protected final Log log;
    protected boolean stats = true;
    protected final boolean relay3;

    public Route(Address site_master, JChannel bridge, RELAY relay, Log log) {
        this.site_master = site_master;
        this.bridge = bridge;
        this.relay = relay;
        this.log = log;
        this.relay3 = Objects.requireNonNull(relay) instanceof RELAY3;
    }

    public JChannel bridge() {
        return this.bridge;
    }

    public Address siteMaster() {
        return this.site_master;
    }

    public boolean stats() {
        return this.stats;
    }

    public Route stats(boolean f) {
        this.stats = f;
        return this;
    }

    public void send(Address final_destination, Address original_sender, Message msg) {
        this.send(final_destination, original_sender, msg, null);
    }

    public void send(Address final_destination, Address original_sender, Message msg, Collection<String> visited_sites) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: routing message to %s via %s", this.bridge.address(), final_destination, this.site_master);
        }
        long start = this.stats ? System.nanoTime() : 0L;
        try {
            Message copy = this.createMessage(this.site_master, final_destination, original_sender, msg, visited_sites);
            if (this.relay3) {
                boolean multicast;
                Address dest = copy.dest();
                boolean bl = multicast = dest == null || dest.isMulticast();
                if (!multicast) {
                    copy.setFlag(Message.Flag.NO_RELIABILITY);
                }
            }
            this.bridge.send(copy);
            if (this.stats) {
                this.relay.addToRelayedTime(System.nanoTime() - start);
                this.relay.incrementRelayed();
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailureRelayingMessage"), e);
        }
    }

    @Override
    public int compareTo(Route o) {
        return this.site_master.compareTo(o.siteMaster());
    }

    public boolean equals(Object obj) {
        return this.compareTo((Route)obj) == 0;
    }

    public int hashCode() {
        return this.site_master.hashCode();
    }

    public String toString() {
        return this.site_master != null ? this.site_master.toString() : "";
    }

    protected Message createMessage(Address target, Address final_destination, Address original_sender, Message msg, Collection<String> visited_sites) throws IOException {
        Header[] original_hdrs;
        Message copy = this.relay.copy(msg).setDest(target).setSrc(null);
        RelayHeader tmp = (RelayHeader)msg.getHeader(this.relay.getId());
        RelayHeader hdr = tmp != null ? tmp.copy().setFinalDestination(final_destination).setOriginalSender(original_sender) : new RelayHeader(1, final_destination, original_sender);
        hdr.addToVisitedSites(visited_sites).originalFlags(copy.getFlags());
        if (this.relay3 && Headers.size(original_hdrs = ((BaseMessage)copy).headers()) > 0) {
            hdr.originalHeaders(original_hdrs);
            copy.clearHeaders();
        }
        copy.putHeader(this.relay.getId(), hdr);
        return copy;
    }
}

