/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.MergeView;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Encrypt;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.EncryptHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.KeyExchange;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GMS;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AsciiString;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArray;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataInputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Tuple;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean(description="Asymmetric encryption protocol. The secret key for encryption and decryption of messages is fetched from a key server (the coordinator) via asymmetric encryption")
public class ASYM_ENCRYPT
extends Encrypt<KeyStore.PrivateKeyEntry> {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    @Property(description="When a node leaves, change the secret group key, preventing old members from eavesdropping")
    protected boolean change_key_on_leave;
    @Property(description="Change the secret group key when the coordinator changes. If enabled, this will take place even if change_key_on_leave is disabled.")
    protected boolean change_key_on_coord_leave = true;
    @Property(description="If true, a separate KeyExchange protocol (somewhere in the stack) is used to fetch the shared secret key. If false, the default (built-in) key exchange protocol will be used.")
    protected boolean use_external_key_exchange;
    protected KeyExchange key_exchange;
    protected volatile Address key_server_addr;
    protected volatile boolean send_group_keys;
    protected KeyPair key_pair;
    protected Cipher asym_cipher;
    protected final Map<Address, byte[]> pub_map = new ConcurrentHashMap<Address, byte[]>();
    protected static final ThreadLocal<Address> srv_addr = new ThreadLocal();

    @Override
    public ASYM_ENCRYPT setKeyStoreEntry(KeyStore.PrivateKeyEntry entry) {
        this.key_pair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
        return this;
    }

    public boolean getChangeKeyOnLeave() {
        return this.change_key_on_leave;
    }

    public ASYM_ENCRYPT setChangeKeyOnLeave(boolean c) {
        this.change_key_on_leave = c;
        return this;
    }

    public boolean getChangeKeyOnCoordLeave() {
        return this.change_key_on_coord_leave;
    }

    public ASYM_ENCRYPT setChangeKeyOnCoordLeave(boolean c) {
        this.change_key_on_coord_leave = c;
        return this;
    }

    public boolean getUseExternalKeyExchange() {
        return this.use_external_key_exchange;
    }

    public ASYM_ENCRYPT setUseExternalKeyExchange(boolean u) {
        this.use_external_key_exchange = u;
        return this;
    }

    public KeyPair keyPair() {
        return this.key_pair;
    }

    public Cipher asymCipher() {
        return this.asym_cipher;
    }

    public Address keyServerAddr() {
        return this.key_server_addr;
    }

    public ASYM_ENCRYPT keyServerAddr(Address ks) {
        this.key_server_addr = ks;
        return this;
    }

    @Override
    public List<Integer> providedDownServices() {
        return Arrays.asList(111, 112);
    }

    @ManagedAttribute(description="Keys in the public key map")
    public String getPublicKeys() {
        return this.pub_map.keySet().toString();
    }

    @ManagedAttribute(description="The current key server")
    public String getKeyServerAddress() {
        return this.key_server_addr != null ? this.key_server_addr.toString() : "null";
    }

    @ManagedAttribute(description="True if this member is the current key server, false otherwise")
    public boolean isKeyServer() {
        return Objects.equals(this.key_server_addr, this.local_addr);
    }

    @Override
    public void init() throws Exception {
        this.send_group_keys = false;
        this.initKeyPair();
        super.init();
        if (this.use_external_key_exchange) {
            this.fetchAndSetKeyExchange();
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.pub_map.put(this.local_addr, this.key_pair.getPublic().getEncoded());
    }

    @Override
    public Object down(Event evt) {
        if (evt.type() == 114) {
            this.createNewKey("because of an INSTALL_MERGE_VIEW event");
        }
        return super.down(evt);
    }

    @Override
    public Object down(Message msg) {
        Processing processing = this.skipDownMessage(msg);
        if (processing == Processing.PROCESS) {
            return super.down(msg);
        }
        if (processing == Processing.SKIP) {
            return this.down_prot.down(msg);
        }
        return null;
    }

    @Override
    public Object up(Event evt) {
        switch (evt.type()) {
            case 111: {
                return new Tuple<Key, byte[]>(this.secret_key, this.sym_version);
            }
            case 112: {
                Tuple tuple = (Tuple)evt.arg();
                try {
                    this.installSharedGroupKey(null, (SecretKey)tuple.getVal1(), (byte[])tuple.getVal2());
                }
                catch (Exception ex) {
                    this.log.error("failed setting group key", ex);
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        if (this.dropMulticastMessageFromNonMember(msg)) {
            return null;
        }
        if (this.skipUpMessage(msg)) {
            return this.up_prot.up(msg);
        }
        return super.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (this.dropMulticastMessageFromNonMember(msg)) {
                it.remove();
                continue;
            }
            if (!this.skipUpMessage(msg)) continue;
            try {
                this.up_prot.up(msg);
                it.remove();
            }
            catch (Throwable t) {
                this.log.error("failed passing up message from %s: %s, ex=%s", msg.src(), msg.printHeaders(), t);
            }
        }
        if (!batch.isEmpty()) {
            super.up(batch);
        }
    }

    protected boolean dropMulticastMessageFromNonMember(Message msg) {
        return msg.dest() == null && !this.inView(msg.src(), String.format("%s: dropped multicast message from non-member %s", this.local_addr, msg.getSrc()));
    }

    public ASYM_ENCRYPT fetchAndSetKeyExchange() {
        this.key_exchange = (KeyExchange)this.stack.findProtocol((Class<? extends Protocol>)KeyExchange.class);
        if (this.key_exchange == null) {
            throw new IllegalStateException(KeyExchange.class.getSimpleName() + " not found in stack");
        }
        return this;
    }

    protected static void cacheServerAddress(Address srv) {
        srv_addr.set(srv);
    }

    protected static Address getCachedServerAddress() {
        Address retval = srv_addr.get();
        srv_addr.remove();
        return retval;
    }

    protected Processing skipDownMessage(Message msg) {
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr == null) {
            return Processing.PROCESS;
        }
        switch (hdr.getType()) {
            case 1: 
            case 7: 
            case 11: {
                if (!this.use_external_key_exchange) {
                    Message copy = this.addKeysToMessage(msg, true, false, null);
                    this.down_prot.down(copy);
                    return Processing.DROP;
                }
                return Processing.SKIP;
            }
            case 2: {
                return this.addMetadata(msg, false, msg.getDest(), true);
            }
            case 5: {
                boolean tmp = this.send_group_keys;
                this.send_group_keys = false;
                return this.addMetadata(msg, tmp, null, tmp);
            }
            case 8: {
                if (Objects.equals(this.local_addr, msg.dest())) break;
                return this.addMetadata(msg, true, null, true);
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                return Processing.SKIP;
            }
        }
        return Processing.PROCESS;
    }

    protected boolean skipUpMessage(Message msg) {
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr == null) {
            return false;
        }
        EncryptHeader h = (EncryptHeader)msg.getHeader(this.id);
        switch (hdr.getType()) {
            case 1: 
            case 7: 
            case 11: {
                return this.processEncryptMessage(msg, h, true);
            }
            case 2: 
            case 5: 
            case 8: {
                if (hdr.getType() == 8) {
                    ASYM_ENCRYPT.cacheServerAddress(h.server());
                }
                return this.processEncryptMessage(msg, h, false);
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    protected boolean processEncryptMessage(Message msg, EncryptHeader hdr, boolean retval) {
        if (hdr == null) {
            return retval;
        }
        switch (hdr.type) {
            case 1: {
                this.removeKeysFromMessageAndInstall(msg, hdr.version());
                break;
            }
            case 2: {
                if (Objects.equals(this.local_addr, msg.getSrc())) break;
                try {
                    Address key_server;
                    Address address = key_server = hdr.server() != null ? hdr.server() : msg.src();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("%s: fetching group key from %s", this.local_addr, key_server);
                    }
                    this.key_exchange.fetchSecretKeyFrom(key_server);
                    break;
                }
                catch (Exception e) {
                    this.log.warn("%s: failed fetching group key from %s: %s", this.local_addr, msg.src(), e);
                }
            }
        }
        return retval;
    }

    protected void installPublicKeys(Address sender, byte[] buf, int offset, int length) {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        try {
            int num_keys = in.readInt();
            for (int i = 0; i < num_keys; ++i) {
                Address mbr = Util.readAddress(in);
                int len = in.readInt();
                byte[] key = new byte[len];
                in.readFully(key, 0, key.length);
                this.pub_map.put(mbr, key);
            }
            this.log.trace("%s: added %d public keys to local cache", this.local_addr, num_keys);
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading public keys received from %s: %s", this.local_addr, sender, ex);
        }
    }

    protected Processing addMetadata(Message msg, boolean add_secret_keys, Address include_secret_key_only_for, boolean attach_fetch_key_header) {
        try {
            if (this.use_external_key_exchange && !attach_fetch_key_header) {
                return Processing.PROCESS;
            }
            Message encr_msg = this.encrypt(msg);
            if (this.use_external_key_exchange) {
                Address srv = this.key_exchange.getServerLocation();
                if (srv == null) {
                    srv = ASYM_ENCRYPT.getCachedServerAddress();
                }
                this.log.trace("%s: asking %s to fetch the shared group key %s via an external key exchange protocol (srv=%s)", this.local_addr, encr_msg.getDest() == null ? "all members" : encr_msg.getDest(), Util.byteArrayToHexString(this.sym_version), srv);
                encr_msg.putHeader(this.id, new EncryptHeader(2, this.symVersion(), this.getIv(encr_msg)).server(srv));
            } else {
                encr_msg = this.addKeysToMessage(encr_msg, false, add_secret_keys, include_secret_key_only_for);
                if (add_secret_keys || include_secret_key_only_for != null) {
                    this.log.trace("%s: sending encrypted group key to %s (version: %s)", this.local_addr, encr_msg.getDest() == null ? "all members" : encr_msg.getDest(), Util.byteArrayToHexString(this.sym_version));
                }
            }
            this.down_prot.down(encr_msg);
            return Processing.DROP;
        }
        catch (Exception ex) {
            this.log.warn("%s: unable to send message to %s: %s", msg.getDest() == null ? "all" : msg.getDest(), this.local_addr, ex);
            return Processing.PROCESS;
        }
    }

    protected Message addKeysToMessage(Message msg, boolean copy, boolean add_secret_keys, Address serialize_only) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(this.pub_map.size() * 200 + msg.getLength());
        try {
            this.serializeKeys(out, add_secret_keys, serialize_only);
            if (msg.getLength() > 0) {
                out.write(msg.getArray(), msg.getOffset(), msg.getLength());
            }
            return (copy ? msg.copy(true, true) : msg).setArray(out.getBuffer()).putHeader(this.id, new EncryptHeader(1, this.symVersion(), this.getIv(msg)));
        }
        catch (Throwable t) {
            this.log.error("%s: failed adding keys to message: %s", this.local_addr, t);
            return null;
        }
    }

    protected void removeKeysFromMessageAndInstall(Message msg, byte[] version) {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(msg.getArray(), msg.getOffset(), msg.getLength());
        this.unserializeAndInstallKeys(msg.getSrc(), version, in);
        int len = msg.getLength();
        int offset = msg.getOffset();
        int bytes_read = in.position();
        if (offset + bytes_read == len) {
            msg.setArray(null, 0, 0);
        } else {
            msg.setArray(msg.getArray(), offset + bytes_read, len - bytes_read);
        }
    }

    protected void serializeKeys(ByteArrayDataOutputStream out, boolean serialize_shared_keys, Address serialize_only) throws Exception {
        out.writeInt(this.pub_map.size());
        int num = 0;
        for (Map.Entry<Address, byte[]> e : this.pub_map.entrySet()) {
            Address mbr = e.getKey();
            byte[] public_key = e.getValue();
            Util.writeAddress(mbr, out);
            out.writeInt(public_key.length);
            out.write(public_key, 0, public_key.length);
            if (serialize_shared_keys || Objects.equals(mbr, serialize_only)) {
                PublicKey pk = this.makePublicKey(public_key);
                byte[] encrypted_shared_key = this.encryptSecretKey(this.secret_key, pk);
                out.writeInt(encrypted_shared_key.length);
                out.write(encrypted_shared_key, 0, encrypted_shared_key.length);
            } else {
                out.writeInt(0);
            }
            ++num;
        }
        int curr_pos = out.position();
        out.position(0).writeInt(num);
        out.position(curr_pos);
    }

    protected void unserializeAndInstallKeys(Address sender, byte[] version, ByteArrayDataInputStream in) {
        try {
            int num_keys = in.readInt();
            for (int i = 0; i < num_keys; ++i) {
                Address mbr = Util.readAddress(in);
                int len = in.readInt();
                if (len > 0) {
                    byte[] public_key = new byte[len];
                    in.readFully(public_key, 0, public_key.length);
                    this.pub_map.put(mbr, public_key);
                }
                if ((len = in.readInt()) <= 0) continue;
                byte[] encrypted_shared_group_key = new byte[len];
                in.readFully(encrypted_shared_group_key, 0, encrypted_shared_group_key.length);
                if (!this.local_addr.equals(mbr)) continue;
                try {
                    SecretKeySpec tmp = this.decodeKey(encrypted_shared_group_key);
                    if (tmp == null) continue;
                    this.installSharedGroupKey(sender, tmp, version);
                    continue;
                }
                catch (Exception e) {
                    this.log.warn("%s: unable to process key received from %s: %s", this.local_addr, sender, e);
                }
            }
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading keys received from %s: %s", this.local_addr, sender, ex);
        }
    }

    protected static ByteArray serializeKeys(Map<Address, byte[]> keys) throws Exception {
        int num_keys = keys.size();
        if (num_keys == 0) {
            return null;
        }
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(num_keys * 100);
        out.writeInt(num_keys);
        for (Map.Entry<Address, byte[]> e : keys.entrySet()) {
            Util.writeAddress(e.getKey(), out);
            byte[] val = e.getValue();
            out.writeInt(val.length);
            out.write(val, 0, val.length);
        }
        return out.getBuffer();
    }

    protected Map<Address, byte[]> unserializeKeys(Address sender, byte[] buf, int offset, int length) {
        HashMap<Address, byte[]> map = new HashMap<Address, byte[]>();
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        try {
            int num_keys = in.readInt();
            for (int i = 0; i < num_keys; ++i) {
                Address mbr = Util.readAddress(in);
                int len = in.readInt();
                byte[] key = new byte[len];
                in.readFully(key, 0, key.length);
                map.put(mbr, key);
            }
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading keys received from %s: %s", this.local_addr, sender, ex);
        }
        return map;
    }

    protected SecretKey createSecretKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm), this.provider) : KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
        keyGen.init(this.sym_keylength);
        return keyGen.generateKey();
    }

    protected void initKeyPair() throws Exception {
        if (this.key_pair == null) {
            KeyPairGenerator KpairGen = null;
            KpairGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm), this.provider) : KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
            KpairGen.initialize(this.asym_keylength, new SecureRandom());
            this.key_pair = KpairGen.generateKeyPair();
        }
        this.asym_cipher = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        this.asym_cipher.init(2, this.key_pair.getPrivate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleView(View v) {
        this.pub_map.keySet().retainAll(v.getMembers());
        ASYM_ENCRYPT aSYM_ENCRYPT = this;
        synchronized (aSYM_ENCRYPT) {
            boolean key_server_changed = !Objects.equals(v.getCoord(), this.key_server_addr);
            boolean left_mbrs = this.view != null && !v.containsMembers(this.view.getMembersRaw());
            super.handleView(v);
            this.key_server_addr = v.getCoord();
            boolean create_new_key = this.secret_key == null || this.change_key_on_leave && left_mbrs || this.change_key_on_coord_leave && key_server_changed;
            boolean bl = this.send_group_keys = (create_new_key &= !(v instanceof MergeView)) || v instanceof MergeView;
            if (!Objects.equals(this.key_server_addr, this.local_addr)) {
                return;
            }
            if (key_server_changed) {
                this.log.debug("%s: I'm the new key server", this.local_addr);
            }
            if (create_new_key) {
                this.createNewKey("because of new view " + v);
            }
        }
    }

    protected void createNewKey(String message) {
        try {
            this.secret_key = this.createSecretKey();
            this.initSymCiphers(this.sym_algorithm, this.secret_key);
            this.log.debug("%s: created new group key (version: %s) %s", this.local_addr, Util.byteArrayToHexString(this.sym_version), message);
            this.cacheGroupKey(this.sym_version);
        }
        catch (Exception ex) {
            this.log.error("%s: failed creating group key and initializing ciphers", this.local_addr, ex);
        }
    }

    protected synchronized void installSharedGroupKey(Address sender, SecretKey key, byte[] version) throws Exception {
        if (Arrays.equals(this.sym_version, version)) {
            this.log.debug("%s: ignoring group key received from %s (version: %s); it has already been installed", this.local_addr, sender != null ? sender : "key exchange protocol", Util.byteArrayToHexString(version));
            return;
        }
        this.log.debug("%s: installing group key received from %s (version: %s)", this.local_addr, sender != null ? sender : "key exchange protocol", Util.byteArrayToHexString(version));
        this.secret_key = key;
        this.initSymCiphers(this.sym_algorithm, key);
        this.sym_version = version;
        this.cacheGroupKey(version);
    }

    protected void cacheGroupKey(byte[] version) throws Exception {
        if (this.secret_key != null) {
            this.key_map.putIfAbsent(new AsciiString(version), this.secret_key);
        }
    }

    protected byte[] encryptSecretKey(Key secret_key, PublicKey public_key) throws Exception {
        Cipher tmp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        tmp.init(1, public_key);
        return tmp.doFinal(secret_key.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes;
        ASYM_ENCRYPT aSYM_ENCRYPT = this;
        synchronized (aSYM_ENCRYPT) {
            try {
                keyBytes = this.asym_cipher.doFinal(encodedKey);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                this.asym_cipher.init(2, this.key_pair.getPrivate());
                throw e;
            }
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
            Cipher temp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.sym_algorithm, this.provider) : Cipher.getInstance(this.sym_algorithm);
            temp.init(3, keySpec);
            return keySpec;
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDecodingKey"), e);
            return null;
        }
    }

    protected PublicKey makePublicKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    protected byte[] getIv(Message msg) {
        EncryptHeader h = (EncryptHeader)msg.getHeader(this.id);
        if (h == null) {
            return null;
        }
        return h.iv();
    }

    protected static enum Processing {
        SKIP,
        PROCESS,
        DROP;

    }
}

