/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TestableJournal;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.AbstractJournalUpdateTask;
import org.apache.activemq.artemis.core.journal.impl.JournalBase;
import org.apache.activemq.artemis.core.journal.impl.JournalCompactor;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFileImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalFilesRepository;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalRecord;
import org.apache.activemq.artemis.core.journal.impl.JournalRecordProvider;
import org.apache.activemq.artemis.core.journal.impl.JournalTransaction;
import org.apache.activemq.artemis.core.journal.impl.Reclaimer;
import org.apache.activemq.artemis.core.journal.impl.TransactionCallback;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalDeleteRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalRollbackRecordTX;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.jboss.logging.Logger;

public class JournalImpl
extends JournalBase
implements TestableJournal,
JournalRecordProvider {
    public static final int FORMAT_VERSION = 2;
    private static final int[] COMPATIBLE_VERSIONS = new int[]{1};
    private static final Logger logger = Logger.getLogger(JournalImpl.class);
    public static final int MIN_FILE_SIZE = 1024;
    public static final int SIZE_HEADER = 16;
    private static final int BASIC_SIZE = 9;
    public static final int SIZE_ADD_RECORD = 22;
    public static final byte ADD_RECORD = 11;
    public static final byte UPDATE_RECORD = 12;
    public static final int SIZE_ADD_RECORD_TX = 30;
    public static final byte ADD_RECORD_TX = 13;
    public static final byte UPDATE_RECORD_TX = 14;
    public static final int SIZE_DELETE_RECORD_TX = 29;
    public static final byte DELETE_RECORD_TX = 15;
    public static final int SIZE_DELETE_RECORD = 17;
    public static final byte DELETE_RECORD = 16;
    public static final int SIZE_COMPLETE_TRANSACTION_RECORD = 21;
    public static final int SIZE_PREPARE_RECORD = 25;
    public static final byte PREPARE_RECORD = 17;
    public static final int SIZE_COMMIT_RECORD = 21;
    public static final byte COMMIT_RECORD = 18;
    public static final int SIZE_ROLLBACK_RECORD = 17;
    public static final byte ROLLBACK_RECORD = 19;
    protected static final byte FILL_CHARACTER = 74;
    private volatile boolean autoReclaim = true;
    private final int userVersion;
    private final int minFiles;
    private final float compactPercentage;
    private final int compactMinFiles;
    private final SequentialFileFactory fileFactory;
    private final JournalFilesRepository filesRepository;
    private final ConcurrentMap<Long, JournalRecord> records = new ConcurrentHashMap<Long, JournalRecord>();
    private final ConcurrentMap<Long, JournalTransaction> transactions = new ConcurrentHashMap<Long, JournalTransaction>();
    private volatile JournalCompactor compactor;
    private final AtomicBoolean compactorRunning = new AtomicBoolean();
    private ExecutorService filesExecutor = null;
    private ExecutorService compactorExecutor = null;
    private ConcurrentHashSet<CountDownLatch> latches = new ConcurrentHashSet();
    private final Object lockAppend = new Object();
    private final ReadWriteLock journalLock = new ReentrantReadWriteLock();
    private final ReadWriteLock compactorLock = new ReentrantReadWriteLock();
    private volatile JournalFile currentFile;
    private volatile Journal.JournalState state = Journal.JournalState.STOPPED;
    private volatile int compactCount = 0;
    private final Reclaimer reclaimer = new Reclaimer();

    public JournalImpl(int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO) {
        this(fileSize, minFiles, poolSize, compactMinFiles, compactPercentage, fileFactory, filePrefix, fileExtension, maxAIO, 0);
    }

    public JournalImpl(int fileSize, int minFiles, int poolSize, int compactMinFiles, int compactPercentage, SequentialFileFactory fileFactory, String filePrefix, String fileExtension, int maxAIO, int userVersion) {
        super(fileFactory.isSupportsCallbacks(), fileSize);
        if (fileSize % fileFactory.getAlignment() != 0) {
            throw new IllegalArgumentException("Invalid journal-file-size " + fileSize + ", It should be multiple of " + fileFactory.getAlignment());
        }
        if (minFiles < 2) {
            throw new IllegalArgumentException("minFiles cannot be less than 2");
        }
        if (compactPercentage < 0 || compactPercentage > 100) {
            throw new IllegalArgumentException("Compact Percentage out of range");
        }
        this.compactPercentage = compactPercentage == 0 ? 0.0f : (float)compactPercentage / 100.0f;
        this.compactMinFiles = compactMinFiles;
        this.minFiles = minFiles;
        this.fileFactory = fileFactory;
        this.filesRepository = new JournalFilesRepository(fileFactory, this, filePrefix, fileExtension, userVersion, maxAIO, fileSize, minFiles, poolSize);
        this.userVersion = userVersion;
    }

    public String toString() {
        return "JournalImpl(state=" + (Object)((Object)this.state) + ", currentFile=[" + this.currentFile + "], hash=" + super.toString() + ")";
    }

    @Override
    public void runDirectJournalBlast() throws Exception {
        int numIts = 100000000;
        ActiveMQJournalLogger.LOGGER.runningJournalBlast(100000000);
        final CountDownLatch latch = new CountDownLatch(200000000);
        class MyAIOCallback
        implements IOCompletion {
            MyAIOCallback() {
            }

            @Override
            public void done() {
                latch.countDown();
            }

            @Override
            public void onError(int errorCode, String errorMessage) {
            }

            @Override
            public void storeLineUp() {
            }
        }
        MyAIOCallback task = new MyAIOCallback();
        int recordSize = 1024;
        final byte[] bytes = new byte[1024];
        class MyRecord
        implements EncodingSupport {
            MyRecord() {
            }

            @Override
            public void decode(ActiveMQBuffer buffer) {
            }

            @Override
            public void encode(ActiveMQBuffer buffer) {
                buffer.writeBytes(bytes);
            }

            @Override
            public int getEncodeSize() {
                return 1024;
            }
        }
        MyRecord record = new MyRecord();
        for (int i = 0; i < 100000000; ++i) {
            this.appendAddRecord(i, (byte)1, record, true, task);
            this.appendDeleteRecord(i, true, task);
        }
        latch.await();
    }

    @Override
    public Map<Long, JournalRecord> getRecords() {
        return this.records;
    }

    @Override
    public JournalFile getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public JournalCompactor getCompactor() {
        return this.compactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JournalFile> orderFiles() throws Exception {
        List<String> fileNames = this.fileFactory.listFiles(this.filesRepository.getFileExtension());
        ArrayList<JournalFile> orderedFiles = new ArrayList<JournalFile>(fileNames.size());
        for (String fileName : fileNames) {
            SequentialFile file = this.fileFactory.createSequentialFile(fileName);
            if (file.size() >= 16L) {
                file.open();
                try {
                    JournalFileImpl jrnFile = this.readFileHeader(file);
                    orderedFiles.add(jrnFile);
                    continue;
                }
                finally {
                    file.close();
                    continue;
                }
            }
            ActiveMQJournalLogger.LOGGER.ignoringShortFile(fileName);
            file.delete();
        }
        Collections.sort(orderedFiles, new JournalFileComparator());
        return orderedFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readJournalFile(SequentialFileFactory fileFactory, JournalFile file, JournalReaderCallback reader) throws Exception {
        int n;
        file.getFile().open(1, false);
        ByteBuffer wholeFileBuffer = null;
        try {
            int filesize = (int)file.getFile().size();
            wholeFileBuffer = fileFactory.newBuffer(filesize);
            int journalFileSize = file.getFile().read(wholeFileBuffer);
            if (journalFileSize != filesize) {
                throw new RuntimeException("Invalid read! The system couldn't read the entire file into memory");
            }
            wholeFileBuffer.position(16);
            int lastDataPos = 16;
            while (wholeFileBuffer.hasRemaining()) {
                int recordSize;
                int pos = wholeFileBuffer.position();
                byte recordType = wholeFileBuffer.get();
                if (recordType < 11 || recordType > 19) continue;
                if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                int readFileId = wholeFileBuffer.getInt();
                if (readFileId != file.getRecordID()) {
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                short compactCount = 0;
                if (file.getJournalVersion() >= 2) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 1)) {
                        reader.markAsDataFile(file);
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    compactCount = wholeFileBuffer.get();
                }
                long transactionID = 0L;
                if (JournalImpl.isTransaction(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    transactionID = wholeFileBuffer.getLong();
                }
                long recordID = 0L;
                if (!JournalImpl.isCompleteTransaction(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 8)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    recordID = wholeFileBuffer.getLong();
                }
                int variableSize = 0;
                int preparedTransactionExtraDataSize = 0;
                byte userRecordType = 0;
                byte[] record = null;
                if (JournalImpl.isContainsBody(recordType)) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                        wholeFileBuffer.position(pos + 1);
                        reader.markAsDataFile(file);
                        continue;
                    }
                    variableSize = wholeFileBuffer.getInt();
                    if (recordType != 15) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 1)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        userRecordType = wholeFileBuffer.get();
                    }
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), variableSize)) {
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    record = new byte[variableSize];
                    wholeFileBuffer.get(record);
                }
                int transactionCheckNumberOfRecords = 0;
                if (recordType == 17 || recordType == 18) {
                    if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                        wholeFileBuffer.position(pos + 1);
                        continue;
                    }
                    transactionCheckNumberOfRecords = wholeFileBuffer.getInt();
                    if (recordType == 17) {
                        if (JournalImpl.isInvalidSize(journalFileSize, wholeFileBuffer.position(), 4)) {
                            wholeFileBuffer.position(pos + 1);
                            continue;
                        }
                        preparedTransactionExtraDataSize = wholeFileBuffer.getInt();
                    }
                    variableSize = 0;
                }
                if (JournalImpl.isInvalidSize(journalFileSize, pos, (recordSize = JournalImpl.getRecordSize(recordType, file.getJournalVersion())) + variableSize + preparedTransactionExtraDataSize)) {
                    logger.trace((Object)("Record at position " + pos + " recordType = " + recordType + " file:" + file.getFile().getFileName() + " recordSize: " + recordSize + " variableSize: " + variableSize + " preparedTransactionExtraDataSize: " + preparedTransactionExtraDataSize + " is corrupted and it is being ignored (II)"));
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                int oldPos = wholeFileBuffer.position();
                wholeFileBuffer.position(pos + variableSize + recordSize + preparedTransactionExtraDataSize - 4);
                int checkSize = wholeFileBuffer.getInt();
                if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                    logger.trace((Object)("Record at position " + pos + " recordType = " + recordType + " possible transactionID = " + transactionID + " possible recordID = " + recordID + " file:" + file.getFile().getFileName() + " is corrupted and it is being ignored (III)"));
                    reader.markAsDataFile(file);
                    wholeFileBuffer.position(pos + 1);
                    continue;
                }
                wholeFileBuffer.position(oldPos);
                switch (recordType) {
                    case 11: {
                        reader.onReadAddRecord(new RecordInfo(recordID, userRecordType, record, false, compactCount));
                        break;
                    }
                    case 12: {
                        reader.onReadUpdateRecord(new RecordInfo(recordID, userRecordType, record, true, compactCount));
                        break;
                    }
                    case 16: {
                        reader.onReadDeleteRecord(recordID);
                        break;
                    }
                    case 13: {
                        reader.onReadAddRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, false, compactCount));
                        break;
                    }
                    case 14: {
                        reader.onReadUpdateRecordTX(transactionID, new RecordInfo(recordID, userRecordType, record, true, compactCount));
                        break;
                    }
                    case 15: {
                        reader.onReadDeleteRecordTX(transactionID, new RecordInfo(recordID, 0, record, true, compactCount));
                        break;
                    }
                    case 17: {
                        byte[] extraData = new byte[preparedTransactionExtraDataSize];
                        wholeFileBuffer.get(extraData);
                        reader.onReadPrepareRecord(transactionID, extraData, transactionCheckNumberOfRecords);
                        break;
                    }
                    case 18: {
                        reader.onReadCommitRecord(transactionID, transactionCheckNumberOfRecords);
                        break;
                    }
                    case 19: {
                        reader.onReadRollbackRecord(transactionID);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Journal " + file.getFile().getFileName() + " is corrupt, invalid record type " + recordType);
                    }
                }
                checkSize = wholeFileBuffer.getInt();
                if (checkSize != variableSize + recordSize + preparedTransactionExtraDataSize) {
                    throw new IllegalStateException("Internal error on loading file. Position doesn't match with checkSize, file = " + file.getFile() + ", pos = " + pos);
                }
                lastDataPos = wholeFileBuffer.position();
            }
            n = lastDataPos;
            if (wholeFileBuffer != null) {
                fileFactory.releaseBuffer(wholeFileBuffer);
            }
        }
        catch (Throwable e) {
            try {
                ActiveMQJournalLogger.LOGGER.errorReadingFile(e);
                throw new Exception(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (wholeFileBuffer != null) {
                    fileFactory.releaseBuffer(wholeFileBuffer);
                }
                try {
                    file.getFile().close();
                    throw throwable;
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            file.getFile().close();
            return n;
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalAddRecord addRecord = new JournalAddRecord(true, id, recordType, record);
            if (callback != null) {
                callback.storeLineUp();
            }
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(addRecord, false, sync, null, callback);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendAddRecord::id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                }
                this.records.put(id, new JournalRecord(usedFile, ((JournalInternalRecord)addRecord).getEncodeSize()));
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalRecord jrnRecord = (JournalRecord)this.records.get(id);
            if (!(jrnRecord != null || this.compactor != null && this.compactor.lookupRecord(id))) {
                throw new IllegalStateException("Cannot find add info " + id);
            }
            JournalAddRecord updateRecord = new JournalAddRecord(false, id, recordType, record);
            if (callback != null) {
                callback.storeLineUp();
            }
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(updateRecord, false, sync, null, callback);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendUpdateRecord::id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                }
                if (jrnRecord == null) {
                    this.compactor.addCommandUpdate(id, usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize());
                } else {
                    jrnRecord.addUpdateFile(usedFile, ((JournalInternalRecord)updateRecord).getEncodeSize());
                }
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendDeleteRecord(long id, boolean sync, IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalRecord record = null;
            if (this.compactor == null) {
                record = (JournalRecord)this.records.remove(id);
                if (record == null) {
                    throw new IllegalStateException("Cannot find add info " + id);
                }
            } else if (!this.records.containsKey(id) && !this.compactor.lookupRecord(id)) {
                throw new IllegalStateException("Cannot find add info " + id + " on compactor or current records");
            }
            JournalDeleteRecord deleteRecord = new JournalDeleteRecord(id);
            if (callback != null) {
                callback.storeLineUp();
            }
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(deleteRecord, false, sync, null, callback);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendDeleteRecord::id=" + id + ", usedFile = " + usedFile));
                }
                if (record == null) {
                    this.compactor.addCommandDelete(id, usedFile);
                } else {
                    record.delete(usedFile);
                }
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalAddRecordTX addRecord = new JournalAddRecordTX(true, txID, id, recordType, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(addRecord, false, false, tx, null);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendAddRecordTransactional:txID=" + txID + ",id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                }
                tx.addPositive(usedFile, id, ((JournalInternalRecord)addRecord).getEncodeSize());
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    private void checkJournalIsLoaded() {
        if (this.state != Journal.JournalState.LOADED && this.state != Journal.JournalState.SYNCING) {
            throw new IllegalStateException("Journal must be in state=" + (Object)((Object)Journal.JournalState.LOADED) + ", was [" + (Object)((Object)this.state) + "]");
        }
    }

    private void setJournalState(Journal.JournalState newState) {
        this.state = newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, txID, id, recordType, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(updateRecordTX, false, false, tx, null);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendUpdateRecordTransactional::txID=" + txID + ",id=" + id + ", userRecordType=" + recordType + ", record = " + record + ", usedFile = " + usedFile));
                }
                tx.addPositive(usedFile, id, ((JournalInternalRecord)updateRecordTX).getEncodeSize());
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalDeleteRecordTX deleteRecordTX = new JournalDeleteRecordTX(txID, id, record);
            JournalTransaction tx = this.getTransactionInfo(txID);
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(deleteRecordTX, false, false, tx, null);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendDeleteRecordTransactional::txID=" + txID + ", id=" + id + ", usedFile = " + usedFile));
                }
                tx.addNegative(usedFile, id);
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalTransaction tx = this.getTransactionInfo(txID);
            JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.PREPARE, txID, transactionData);
            if (callback != null) {
                callback.storeLineUp();
            }
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(prepareRecord, true, sync, tx, callback);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendPrepareRecord::txID=" + txID + ", usedFile = " + usedFile));
                }
                tx.prepare(usedFile);
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    @Override
    public void lineUpContext(IOCompletion callback) {
        callback.storeLineUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        try {
            JournalTransaction tx = (JournalTransaction)this.transactions.remove(txID);
            if (tx == null) {
                throw new IllegalStateException("Cannot find tx with id " + txID);
            }
            JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(JournalCompleteRecordTX.TX_RECORD_TYPE.COMMIT, txID, null);
            if (callback != null && lineUpContext) {
                callback.storeLineUp();
            }
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(commitRecord, true, sync, tx, callback);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appendCommitRecord::txID=" + txID + ", usedFile = " + usedFile));
                }
                tx.commit(usedFile);
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        this.checkJournalIsLoaded();
        this.journalLock.readLock().lock();
        JournalTransaction tx = null;
        try {
            tx = (JournalTransaction)this.transactions.remove(txID);
            if (tx == null) {
                throw new IllegalStateException("Cannot find tx with id " + txID);
            }
            JournalRollbackRecordTX rollbackRecord = new JournalRollbackRecordTX(txID);
            if (callback != null) {
                callback.storeLineUp();
            }
            Object object = this.lockAppend;
            synchronized (object) {
                JournalFile usedFile = this.appendRecord(rollbackRecord, false, sync, tx, callback);
                tx.rollback(usedFile);
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    @Override
    public int getAlignment() throws Exception {
        return this.fileFactory.getAlignment();
    }

    @Override
    public synchronized JournalLoadInformation loadInternalOnly() throws Exception {
        return this.load(DummyLoader.INSTANCE, true, null);
    }

    @Override
    public synchronized JournalLoadInformation loadSyncOnly(Journal.JournalState syncState) throws Exception {
        assert (syncState == Journal.JournalState.SYNCING || syncState == Journal.JournalState.SYNCING_UP_TO_DATE);
        return this.load(DummyLoader.INSTANCE, true, syncState);
    }

    @Override
    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback failureCallback) throws Exception {
        return this.load(committedRecords, preparedTransactions, failureCallback, true);
    }

    public synchronized JournalLoadInformation load(List<RecordInfo> committedRecords, final List<PreparedTransactionInfo> preparedTransactions, final TransactionFailureCallback failureCallback, boolean fixBadTX) throws Exception {
        final HashSet recordsToDelete = new HashSet();
        final LinkedList records = new LinkedList();
        int DELETE_FLUSH = 20000;
        JournalLoadInformation info = this.load(new LoaderCallback(){
            Runtime runtime = Runtime.getRuntime();

            private void checkDeleteSize() {
                if (recordsToDelete.size() > 20000 && (double)this.runtime.freeMemory() < (double)this.runtime.maxMemory() * 0.2) {
                    ActiveMQJournalLogger.LOGGER.debug("Flushing deletes during loading, deleteCount = " + recordsToDelete.size());
                    Iterator iter = records.iterator();
                    while (iter.hasNext()) {
                        RecordInfo record = (RecordInfo)iter.next();
                        if (!recordsToDelete.contains(record.id)) continue;
                        iter.remove();
                    }
                    recordsToDelete.clear();
                    ActiveMQJournalLogger.LOGGER.debug("flush delete done");
                }
            }

            @Override
            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
                preparedTransactions.add(preparedTransaction);
                this.checkDeleteSize();
            }

            @Override
            public void addRecord(RecordInfo info) {
                records.add(info);
                this.checkDeleteSize();
            }

            @Override
            public void updateRecord(RecordInfo info) {
                records.add(info);
                this.checkDeleteSize();
            }

            @Override
            public void deleteRecord(long id) {
                recordsToDelete.add(id);
                this.checkDeleteSize();
            }

            @Override
            public void failedTransaction(long transactionID, List<RecordInfo> records2, List<RecordInfo> recordsToDelete2) {
                if (failureCallback != null) {
                    failureCallback.failedTransaction(transactionID, records2, recordsToDelete2);
                }
            }
        }, fixBadTX, null);
        for (RecordInfo record : records) {
            if (recordsToDelete.contains(record.id)) continue;
            committedRecords.add(record);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleCompactAndBlock(int timeout) throws Exception {
        final AtomicInteger errors = new AtomicInteger(0);
        final CountDownLatch latch = this.newLatch(1);
        this.compactorRunning.set(true);
        this.compactorExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JournalImpl.this.compact();
                }
                catch (Throwable e) {
                    errors.incrementAndGet();
                    ActiveMQJournalLogger.LOGGER.errorCompacting(e);
                    e.printStackTrace();
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            this.awaitLatch(latch, timeout);
            if (errors.get() > 0) {
                throw new RuntimeException("Error during compact, look at the logs");
            }
        }
        finally {
            this.compactorRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void compact() throws Exception {
        if (this.compactor != null) {
            throw new IllegalStateException("There is pending compacting operation");
        }
        if (ActiveMQJournalLogger.LOGGER.isDebugEnabled()) {
            ActiveMQJournalLogger.LOGGER.debug("JournalImpl::compact compacting journal " + ++this.compactCount);
        }
        this.compactorLock.writeLock().lock();
        try {
            ArrayList<JournalFile> dataFilesToProcess = new ArrayList<JournalFile>(this.filesRepository.getDataFilesCount());
            boolean previousReclaimValue = this.isAutoReclaim();
            try {
                ActiveMQJournalLogger.LOGGER.debug("Starting compacting operation on journal");
                this.onCompactStart();
                this.journalLock.writeLock().lock();
                try {
                    if (this.state != Journal.JournalState.LOADED) {
                        return;
                    }
                    this.onCompactLockingTheJournal();
                    this.setAutoReclaim(false);
                    this.moveNextFile(false);
                    dataFilesToProcess.addAll(this.filesRepository.getDataFiles());
                    this.filesRepository.clearDataFiles();
                    if (dataFilesToProcess.size() == 0) {
                        logger.trace((Object)"Finishing compacting, nothing to process");
                        return;
                    }
                    this.compactor = new JournalCompactor(this.fileFactory, this, this.filesRepository, this.records.keySet(), ((JournalFile)dataFilesToProcess.get(0)).getFileID());
                    for (Map.Entry entry : this.transactions.entrySet()) {
                        this.compactor.addPendingTransaction((Long)entry.getKey(), ((JournalTransaction)entry.getValue()).getPositiveArray());
                        ((JournalTransaction)entry.getValue()).setCompacting();
                    }
                    this.records.clear();
                }
                finally {
                    this.journalLock.writeLock().unlock();
                }
                Collections.sort(dataFilesToProcess, new JournalFileComparator());
                for (JournalFile file : dataFilesToProcess) {
                    try {
                        JournalImpl.readJournalFile(this.fileFactory, file, this.compactor);
                    }
                    catch (Throwable e) {
                        ActiveMQJournalLogger.LOGGER.compactReadError(file);
                        throw new Exception("Error on reading compacting for " + file, e);
                    }
                }
                this.compactor.flush();
                this.onCompactDone();
                List<JournalFile> newDatafiles = null;
                JournalCompactor localCompactor = this.compactor;
                SequentialFile controlFile = this.createControlFile(dataFilesToProcess, this.compactor.getNewDataFiles(), null);
                this.journalLock.writeLock().lock();
                try {
                    this.compactor = null;
                    this.onCompactLockingTheJournal();
                    newDatafiles = localCompactor.getNewDataFiles();
                    for (Map.Entry<Long, JournalRecord> newRecordEntry : localCompactor.getNewRecords().entrySet()) {
                        this.records.put(newRecordEntry.getKey(), newRecordEntry.getValue());
                    }
                    for (int i = newDatafiles.size() - 1; i >= 0; --i) {
                        JournalFile fileToAdd = newDatafiles.get(i);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Adding file " + fileToAdd + " back as datafile"));
                        }
                        this.filesRepository.addDataFileOnTop(fileToAdd);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("There are " + this.filesRepository.getDataFilesCount() + " datafiles Now"));
                    }
                    for (JournalTransaction newTransaction : localCompactor.getNewTransactions().values()) {
                        newTransaction.replaceRecordProvider(this);
                    }
                    localCompactor.replayPendingCommands();
                    for (JournalTransaction newTransaction : localCompactor.getNewTransactions().values()) {
                        JournalTransaction liveTransaction;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Merging pending transaction " + newTransaction + " after compacting the journal"));
                        }
                        if ((liveTransaction = (JournalTransaction)this.transactions.get(newTransaction.getId())) != null) {
                            liveTransaction.merge(newTransaction);
                            continue;
                        }
                        ActiveMQJournalLogger.LOGGER.compactMergeError(newTransaction.getId());
                    }
                }
                finally {
                    this.journalLock.writeLock().unlock();
                }
                this.renameFiles(dataFilesToProcess, newDatafiles);
                this.deleteControlFile(controlFile);
                ActiveMQJournalLogger.LOGGER.debug("Finished compacting on journal");
                return;
            }
            finally {
                if (this.compactor != null) {
                    try {
                        this.compactor.flush();
                    }
                    catch (Throwable ignored) {}
                    this.compactor = null;
                }
                this.setAutoReclaim(previousReclaimValue);
            }
        }
        finally {
            this.compactorLock.writeLock().unlock();
        }
    }

    @Override
    public JournalLoadInformation load(LoaderCallback loadManager) throws Exception {
        return this.load(loadManager, true, null);
    }

    private synchronized JournalLoadInformation load(final LoaderCallback loadManager, boolean changeData, Journal.JournalState replicationSync) throws Exception {
        if (this.state == Journal.JournalState.STOPPED || this.state == Journal.JournalState.LOADED) {
            throw new IllegalStateException("Journal " + this + " must be in " + (Object)((Object)Journal.JournalState.STARTED) + " state, was " + (Object)((Object)this.state));
        }
        if (this.state == replicationSync) {
            throw new IllegalStateException("Journal cannot be in state " + (Object)((Object)Journal.JournalState.STARTED));
        }
        this.checkControlFile();
        this.records.clear();
        this.filesRepository.clear();
        this.transactions.clear();
        this.currentFile = null;
        final LinkedHashMap loadTransactions = new LinkedHashMap();
        final List<JournalFile> orderedFiles = this.orderFiles();
        this.filesRepository.calculateNextfileID(orderedFiles);
        int lastDataPos = 16;
        final AtomicLong maxID = new AtomicLong(-1L);
        for (final JournalFile file : orderedFiles) {
            logger.trace((Object)("Loading file " + file.getFile().getFileName()));
            final AtomicBoolean hasData = new AtomicBoolean(false);
            int resultLastPost = JournalImpl.readJournalFile(this.fileFactory, file, new JournalReaderCallback(){

                private void checkID(long id) {
                    if (id > maxID.longValue()) {
                        maxID.set(id);
                    }
                }

                @Override
                public void onReadAddRecord(RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.set(true);
                    loadManager.addRecord(info);
                    JournalImpl.this.records.put(info.id, new JournalRecord(file, info.data.length + 22 + 1));
                }

                @Override
                public void onReadUpdateRecord(RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.set(true);
                    loadManager.updateRecord(info);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.get(info.id);
                    if (posFiles != null) {
                        posFiles.addUpdateFile(file, info.data.length + 22 + 1);
                    }
                }

                @Override
                public void onReadDeleteRecord(long recordID) throws Exception {
                    hasData.set(true);
                    loadManager.deleteRecord(recordID);
                    JournalRecord posFiles = (JournalRecord)JournalImpl.this.records.remove(recordID);
                    if (posFiles != null) {
                        posFiles.delete(file);
                    }
                }

                @Override
                public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadAddRecordTX(transactionID, info);
                }

                @Override
                public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.checkID(info.id);
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordInfos.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, tnp);
                    }
                    tnp.addPositive(file, info.id, info.data.length + 30 + 1);
                }

                @Override
                public void onReadDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.recordsToDelete.add(info);
                    JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (tnp == null) {
                        tnp = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, tnp);
                    }
                    tnp.addNegative(file, info.id);
                }

                @Override
                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    boolean healthy;
                    hasData.set(true);
                    TransactionHolder tx = (TransactionHolder)loadTransactions.get(transactionID);
                    if (tx == null) {
                        tx = new TransactionHolder(transactionID);
                        loadTransactions.put(transactionID, tx);
                    }
                    tx.prepared = true;
                    tx.extraData = extraData;
                    JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.get(transactionID);
                    if (journalTransaction == null) {
                        journalTransaction = new JournalTransaction(transactionID, JournalImpl.this);
                        JournalImpl.this.transactions.put(transactionID, journalTransaction);
                    }
                    if (healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords)) {
                        journalTransaction.prepare(file);
                    } else {
                        ActiveMQJournalLogger.LOGGER.preparedTXIncomplete(transactionID);
                        tx.invalid = true;
                    }
                }

                @Override
                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    TransactionHolder tx = (TransactionHolder)loadTransactions.remove(transactionID);
                    if (tx != null) {
                        JournalTransaction journalTransaction = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (journalTransaction == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        boolean healthy = JournalImpl.this.checkTransactionHealth(file, journalTransaction, orderedFiles, numberOfRecords);
                        if (healthy) {
                            for (RecordInfo txRecord : tx.recordInfos) {
                                if (txRecord.isUpdate) {
                                    loadManager.updateRecord(txRecord);
                                    continue;
                                }
                                loadManager.addRecord(txRecord);
                            }
                            for (RecordInfo deleteValue : tx.recordsToDelete) {
                                loadManager.deleteRecord(deleteValue.id);
                            }
                            journalTransaction.commit(file);
                        } else {
                            ActiveMQJournalLogger.LOGGER.txMissingElements(transactionID);
                            journalTransaction.forget();
                        }
                        hasData.set(true);
                    }
                }

                @Override
                public void onReadRollbackRecord(long transactionID) throws Exception {
                    TransactionHolder tx = (TransactionHolder)loadTransactions.remove(transactionID);
                    if (tx != null) {
                        JournalTransaction tnp = (JournalTransaction)JournalImpl.this.transactions.remove(transactionID);
                        if (tnp == null) {
                            throw new IllegalStateException("Cannot find tx " + transactionID);
                        }
                        tnp.rollback(file);
                        hasData.set(true);
                    }
                }

                @Override
                public void markAsDataFile(JournalFile file2) {
                    hasData.set(true);
                }
            });
            if (hasData.get()) {
                lastDataPos = resultLastPost;
                this.filesRepository.addDataFileOnBottom(file);
                continue;
            }
            if (!changeData) continue;
            this.filesRepository.addFreeFile(file, false, false);
        }
        if (replicationSync == Journal.JournalState.SYNCING) {
            assert (this.filesRepository.getDataFiles().isEmpty());
            this.setJournalState(Journal.JournalState.SYNCING);
            return new JournalLoadInformation(0, -1L);
        }
        this.setUpCurrentFile(lastDataPos);
        this.setJournalState(Journal.JournalState.LOADED);
        for (TransactionHolder transaction : loadTransactions.values()) {
            if ((!transaction.prepared || transaction.invalid) && replicationSync != Journal.JournalState.SYNCING_UP_TO_DATE) {
                ActiveMQJournalLogger.LOGGER.uncomittedTxFound(transaction.transactionID);
                if (changeData) {
                    this.appendRollbackRecord(transaction.transactionID, false);
                }
                loadManager.failedTransaction(transaction.transactionID, transaction.recordInfos, transaction.recordsToDelete);
                continue;
            }
            for (RecordInfo info : transaction.recordInfos) {
                if (info.id <= maxID.get()) continue;
                maxID.set(info.id);
            }
            PreparedTransactionInfo info = new PreparedTransactionInfo(transaction.transactionID, transaction.extraData);
            info.records.addAll(transaction.recordInfos);
            info.recordsToDelete.addAll(transaction.recordsToDelete);
            loadManager.addPreparedTransaction(info);
        }
        this.checkReclaimStatus();
        return new JournalLoadInformation(this.records.size(), maxID.longValue());
    }

    @Override
    public final boolean checkReclaimStatus() throws Exception {
        if (this.compactorRunning.get()) {
            return false;
        }
        do {
            if (this.state != Journal.JournalState.LOADED) {
                return false;
            }
            if (this.isAutoReclaim()) continue;
            return false;
        } while (!this.journalLock.readLock().tryLock(250L, TimeUnit.MILLISECONDS));
        try {
            this.reclaimer.scan(this.getDataFiles());
            for (JournalFile file : this.filesRepository.getDataFiles()) {
                if (!file.isCanReclaim()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Reclaiming file " + file));
                }
                this.filesRepository.removeDataFile(file);
                this.filesRepository.addFreeFile(file, false);
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
        return false;
    }

    private boolean needsCompact() throws Exception {
        JournalFile[] dataFiles = this.getDataFiles();
        long totalLiveSize = 0L;
        for (JournalFile file : dataFiles) {
            totalLiveSize += (long)file.getLiveSize();
        }
        long totalBytes = (long)dataFiles.length * (long)this.fileSize;
        long compactMargin = (long)((float)totalBytes * this.compactPercentage);
        boolean needCompact = totalLiveSize < compactMargin && dataFiles.length > this.compactMinFiles;
        return needCompact;
    }

    private void checkCompact() throws Exception {
        if (this.compactMinFiles == 0) {
            return;
        }
        if (this.state != Journal.JournalState.LOADED) {
            return;
        }
        if (!this.compactorRunning.get() && this.needsCompact()) {
            this.scheduleCompact();
        }
    }

    private void scheduleCompact() {
        if (!this.compactorRunning.compareAndSet(false, true)) {
            return;
        }
        this.compactorExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JournalImpl.this.compact();
                }
                catch (Throwable e) {
                    ActiveMQJournalLogger.LOGGER.errorCompacting(e);
                }
                finally {
                    JournalImpl.this.compactorRunning.set(false);
                }
            }
        });
    }

    @Override
    public final void setAutoReclaim(boolean autoReclaim) {
        this.autoReclaim = autoReclaim;
    }

    @Override
    public final boolean isAutoReclaim() {
        return this.autoReclaim;
    }

    @Override
    public String debug() throws Exception {
        this.reclaimer.scan(this.getDataFiles());
        StringBuilder builder = new StringBuilder();
        for (JournalFile file : this.filesRepository.getDataFiles()) {
            builder.append("DataFile:" + file + " posCounter = " + file.getPosCount() + " reclaimStatus = " + file.isCanReclaim() + " live size = " + file.getLiveSize() + "\n");
            if (!(file instanceof JournalFileImpl)) continue;
            builder.append(((JournalFileImpl)file).debug());
        }
        for (JournalFile file : this.filesRepository.getFreeFiles()) {
            builder.append("FreeFile:" + file + "\n");
        }
        if (this.currentFile != null) {
            builder.append("CurrentFile:" + this.currentFile + " posCounter = " + this.currentFile.getPosCount() + "\n");
            if (this.currentFile instanceof JournalFileImpl) {
                builder.append(((JournalFileImpl)this.currentFile).debug());
            }
        } else {
            builder.append("CurrentFile: No current file at this point!");
        }
        return builder.toString();
    }

    @Override
    public void debugWait() throws InterruptedException {
        this.fileFactory.flush();
        for (JournalTransaction tx : this.transactions.values()) {
            tx.waitCallbacks();
        }
        if (this.filesExecutor != null && !this.filesExecutor.isShutdown()) {
            final CountDownLatch latch = this.newLatch(1);
            this.filesExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            });
            this.awaitLatch(latch, -1);
        }
    }

    @Override
    public int getDataFilesCount() {
        return this.filesRepository.getDataFilesCount();
    }

    @Override
    public JournalFile[] getDataFiles() {
        return this.filesRepository.getDataFilesArray();
    }

    @Override
    public int getFreeFilesCount() {
        return this.filesRepository.getFreeFilesCount();
    }

    @Override
    public int getOpenedFilesCount() {
        return this.filesRepository.getOpenedFilesCount();
    }

    @Override
    public int getIDMapSize() {
        return this.records.size();
    }

    @Override
    public int getFileSize() {
        return this.fileSize;
    }

    @Override
    public int getMinFiles() {
        return this.minFiles;
    }

    @Override
    public String getFilePrefix() {
        return this.filesRepository.getFilePrefix();
    }

    @Override
    public String getFileExtension() {
        return this.filesRepository.getFileExtension();
    }

    @Override
    public int getMaxAIO() {
        return this.filesRepository.getMaxAIO();
    }

    @Override
    public int getUserVersion() {
        return this.userVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMoveNextFile() throws Exception {
        this.journalLock.readLock().lock();
        try {
            Object object = this.lockAppend;
            synchronized (object) {
                this.moveNextFile(false);
                this.debugWait();
            }
        }
        finally {
            this.journalLock.readLock().unlock();
        }
    }

    @Override
    public void perfBlast(int pages) {
        new PerfBlast(pages).start();
    }

    public synchronized boolean isStarted() {
        return this.state != Journal.JournalState.STOPPED;
    }

    public synchronized void start() {
        if (this.state != Journal.JournalState.STOPPED) {
            throw new IllegalStateException("Journal " + this + " is not stopped, state is " + (Object)((Object)this.state));
        }
        this.filesExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "JournalImpl::FilesExecutor");
            }
        });
        this.compactorExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "JournalImpl::CompactorExecutor");
            }
        });
        this.filesRepository.setExecutor(this.filesExecutor);
        this.fileFactory.start();
        this.setJournalState(Journal.JournalState.STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        if (this.state == Journal.JournalState.STOPPED) {
            throw new IllegalStateException("Journal is already stopped");
        }
        this.journalLock.writeLock().lock();
        try {
            Object object = this.lockAppend;
            synchronized (object) {
                this.setJournalState(Journal.JournalState.STOPPED);
                this.compactorExecutor.shutdown();
                if (!this.compactorExecutor.awaitTermination(120L, TimeUnit.SECONDS)) {
                    ActiveMQJournalLogger.LOGGER.couldNotStopCompactor();
                }
                this.filesExecutor.shutdown();
                this.filesRepository.setExecutor(null);
                if (!this.filesExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    ActiveMQJournalLogger.LOGGER.couldNotStopJournalExecutor();
                }
                try {
                    for (CountDownLatch latch : this.latches) {
                        latch.countDown();
                    }
                }
                catch (Throwable e) {
                    ActiveMQJournalLogger.LOGGER.warn(e.getMessage(), e);
                }
                this.fileFactory.deactivateBuffer();
                if (this.currentFile != null && this.currentFile.getFile().isOpen()) {
                    this.currentFile.getFile().close();
                }
                this.filesRepository.clear();
                this.fileFactory.stop();
                this.currentFile = null;
            }
        }
        finally {
            this.journalLock.writeLock().unlock();
        }
    }

    @Override
    public int getNumberOfRecords() {
        return this.records.size();
    }

    protected SequentialFile createControlFile(List<JournalFile> files, List<JournalFile> newFiles, Pair<String, String> cleanupRename) throws Exception {
        ArrayList<Pair<String, String>> cleanupList;
        if (cleanupRename == null) {
            cleanupList = null;
        } else {
            cleanupList = new ArrayList<Pair<String, String>>();
            cleanupList.add(cleanupRename);
        }
        return AbstractJournalUpdateTask.writeControlFile(this.fileFactory, files, newFiles, cleanupList);
    }

    protected void deleteControlFile(SequentialFile controlFile) throws Exception {
        controlFile.delete();
    }

    protected void renameFiles(final List<JournalFile> oldFiles, List<JournalFile> newFiles) throws Exception {
        final CountDownLatch done = this.newLatch(1);
        this.filesExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (JournalFile file : oldFiles) {
                        try {
                            JournalImpl.this.filesRepository.addFreeFile(file, false);
                        }
                        catch (Throwable e) {
                            ActiveMQJournalLogger.LOGGER.errorReinitializingFile(e, file);
                        }
                    }
                }
                finally {
                    done.countDown();
                }
            }
        });
        this.awaitLatch(done, -1);
        for (JournalFile file : newFiles) {
            String newName = JournalImpl.renameExtensionFile(file.getFile().getFileName(), ".cmp");
            file.getFile().renameTo(newName);
        }
    }

    protected static String renameExtensionFile(String name, String extension) {
        name = name.substring(0, name.lastIndexOf(extension));
        return name;
    }

    protected void onCompactStart() throws Exception {
    }

    protected void onCompactLockingTheJournal() throws Exception {
    }

    protected void onCompactDone() {
    }

    private boolean checkTransactionHealth(JournalFile currentFile, JournalTransaction journalTransaction, List<JournalFile> orderedFiles, int numberOfRecords) {
        return journalTransaction.getCounter(currentFile) == numberOfRecords;
    }

    private static boolean isTransaction(byte recordType) {
        return recordType == 13 || recordType == 14 || recordType == 15 || JournalImpl.isCompleteTransaction(recordType);
    }

    private static boolean isCompleteTransaction(byte recordType) {
        return recordType == 18 || recordType == 17 || recordType == 19;
    }

    private static boolean isContainsBody(byte recordType) {
        return recordType >= 11 && recordType <= 15;
    }

    private static int getRecordSize(byte recordType, int journalVersion) {
        int recordSize = 0;
        switch (recordType) {
            case 11: {
                recordSize = 22;
                break;
            }
            case 12: {
                recordSize = 22;
                break;
            }
            case 13: {
                recordSize = 30;
                break;
            }
            case 14: {
                recordSize = 30;
                break;
            }
            case 16: {
                recordSize = 17;
                break;
            }
            case 15: {
                recordSize = 29;
                break;
            }
            case 17: {
                recordSize = 25;
                break;
            }
            case 18: {
                recordSize = 21;
                break;
            }
            case 19: {
                recordSize = 17;
                break;
            }
            default: {
                throw new IllegalStateException("Record other than expected");
            }
        }
        if (journalVersion >= 2) {
            return recordSize + 1;
        }
        return recordSize;
    }

    private JournalFileImpl readFileHeader(SequentialFile file) throws Exception {
        int readUserVersion;
        ByteBuffer bb = this.fileFactory.newBuffer(16);
        file.read(bb);
        int journalVersion = bb.getInt();
        if (journalVersion != 2) {
            boolean isCompatible = false;
            for (int v : COMPATIBLE_VERSIONS) {
                if (v != journalVersion) continue;
                isCompatible = true;
            }
            if (!isCompatible) {
                throw ActiveMQJournalBundle.BUNDLE.journalFileMisMatch();
            }
        }
        if ((readUserVersion = bb.getInt()) != this.userVersion) {
            throw ActiveMQJournalBundle.BUNDLE.journalDifferentVersion();
        }
        long fileID = bb.getLong();
        this.fileFactory.releaseBuffer(bb);
        bb = null;
        return new JournalFileImpl(file, fileID, journalVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int initFileHeader(SequentialFileFactory fileFactory, SequentialFile sequentialFile, int userVersion, long fileID) throws Exception {
        ByteBuffer bb = fileFactory.newBuffer(16);
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)bb);
        try {
            JournalImpl.writeHeader(buffer, userVersion, fileID);
            bb.rewind();
            int bufferSize = bb.limit();
            sequentialFile.position(0L);
            sequentialFile.writeDirect(bb, true);
            int n = bufferSize;
            return n;
        }
        finally {
            buffer.byteBuf().unwrap().release();
        }
    }

    public static void writeHeader(ActiveMQBuffer buffer, int userVersion, long fileID) {
        buffer.writeInt(2);
        buffer.writeInt(userVersion);
        buffer.writeLong(fileID);
    }

    private JournalFile appendRecord(JournalInternalRecord encoder, boolean completeTransaction, boolean sync, JournalTransaction tx, IOCallback parameterCallback) throws Exception {
        IOCallback callback;
        this.checkJournalIsLoaded();
        int size = encoder.getEncodeSize();
        this.switchFileIfNecessary(size);
        if (tx != null) {
            if (this.fileFactory.isSupportsCallbacks()) {
                TransactionCallback txcallback = tx.getCallback(this.currentFile);
                if (parameterCallback != null) {
                    txcallback.setDelegateCompletion(parameterCallback);
                }
                callback = txcallback;
            } else {
                callback = null;
            }
            if (completeTransaction) {
                tx.fillNumberOfRecords(this.currentFile, encoder);
            }
        } else {
            callback = parameterCallback;
        }
        encoder.setFileID(this.currentFile.getRecordID());
        if (callback != null) {
            this.currentFile.getFile().write(encoder, sync, callback);
        } else {
            this.currentFile.getFile().write(encoder, sync);
        }
        return this.currentFile;
    }

    @Override
    void scheduleReclaim() {
        if (this.state != Journal.JournalState.LOADED) {
            return;
        }
        if (this.isAutoReclaim() && !this.compactorRunning.get()) {
            this.compactorExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!JournalImpl.this.checkReclaimStatus()) {
                            JournalImpl.this.checkCompact();
                        }
                    }
                    catch (Exception e) {
                        ActiveMQJournalLogger.LOGGER.errorSchedulingCompacting(e);
                    }
                }
            });
        }
    }

    private JournalTransaction getTransactionInfo(long txID) {
        JournalTransaction tx = (JournalTransaction)this.transactions.get(txID);
        if (tx == null) {
            tx = new JournalTransaction(txID, this);
            JournalTransaction trans = this.transactions.putIfAbsent(txID, tx);
            if (trans != null) {
                tx = trans;
            }
        }
        return tx;
    }

    private void checkControlFile() throws Exception {
        ArrayList<String> dataFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        ArrayList<Pair<String, String>> renames = new ArrayList<Pair<String, String>>();
        SequentialFile controlFile = JournalCompactor.readControlFile(this.fileFactory, dataFiles, newFiles, renames);
        if (controlFile != null) {
            SequentialFile file;
            for (String string : dataFiles) {
                file = this.fileFactory.createSequentialFile(string);
                if (!file.exists()) continue;
                file.delete();
            }
            for (String string : newFiles) {
                file = this.fileFactory.createSequentialFile(string);
                if (!file.exists()) continue;
                String originalName = file.getFileName();
                String newName = originalName.substring(0, originalName.lastIndexOf(".cmp"));
                file.renameTo(newName);
            }
            for (Pair pair : renames) {
                SequentialFile fileTmp = this.fileFactory.createSequentialFile((String)pair.getA());
                SequentialFile fileTo = this.fileFactory.createSequentialFile((String)pair.getB());
                if (!fileTmp.exists()) continue;
                fileTo.delete();
                fileTmp.renameTo((String)pair.getB());
            }
            controlFile.delete();
        }
        this.cleanupTmpFiles(".cmp");
        this.cleanupTmpFiles(".tmp");
    }

    private void cleanupTmpFiles(String extension) throws Exception {
        List<String> leftFiles = this.fileFactory.listFiles(this.getFileExtension() + extension);
        if (leftFiles.size() > 0) {
            ActiveMQJournalLogger.LOGGER.tempFilesLeftOpen();
            for (String fileToDelete : leftFiles) {
                ActiveMQJournalLogger.LOGGER.deletingOrphanedFile(fileToDelete);
                SequentialFile file = this.fileFactory.createSequentialFile(fileToDelete);
                file.delete();
            }
        }
    }

    private static boolean isInvalidSize(int fileSize, int bufferPos, int size) {
        if (size < 0) {
            return true;
        }
        int position = bufferPos + size;
        return position > fileSize || position < 0;
    }

    @Override
    public final void synchronizationLock() {
        this.compactorLock.writeLock().lock();
        this.journalLock.writeLock().lock();
    }

    @Override
    public final void synchronizationUnlock() {
        try {
            this.compactorLock.writeLock().unlock();
        }
        finally {
            this.journalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        this.synchronizationLock();
        try {
            HashMap<Long, JournalFile> map = new HashMap<Long, JournalFile>();
            long maxID = -1L;
            for (long id : fileIds) {
                maxID = Math.max(maxID, id);
                map.put(id, this.filesRepository.createRemoteBackupSyncFile(id));
            }
            this.filesRepository.setNextFileID(maxID);
            HashMap<Long, JournalFile> hashMap = map;
            return hashMap;
        }
        finally {
            this.synchronizationUnlock();
        }
    }

    @Override
    public SequentialFileFactory getFileFactory() {
        return this.fileFactory;
    }

    protected JournalFile setUpCurrentFile(int lastDataPos) throws Exception {
        this.filesRepository.ensureMinFiles();
        this.currentFile = this.filesRepository.pollLastDataFile();
        if (this.currentFile != null) {
            if (!this.currentFile.getFile().isOpen()) {
                this.currentFile.getFile().open();
            }
            this.currentFile.getFile().position(this.currentFile.getFile().calculateBlockStart(lastDataPos));
        } else {
            this.currentFile = this.filesRepository.getFreeFile();
            this.filesRepository.openFile(this.currentFile, true);
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
        this.filesRepository.pushOpenedFile();
        return this.currentFile;
    }

    protected JournalFile switchFileIfNecessary(int size) throws Exception {
        if (size > this.fileSize - this.currentFile.getFile().calculateBlockStart(16)) {
            throw new IllegalArgumentException("Record is too large to store " + size);
        }
        if (!this.currentFile.getFile().fits(size)) {
            this.moveNextFile(true);
            if (!this.currentFile.getFile().fits(size)) {
                throw new IllegalStateException("Invalid logic on buffer allocation");
            }
        }
        return this.currentFile;
    }

    private CountDownLatch newLatch(int countDown) {
        if (this.state == Journal.JournalState.STOPPED) {
            throw new RuntimeException("Server is not started");
        }
        CountDownLatch latch = new CountDownLatch(countDown);
        this.latches.add((Object)latch);
        return latch;
    }

    private void awaitLatch(CountDownLatch latch, int timeout) throws InterruptedException {
        try {
            if (timeout < 0) {
                latch.await();
            } else {
                latch.await(timeout, TimeUnit.SECONDS);
            }
            if (this.state == Journal.JournalState.STOPPED) {
                throw new RuntimeException("Server is not started");
            }
        }
        finally {
            this.latches.remove((Object)latch);
        }
    }

    private void moveNextFile(boolean scheduleReclaim) throws Exception {
        this.filesRepository.closeFile(this.currentFile);
        this.currentFile = this.filesRepository.openFile();
        if (scheduleReclaim) {
            this.scheduleReclaim();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Moving next file " + this.currentFile));
        }
        this.fileFactory.activateBuffer(this.currentFile.getFile());
    }

    @Override
    public void replicationSyncPreserveOldFiles() {
        this.setAutoReclaim(false);
    }

    @Override
    public void replicationSyncFinished() {
        this.setAutoReclaim(true);
    }

    @Override
    public void testCompact() {
        try {
            this.scheduleCompactAndBlock(60);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getCompactCount() {
        return this.compactCount;
    }

    private final class PerfBlast
    extends Thread {
        private final int pages;

        private PerfBlast(int pages) {
            super("activemq-perfblast-thread");
            this.pages = pages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = JournalImpl.this.lockAppend;
            synchronized (object) {
                try {
                    final ByteArrayEncoding byteEncoder = new ByteArrayEncoding(new byte[131072]);
                    JournalInternalRecord blastRecord = new JournalInternalRecord(){

                        @Override
                        public int getEncodeSize() {
                            return byteEncoder.getEncodeSize();
                        }

                        @Override
                        public void encode(ActiveMQBuffer buffer) {
                            byteEncoder.encode(buffer);
                        }
                    };
                    for (int i = 0; i < this.pages; ++i) {
                        JournalImpl.this.appendRecord(blastRecord, false, false, null, null);
                    }
                }
                catch (Exception e) {
                    ActiveMQJournalLogger.LOGGER.failedToPerfBlast(e);
                }
            }
        }
    }

    private static final class JournalFileComparator
    implements Comparator<JournalFile>,
    Serializable {
        private static final long serialVersionUID = -6264728973604070321L;

        private JournalFileComparator() {
        }

        @Override
        public int compare(JournalFile f1, JournalFile f2) {
            long id2;
            long id1 = f1.getFileID();
            return id1 < (id2 = f2.getFileID()) ? -1 : (id1 == id2 ? 0 : 1);
        }
    }

    private static final class TransactionHolder {
        public final long transactionID;
        public final List<RecordInfo> recordInfos = new ArrayList<RecordInfo>();
        public final List<RecordInfo> recordsToDelete = new ArrayList<RecordInfo>();
        public boolean prepared;
        public boolean invalid;
        public byte[] extraData;

        public TransactionHolder(long id) {
            this.transactionID = id;
        }
    }

    private static final class DummyLoader
    implements LoaderCallback {
        static final LoaderCallback INSTANCE = new DummyLoader();

        private DummyLoader() {
        }

        @Override
        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }

        @Override
        public void updateRecord(RecordInfo info) {
        }

        @Override
        public void deleteRecord(long id) {
        }

        @Override
        public void addRecord(RecordInfo info) {
        }

        @Override
        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        }
    }
}

