/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AcceptorControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationBrokerPlugin;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.LegacyJMSConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryDatabase;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.AbstractPersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedBridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedConnector;
import org.apache.activemq.artemis.core.persistence.config.PersistedDivertConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedSecuritySetting;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.persistence.impl.journal.JDBCJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.remoting.server.impl.RemotingServiceImpl;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.security.impl.SecurityStoreImpl;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActivationFailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MemoryManager;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.PostQueueCreationCallback;
import org.apache.activemq.artemis.core.server.PostQueueDeletionCallback;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.federation.FederationManager;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.GroupHandlingAbstract;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.group.impl.LocalGroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.RemoteGroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.ConnectorsService;
import org.apache.activemq.artemis.core.server.impl.DivertImpl;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.impl.QueueConfigurationUtils;
import org.apache.activemq.artemis.core.server.impl.QueueFactoryImpl;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.impl.ServerInfo;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.impl.ServerStatus;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistryImpl;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcNodeManager;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.impl.ManagementServiceImpl;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQPluginRunnable;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBridgePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConnectionPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerCriticalPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerFederationPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerMessagePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerResourcePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerSessionPlugin;
import org.apache.activemq.artemis.core.server.reload.ReloadCallback;
import org.apache.activemq.artemis.core.server.reload.ReloadManager;
import org.apache.activemq.artemis.core.server.reload.ReloadManagerImpl;
import org.apache.activemq.artemis.core.server.replay.ReplayManager;
import org.apache.activemq.artemis.core.server.routing.ConnectionRouterManager;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.impl.ResourceManagerImpl;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ActiveMQThreadPoolExecutor;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.PemConfigUtil;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SecurityFormatter;
import org.apache.activemq.artemis.utils.ThreadDumpUtil;
import org.apache.activemq.artemis.utils.TimeUtils;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.artemis.utils.critical.CriticalAction;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerImpl;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQServerImpl
implements ActiveMQServer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String INTERNAL_NAMING_PREFIX = "$.artemis.internal";
    @Deprecated
    public static final String GENERIC_IGNORED_FILTER = "__AMQX=-1";
    private HAPolicy haPolicy;
    private boolean rebuildCounters = true;
    private volatile ActiveMQServer.SERVER_STATE state = ActiveMQServer.SERVER_STATE.STOPPED;
    private final Version version;
    private ActiveMQSecurityManager securityManager;
    private final Configuration configuration;
    private final AtomicBoolean configurationReloadDeployed;
    private MBeanServer mbeanServer;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    protected volatile ScheduledExecutorService scheduledPool;
    protected volatile ExecutorFactory executorFactory;
    private volatile ExecutorService ioExecutorPool;
    private ReplayManager replayManager;
    private final ReentrantLock managementLock = new ReentrantLock();
    protected volatile ExecutorFactory ioExecutorFactory;
    protected volatile ExecutorFactory pageExecutorFactory;
    protected volatile ExecutorService pageExecutorPool;
    private final NetworkHealthCheck networkHealthCheck = new NetworkHealthCheck(ActiveMQDefaultConfiguration.getDefaultNetworkCheckNic(), ActiveMQDefaultConfiguration.getDefaultNetworkCheckPeriod(), ActiveMQDefaultConfiguration.getDefaultNetworkCheckTimeout());
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile MetricsManager metricsManager;
    private volatile ActiveMQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile BackupManager backupManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private volatile ConnectionRouterManager connectionRouterManager;
    private final List<ProtocolManagerFactory> protocolManagerFactories = new ArrayList<ProtocolManagerFactory>();
    private final List<ActiveMQComponent> protocolServices = new ArrayList<ActiveMQComponent>();
    private volatile ManagementService managementService;
    private volatile MirrorController mirrorControllerService;
    private volatile ConnectorsService connectorsService;
    private MemoryManager memoryManager;
    private ReloadManager reloadManager;
    private FileStoreMonitor fileStoreMonitor;
    private final ConcurrentMap<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final Semaphore activationLock = new Semaphore(1);
    private final ReusableLatch activationLatch = new ReusableLatch(0);
    private final Map<String, BrokerConnection> brokerConnectionMap = new ConcurrentHashMap<String, BrokerConnection>();
    private final Set<ActivateCallback> activateCallbacks = new ConcurrentHashSet();
    private final Set<ActivationFailureListener> activationFailureListeners = new ConcurrentHashSet();
    private final Set<IOCriticalErrorListener> ioCriticalErrorListeners = new ConcurrentHashSet();
    private final Set<PostQueueCreationCallback> postQueueCreationCallbacks = new ConcurrentHashSet();
    private final Set<PostQueueDeletionCallback> postQueueDeletionCallbacks = new ConcurrentHashSet();
    private volatile GroupingHandler groupingHandler;
    private NodeManager nodeManager;
    private String identity;
    private Thread activationThread;
    private Activation activation;
    private final Map<String, Object> activationParams = new HashMap<String, Object>();
    protected final IOCriticalErrorListener ioCriticalErrorListener = new DefaultCriticalErrorListener();
    private final ActiveMQServer parentServer;
    private CriticalAnalyzer analyzer;
    private Runnable afterActivationCreated;
    private final List<SimpleString> scaledDownNodeIDs = new ArrayList<SimpleString>();
    private boolean threadPoolSupplied = false;
    private boolean scheduledPoolSupplied = false;
    private final ServiceRegistry serviceRegistry;
    private Date startDate;
    private final List<ActiveMQComponent> externalComponents = new ArrayList<ActiveMQComponent>();
    private final ConcurrentMap<String, AtomicInteger> connectedClientIds = new ConcurrentHashMap<String, AtomicInteger>();
    private volatile FederationManager federationManager;
    private String propertiesFileUrl;
    private List<Consumer<RecordInfo>> extraRecordsLoader;
    private final ActiveMQComponent networkCheckMonitor = new ActiveMQComponent(){

        public void start() throws Exception {
            ActiveMQServerImpl.this.internalStart();
        }

        public void stop() throws Exception {
            ActiveMQServerImpl.this.stop(false);
        }

        public String toString() {
            return ActiveMQServerImpl.this.toString();
        }

        public boolean isStarted() {
            return ActiveMQServerImpl.this.isStarted();
        }
    };
    private final ServerStatus serverStatus;

    public ActiveMQServerImpl() {
        this(null, null, null);
    }

    public ActiveMQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public ActiveMQServerImpl(Configuration configuration, ActiveMQServer parentServer) {
        this(configuration, null, null, parentServer);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public ActiveMQServerImpl(Configuration configuration, ActiveMQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager) {
        this(configuration, mbeanServer, securityManager, null);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager, ActiveMQServer parentServer) {
        this(configuration, mbeanServer, securityManager, parentServer, null);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager, ActiveMQServer parentServer, ServiceRegistry serviceRegistry) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        } else {
            ConfigurationUtils.validateConfiguration(configuration);
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.configurationReloadDeployed = new AtomicBoolean(true);
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>(configuration.getWildcardConfiguration(), new HierarchicalObjectRepository.MatchModifier(){

            @Override
            public String modify(String input) {
                return CompositeAddress.extractAddressName((String)input);
            }
        }, this.configuration.getLiteralMatchMarkers());
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>(configuration.getWildcardConfiguration());
        this.securityRepository.setDefault(new HashSet());
        this.parentServer = parentServer;
        this.serviceRegistry = serviceRegistry == null ? new ServiceRegistryImpl() : serviceRegistry;
        this.serverStatus = ServerStatus.getInstanceFor(this);
    }

    @Override
    public ReloadManager getReloadManager() {
        return this.reloadManager;
    }

    @Override
    public NetworkHealthCheck getNetworkHealthCheck() {
        return this.networkHealthCheck;
    }

    @Override
    public void setRebuildCounters(boolean rebuildCounters) {
        this.rebuildCounters = rebuildCounters;
    }

    @Override
    public boolean isRebuildCounters() {
        return this.rebuildCounters;
    }

    @Override
    public void replay(Date start, Date end, String address, String target, String filter) throws Exception {
        if (this.replayManager == null) {
            throw ActiveMQMessageBundle.BUNDLE.noRetention();
        }
        try (AutoCloseable lock = this.managementLock();){
            this.replayManager.replay(start, end, address, target, filter);
        }
    }

    @Override
    public void registerRecordsLoader(Consumer<RecordInfo> recordsLoader) {
        if (this.extraRecordsLoader == null) {
            this.extraRecordsLoader = new ArrayList<Consumer<RecordInfo>>();
        }
        this.extraRecordsLoader.add(recordsLoader);
    }

    public Runnable getAfterActivationCreated() {
        return this.afterActivationCreated;
    }

    public ActiveMQServerImpl setAfterActivationCreated(Runnable afterActivationCreated) {
        this.afterActivationCreated = afterActivationCreated;
        return this;
    }

    private void configureJdbcNetworkTimeout() {
        if (this.configuration.isPersistenceEnabled() && this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
            this.configuration.setMaxDiskUsage(-1);
            DatabaseStorageConfiguration databaseStorageConfiguration = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
            databaseStorageConfiguration.setConnectionProviderNetworkTimeout(this.threadPool, databaseStorageConfiguration.getJdbcNetworkTimeout());
        }
    }

    private void clearJdbcNetworkTimeout() {
        if (this.configuration.isPersistenceEnabled() && this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
            DatabaseStorageConfiguration databaseStorageConfiguration = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
            databaseStorageConfiguration.clearConnectionProviderNetworkTimeout();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected NodeManager createNodeManager(File directory, boolean replicatingBackup) {
        void var3_8;
        if (!this.configuration.isPersistenceEnabled()) {
            InVMNodeManager inVMNodeManager = new InVMNodeManager(replicatingBackup);
            return var3_8;
        } else if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
            HAPolicyConfiguration.TYPE haType;
            HAPolicyConfiguration.TYPE tYPE = haType = this.configuration.getHAPolicyConfiguration() == null ? null : this.configuration.getHAPolicyConfiguration().getType();
            if (haType == HAPolicyConfiguration.TYPE.SHARED_STORE_PRIMARY || haType == HAPolicyConfiguration.TYPE.SHARED_STORE_BACKUP) {
                if (replicatingBackup) {
                    throw new IllegalArgumentException("replicatingBackup is not supported yet while using JDBC persistence");
                }
                DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
                JdbcNodeManager jdbcNodeManager = JdbcNodeManager.with(dbConf, this.scheduledPool, this.executorFactory);
                return var3_8;
            } else {
                if (haType != null && haType != HAPolicyConfiguration.TYPE.PRIMARY_ONLY) throw new IllegalArgumentException("JDBC persistence allows only Shared Store HA options");
                logger.debug("Detected no Shared Store HA options on JDBC store");
                FileLockNodeManager fileLockNodeManager = new FileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout(), this.scheduledPool);
            }
            return var3_8;
        } else {
            FileLockNodeManager fileLockNodeManager = new FileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout(), this.scheduledPool);
        }
        return var3_8;
    }

    @Override
    public OperationContext newOperationContext() {
        return this.getStorageManager().newContext((Executor)this.getExecutorFactory().getExecutor());
    }

    public final synchronized void start() throws Exception {
        ActiveMQServer.SERVER_STATE originalState = this.state;
        try {
            this.internalStart();
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.failedToStartServer(t);
            throw t;
        }
        finally {
            if (originalState == ActiveMQServer.SERVER_STATE.STOPPED) {
                this.reloadNetworkHealthCheck();
            }
        }
    }

    public void reloadNetworkHealthCheck() {
        this.networkHealthCheck.setTimeUnit(TimeUnit.MILLISECONDS).setPeriod(this.configuration.getNetworkCheckPeriod()).setNetworkTimeout(this.configuration.getNetworkCheckTimeout()).setNICName(this.configuration.getNetworkCheckNIC()).setIpv4Command(this.configuration.getNetworkCheckPingCommand()).setIpv6Command(this.configuration.getNetworkCheckPing6Command()).parseAddressList(this.configuration.getNetworkCheckList()).parseURIList(this.configuration.getNetworkCheckURLList());
        this.networkHealthCheck.addComponent(this.networkCheckMonitor);
    }

    @Override
    public CriticalAnalyzer getCriticalAnalyzer() {
        return this.analyzer;
    }

    @Override
    public void setProperties(String fileUrltoBrokerProperties) {
        this.propertiesFileUrl = fileUrltoBrokerProperties;
    }

    @Override
    public String getStatus() {
        return this.serverStatus.asJson();
    }

    @Override
    public void updateStatus(String component, String statusJson) {
        this.serverStatus.update(component, statusJson);
    }

    private void internalStart() throws Exception {
        if (this.state != ActiveMQServer.SERVER_STATE.STOPPED) {
            logger.debug("Server already started!");
            return;
        }
        this.configuration.parseProperties(this.propertiesFileUrl);
        this.updateStatus("configuration", this.configuration.getStatus());
        this.initializeExecutorServices();
        this.initializeCriticalAnalyzer();
        this.replayManager = this.configuration.getJournalRetentionLocation() != null ? new ReplayManager(this) : null;
        this.startDate = new Date();
        this.state = ActiveMQServer.SERVER_STATE.STARTING;
        if (this.haPolicy == null) {
            this.haPolicy = ConfigurationUtils.getHAPolicy(this.configuration.getHAPolicyConfiguration(), this);
        }
        this.activationLatch.setCount(1);
        logger.debug("Starting server {}", (Object)this);
        OperationContextImpl.clearContext();
        try {
            boolean wasPrimary;
            this.checkJournalDirectory();
            this.configureJdbcNetworkTimeout();
            this.nodeManager = this.createNodeManager(this.configuration.getNodeManagerLockLocation(), false);
            try {
                this.nodeManager.start();
            }
            catch (Exception e) {
                this.stopTheServer(true);
                throw e;
            }
            ActiveMQServerLogger.LOGGER.serverStarting(this.haPolicy.isBackup() ? "Backup" : "Primary", this.configuration);
            boolean bl = wasPrimary = !this.haPolicy.isBackup();
            if (!this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.createActivation(this, false, this.activationParams, this.ioCriticalErrorListener);
                if (this.afterActivationCreated != null) {
                    try {
                        this.afterActivationCreated.run();
                    }
                    catch (Throwable e) {
                        logger.warn(e.getMessage(), e);
                    }
                    this.afterActivationCreated = null;
                }
                if (this.haPolicy.isWaitForActivation()) {
                    this.activation.run();
                } else {
                    logger.trace("starting activation");
                    this.activationThread = new ActivationThread((Runnable)this.activation, ActiveMQMessageBundle.BUNDLE.activationForServer(this));
                    this.activationThread.start();
                }
            }
            if (this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.isSharedStore() ? this.haPolicy.createActivation(this, false, this.activationParams, this.ioCriticalErrorListener) : this.haPolicy.createActivation(this, wasPrimary, this.activationParams, this.ioCriticalErrorListener);
                if (this.afterActivationCreated != null) {
                    try {
                        this.afterActivationCreated.run();
                    }
                    catch (Throwable e) {
                        logger.warn(e.getMessage(), e);
                    }
                    this.afterActivationCreated = null;
                }
                logger.trace("starting backupActivation");
                this.activationThread = new ActivationThread((Runnable)this.activation, ActiveMQMessageBundle.BUNDLE.activationForServer(this));
                this.activationThread.start();
            } else {
                ActiveMQServerLogger.LOGGER.serverStarted(this.getVersion().getFullVersion(), this.configuration.getName(), this.nodeManager.getNodeId(), this.identity != null ? this.identity : "");
            }
            this.connectorsService = new ConnectorsService(this.configuration, this.storageManager, this.scheduledPool, this.postOffice, this.serviceRegistry);
            this.connectorsService.start();
        }
        finally {
            OperationContextImpl.clearContext();
        }
    }

    private void takingLongToStart(Object criticalComponent) {
        ActiveMQServerLogger.LOGGER.tooLongToStart(criticalComponent);
        this.threadDump();
    }

    protected void initializeCriticalAnalyzer() throws Exception {
        Object analyzer = this.getCriticalAnalyzer();
        if (analyzer == null) {
            analyzer = this.configuration.isCriticalAnalyzer() ? new CriticalAnalyzerImpl() : EmptyCriticalAnalyzer.getInstance();
            this.analyzer = analyzer;
        }
        analyzer.clear();
        analyzer.setCheckTime(this.configuration.getCriticalAnalyzerCheckPeriod(), TimeUnit.MILLISECONDS).setTimeout(this.configuration.getCriticalAnalyzerTimeout(), TimeUnit.MILLISECONDS);
        if (this.configuration.isCriticalAnalyzer()) {
            analyzer.start();
        }
        CriticalAction criticalAction = null;
        CriticalAnalyzerPolicy criticalAnalyzerPolicy = this.configuration.getCriticalAnalyzerPolicy();
        switch (criticalAnalyzerPolicy) {
            case HALT: {
                criticalAction = criticalComponent -> {
                    if (this.state == ActiveMQServer.SERVER_STATE.STARTING) {
                        this.takingLongToStart(criticalComponent);
                    } else {
                        ActiveMQServerImpl.checkCriticalAnalyzerLogging();
                        ActiveMQServerLogger.LOGGER.criticalSystemHalt(criticalComponent);
                        this.threadDump();
                        this.sendCriticalNotification(criticalComponent);
                        Runtime.getRuntime().halt(70);
                    }
                };
                break;
            }
            case SHUTDOWN: {
                criticalAction = criticalComponent -> {
                    if (this.state == ActiveMQServer.SERVER_STATE.STARTING) {
                        this.takingLongToStart(criticalComponent);
                    } else {
                        ActiveMQServerImpl.checkCriticalAnalyzerLogging();
                        ActiveMQServerLogger.LOGGER.criticalSystemShutdown(criticalComponent);
                        this.threadDump();
                        this.sendCriticalNotification(criticalComponent);
                        Thread stopThread = new Thread(() -> {
                            try {
                                this.stop();
                            }
                            catch (Throwable e) {
                                logger.warn(e.getMessage(), e);
                            }
                        });
                        stopThread.start();
                    }
                };
                break;
            }
            case LOG: {
                criticalAction = criticalComponent -> {
                    if (this.state == ActiveMQServer.SERVER_STATE.STARTING) {
                        this.takingLongToStart(criticalComponent);
                    } else {
                        ActiveMQServerImpl.checkCriticalAnalyzerLogging();
                        ActiveMQServerLogger.LOGGER.criticalSystemLog(criticalComponent);
                        this.threadDump();
                        this.sendCriticalNotification(criticalComponent);
                    }
                };
            }
        }
        analyzer.addAction(criticalAction);
    }

    private static void checkCriticalAnalyzerLogging() {
        Logger criticalLogger = LoggerFactory.getLogger((String)"org.apache.activemq.artemis.utils.critical");
        if (!criticalLogger.isTraceEnabled()) {
            ActiveMQServerLogger.LOGGER.enableTraceForCriticalAnalyzer();
        }
    }

    private void sendCriticalNotification(CriticalComponent criticalComponent) {
        long timeout = this.configuration.getGracefulShutdownTimeout() < 0L ? 30000L : this.configuration.getGracefulShutdownTimeout();
        Thread notificationSender = new Thread(() -> {
            try {
                if (this.hasBrokerCriticalPlugins()) {
                    this.callBrokerCriticalPlugins(plugin -> plugin.criticalFailure(criticalComponent));
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
        });
        notificationSender.start();
        try {
            notificationSender.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void unlockActivation() {
        this.activationLock.release();
    }

    @Override
    public void lockActivation() {
        try {
            this.activationLock.acquire();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToAcquireLock(e);
        }
    }

    @Override
    public void setState(ActiveMQServer.SERVER_STATE state) {
        this.state = state;
    }

    @Override
    public ActiveMQServer.SERVER_STATE getState() {
        return this.state;
    }

    public void interruptActivationThread(NodeManager nodeManagerInUse) throws InterruptedException {
        long timeout = 30000L;
        long start = System.currentTimeMillis();
        while (this.activationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
            if (nodeManagerInUse != null) {
                nodeManagerInUse.interrupt();
            }
            this.activationThread.interrupt();
            this.activationThread.join(1000L);
        }
        if (System.currentTimeMillis() - start >= timeout) {
            ActiveMQServerLogger.LOGGER.activationTimeout();
            this.threadDump();
        }
    }

    public void resetNodeManager() throws Exception {
        if (this.nodeManager != null) {
            this.nodeManager.stop();
        }
        this.nodeManager = this.createNodeManager(this.configuration.getNodeManagerLockLocation(), true);
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public HAPolicy getHAPolicy() {
        return this.haPolicy;
    }

    @Override
    public void setHAPolicy(HAPolicy haPolicy) {
        logger.trace("Setting {}, isBackup={} at {}", new Object[]{haPolicy, haPolicy.isBackup(), this});
        this.haPolicy = haPolicy;
    }

    @Override
    public void setMBeanServer(MBeanServer mbeanServer) {
        if (this.state == ActiveMQServer.SERVER_STATE.STARTING || this.state == ActiveMQServer.SERVER_STATE.STARTED) {
            throw ActiveMQMessageBundle.BUNDLE.cannotSetMBeanserver();
        }
        this.mbeanServer = mbeanServer;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public void setSecurityManager(ActiveMQSecurityManager securityManager) {
        if (this.state == ActiveMQServer.SERVER_STATE.STARTING || this.state == ActiveMQServer.SERVER_STATE.STARTED) {
            throw ActiveMQMessageBundle.BUNDLE.cannotSetSecurityManager();
        }
        this.securityManager = securityManager;
    }

    private void validateAddExternalComponent(ActiveMQComponent externalComponent) {
        ActiveMQServer.SERVER_STATE state = this.state;
        if (state == ActiveMQServer.SERVER_STATE.STOPPED || state == ActiveMQServer.SERVER_STATE.STOPPING) {
            throw new IllegalStateException("cannot add " + externalComponent.getClass().getSimpleName() + " if state is " + state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExternalComponent(ActiveMQComponent externalComponent, boolean start) throws Exception {
        List<ActiveMQComponent> list = this.externalComponents;
        synchronized (list) {
            this.validateAddExternalComponent(externalComponent);
            this.externalComponents.add(externalComponent);
            if (start) {
                externalComponent.start();
            }
        }
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public final void stopTheServer(boolean criticalIOError) {
        Thread thread = new Thread(() -> {
            try {
                this.stop(false, criticalIOError, false);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingServer(e);
            }
        });
        thread.start();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean isShutdown) throws Exception {
        try {
            this.stop(false, isShutdown);
        }
        finally {
            if (isShutdown) {
                this.networkHealthCheck.stop();
            }
        }
    }

    @Override
    public void addActivationParam(String key, Object val) {
        this.activationParams.put(key, val);
    }

    @Override
    public boolean isAddressBound(String address) throws Exception {
        return this.postOffice.isAddressBound(SimpleString.of((String)address));
    }

    @Override
    public BindingQueryResult bindingQuery(SimpleString address, boolean newFQQN) throws Exception {
        if (address == null) {
            throw ActiveMQMessageBundle.BUNDLE.addressIsNull();
        }
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(realAddress.toString());
        boolean autoCreateQeueus = addressSettings.isAutoCreateQueues();
        boolean autoCreateAddresses = addressSettings.isAutoCreateAddresses();
        boolean defaultPurgeOnNoConsumers = addressSettings.isDefaultPurgeOnNoConsumers();
        int defaultMaxConsumers = addressSettings.getDefaultMaxConsumers();
        boolean defaultExclusive = addressSettings.isDefaultExclusiveQueue();
        boolean defaultLastValue = addressSettings.isDefaultLastValueQueue();
        SimpleString defaultLastValueKey = addressSettings.getDefaultLastValueKey();
        boolean defaultNonDestructive = addressSettings.isDefaultNonDestructive();
        int defaultConsumersBeforeDispatch = addressSettings.getDefaultConsumersBeforeDispatch();
        long defaultDelayBeforeDispatch = addressSettings.getDefaultDelayBeforeDispatch();
        ManagementService managementService = this.getManagementService();
        if (managementService != null && realAddress.equals((Object)managementService.getManagementAddress())) {
            return new BindingQueryResult(true, new AddressInfo(managementService.getManagementAddress(), EnumSet.allOf(RoutingType.class)), Collections.emptyList(), autoCreateQeueus, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers, defaultExclusive, defaultLastValue, defaultLastValueKey, defaultNonDestructive, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch);
        }
        ArrayList<SimpleString> names = new ArrayList<SimpleString>();
        for (Binding binding : this.getPostOffice().getMatchingBindings(realAddress)) {
            if (binding.getType() != BindingType.LOCAL_QUEUE && binding.getType() != BindingType.REMOTE_QUEUE) continue;
            SimpleString name = !newFQQN && CompositeAddress.isFullyQualified((String)address.toString()) ? CompositeAddress.toFullyQualified((SimpleString)realAddress, (SimpleString)binding.getUniqueName()) : binding.getUniqueName();
            names.add(name);
        }
        AddressInfo info = this.getAddressInfo(realAddress);
        return new BindingQueryResult(info != null, info, names, autoCreateQeueus, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers, defaultExclusive, defaultLastValue, defaultLastValueKey, defaultNonDestructive, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch);
    }

    @Override
    public QueueQueryResult queueQuery(SimpleString name) {
        QueueQueryResult response;
        SimpleString managementAddress;
        if (name == null) {
            throw ActiveMQMessageBundle.BUNDLE.queueNameIsNull();
        }
        SimpleString realName = CompositeAddress.extractQueueName((SimpleString)name);
        Binding binding = this.getPostOffice().getBinding(realName);
        SimpleString addressName = binding != null && binding.getType() == BindingType.LOCAL_QUEUE ? binding.getAddress() : CompositeAddress.extractAddressName((SimpleString)name);
        AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(addressName.toString());
        boolean autoCreateQueues = addressSettings.isAutoCreateQueues();
        boolean defaultPurgeOnNoConsumers = addressSettings.isDefaultPurgeOnNoConsumers();
        int defaultMaxConsumers = addressSettings.getDefaultMaxConsumers();
        boolean defaultExclusiveQueue = addressSettings.isDefaultExclusiveQueue();
        boolean defaultLastValueQueue = addressSettings.isDefaultLastValueQueue();
        SimpleString defaultLastValueKey = addressSettings.getDefaultLastValueKey();
        boolean defaultNonDestructive = addressSettings.isDefaultNonDestructive();
        int defaultConsumersBeforeDispatch = addressSettings.getDefaultConsumersBeforeDispatch();
        long defaultDelayBeforeDispatch = addressSettings.getDefaultDelayBeforeDispatch();
        int defaultConsumerWindowSize = addressSettings.getDefaultConsumerWindowSize();
        boolean defaultGroupRebalance = addressSettings.isDefaultGroupRebalance();
        boolean defaultGroupRebalancePauseDispatch = addressSettings.isDefaultGroupRebalancePauseDispatch();
        int defaultGroupBuckets = addressSettings.getDefaultGroupBuckets();
        SimpleString defaultGroupFirstKey = addressSettings.getDefaultGroupFirstKey();
        long autoDeleteQueuesDelay = addressSettings.getAutoDeleteQueuesDelay();
        long autoDeleteQueuesMessageCount = addressSettings.getAutoDeleteQueuesMessageCount();
        long defaultRingSize = addressSettings.getDefaultRingSize();
        boolean defaultEnabled = ActiveMQDefaultConfiguration.getDefaultEnabled();
        SimpleString simpleString = managementAddress = this.getManagementService() != null ? this.getManagementService().getManagementAddress() : null;
        if (binding != null && binding.getType() == BindingType.LOCAL_QUEUE) {
            Queue queue = (Queue)binding.getBindable();
            Filter filter = queue.getFilter();
            SimpleString filterString = filter == null ? null : filter.getFilterString();
            response = new QueueQueryResult(realName, binding.getAddress(), queue.isDurable(), queue.isTemporary(), filterString, queue.getConsumerCount(), queue.getMessageCount(), autoCreateQueues, true, queue.isAutoCreated(), queue.isPurgeOnNoConsumers(), queue.getRoutingType(), queue.getMaxConsumers(), Boolean.valueOf(queue.isExclusive()), Boolean.valueOf(queue.isGroupRebalance()), Boolean.valueOf(queue.isGroupRebalancePauseDispatch()), Integer.valueOf(queue.getGroupBuckets()), queue.getGroupFirstKey(), Boolean.valueOf(queue.isLastValue()), queue.getLastValueKey(), Boolean.valueOf(queue.isNonDestructive()), Integer.valueOf(queue.getConsumersBeforeDispatch()), Long.valueOf(queue.getDelayBeforeDispatch()), Boolean.valueOf(queue.isAutoDelete()), Long.valueOf(queue.getAutoDeleteDelay()), Long.valueOf(queue.getAutoDeleteMessageCount()), Integer.valueOf(defaultConsumerWindowSize), Long.valueOf(queue.getRingSize()), Boolean.valueOf(queue.isEnabled()), Boolean.valueOf(queue.isConfigurationManaged()));
        } else {
            response = realName.equals((Object)managementAddress) ? new QueueQueryResult(realName, managementAddress, true, false, null, -1, -1L, autoCreateQueues, true, false, false, RoutingType.MULTICAST, -1, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, Integer.valueOf(defaultConsumerWindowSize), null, null, null) : new QueueQueryResult(realName, addressName, true, false, null, 0, 0L, autoCreateQueues, false, false, defaultPurgeOnNoConsumers, RoutingType.MULTICAST, defaultMaxConsumers, Boolean.valueOf(defaultExclusiveQueue), Boolean.valueOf(defaultGroupRebalance), Boolean.valueOf(defaultGroupRebalancePauseDispatch), Integer.valueOf(defaultGroupBuckets), defaultGroupFirstKey, Boolean.valueOf(defaultLastValueQueue), defaultLastValueKey, Boolean.valueOf(defaultNonDestructive), Integer.valueOf(defaultConsumersBeforeDispatch), Long.valueOf(defaultDelayBeforeDispatch), Boolean.valueOf(ActiveMQServerImpl.isAutoDelete(false, addressSettings)), Long.valueOf(autoDeleteQueuesDelay), Long.valueOf(autoDeleteQueuesMessageCount), Integer.valueOf(defaultConsumerWindowSize), Long.valueOf(defaultRingSize), Boolean.valueOf(defaultEnabled), Boolean.valueOf(false));
        }
        return response;
    }

    @Override
    public AddressQueryResult addressQuery(SimpleString name) throws Exception {
        if (name == null) {
            throw ActiveMQMessageBundle.BUNDLE.queueNameIsNull();
        }
        SimpleString realName = CompositeAddress.extractAddressName((SimpleString)name);
        AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(realName.toString());
        boolean autoCreateAddresses = addressSettings.isAutoCreateAddresses();
        boolean defaultPurgeOnNoConsumers = addressSettings.isDefaultPurgeOnNoConsumers();
        int defaultMaxConsumers = addressSettings.getDefaultMaxConsumers();
        AddressInfo addressInfo = this.postOffice.getAddressInfo(realName);
        AddressQueryResult response = addressInfo != null ? new AddressQueryResult(addressInfo.getName(), addressInfo.getRoutingTypes(), addressInfo.getId(), addressInfo.isAutoCreated(), true, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers) : new AddressQueryResult(realName, null, -1L, false, false, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers);
        return response;
    }

    @Override
    public void registerBrokerConnection(BrokerConnection brokerConnection) {
        this.brokerConnectionMap.put(brokerConnection.getName(), brokerConnection);
    }

    @Override
    public void unregisterBrokerConnection(BrokerConnection brokerConnection) {
        this.brokerConnectionMap.remove(brokerConnection.getName());
    }

    @Override
    public void startBrokerConnection(String name) throws Exception {
        BrokerConnection connection = this.getBrokerConnection(name);
        connection.start();
    }

    protected BrokerConnection getBrokerConnection(String name) {
        BrokerConnection connection = this.brokerConnectionMap.get(name);
        if (connection == null) {
            throw new IllegalArgumentException("broker connection " + name + " not found");
        }
        return connection;
    }

    @Override
    public void stopBrokerConnection(String name) throws Exception {
        BrokerConnection connection = this.getBrokerConnection(name);
        connection.stop();
    }

    @Override
    public Collection<BrokerConnection> getBrokerConnections() {
        HashSet<BrokerConnection> collections = new HashSet<BrokerConnection>(this.brokerConnectionMap.size());
        collections.addAll(this.brokerConnectionMap.values());
        return collections;
    }

    @Override
    public void threadDump() {
        ActiveMQServerLogger.LOGGER.threadDump(ThreadDumpUtil.threadDump((String)""));
    }

    @Override
    public final void fail(boolean failoverOnServerShutdown) throws Exception {
        this.stop(failoverOnServerShutdown, false, false, false);
    }

    @Override
    public final void stop(boolean failoverOnServerShutdown, boolean isExit) throws Exception {
        this.stop(failoverOnServerShutdown, false, false, isExit);
    }

    @Override
    public boolean isReplicaSync() {
        return this.activation.isReplicaSync();
    }

    public void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean restarting) {
        this.stop(failoverOnServerShutdown, criticalIOError, restarting, false);
    }

    private void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean restarting, boolean isShutdown) {
        this.stop(failoverOnServerShutdown, criticalIOError, isShutdown || criticalIOError, restarting, isShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean shutdownExternalComponents, boolean restarting, boolean isShutdown) {
        ExecutorService threadPool;
        ManagementService managementService;
        RemotingService remotingService;
        logger.debug("Stopping server {}", (Object)this);
        ActiveMQServerImpl activeMQServerImpl = this;
        synchronized (activeMQServerImpl) {
            Object activation;
            FileStoreMonitor fileStoreMonitor;
            ManagementService managementService2;
            if (this.state == ActiveMQServer.SERVER_STATE.STOPPED || this.state == ActiveMQServer.SERVER_STATE.STOPPING) {
                return;
            }
            this.state = ActiveMQServer.SERVER_STATE.STOPPING;
            this.callPreDeActiveCallbacks();
            if (criticalIOError && (managementService2 = this.managementService) != null) {
                managementService2.enableNotifications(false);
            }
            if ((fileStoreMonitor = this.fileStoreMonitor) != null) {
                fileStoreMonitor.stop();
                this.fileStoreMonitor = null;
            }
            if (failoverOnServerShutdown && (activation = this.activation) != null) {
                ((Activation)activation).sendPrimaryIsStopping();
            }
            ActiveMQServerImpl.stopComponent(this.connectionRouterManager);
            ActiveMQServerImpl.stopComponent(this.connectorsService);
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                ActiveMQServerImpl.stopComponent(this.groupingHandler);
            }
            ActiveMQServerImpl.stopComponent(this.federationManager);
            ActiveMQServerImpl.stopComponent(this.clusterManager);
            for (ActiveMQComponent component : this.protocolServices) {
                ActiveMQServerImpl.stopComponent(component);
            }
            this.protocolServices.clear();
            remotingService = this.remotingService;
            if (remotingService != null) {
                remotingService.pauseAcceptors();
            }
            if (remotingService != null && this.configuration.isGracefulShutdownEnabled()) {
                long timeout = this.configuration.getGracefulShutdownTimeout();
                try {
                    if (timeout == -1L) {
                        remotingService.getConnectionCountLatch().await();
                    } else {
                        remotingService.getConnectionCountLatch().await(timeout);
                    }
                }
                catch (InterruptedException e) {
                    ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(remotingService.getClass().getName());
                }
            }
            this.freezeConnections();
        }
        Activation activation = this.activation;
        if (activation != null) {
            activation.postConnectionFreeze();
        }
        this.closeAllServerSessions(criticalIOError);
        StorageManager storageManager = this.storageManager;
        if (storageManager != null) {
            storageManager.clearContext();
        }
        this.callDeActiveCallbacks();
        ActiveMQServerImpl.stopComponent(this.backupManager);
        if (activation != null) {
            try {
                activation.preStorageClose();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(activation.getClass().getName(), t);
            }
        }
        if (!criticalIOError && this.pagingManager != null) {
            this.pagingManager.counterSnapshot();
        }
        ActiveMQServerImpl.stopComponent(this.pagingManager);
        if (storageManager != null) {
            try {
                storageManager.stop(criticalIOError, failoverOnServerShutdown);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(storageManager.getClass().getName(), t);
            }
        }
        if ((remotingService = this.remotingService) != null) {
            try {
                remotingService.stop(criticalIOError);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(remotingService.getClass().getName(), t);
            }
        }
        if ((managementService = this.managementService) != null) {
            try {
                managementService.unregisterServer();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(managementService.getClass().getName(), t);
            }
        }
        ActiveMQServerImpl.stopComponent(managementService);
        ActiveMQServerImpl.stopComponent(this.resourceManager);
        ActiveMQServerImpl.stopComponent(this.postOffice);
        if (this.scheduledPool != null && !this.scheduledPoolSupplied) {
            this.scheduledPool.shutdownNow();
        }
        ActiveMQServerImpl.stopComponent(this.memoryManager);
        for (SecuritySettingPlugin securitySettingPlugin : this.configuration.getSecuritySettingPlugins()) {
            securitySettingPlugin.stop();
        }
        if (this.ioExecutorPool != null) {
            this.shutdownPool(this.ioExecutorPool);
        }
        if (this.pageExecutorPool != null) {
            this.shutdownPool(this.pageExecutorPool);
        }
        if (!this.scheduledPoolSupplied) {
            this.scheduledPool = null;
        }
        if (this.securityStore != null) {
            try {
                this.securityStore.stop();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(this.securityStore.getClass().getName(), t);
            }
        }
        this.installMirrorController(null);
        this.pagingManager = null;
        this.securityStore = null;
        this.resourceManager = null;
        this.postOffice = null;
        this.queueFactory = null;
        this.resourceManager = null;
        this.messagingServerControl = null;
        this.memoryManager = null;
        this.backupManager = null;
        this.extraRecordsLoader = null;
        this.storageManager = null;
        this.sessions.clear();
        this.state = ActiveMQServer.SERVER_STATE.STOPPED;
        this.activationLatch.setCount(1);
        SimpleString tempNodeID = this.getNodeID();
        if (activation != null) {
            try {
                activation.close(failoverOnServerShutdown, restarting);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(activation.getClass().getName(), t);
            }
        }
        if ((threadPool = this.threadPool) != null && !this.threadPoolSupplied) {
            this.shutdownPool(threadPool);
        }
        if (!this.threadPoolSupplied) {
            this.threadPool = null;
        }
        this.clearJdbcNetworkTimeout();
        if (this.activationThread != null) {
            try {
                this.activationThread.join(30000L);
            }
            catch (InterruptedException e) {
                ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.activationThread.getClass().getName());
            }
            if (this.activationThread.isAlive()) {
                ActiveMQServerLogger.LOGGER.activationDidntFinish(this);
                this.activationThread.interrupt();
            }
        }
        ActiveMQServerImpl.stopComponent(this.nodeManager);
        this.nodeManager = null;
        this.addressSettingsRepository.clearListeners();
        this.addressSettingsRepository.clearCache();
        this.scaledDownNodeIDs.clear();
        this.connectedClientIds.clear();
        this.stopExternalComponents(shutdownExternalComponents);
        try {
            this.analyzer.clear();
            this.analyzer.stop();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.analyzer = null;
        }
        for (ActivateCallback callback : this.activateCallbacks) {
            if (isShutdown) {
                callback.shutdown(this);
                continue;
            }
            callback.stop(this);
        }
        if (this.identity != null) {
            ActiveMQServerLogger.LOGGER.serverStopped("identity=" + this.identity + ",version=" + this.getVersion().getFullVersion(), tempNodeID, this.getUptime());
        } else {
            ActiveMQServerLogger.LOGGER.serverStopped(this.getVersion().getFullVersion(), tempNodeID, this.getUptime());
        }
    }

    private void shutdownPool(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                ActiveMQServerLogger.LOGGER.timedOutStoppingThreadpool(this.threadPool);
                for (Runnable r : executorService.shutdownNow()) {
                    logger.debug("Cancelled the execution of {}", (Object)r);
                }
            }
        }
        catch (InterruptedException e) {
            ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.threadPool.getClass().getName());
        }
    }

    public boolean checkBrokerIsNotColocated(String nodeId) {
        if (this.parentServer == null) {
            return true;
        }
        return !this.parentServer.getNodeID().toString().equals(nodeId);
    }

    private void freezeConnections() {
        Activation activation = this.activation;
        if (activation != null) {
            activation.freezeConnections(this.remotingService);
        }
        for (ServerSession serverSession : this.sessions.values()) {
            try {
                serverSession.close(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorClosingSession(e);
            }
        }
    }

    private void closeAllServerSessions(boolean criticalIOError) {
        if (this.state != ActiveMQServer.SERVER_STATE.STOPPING) {
            return;
        }
        for (ServerSession session : this.sessions.values()) {
            try {
                session.close(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
            }
        }
    }

    static void stopComponent(ActiveMQComponent component) {
        try {
            if (component != null) {
                component.stop();
            }
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.errorStoppingComponent(component.getClass().getName(), t);
        }
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println(ActiveMQMessageBundle.BUNDLE.serverDescribe(this.identity, this.getClusterManager().describe()));
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String destroyConnectionWithSessionMetadata(String metaKey, String parameterValue) throws Exception {
        StringBuffer operationsExecuted = new StringBuffer();
        try {
            operationsExecuted.append("**************************************************************************************************\n");
            operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataHeader(metaKey, parameterValue) + "\n");
            Set<ServerSession> allSessions = this.getSessions();
            ServerSession sessionFound = null;
            for (ServerSession session : allSessions) {
                try {
                    String value = session.getMetaData(metaKey);
                    if (value == null || !value.equals(parameterValue)) continue;
                    sessionFound = session;
                    operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataClosingConnection(sessionFound.toString()) + "\n");
                    RemotingConnection conn = session.getRemotingConnection();
                    if (conn != null) {
                        conn.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataSendException(metaKey, parameterValue));
                    }
                    session.close(true);
                    this.sessions.remove(session.getName());
                }
                catch (Throwable e) {
                    ActiveMQServerLogger.LOGGER.unableDestroyConnectionWithSessionMetadata(e);
                }
            }
            if (sessionFound == null) {
                operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataNoSessionFound(metaKey, parameterValue) + "\n");
            }
            operationsExecuted.append("**************************************************************************************************");
            String string = operationsExecuted.toString();
            return string;
        }
        finally {
            ActiveMQServerLogger.LOGGER.onDestroyConnectionWithSessionMetadata(operationsExecuted.toString());
        }
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public ActiveMQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public boolean isStarted() {
        return this.state == ActiveMQServer.SERVER_STATE.STARTED;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public ConnectionRouterManager getConnectionRouterManager() {
        return this.connectionRouterManager;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes, String securityDomain, String validatedUser, boolean isLegacyProducer) throws Exception {
        if (validatedUser == null) {
            validatedUser = this.validateUser(username, password, connection, securityDomain);
        }
        this.checkSessionLimit(validatedUser);
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.createCoreSession((Object)this, (Subject)connection.getSubject(), (String)connection.getRemoteAddress(), (Object[])new Object[]{name, username, "****", minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, autoCreateQueues, prefixes});
        }
        ServerSessionImpl session = this.internalCreateSession(name, username, password, validatedUser, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, context, autoCreateQueues, prefixes, securityDomain, isLegacyProducer);
        return session;
    }

    @Override
    public String validateUser(String username, String password, RemotingConnection connection, String securityDomain) throws Exception {
        String validatedUser = "";
        if (this.securityStore != null) {
            validatedUser = this.securityStore.authenticate(username, password, connection, securityDomain);
        }
        return validatedUser;
    }

    @Override
    public ServerSession createInternalSession(String name, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes, String securityDomain, boolean isLegacyProducer) throws Exception {
        ServerSessionImpl session = this.internalCreateSession(name, null, null, null, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, context, autoCreateQueues, prefixes, securityDomain, isLegacyProducer);
        session.disableSecurity();
        return session;
    }

    private void checkSessionLimit(String username) throws Exception {
        if (this.configuration.getResourceLimitSettings() != null && this.configuration.getResourceLimitSettings().containsKey(username)) {
            ResourceLimitSettings limits = this.configuration.getResourceLimitSettings().get(username);
            if (limits.getMaxConnections() == -1) {
                return;
            }
            if (limits.getMaxConnections() == 0 || this.getSessionCountForUser(username) >= limits.getMaxConnections()) {
                throw ActiveMQMessageBundle.BUNDLE.sessionLimitReached(username, limits.getMaxConnections());
            }
        }
    }

    private int getSessionCountForUser(String username) {
        int sessionCount = 0;
        for (Map.Entry sessionEntry : this.sessions.entrySet()) {
            if ((((ServerSession)sessionEntry.getValue()).getValidatedUser() == null || !((ServerSession)sessionEntry.getValue()).getValidatedUser().equals(username)) && (((ServerSession)sessionEntry.getValue()).getUsername() == null || !((ServerSession)sessionEntry.getValue()).getUsername().equals(username))) continue;
            ++sessionCount;
        }
        return sessionCount;
    }

    @Override
    public void checkQueueCreationLimit(String username) throws Exception {
        if (this.configuration.getResourceLimitSettings() != null && this.configuration.getResourceLimitSettings().containsKey(username)) {
            ResourceLimitSettings limits = this.configuration.getResourceLimitSettings().get(username);
            if (limits.getMaxQueues() == -1) {
                return;
            }
            if (limits.getMaxQueues() == 0 || this.getQueueCountForUser(username) >= limits.getMaxQueues()) {
                throw ActiveMQMessageBundle.BUNDLE.queueLimitReached(username, limits.getMaxQueues());
            }
        }
    }

    public int getQueueCountForUser(String username) throws Exception {
        SimpleString userNameSimpleString = SimpleString.of((String)username);
        AtomicInteger bindingsCount = new AtomicInteger(0);
        this.postOffice.getAllBindings().forEach(b -> {
            LocalQueueBinding l;
            SimpleString user;
            if (b instanceof LocalQueueBinding && (user = (l = (LocalQueueBinding)b).getQueue().getUser()) != null && user.equals((Object)userNameSimpleString)) {
                bindingsCount.incrementAndGet();
            }
        });
        return bindingsCount.get();
    }

    protected ServerSessionImpl internalCreateSession(String name, String username, String password, String validatedUser, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, OperationContext context, boolean autoCreateQueues, Map<SimpleString, RoutingType> prefixes, String securityDomain, boolean isLegacyProducer) throws Exception {
        if (this.hasBrokerSessionPlugins()) {
            this.callBrokerSessionPlugins(plugin -> plugin.beforeCreateSession(name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, autoCreateQueues, context, prefixes));
        }
        ServerSessionImpl session = new ServerSessionImpl(name, username, password, validatedUser, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : SimpleString.of((String)defaultAddress), callback, context, this.pagingManager, prefixes, securityDomain, isLegacyProducer);
        this.sessions.put(name, session);
        if (this.hasBrokerSessionPlugins()) {
            this.callBrokerSessionPlugins(plugin -> plugin.afterCreateSession(session));
        }
        return session;
    }

    @Override
    public SecurityStore getSecurityStore() {
        return this.securityStore;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public ServerSession lookupSession(String key, String value) {
        Set<ServerSession> allSessions = this.getSessions();
        for (ServerSession session : allSessions) {
            String metaValue = session.getMetaData(key);
            if (metaValue == null || !metaValue.equals(value)) continue;
            return session;
        }
        return null;
    }

    @Override
    public List<ServerSession> getSessions(String connectionID) {
        Set sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry sessionEntry : sessionEntries) {
            ServerSession serverSession = (ServerSession)sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    @Override
    public boolean isActive() {
        return this.activationLatch.getCount() < 1;
    }

    @Override
    public boolean waitForActivation(long timeout, TimeUnit unit) throws InterruptedException {
        return this.activationLatch.await(timeout, unit);
    }

    @Override
    public ActiveMQServerControlImpl getActiveMQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnectionCount();
    }

    @Override
    public long getTotalConnectionCount() {
        return this.remotingService.getTotalConnectionCount();
    }

    @Override
    public long getTotalMessageCount() {
        long total = 0L;
        for (Binding binding : IterableStream.iterableOf(this.postOffice.getAllBindings())) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessageCount();
        }
        return total;
    }

    @Override
    public long getTotalMessagesAdded() {
        long total = 0L;
        for (Binding binding : IterableStream.iterableOf(this.postOffice.getAllBindings())) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessagesAdded();
        }
        return total;
    }

    @Override
    public long getTotalMessagesAcknowledged() {
        long total = 0L;
        for (Binding binding : IterableStream.iterableOf(this.postOffice.getAllBindings())) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessagesAcknowledged();
        }
        return total;
    }

    @Override
    public long getTotalConsumerCount() {
        long total = 0L;
        for (Binding binding : IterableStream.iterableOf(this.postOffice.getAllBindings())) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += (long)((LocalQueueBinding)binding).getQueue().getConsumerCount();
        }
        return total;
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeManager == null ? null : this.nodeManager.getNodeId();
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filterString, durable, temporary, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isAutoCreateAddresses());
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString user, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filterString, user, durable, temporary, false, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isAutoCreateAddresses());
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, null, durable, temporary, false, maxConsumers, purgeOnNoConsumers, autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, null, durable, temporary, false, false, false, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, null, durable, temporary, false, false, false, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress, long ringSize) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, null, durable, temporary, false, false, false, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, ringSize);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(addressInfo == null ? queueName.toString() : addressInfo.getName().toString());
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)as.isDefaultExclusiveQueue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.getDefaultGroupFirstKey(), as.isDefaultLastValueQueue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress, false, as.getDefaultRingSize());
    }

    @Override
    @Deprecated
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(addressInfo == null ? queueName.toString() : addressInfo.getName().toString());
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)exclusive, as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.getDefaultGroupFirstKey(), lastValue, as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress, false, as.getDefaultRingSize());
    }

    @Override
    @Deprecated
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(addressInfo == null ? queueName.toString() : addressInfo.getName().toString());
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)exclusive, (boolean)groupRebalance, groupBuckets, as.getDefaultGroupFirstKey(), lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, (long)autoDeleteMessageCount, autoCreateAddress, false, as.getDefaultRingSize());
    }

    @Override
    @Deprecated
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(addressInfo == null ? queueName.toString() : addressInfo.getName().toString());
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)exclusive, (boolean)groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, (long)autoDeleteMessageCount, autoCreateAddress, false, as.getDefaultRingSize());
    }

    @Override
    @Deprecated
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean autoCreateAddress, Long ringSize) throws Exception {
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)exclusive, (boolean)groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, (long)autoDeleteMessageCount, autoCreateAddress, false, (long)ringSize);
    }

    static boolean isAutoDelete(boolean autoCreated, AddressSettings addressSettings) {
        return autoCreated ? addressSettings.isAutoDeleteQueues() : addressSettings.isAutoDeleteCreatedQueues();
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filter, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, as.isDefaultExclusiveQueue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.isDefaultLastValueQueue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean lastValue, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filter, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), lastValue, as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString()).getDefaultQueueRoutingType(), queueName, filterString, durable, temporary);
    }

    @Override
    @Deprecated
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? name.toString() : address.toString());
        this.createSharedQueue(address, routingType, name, filterString, user, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isDefaultExclusiveQueue(), as.isDefaultLastValueQueue());
    }

    @Override
    @Deprecated
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean lastValue) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? name.toString() : address.toString());
        this.createSharedQueue(address, routingType, name, filterString, user, durable, maxConsumers, purgeOnNoConsumers, exclusive, as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), lastValue, as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(false, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount());
    }

    @Override
    @Deprecated
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? name.toString() : address.toString());
        this.createSharedQueue(address, routingType, name, filterString, user, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, as.getDefaultGroupFirstKey(), lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount);
    }

    @Override
    @Deprecated
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount) throws Exception {
        this.createSharedQueue(QueueConfiguration.of((SimpleString)name).setAddress(address).setRoutingType(routingType).setFilterString(filterString).setUser(user).setDurable(Boolean.valueOf(durable)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setExclusive(Boolean.valueOf(exclusive)).setGroupRebalance(Boolean.valueOf(groupRebalance)).setGroupBuckets(Integer.valueOf(groupBuckets)).setGroupFirstKey(groupFirstKey).setLastValue(Boolean.valueOf(lastValue)).setLastValueKey(lastValueKey).setNonDestructive(Boolean.valueOf(nonDestructive)).setConsumersBeforeDispatch(Integer.valueOf(consumersBeforeDispatch)).setDelayBeforeDispatch(Long.valueOf(delayBeforeDispatch)).setAutoDelete(Boolean.valueOf(autoDelete)).setAutoDeleteDelay(Long.valueOf(autoDeleteDelay)).setAutoDeleteMessageCount(Long.valueOf(autoDeleteMessageCount)));
    }

    @Override
    public void createSharedQueue(QueueConfiguration queueConfiguration) throws Exception {
        Queue queue = this.createQueue(queueConfiguration.setTemporary(Boolean.valueOf(queueConfiguration.isDurable() == false)).setTransient(Boolean.valueOf(queueConfiguration.isDurable() == false)).setAutoCreated(Boolean.valueOf(false)).setAutoCreateAddress(Boolean.valueOf(true)), true);
        if (!queue.getAddress().equals((Object)queueConfiguration.getAddress())) {
            throw ActiveMQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentAddress(queueConfiguration.getName());
        }
        if (queueConfiguration.getFilterString() != null && (queue.getFilter() == null || !queue.getFilter().getFilterString().equals((Object)queueConfiguration.getFilterString())) || queueConfiguration.getFilterString() == null && queue.getFilter() != null) {
            throw ActiveMQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentFilter(queueConfiguration.getName());
        }
        logger.debug("Transient Queue {} created on address {} with filter={}", new Object[]{queueConfiguration.getName(), queueConfiguration.getAddress(), queueConfiguration.getFilterString()});
    }

    @Override
    public Queue locateQueue(SimpleString queueName) {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            return null;
        }
        Bindable queue = binding.getBindable();
        if (!(queue instanceof Queue)) {
            throw new IllegalStateException("locateQueue should only be used to locate queues");
        }
        return (Queue)binding.getBindable();
    }

    @Override
    @Deprecated
    public Queue deployQueue(SimpleString address, SimpleString resourceName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, this.getAddressSettingsRepository().getMatch(address == null ? resourceName.toString() : address.toString()).getDefaultQueueRoutingType(), resourceName, filterString, durable, temporary);
    }

    @Override
    @Deprecated
    public Queue deployQueue(String address, String resourceName, String filterString, boolean durable, boolean temporary) throws Exception {
        return this.deployQueue(SimpleString.of((String)address), SimpleString.of((String)resourceName), SimpleString.of((String)filterString), durable, temporary);
    }

    @Override
    public void destroyQueue(SimpleString queueName) throws Exception {
        this.destroyQueue(queueName, null, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session) throws Exception {
        this.destroyQueue(queueName, session, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount) throws Exception {
        this.destroyQueue(queueName, session, checkConsumerCount, false);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers) throws Exception {
        if (this.postOffice == null) {
            return;
        }
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(queueName);
        }
        this.destroyQueue(queueName, session, checkConsumerCount, removeConsumers, false);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean forceAutoDeleteAddress) throws Exception {
        this.destroyQueue(queueName, session, checkConsumerCount, removeConsumers, forceAutoDeleteAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean forceAutoDeleteAddress, boolean checkMessageCount) throws Exception {
        if (this.postOffice == null) {
            return;
        }
        try {
            Binding binding = this.postOffice.getBinding(queueName);
            if (binding == null) {
                throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(queueName);
            }
            SimpleString address = binding.getAddress();
            Queue queue = (Queue)binding.getBindable();
            if (session != null) {
                this.securityStore.check(address, queueName, queue.isDurable() ? CheckType.DELETE_DURABLE_QUEUE : CheckType.DELETE_NON_DURABLE_QUEUE, session);
            }
            if (checkConsumerCount && queue.getConsumerCount() != 0) {
                throw ActiveMQMessageBundle.BUNDLE.cannotDeleteQueueWithConsumers(queue.getName(), queueName, binding.getClass().getName());
            }
            if (checkMessageCount && queue.getAutoDeleteMessageCount() != -1L) {
                long messageCount = queue.getMessageCount();
                if (queue.getMessageCount() > queue.getAutoDeleteMessageCount()) {
                    throw ActiveMQMessageBundle.BUNDLE.cannotDeleteQueueWithMessages(queue.getName(), queueName, messageCount);
                }
            }
            if (this.hasBrokerQueuePlugins()) {
                this.callBrokerQueuePlugins(plugin -> plugin.beforeDestroyQueue(queue, session, checkConsumerCount, removeConsumers, forceAutoDeleteAddress));
            }
            if (this.mirrorControllerService != null) {
                this.mirrorControllerService.deleteQueue(queue.getAddress(), queue.getName());
            }
            queue.deleteQueue(removeConsumers);
            if (this.hasBrokerQueuePlugins()) {
                this.callBrokerQueuePlugins(plugin -> plugin.afterDestroyQueue(queue, address, session, checkConsumerCount, removeConsumers, forceAutoDeleteAddress));
            }
            if (forceAutoDeleteAddress) {
                AddressInfo addressInfo = this.getAddressInfo(address);
                if (this.postOffice != null && addressInfo != null && addressInfo.isAutoCreated() && !this.isAddressBound(address.toString()) && this.addressSettingsRepository.getMatch(address.toString()).getAutoDeleteAddressesDelay() == 0L) {
                    try {
                        this.removeAddressInfo(address, session);
                    }
                    catch (ActiveMQDeleteAddressException activeMQDeleteAddressException) {
                        // empty catch block
                    }
                }
            }
            this.callPostQueueDeletionCallbacks(address, queueName);
        }
        finally {
            this.clearAddressCache();
        }
    }

    @Override
    public void clearAddressCache() {
        this.securityRepository.clearCache();
        this.addressSettingsRepository.clearCache();
    }

    @Override
    public void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public void registerActivationFailureListener(ActivationFailureListener listener) {
        this.activationFailureListeners.add(listener);
    }

    @Override
    public void unregisterActivationFailureListener(ActivationFailureListener listener) {
        this.activationFailureListeners.remove(listener);
    }

    @Override
    public void callActivationFailureListeners(Exception e) {
        for (ActivationFailureListener listener : this.activationFailureListeners) {
            listener.activationFailed(e);
        }
    }

    @Override
    public void registerIOCriticalErrorListener(IOCriticalErrorListener listener) {
        this.ioCriticalErrorListeners.add(listener);
    }

    @Override
    public void registerPostQueueCreationCallback(PostQueueCreationCallback callback) {
        this.postQueueCreationCallbacks.add(callback);
    }

    @Override
    public void unregisterPostQueueCreationCallback(PostQueueCreationCallback callback) {
        this.postQueueCreationCallbacks.remove(callback);
    }

    @Override
    public void callPostQueueCreationCallbacks(SimpleString queueName) throws Exception {
        for (PostQueueCreationCallback callback : this.postQueueCreationCallbacks) {
            callback.callback(queueName);
        }
    }

    @Override
    public void registerPostQueueDeletionCallback(PostQueueDeletionCallback callback) {
        this.postQueueDeletionCallbacks.add(callback);
    }

    @Override
    public void unregisterPostQueueDeletionCallback(PostQueueDeletionCallback callback) {
        this.postQueueDeletionCallbacks.remove(callback);
    }

    @Override
    public void callPostQueueDeletionCallbacks(SimpleString address, SimpleString queueName) throws Exception {
        for (PostQueueDeletionCallback callback : this.postQueueDeletionCallbacks) {
            callback.callback(address, queueName);
        }
    }

    @Override
    public void registerBrokerPlugins(List<ActiveMQServerBasePlugin> plugins) {
        this.configuration.registerBrokerPlugins(plugins);
        plugins.forEach(plugin -> plugin.registered(this));
    }

    @Override
    public void registerBrokerPlugin(ActiveMQServerBasePlugin plugin) {
        this.configuration.registerBrokerPlugin(plugin);
        plugin.registered(this);
    }

    @Override
    public void unRegisterBrokerPlugin(ActiveMQServerBasePlugin plugin) {
        this.configuration.unRegisterBrokerPlugin(plugin);
        plugin.unregistered(this);
    }

    @Override
    public List<ActiveMQServerBasePlugin> getBrokerPlugins() {
        return this.configuration.getBrokerPlugins();
    }

    @Override
    public List<ActiveMQServerConnectionPlugin> getBrokerConnectionPlugins() {
        return this.configuration.getBrokerConnectionPlugins();
    }

    @Override
    public List<ActiveMQServerSessionPlugin> getBrokerSessionPlugins() {
        return this.configuration.getBrokerSessionPlugins();
    }

    @Override
    public List<ActiveMQServerConsumerPlugin> getBrokerConsumerPlugins() {
        return this.configuration.getBrokerConsumerPlugins();
    }

    @Override
    public List<ActiveMQServerAddressPlugin> getBrokerAddressPlugins() {
        return this.configuration.getBrokerAddressPlugins();
    }

    @Override
    public List<ActiveMQServerQueuePlugin> getBrokerQueuePlugins() {
        return this.configuration.getBrokerQueuePlugins();
    }

    @Override
    public List<ActiveMQServerBindingPlugin> getBrokerBindingPlugins() {
        return this.configuration.getBrokerBindingPlugins();
    }

    @Override
    public List<ActiveMQServerMessagePlugin> getBrokerMessagePlugins() {
        return this.configuration.getBrokerMessagePlugins();
    }

    @Override
    public List<ActiveMQServerBridgePlugin> getBrokerBridgePlugins() {
        return this.configuration.getBrokerBridgePlugins();
    }

    @Override
    public List<ActiveMQServerCriticalPlugin> getBrokerCriticalPlugins() {
        return this.configuration.getBrokerCriticalPlugins();
    }

    @Override
    public List<ActiveMQServerFederationPlugin> getBrokerFederationPlugins() {
        return this.configuration.getBrokerFederationPlugins();
    }

    @Override
    public List<AMQPFederationBrokerPlugin> getBrokerAMQPFederationPlugins() {
        return this.configuration.getBrokerAMQPFederationPlugins();
    }

    @Override
    public List<ActiveMQServerResourcePlugin> getBrokerResourcePlugins() {
        return this.configuration.getBrokerResourcePlugins();
    }

    @Override
    public void callBrokerPlugins(ActiveMQPluginRunnable pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerPlugins(), pluginRun);
    }

    @Override
    public void callBrokerConnectionPlugins(ActiveMQPluginRunnable<ActiveMQServerConnectionPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerConnectionPlugins(), pluginRun);
    }

    @Override
    public void callBrokerSessionPlugins(ActiveMQPluginRunnable<ActiveMQServerSessionPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerSessionPlugins(), pluginRun);
    }

    @Override
    public void callBrokerConsumerPlugins(ActiveMQPluginRunnable<ActiveMQServerConsumerPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerConsumerPlugins(), pluginRun);
    }

    @Override
    public void callBrokerAddressPlugins(ActiveMQPluginRunnable<ActiveMQServerAddressPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerAddressPlugins(), pluginRun);
    }

    @Override
    public void callBrokerQueuePlugins(ActiveMQPluginRunnable<ActiveMQServerQueuePlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerQueuePlugins(), pluginRun);
    }

    @Override
    public void callBrokerBindingPlugins(ActiveMQPluginRunnable<ActiveMQServerBindingPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerBindingPlugins(), pluginRun);
    }

    @Override
    public void callBrokerMessagePlugins(ActiveMQPluginRunnable<ActiveMQServerMessagePlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerMessagePlugins(), pluginRun);
    }

    @Override
    public boolean callBrokerMessagePluginsCanAccept(ServerConsumer serverConsumer, MessageReference messageReference) throws ActiveMQException {
        for (ActiveMQServerMessagePlugin plugin : this.getBrokerMessagePlugins()) {
            try {
                if (plugin.canAccept(serverConsumer, messageReference)) continue;
                return false;
            }
            catch (Throwable e) {
                if (e instanceof ActiveMQException) {
                    logger.debug("plugin {} is throwing ActiveMQException", (Object)plugin);
                    throw (ActiveMQException)e;
                }
                logger.warn("Internal error on plugin {}", (Object)plugin, (Object)e);
            }
        }
        return true;
    }

    @Override
    public void callBrokerBridgePlugins(ActiveMQPluginRunnable<ActiveMQServerBridgePlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerBridgePlugins(), pluginRun);
    }

    @Override
    public void callBrokerCriticalPlugins(ActiveMQPluginRunnable<ActiveMQServerCriticalPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerCriticalPlugins(), pluginRun);
    }

    @Override
    public void callBrokerFederationPlugins(ActiveMQPluginRunnable<ActiveMQServerFederationPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerFederationPlugins(), pluginRun);
    }

    @Override
    public void callBrokerAMQPFederationPlugins(ActiveMQPluginRunnable<AMQPFederationBrokerPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerAMQPFederationPlugins(), pluginRun);
    }

    @Override
    public void callBrokerResourcePlugins(ActiveMQPluginRunnable<ActiveMQServerResourcePlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerResourcePlugins(), pluginRun);
    }

    private <P extends ActiveMQServerBasePlugin> void callBrokerPlugins(List<P> plugins, ActiveMQPluginRunnable<P> pluginRun) throws ActiveMQException {
        if (pluginRun != null) {
            for (ActiveMQServerBasePlugin plugin : plugins) {
                try {
                    pluginRun.run(plugin);
                }
                catch (Throwable e) {
                    if (e instanceof ActiveMQException) {
                        logger.debug("plugin {} is throwing ActiveMQException", (Object)plugin);
                        throw (ActiveMQException)e;
                    }
                    logger.warn("Internal error on plugin {}", pluginRun, (Object)e);
                }
            }
        }
    }

    @Override
    public boolean hasBrokerPlugins() {
        return !this.getBrokerPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerConnectionPlugins() {
        return !this.getBrokerConnectionPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerSessionPlugins() {
        return !this.getBrokerSessionPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerConsumerPlugins() {
        return !this.getBrokerConsumerPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerAddressPlugins() {
        return !this.getBrokerAddressPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerQueuePlugins() {
        return !this.getBrokerQueuePlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerBindingPlugins() {
        return !this.getBrokerBindingPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerMessagePlugins() {
        return !this.getBrokerMessagePlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerBridgePlugins() {
        return !this.getBrokerBridgePlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerCriticalPlugins() {
        return !this.getBrokerCriticalPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerFederationPlugins() {
        return !this.getBrokerFederationPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerAMQPFederationPlugins() {
        return !this.getBrokerAMQPFederationPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerResourcePlugins() {
        return !this.getBrokerResourcePlugins().isEmpty();
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public ExecutorFactory getIOExecutorFactory() {
        return this.ioExecutorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        if (this.groupingHandler != null && this.managementService != null) {
            this.managementService.removeNotificationListener(this.groupingHandler);
        }
        this.groupingHandler = groupingHandler;
        if (this.managementService != null) {
            this.managementService.addNotificationListener(this.groupingHandler);
        }
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.activation.getReplicationManager();
    }

    @Override
    public ConnectorsService getConnectorsService() {
        return this.connectorsService;
    }

    @Override
    public FederationManager getFederationManager() {
        return this.federationManager;
    }

    @Override
    public Divert deployDivert(DivertConfiguration config) throws Exception {
        if (config.getName() == null) {
            throw ActiveMQMessageBundle.BUNDLE.divertWithNoName();
        }
        if (config.getAddress() == null) {
            ActiveMQServerLogger.LOGGER.divertWithNoAddress();
            return null;
        }
        if (config.getForwardingAddress() == null) {
            ActiveMQServerLogger.LOGGER.divertWithNoForwardingAddress();
            return null;
        }
        SimpleString sName = SimpleString.of((String)config.getName());
        if (this.postOffice.getBinding(sName) != null) {
            ActiveMQServerLogger.LOGGER.divertBindingAlreadyExists(sName);
            return null;
        }
        SimpleString sAddress = SimpleString.of((String)config.getAddress());
        Transformer transformer = this.getServiceRegistry().getDivertTransformer(config.getName(), config.getTransformerConfiguration());
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        DivertImpl divert = new DivertImpl(sName, sAddress, SimpleString.of((String)config.getForwardingAddress()), SimpleString.of((String)config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager, config.getRoutingType());
        DivertBinding binding = new DivertBinding(this.storageManager.generateID(), sAddress, divert);
        this.storageManager.storeDivertConfiguration(new PersistedDivertConfiguration(config));
        this.postOffice.addBinding(binding);
        this.managementService.registerDivert(divert);
        return divert;
    }

    @Override
    public Divert updateDivert(DivertConfiguration config) throws Exception {
        SimpleString forwardAddress;
        DivertBinding divertBinding = (DivertBinding)this.postOffice.getBinding(SimpleString.of((String)config.getName()));
        if (divertBinding == null) {
            return null;
        }
        Divert divert = divertBinding.getDivert();
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        if (filter == null) {
            divert.setFilter(null);
        } else if (!filter.equals(divert.getFilter())) {
            divert.setFilter(filter);
        }
        if (config.getTransformerConfiguration() != null) {
            this.getServiceRegistry().removeDivertTransformer(divert.getUniqueName().toString());
            Transformer transformer = this.getServiceRegistry().getDivertTransformer(config.getName(), config.getTransformerConfiguration());
            divert.setTransformer(transformer);
        }
        if (config.getForwardingAddress() != null && !(forwardAddress = SimpleString.of((String)config.getForwardingAddress())).equals((Object)divert.getForwardAddress())) {
            divert.setForwardAddress(forwardAddress);
        }
        if (config.getRoutingType() != null && divert.getRoutingType() != config.getRoutingType()) {
            divert.setRoutingType(config.getRoutingType());
        }
        this.storageManager.storeDivertConfiguration(new PersistedDivertConfiguration(config));
        return divert;
    }

    @Override
    public void destroyDivert(SimpleString name) throws Exception {
        this.destroyDivert(name, false);
    }

    @Override
    public void destroyDivert(SimpleString name, boolean deleteFromStorage) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null) {
            throw ActiveMQMessageBundle.BUNDLE.noBindingForDivert(name);
        }
        if (!(binding instanceof DivertBinding)) {
            throw ActiveMQMessageBundle.BUNDLE.bindingNotDivert(name);
        }
        this.postOffice.removeBinding(name, null, true);
        if (((DivertBinding)binding).getDivert().getTransformer() != null) {
            this.getServiceRegistry().removeDivertTransformer(name.toString());
        }
        if (deleteFromStorage) {
            this.storageManager.deleteDivertConfiguration(name.toString());
        }
    }

    @Override
    public boolean deployBridge(BridgeConfiguration config) throws Exception {
        if (this.clusterManager != null && this.clusterManager.deployBridge(config)) {
            for (Bridge bridge : this.clusterManager.getBridges().values()) {
                BridgeConfiguration copyConfig = new BridgeConfiguration(bridge.getConfiguration());
                if (copyConfig.getConcurrency() > 1 && !copyConfig.getName().endsWith("-0")) continue;
                copyConfig.setName(copyConfig.getParentName());
                this.storageManager.storeBridgeConfiguration(new PersistedBridgeConfiguration(copyConfig));
            }
            return true;
        }
        return false;
    }

    @Override
    public void destroyBridge(String name) throws Exception {
        if (this.clusterManager != null) {
            for (Bridge bridge : this.clusterManager.getBridges().values()) {
                if (!bridge.getConfiguration().getParentName().equals(name)) continue;
                this.clusterManager.destroyBridge(bridge.getConfiguration().getName());
            }
            this.storageManager.deleteBridgeConfiguration(name);
        }
    }

    @Override
    public void deployFederation(FederationConfiguration config) throws Exception {
        if (this.federationManager != null) {
            this.federationManager.deploy(config);
        }
    }

    @Override
    public void undeployFederation(String name) throws Exception {
        if (this.federationManager != null) {
            this.federationManager.undeploy(name);
        }
    }

    @Override
    public ServerSession getSessionByID(String sessionName) {
        return (ServerSession)this.sessions.get(sessionName);
    }

    public String toString() {
        if (this.identity != null) {
            return "ActiveMQServerImpl::" + this.identity;
        }
        if (this.configuration != null && this.configuration.getName() != null) {
            return "ActiveMQServerImpl::name=" + this.configuration.getName();
        }
        return "ActiveMQServerImpl::" + (String)(this.nodeManager != null ? "serverUUID=" + this.nodeManager.getUUID() : "");
    }

    public void replaceQueueFactory(QueueFactory factory) {
        this.queueFactory = factory;
    }

    @Override
    public PagingManager createPagingManager() throws Exception {
        return new PagingManagerImpl(this.getPagingStoreFactory(), this.addressSettingsRepository, this.configuration.getGlobalMaxSize(), this.configuration.getGlobalMaxMessages(), this.configuration.getManagementAddress(), this);
    }

    protected PagingStoreFactory getPagingStoreFactory() throws Exception {
        if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
            DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
            return new PagingStoreFactoryDatabase(dbConf, this.storageManager, this.configuration.getPageSyncTimeout(), this.scheduledPool, this.pageExecutorFactory, this.ioExecutorFactory, false, this.ioCriticalErrorListener);
        }
        return new PagingStoreFactoryNIO(this.storageManager, this.configuration.getPagingLocation(), this.configuration.getPageSyncTimeout(), this.scheduledPool, this.pageExecutorFactory, this.ioExecutorFactory, this.configuration.isJournalSyncNonTransactional(), this.ioCriticalErrorListener);
    }

    protected StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
                JDBCJournalStorageManager journal = new JDBCJournalStorageManager(this.configuration, this.getCriticalAnalyzer(), this.getScheduledPool(), this.executorFactory, this.ioExecutorFactory, this.ioCriticalErrorListener);
                this.getCriticalAnalyzer().add((CriticalComponent)journal);
                return journal;
            }
            JournalStorageManager journal = new JournalStorageManager(this.configuration, this.getCriticalAnalyzer(), this.executorFactory, this.scheduledPool, this.ioExecutorFactory, this.ioCriticalErrorListener);
            this.getCriticalAnalyzer().add((CriticalComponent)journal);
            return journal;
        }
        return new NullStorageManager();
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    private void callDeActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            try {
                callback.deActivate();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.unableToInvokeCallback(e);
            }
        }
    }

    private void callPreDeActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            try {
                callback.preDeActivate();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.unableToInvokeCallback(e);
            }
        }
    }

    private void callActivationCompleteCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activationComplete();
        }
    }

    private void initializeExecutorServices() {
        int maxIO;
        ThreadFactory tFactory;
        if (this.serviceRegistry.getExecutorService() == null) {
            tFactory = AccessController.doPrivileged(() -> new ActiveMQThreadFactory("ActiveMQ-server-" + this, false, ClientSessionFactoryImpl.class.getClassLoader()));
            this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tFactory) : new ActiveMQThreadPoolExecutor(0, this.configuration.getThreadPoolMaxSize(), 60L, TimeUnit.SECONDS, tFactory);
        } else {
            this.threadPool = this.serviceRegistry.getExecutorService();
            this.threadPoolSupplied = true;
        }
        this.executorFactory = new OrderedExecutorFactory((Executor)this.threadPool);
        if (this.serviceRegistry.getIOExecutorService() != null) {
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.serviceRegistry.getIOExecutorService());
        } else {
            tFactory = AccessController.doPrivileged(() -> new ActiveMQThreadFactory("ActiveMQ-IO-server-" + this, false, ClientSessionFactoryImpl.class.getClassLoader()));
            maxIO = this.configuration.getPageMaxConcurrentIO() <= 0 ? Integer.MAX_VALUE : this.configuration.getPageMaxConcurrentIO();
            this.ioExecutorPool = new ActiveMQThreadPoolExecutor(0, maxIO, 60L, TimeUnit.SECONDS, tFactory);
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.ioExecutorPool);
        }
        if (this.serviceRegistry.getIOExecutorService() != null) {
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.serviceRegistry.getIOExecutorService());
        } else {
            tFactory = AccessController.doPrivileged(() -> new ActiveMQThreadFactory("ActiveMQ-IO-server-" + this, false, ClientSessionFactoryImpl.class.getClassLoader()));
            this.ioExecutorPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tFactory);
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.ioExecutorPool);
        }
        if (this.serviceRegistry.getPageExecutorService() != null) {
            this.pageExecutorFactory = new OrderedExecutorFactory((Executor)this.serviceRegistry.getPageExecutorService()).setFair(true);
        } else {
            tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-PageExecutor-server-" + this.toString(), false, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            maxIO = this.configuration.getPageMaxConcurrentIO() <= 0 ? Integer.MAX_VALUE : this.configuration.getPageMaxConcurrentIO();
            this.pageExecutorPool = new ActiveMQThreadPoolExecutor(0, maxIO, 60L, TimeUnit.SECONDS, tFactory);
            this.pageExecutorFactory = new OrderedExecutorFactory((Executor)this.pageExecutorPool);
        }
        if (this.serviceRegistry.getScheduledExecutorService() == null) {
            tFactory = AccessController.doPrivileged(() -> new ActiveMQThreadFactory("ActiveMQ-scheduled-threads", false, ClientSessionFactoryImpl.class.getClassLoader()));
            ScheduledThreadPoolExecutor scheduledPoolExecutor = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), tFactory);
            scheduledPoolExecutor.setRemoveOnCancelPolicy(true);
            this.scheduledPool = scheduledPoolExecutor;
        } else {
            this.scheduledPoolSupplied = true;
            this.scheduledPool = this.serviceRegistry.getScheduledExecutorService();
            if (!(this.scheduledPool instanceof ScheduledThreadPoolExecutor) || !((ScheduledThreadPoolExecutor)this.scheduledPool).getRemoveOnCancelPolicy()) {
                ActiveMQServerLogger.LOGGER.scheduledPoolWithNoRemoveOnCancelPolicy();
            }
        }
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    synchronized boolean initialisePart1(boolean scalingDown) throws Exception {
        if (this.state == ActiveMQServer.SERVER_STATE.STOPPED) {
            return false;
        }
        if (this.configuration.getJournalType() == JournalType.ASYNCIO) {
            if (!AIOSequentialFileFactory.isSupported()) {
                ActiveMQServerLogger.LOGGER.switchingNIO();
                this.configuration.setJournalType(JournalType.NIO);
            } else if (!AIOSequentialFileFactory.isSupported((File)this.configuration.getJournalLocation())) {
                ActiveMQServerLogger.LOGGER.switchingNIOonPath(this.configuration.getJournalLocation().getAbsolutePath());
                this.configuration.setJournalType(JournalType.NIO);
            }
        }
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManager(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
        this.callPreActiveCallbacks();
        this.storageManager = this.createStorageManager();
        if (this.configuration.getClusterConfigurations().size() > 0 && ActiveMQDefaultConfiguration.getDefaultClusterUser().equals(this.configuration.getClusterUser()) && ActiveMQDefaultConfiguration.getDefaultClusterPassword().equals(this.configuration.getClusterPassword())) {
            ActiveMQServerLogger.LOGGER.clusterSecurityRisk();
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService, this.configuration.getAuthenticationCacheSize(), this.configuration.getAuthorizationCacheSize());
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager, this);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl(this, (int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        if (this.configuration.getMetricsConfiguration() != null && this.configuration.getMetricsConfiguration().getPlugin() != null) {
            this.metricsManager = new MetricsManager(this.configuration.getName(), this.configuration.getMetricsConfiguration(), this.addressSettingsRepository, this.securityStore);
        }
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getAddressQueueScanPeriod(), this.configuration.getWildcardConfiguration(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.clusterManager = new ClusterManager(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.nodeManager, this.haPolicy.useQuorumManager());
        this.federationManager = new FederationManager(this);
        this.backupManager = new BackupManager(this, this.executorFactory, this.scheduledPool, this.nodeManager, this.configuration, this.clusterManager);
        this.clusterManager.deploy();
        this.federationManager.deploy();
        this.connectionRouterManager = new ConnectionRouterManager(this.configuration, this, this.scheduledPool);
        this.connectionRouterManager.deploy();
        this.remotingService = new RemotingServiceImpl(this.clusterManager, this.configuration, this, this.managementService, this.scheduledPool, this.protocolManagerFactories, (Executor)this.executorFactory.getExecutor(), this.serviceRegistry);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.securityStore, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.haPolicy.isBackup());
        if (!scalingDown) {
            this.deployAddressSettingsFromConfiguration();
        }
        if (!this.configuration.isPersistenceEnabled()) {
            for (AddressSettings addressSettings : this.addressSettingsRepository.values()) {
                if (addressSettings.getAddressFullMessagePolicy() != AddressFullMessagePolicy.PAGE) continue;
                ActiveMQServerLogger.LOGGER.pageWillBePersisted();
                break;
            }
        }
        this.storageManager.start();
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        this.deploySecurityFromConfiguration();
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
        long configurationFileRefreshPeriod = this.configuration.getConfigurationFileRefreshPeriod();
        if (configurationFileRefreshPeriod > 0L) {
            File optionalJaasConfigBaseDir;
            this.reloadManager = new ReloadManagerImpl(this.getScheduledPool(), (Executor)this.executorFactory.getExecutor(), configurationFileRefreshPeriod);
            if (this.configuration.getConfigurationUrl() != null && this.getScheduledPool() != null) {
                URL configUrl = this.configuration.getConfigurationUrl();
                ReloadCallback xmlConfigReload = uri -> this.reloadConfigurationFile(configUrl);
                this.reloadManager.addCallback(configUrl, xmlConfigReload);
                String propsLocations = this.configuration.resolvePropertiesSources(this.propertiesFileUrl);
                if (propsLocations != null) {
                    for (String fileUrl : propsLocations.split(",")) {
                        this.reloadManager.addCallback(new File(fileUrl).toURI().toURL(), xmlConfigReload);
                    }
                }
            }
            if ((optionalJaasConfigBaseDir = PropertiesLoader.FileNameKey.parentDirOfLoginConfigSystemProperty()) != null) {
                this.reloadManager.addCallback(optionalJaasConfigBaseDir.toURI().toURL(), uri -> PropertiesLoader.reload());
            }
            this.configuration.getAcceptorConfigurations().forEach(acceptorConfig -> {
                Map config = acceptorConfig.getCombinedParams();
                if (ConfigurationHelper.getBooleanProperty((String)"sslAutoReload", (boolean)false, (Map)config)) {
                    this.addAcceptorStoreReloadCallback(acceptorConfig.getName(), this.fileUrlFrom(config.get("keyStorePath")), this.storeTypeFrom(config.get("keyStoreType")));
                    this.addAcceptorStoreReloadCallback(acceptorConfig.getName(), this.fileUrlFrom(config.get("trustStorePath")), this.storeTypeFrom(config.get("trustStoreType")));
                }
            });
        }
        if (this.hasBrokerPlugins()) {
            this.registerBrokerPlugins(this.getBrokerPlugins());
        }
        if (this.configuration.getMetricsConfiguration() != null && this.configuration.getMetricsConfiguration().getPlugin() != null) {
            this.configuration.getMetricsConfiguration().getPlugin().registered(this);
        }
        return true;
    }

    private void addAcceptorStoreReloadCallback(String acceptorName, URL storeURL, String storeType) {
        if (storeURL != null) {
            this.reloadManager.addCallback(storeURL, uri -> {
                Object targetControl;
                if (this.managementService != null && (targetControl = this.managementService.getResource("acceptor." + acceptorName)) instanceof AcceptorControl) {
                    ((AcceptorControl)targetControl).reload();
                }
            });
            if (PemConfigUtil.isPemConfigStoreType((String)storeType)) {
                String[] sources = null;
                try (InputStream pemConfigStream = storeURL.openStream();){
                    sources = PemConfigUtil.parseSources((InputStream)pemConfigStream);
                }
                catch (IOException e) {
                    ActiveMQServerLogger.LOGGER.skipSSLAutoReloadForSourcesOfStore(storeURL.getPath(), e.toString());
                }
                if (sources != null) {
                    for (String source : sources) {
                        URL sourceURL = this.fileUrlFrom(source);
                        if (sourceURL == null) continue;
                        this.addAcceptorStoreReloadCallback(acceptorName, sourceURL, null);
                    }
                }
            }
        }
    }

    private URL fileUrlFrom(Object o) {
        if (o instanceof String) {
            try {
                return new File((String)o).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String storeTypeFrom(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    @Override
    public void installMirrorController(MirrorController mirrorController) {
        logger.debug("Mirror controller is being installed");
        if (this.postOffice != null) {
            this.postOffice.setMirrorControlSource(mirrorController);
        }
        this.mirrorControllerService = mirrorController;
    }

    @Override
    public void scanAddresses(MirrorController mirrorController) throws Exception {
        logger.debug("Scanning addresses to send on mirror controller");
        this.postOffice.scanAddresses(mirrorController);
    }

    @Override
    public MirrorController getMirrorController() {
        return this.mirrorControllerService;
    }

    @Override
    public void removeMirrorControl() {
        this.postOffice.setMirrorControlSource(null);
    }

    synchronized void initialisePart2(boolean scalingDown) throws Exception {
        if (this.state == ActiveMQServer.SERVER_STATE.STOPPED || this.state == ActiveMQServer.SERVER_STATE.STOPPING) {
            return;
        }
        this.loadProtocolServices();
        this.pagingManager.reloadStores();
        HashSet<Long> storedLargeMessages = new HashSet<Long>();
        this.loadJournals(storedLargeMessages);
        if (this.rebuildCounters) {
            this.pagingManager.rebuildCounters(storedLargeMessages);
            this.pagingManager.execute(() -> storedLargeMessages.forEach(id -> {
                try {
                    SequentialFile file = this.storageManager.createFileForLargeMessage((long)id, true);
                    logger.debug("Removing pending large message for file={}", (Object)file);
                    file.delete();
                }
                catch (Exception e) {
                    logger.warn("It was not possible to remove previously stored large message on folder::It will be retried on next startup", (Throwable)e);
                }
            }));
        }
        this.removeExtraAddressStores();
        if (this.securityManager instanceof ActiveMQBasicSecurityManager) {
            ((ActiveMQBasicSecurityManager)this.securityManager).completeInit(this.storageManager);
        }
        ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(() -> ActiveMQServerLogger.LOGGER.dumpServerInfo(dumper.dump()), 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        this.deployAddressesFromConfiguration();
        this.deployQueuesFromConfiguration();
        this.undeployAddressesAndQueueNotInConfiguration();
        this.deployReloadableConfigFromConfiguration();
        this.callActivateCallbacks();
        this.checkForPotentialOOMEInAddressConfiguration();
        if (!scalingDown) {
            this.deployDiverts();
            if (this.groupingHandler != null) {
                this.groupingHandler.start();
            }
            if (this.groupingHandler != null && this.groupingHandler instanceof LocalGroupingHandler) {
                this.clusterManager.start();
                this.federationManager.start();
                this.groupingHandler.awaitBindings();
                this.remotingService.start();
            } else {
                this.remotingService.start();
                this.clusterManager.start();
                this.federationManager.start();
            }
            this.connectionRouterManager.start();
            this.startProtocolServices();
            if (this.nodeManager.getNodeId() == null) {
                throw ActiveMQMessageBundle.BUNDLE.nodeIdNull();
            }
            this.postOffice.startExpiryScanner();
            this.postOffice.startAddressQueueScanner();
            this.recoverStoredConnectors();
            this.recoverStoredBridges();
        }
        this.deployFileStoreMonitor();
    }

    private void deployFileStoreMonitor() throws Exception {
        FileStoreMonitor.FileStoreMonitorType fileStoreMonitorType = null;
        Number referenceValue = null;
        if (this.configuration.getMinDiskFree() != -1L) {
            if (this.configuration.getMaxDiskUsage() != -1) {
                ActiveMQServerLogger.LOGGER.configParamOverride("min-disk-free", this.configuration.getMinDiskFree(), "max-disk-usage", this.configuration.getMaxDiskUsage());
            }
            fileStoreMonitorType = FileStoreMonitor.FileStoreMonitorType.MinDiskFree;
            referenceValue = this.configuration.getMinDiskFree();
        } else if (this.configuration.getMaxDiskUsage() != -1) {
            fileStoreMonitorType = FileStoreMonitor.FileStoreMonitorType.MaxDiskUsage;
            referenceValue = (double)this.configuration.getMaxDiskUsage() / 100.0;
        }
        if (fileStoreMonitorType != null) {
            this.injectMonitor(new FileStoreMonitor(this.getScheduledPool(), (Executor)this.executorFactory.getExecutor(), this.configuration.getDiskScanPeriod(), TimeUnit.MILLISECONDS, referenceValue, this.ioCriticalErrorListener, fileStoreMonitorType));
        }
    }

    private void loadProtocolServices() {
        this.remotingService.loadProtocolServices(this.protocolServices);
    }

    private void startProtocolServices() throws Exception {
        for (ProtocolManagerFactory protocolManagerFactory : this.protocolManagerFactories) {
            protocolManagerFactory.loadProtocolServices(this, this.protocolServices);
        }
        for (ActiveMQComponent protocolComponent : this.protocolServices) {
            protocolComponent.start();
        }
    }

    private void updateProtocolServices() throws Exception {
        this.remotingService.updateProtocolServices(this.protocolServices);
        for (ProtocolManagerFactory protocolManagerFactory : this.protocolManagerFactories) {
            protocolManagerFactory.updateProtocolServices(this, this.protocolServices);
        }
    }

    public void injectMonitor(FileStoreMonitor storeMonitor) throws Exception {
        try {
            this.fileStoreMonitor = storeMonitor;
            this.pagingManager.injectMonitor(storeMonitor);
            this.storageManager.injectMonitor(storeMonitor);
            this.fileStoreMonitor.start();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToInjectMonitor(e);
        }
    }

    public FileStoreMonitor getMonitor() {
        return this.fileStoreMonitor;
    }

    public void completeActivation(boolean replicated) throws Exception {
        this.setState(ActiveMQServer.SERVER_STATE.STARTED);
        if (replicated && this.getClusterManager() != null) {
            for (ClusterConnection clusterConnection : this.getClusterManager().getClusterConnections()) {
                clusterConnection.setSplitBrainDetection(true);
            }
        }
        this.getRemotingService().startAcceptors();
        this.activationLatch.countDown();
        this.callActivationCompleteCallbacks();
    }

    @Override
    public double getDiskStoreUsage() {
        if (this.getPagingManager() == null) {
            return -1.0;
        }
        return FileStoreMonitor.calculateUsage(this.getPagingManager().getDiskUsableSpace(), this.getPagingManager().getDiskTotalSpace());
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
        for (SecuritySettingPlugin securitySettingPlugin : this.configuration.getSecuritySettingPlugins()) {
            securitySettingPlugin.setSecurityRepository(this.securityRepository);
        }
    }

    private void undeployAddressesAndQueueNotInConfiguration() throws Exception {
        this.undeployAddressesAndQueueNotInConfiguration(this.configuration);
    }

    private void undeployAddressesAndQueueNotInConfiguration(Configuration configuration) throws Exception {
        Set addressesInConfig = configuration.getAddressConfigurations().stream().map(CoreAddressConfiguration::getName).collect(Collectors.toSet());
        Map<SimpleString, List<QueueConfiguration>> queuesInConfig = configuration.getAddressConfigurations().stream().map(CoreAddressConfiguration::getQueueConfigs).flatMap(Collection::stream).collect(Collectors.groupingBy(QueueConfiguration::getName));
        for (SimpleString addressName : this.listAddressNames()) {
            AddressInfo addressInfo = this.getAddressInfo(addressName);
            AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(addressName.toString());
            if (!addressesInConfig.contains(addressName.toString()) && addressInfo != null && !addressInfo.isAutoCreated() && addressSettings.getConfigDeleteAddresses() == DeletionPolicy.FORCE) {
                for (Queue queue : this.listQueues(addressName)) {
                    ActiveMQServerLogger.LOGGER.undeployQueue(queue.getName());
                    try {
                        queue.deleteQueue(true);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToUndeployQueue(addressName, e.getMessage());
                    }
                }
                ActiveMQServerLogger.LOGGER.undeployAddress(addressName);
                try {
                    this.removeAddressInfo(addressName, null);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToUndeployAddress(addressName, e.getMessage());
                }
                continue;
            }
            if (addressSettings.getConfigDeleteQueues() != DeletionPolicy.FORCE) continue;
            for (Queue queue : this.listConfiguredQueues(addressName)) {
                List<QueueConfiguration> queueConfigsInConfig = queuesInConfig.get(queue.getName());
                if (queueConfigsInConfig != null && queueConfigsInConfig.stream().anyMatch(queueConfiguration -> queueConfiguration.getAddress().equals((Object)addressName))) continue;
                ActiveMQServerLogger.LOGGER.undeployQueue(queue.getName());
                try {
                    queue.deleteQueue(true);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToUndeployQueue(addressName, e.getMessage());
                }
            }
        }
    }

    private Set<SimpleString> listAddressNames() {
        return this.postOffice.getAddresses();
    }

    private List<Queue> listConfiguredQueues(SimpleString address) throws Exception {
        return this.listQueues(address).stream().filter(queue -> queue.isConfigurationManaged()).collect(Collectors.toList());
    }

    private List<Queue> listQueues(SimpleString address) throws Exception {
        return this.postOffice.listQueuesForAddress(address);
    }

    private void deployAddressesFromConfiguration() throws Exception {
        this.deployAddressesFromConfiguration(this.configuration);
    }

    private void deployAddressesFromConfiguration(Configuration configuration) throws Exception {
        for (CoreAddressConfiguration config : configuration.getAddressConfigurations()) {
            try {
                ActiveMQServerLogger.LOGGER.deployAddress(config.getName(), config.getRoutingTypes().toString());
                SimpleString address = SimpleString.of((String)config.getName());
                AddressInfo tobe = new AddressInfo(address, config.getRoutingTypes());
                AddressInfo current = this.getAddressInfo(address);
                AddressInfo merged = new AddressInfo(address, tobe.getRoutingType());
                if (current != null) {
                    merged.getRoutingTypes().addAll(current.getRoutingTypes());
                }
                this.addOrUpdateAddressInfo(merged);
                this.deployQueuesFromListQueueConfiguration(config.getQueueConfigs());
                this.addOrUpdateAddressInfo(tobe);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.problemDeployingAddress(config.getName(), e.getMessage());
            }
        }
    }

    private AddressInfo mergedRoutingTypes(SimpleString address, AddressInfo ... addressInfos) {
        EnumSet<RoutingType> mergedRoutingTypes = EnumSet.noneOf(RoutingType.class);
        for (AddressInfo addressInfo : addressInfos) {
            if (addressInfo == null) continue;
            mergedRoutingTypes.addAll(addressInfo.getRoutingTypes());
        }
        return new AddressInfo(address, mergedRoutingTypes);
    }

    private void deployQueuesFromListQueueConfiguration(List<QueueConfiguration> queues) throws Exception {
        for (QueueConfiguration config : queues) {
            try {
                QueueConfigurationUtils.applyDynamicQueueDefaults(config, this.addressSettingsRepository.getMatch(config.getAddress().toString()));
                config.setAutoCreateAddress(Boolean.valueOf(true));
                ActiveMQServerLogger.LOGGER.deployQueue(config.getRoutingType().toString(), config.getName().toString(), config.getAddress().toString());
                if (this.locateQueue(config.getName()) != null && this.locateQueue(config.getName()).getAddress().equals((Object)config.getAddress())) {
                    config.setConfigurationManaged(Boolean.valueOf(true));
                    ActiveMQServerImpl.setUnsetQueueParamsToDefaults(config);
                    this.updateQueue(config, true);
                    continue;
                }
                try {
                    this.createQueue(config.setTemporary(Boolean.valueOf(false)).setTransient(Boolean.valueOf(false)).setAutoCreated(Boolean.valueOf(false)).setConfigurationManaged(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(true)), false);
                }
                catch (ActiveMQQueueExistsException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.problemDeployingQueue(config.getName().toString(), e.getMessage());
            }
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        this.deployQueuesFromListQueueConfiguration(this.configuration.getQueueConfigs());
    }

    private void checkForPotentialOOMEInAddressConfiguration() {
        long totalMaxSizeBytes = 0L;
        long addressCount = 0L;
        for (SimpleString address : this.postOffice.getAddresses()) {
            totalMaxSizeBytes += this.addressSettingsRepository.getMatch(address.toString()).getMaxSizeBytes();
            ++addressCount;
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (totalMaxSizeBytes >= maxMemory && this.configuration.getGlobalMaxSize() < 0L) {
            ActiveMQServerLogger.LOGGER.potentialOOME(addressCount, totalMaxSizeBytes, maxMemory);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private JournalLoadInformation[] loadJournals(Set<Long> storedLargeMessages) throws Exception {
        JournalLoader journalLoader = this.activation.createJournalLoader(this.postOffice, this.pagingManager, this.storageManager, this.queueFactory, this.nodeManager, this.managementService, this.groupingHandler, this.configuration, this.parentServer);
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        ArrayList<AddressBindingInfo> addressBindingInfos = new ArrayList<AddressBindingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos, addressBindingInfos);
        this.recoverStoredConfigs();
        journalLoader.initAddresses(addressBindingInfos);
        HashMap<Long, QueueBindingInfo> queueBindingInfosMap = new HashMap<Long, QueueBindingInfo>();
        journalLoader.initQueues(queueBindingInfosMap, queueBindingInfos);
        journalLoader.handleGroupingBindings(groupingInfos);
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        HashSet<Pair<Long, Long>> pendingLargeMessages = new HashSet<Pair<Long, Long>>();
        LinkedList<PageCountPending> pendingNonTXPageCounter = new LinkedList<PageCountPending>();
        this.storageManager.recoverLargeMessagesOnFolder(storedLargeMessages);
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queueBindingInfosMap, duplicateIDMap, pendingLargeMessages, storedLargeMessages, pendingNonTXPageCounter, journalLoader, this.extraRecordsLoader);
        journalLoader.handleDuplicateIds(duplicateIDMap);
        for (Pair<Long, Long> msgToDelete : pendingLargeMessages) {
            ActiveMQServerLogger.LOGGER.deletingPendingMessage(msgToDelete);
            LargeServerMessage msg = this.storageManager.createCoreLargeMessage();
            msg.setMessageID((Long)msgToDelete.getB());
            msg.setDurable(true);
            msg.deleteFile();
        }
        if (pendingNonTXPageCounter.size() != 0) {
            try {
                journalLoader.recoverPendingPageCounters(pendingNonTXPageCounter);
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorRecoveringPageCounter(e);
            }
        }
        journalLoader.cleanUp();
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        this.recoverStoredAddressSettings();
        this.recoverStoredSecuritySettings();
    }

    private void recoverStoredSecuritySettings() throws Exception {
        List<PersistedSecuritySetting> roles = this.storageManager.recoverSecuritySettings();
        for (PersistedSecuritySetting roleItem : roles) {
            Set setRoles = SecurityFormatter.createSecurity((String)roleItem.getSendRoles(), (String)roleItem.getConsumeRoles(), (String)roleItem.getCreateDurableQueueRoles(), (String)roleItem.getDeleteDurableQueueRoles(), (String)roleItem.getCreateNonDurableQueueRoles(), (String)roleItem.getDeleteNonDurableQueueRoles(), (String)roleItem.getManageRoles(), (String)roleItem.getBrowseRoles(), (String)roleItem.getCreateAddressRoles(), (String)roleItem.getDeleteAddressRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    private void recoverStoredAddressSettings() throws Exception {
        List<AbstractPersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (AbstractPersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
    }

    @Override
    public boolean updateAddressInfo(SimpleString address, EnumSet<RoutingType> routingTypes) throws Exception {
        if (this.getAddressInfo(address) == null) {
            return false;
        }
        this.postOffice.updateAddressInfo(address, routingTypes);
        return true;
    }

    @Override
    public boolean updateAddressInfo(SimpleString address, Collection<RoutingType> routingTypes) throws Exception {
        return this.updateAddressInfo(address, EnumSet.copyOf(routingTypes));
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) throws Exception {
        boolean result = this.postOffice.addAddressInfo(addressInfo);
        return result;
    }

    @Override
    public AddressInfo addOrUpdateAddressInfo(AddressInfo addressInfo) throws Exception {
        if (!this.addAddressInfo(addressInfo)) {
            this.updateAddressInfo(addressInfo.getName(), addressInfo.getRoutingTypes());
        }
        return this.getAddressInfo(addressInfo.getName());
    }

    @Override
    public void removeAddressInfo(SimpleString address, SecurityAuth auth) throws Exception {
        this.removeAddressInfo(address, auth, false);
    }

    @Override
    public void autoRemoveAddressInfo(SimpleString address, SecurityAuth auth) throws Exception {
        logger.debug("deleting auto-created address \"{}.\"", (Object)address);
        ActiveMQServerLogger.LOGGER.autoRemoveAddress(String.valueOf(address));
        this.removeAddressInfo(address, auth);
    }

    @Override
    public void registerQueueOnManagement(Queue queue) throws Exception {
        this.managementService.registerQueue(queue, queue.getAddress(), this.storageManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAddressInfo(SimpleString address, SecurityAuth auth, boolean force) throws Exception {
        if (auth != null) {
            this.securityStore.check(address, CheckType.DELETE_ADDRESS, auth);
        }
        try {
            AddressInfo addressInfo = this.getAddressInfo(address);
            if (this.postOffice.removeAddressInfo(address, force) == null) {
                throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(address);
            }
            if (addressInfo.getRepositoryChangeListener() != null) {
                this.addressSettingsRepository.unRegisterListener(addressInfo.getRepositoryChangeListener());
                addressInfo.setRepositoryChangeListener(null);
            }
            long txID = this.storageManager.generateID();
            this.storageManager.deleteAddressBinding(txID, addressInfo.getId());
            this.storageManager.commitBindings(txID);
            this.pagingManager.deletePageStore(address);
        }
        finally {
            this.clearAddressCache();
        }
    }

    @Override
    public String getInternalNamingPrefix() {
        return this.configuration.getInternalNamingPrefix();
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString address) {
        return this.postOffice.getAddressInfo(address);
    }

    @Deprecated
    public Queue createQueue(AddressInfo addrInfo, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress, boolean configurationManaged, long ringSize) throws Exception {
        return this.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addrInfo == null ? null : addrInfo.getName()).setRoutingType(addrInfo == null ? null : addrInfo.getRoutingType()).setFilterString(filterString).setUser(user).setDurable(Boolean.valueOf(durable)).setTemporary(Boolean.valueOf(temporary)).setTransient(Boolean.valueOf(transientQueue)).setAutoCreated(Boolean.valueOf(autoCreated)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setExclusive(Boolean.valueOf(exclusive)).setGroupRebalance(Boolean.valueOf(groupRebalance)).setGroupBuckets(Integer.valueOf(groupBuckets)).setGroupFirstKey(groupFirstKey).setLastValue(Boolean.valueOf(lastValue)).setLastValueKey(lastValueKey).setNonDestructive(Boolean.valueOf(nonDestructive)).setConsumersBeforeDispatch(Integer.valueOf(consumersBeforeDispatch)).setDelayBeforeDispatch(Long.valueOf(delayBeforeDispatch)).setAutoDelete(Boolean.valueOf(autoDelete)).setAutoDeleteDelay(Long.valueOf(autoDeleteDelay)).setAutoDeleteMessageCount(Long.valueOf(autoDeleteMessageCount)).setAutoCreateAddress(Boolean.valueOf(autoCreateAddress)).setConfigurationManaged(Boolean.valueOf(configurationManaged)).setRingSize(Long.valueOf(ringSize)), ignoreIfExists);
    }

    @Override
    public Queue createQueue(QueueConfiguration queueConfiguration) throws Exception {
        return this.createQueue(queueConfiguration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue createQueue(QueueConfiguration queueConfiguration, boolean ignoreIfExists) throws Exception {
        PostOffice postOfficeInUse = this.postOffice;
        if (postOfficeInUse == null) {
            return null;
        }
        PostOffice postOffice = postOfficeInUse;
        synchronized (postOffice) {
            if (queueConfiguration.getName() == null || queueConfiguration.getName().length() == 0) {
                throw ActiveMQMessageBundle.BUNDLE.invalidQueueName(queueConfiguration.getName());
            }
            Binding rawBinding = postOfficeInUse.getBinding(queueConfiguration.getName());
            if (rawBinding != null) {
                if (rawBinding.getType() != BindingType.LOCAL_QUEUE) {
                    throw ActiveMQMessageBundle.BUNDLE.bindingAlreadyExists(queueConfiguration.getName().toString(), rawBinding.toManagementString());
                }
                QueueBinding queueBinding = (QueueBinding)rawBinding;
                if (ignoreIfExists) {
                    queueBinding.getQueue().setSwept(false);
                    return queueBinding.getQueue();
                }
                throw ActiveMQMessageBundle.BUNDLE.queueAlreadyExists(queueConfiguration.getName(), queueBinding.getAddress());
            }
            QueueConfigurationUtils.applyDynamicQueueDefaults(queueConfiguration, this.addressSettingsRepository.getMatch(this.getRuntimeTempQueueNamespace(queueConfiguration.isTemporary()) + queueConfiguration.getAddress().toString()));
            AddressInfo info = postOfficeInUse.getAddressInfo(queueConfiguration.getAddress());
            if (queueConfiguration.isAutoCreateAddress().booleanValue() || queueConfiguration.isTemporary().booleanValue()) {
                if (info == null) {
                    this.addAddressInfo(new AddressInfo(queueConfiguration.getAddress(), queueConfiguration.getRoutingType()).setAutoCreated(true).setTemporary(queueConfiguration.isTemporary()).setInternal(queueConfiguration.isInternal()));
                } else if (!info.getRoutingTypes().contains(queueConfiguration.getRoutingType())) {
                    EnumSet<RoutingType> routingTypes = EnumSet.copyOf(info.getRoutingTypes());
                    routingTypes.add(queueConfiguration.getRoutingType());
                    this.updateAddressInfo(info.getName(), routingTypes);
                }
            } else {
                if (info == null) {
                    throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(queueConfiguration.getAddress());
                }
                if (!info.getRoutingTypes().contains(queueConfiguration.getRoutingType())) {
                    throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeForAddress(queueConfiguration.getRoutingType(), info.getName().toString(), info.getRoutingTypes());
                }
            }
            if (this.hasBrokerQueuePlugins()) {
                this.callBrokerQueuePlugins(plugin -> plugin.beforeCreateQueue(queueConfiguration));
            }
            if (this.mirrorControllerService != null && !queueConfiguration.isInternal().booleanValue()) {
                this.mirrorControllerService.createQueue(queueConfiguration);
            }
            queueConfiguration.setId(Long.valueOf(this.storageManager.generateID()));
            Filter filter = FilterImpl.createFilter(queueConfiguration.getFilterString());
            Queue queue = this.queueFactory.createQueueWith(queueConfiguration, this.pagingManager, filter);
            LocalQueueBinding localQueueBinding = new LocalQueueBinding(queue.getAddress(), queue, this.nodeManager.getNodeId());
            long txID = 0L;
            if (queue.isDurable()) {
                txID = this.storageManager.generateID();
                this.storageManager.addQueueBinding(txID, localQueueBinding);
            }
            try {
                postOfficeInUse.addBinding(localQueueBinding);
                if (queue.isDurable()) {
                    this.storageManager.commitBindings(txID);
                }
            }
            catch (Exception e) {
                try {
                    if (queueConfiguration.isDurable().booleanValue()) {
                        this.storageManager.rollbackBindings(txID);
                    }
                    try {
                        queue.close();
                    }
                    finally {
                        if (queue.getPageSubscription() != null) {
                            queue.getPageSubscription().destroy();
                        }
                    }
                }
                catch (Throwable ignored) {
                    logger.debug(ignored.getMessage(), ignored);
                }
                throw e;
            }
            this.managementService.registerQueue(queue, queue.getAddress(), this.storageManager);
            this.copyRetroactiveMessages(queue);
            if (this.hasBrokerQueuePlugins()) {
                this.callBrokerQueuePlugins(plugin -> plugin.afterCreateQueue(queue));
            }
            this.callPostQueueCreationCallbacks(queue.getName());
            return queue;
        }
    }

    public String getRuntimeTempQueueNamespace(boolean temporary) {
        StringBuilder runtimeTempQueueNamespace = new StringBuilder();
        if (temporary && this.configuration.getTemporaryQueueNamespace() != null && this.configuration.getTemporaryQueueNamespace().length() > 0) {
            runtimeTempQueueNamespace.append(this.configuration.getTemporaryQueueNamespace()).append(this.configuration.getWildcardConfiguration().getDelimiterString());
        }
        return runtimeTempQueueNamespace.toString();
    }

    private void copyRetroactiveMessages(Queue queue) throws Exception {
        Queue retroQueue;
        if (this.addressSettingsRepository.getMatch(queue.getAddress().toString()).getRetroactiveMessageCount() > 0L && (retroQueue = this.locateQueue(ResourceNames.getRetroactiveResourceQueueName((String)this.getInternalNamingPrefix(), (String)this.getConfiguration().getWildcardConfiguration().getDelimiterString(), (SimpleString)queue.getAddress(), (RoutingType)queue.getRoutingType()))) != null && retroQueue instanceof QueueImpl) {
            ((QueueImpl)retroQueue).rerouteMessages(queue.getName(), queue.getFilter());
        }
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(new AddressInfo(address).addRoutingType(routingType), queueName, filterString, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, as.getDefaultGroupFirstKey(), lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, false, as.getDefaultRingSize());
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(new AddressInfo(address).addRoutingType(routingType), queueName, filterString, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, false, as.getDefaultRingSize());
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress, long ringSize) throws Exception {
        return this.createQueue(new AddressInfo(address).addRoutingType(routingType), queueName, filterString, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, false, ringSize);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers) throws Exception {
        return this.updateQueue(name, routingType, maxConsumers, purgeOnNoConsumers, null);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive) throws Exception {
        return this.updateQueue(name, routingType, maxConsumers, purgeOnNoConsumers, null, null);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, String user) throws Exception {
        return this.updateQueue(name, routingType, null, maxConsumers, purgeOnNoConsumers, exclusive, null, null, null, null, null, user);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, String filterString, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user) throws Exception {
        return this.updateQueue(name, routingType, filterString, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, null, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, null);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, String filterString, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, String groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user) throws Exception {
        return this.updateQueue(name, routingType, filterString, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, null);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, String filterString, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, String groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user, Long ringSize) throws Exception {
        return this.updateQueue(QueueConfiguration.of((String)name).setRoutingType(routingType).setFilterString(filterString).setMaxConsumers(maxConsumers).setPurgeOnNoConsumers(purgeOnNoConsumers).setExclusive(exclusive).setGroupRebalance(groupRebalance).setGroupBuckets(groupBuckets).setGroupFirstKey(groupFirstKey).setNonDestructive(nonDestructive).setConsumersBeforeDispatch(consumersBeforeDispatch).setDelayBeforeDispatch(delayBeforeDispatch).setUser(user).setRingSize(ringSize));
    }

    @Override
    public Queue updateQueue(QueueConfiguration queueConfiguration) throws Exception {
        return this.updateQueue(queueConfiguration, false);
    }

    @Override
    public Queue updateQueue(QueueConfiguration queueConfiguration, boolean forceUpdate) throws Exception {
        QueueBinding queueBinding = this.postOffice.updateQueue(queueConfiguration, forceUpdate);
        if (queueBinding != null) {
            return queueBinding.getQueue();
        }
        return null;
    }

    private void deployDiverts() throws Exception {
        this.recoverStoredDiverts();
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            this.deployDivert(config);
        }
    }

    private void recoverStoredDiverts() throws Exception {
        if (this.storageManager.recoverDivertConfigurations() != null) {
            for (PersistedDivertConfiguration persistedDivertConfiguration : this.storageManager.recoverDivertConfigurations()) {
                boolean deleted = this.configuration.getDivertConfigurations().stream().noneMatch(divertConfiguration -> divertConfiguration.getName().equals(persistedDivertConfiguration.getName()));
                if (!deleted) continue;
                if (this.addressSettingsRepository.getMatch(persistedDivertConfiguration.getDivertConfiguration().getAddress()).getConfigDeleteDiverts() == DeletionPolicy.FORCE) {
                    this.storageManager.deleteDivertConfiguration(persistedDivertConfiguration.getName());
                    continue;
                }
                this.deployDivert(persistedDivertConfiguration.getDivertConfiguration());
            }
        }
    }

    private void recoverStoredBridges() throws Exception {
        if (this.storageManager.recoverBridgeConfigurations() != null) {
            for (PersistedBridgeConfiguration persistedBridgeConfiguration : this.storageManager.recoverBridgeConfigurations()) {
                this.deployBridge(persistedBridgeConfiguration.getBridgeConfiguration());
            }
        }
    }

    private void recoverStoredConnectors() throws Exception {
        if (this.storageManager.recoverConnectors() != null) {
            for (PersistedConnector persistedConnector : this.storageManager.recoverConnectors()) {
                this.getConfiguration().addConnectorConfiguration(persistedConnector.getName(), persistedConnector.getUrl());
            }
        }
    }

    private void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupHandlingAbstract groupingHandler1 = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.executorFactory, this.scheduledPool, this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout(), config.getGroupTimeout(), config.getReaperPeriod()) : new RemoteGroupingHandler(this.executorFactory, this.managementService, config.getName(), config.getAddress(), config.getTimeout(), config.getGroupTimeout());
            this.groupingHandler = groupingHandler1;
            this.managementService.addNotificationListener(groupingHandler1);
        }
    }

    public void checkJournalDirectory() {
        File nodeManagerLockDir;
        File journalDir = this.configuration.getJournalLocation();
        if (!journalDir.exists() && this.configuration.isPersistenceEnabled()) {
            if (this.configuration.isCreateJournalDir()) {
                journalDir.mkdirs();
            } else {
                throw ActiveMQMessageBundle.BUNDLE.cannotCreateDir(journalDir.getAbsolutePath());
            }
        }
        if (!journalDir.equals(nodeManagerLockDir = this.configuration.getNodeManagerLockLocation()) && this.configuration.isPersistenceEnabled() && !nodeManagerLockDir.exists()) {
            nodeManagerLockDir.mkdirs();
        }
    }

    @Override
    public void addProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.add(factory);
    }

    @Override
    public void removeProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.remove(factory);
    }

    @Override
    public ActiveMQServer createBackupServer(Configuration configuration) {
        return new ActiveMQServerImpl(configuration, null, this.securityManager, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScaledDownNode(SimpleString scaledDownNodeId) {
        List<SimpleString> list = this.scaledDownNodeIDs;
        synchronized (list) {
            this.scaledDownNodeIDs.add(scaledDownNodeId);
            if (this.scaledDownNodeIDs.size() > 10) {
                this.scaledDownNodeIDs.remove(10);
            }
        }
    }

    @Override
    public boolean hasScaledDown(SimpleString scaledDownNodeId) {
        return this.scaledDownNodeIDs.contains(scaledDownNodeId);
    }

    void moveServerData(int maxSavedReplicated) throws IOException {
        this.moveServerData(maxSavedReplicated, false);
    }

    void moveServerData(int maxSavedReplicated, boolean preserveLockFiles) throws IOException {
        File[] dataDirs;
        for (File data : dataDirs = new File[]{this.configuration.getBindingsLocation(), this.configuration.getJournalLocation(), this.configuration.getPagingLocation(), this.configuration.getLargeMessagesLocation()}) {
            String[] stringArray;
            boolean isLockFolder;
            boolean bl = isLockFolder = preserveLockFiles ? data.equals(this.configuration.getNodeManagerLockLocation()) : false;
            if (isLockFolder) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "server.lock";
                stringArray = stringArray2;
                stringArray2[1] = "serverlock";
            } else {
                stringArray = null;
            }
            String[] lockPrefixes = stringArray;
            FileMoveManager moveManager = new FileMoveManager(data, maxSavedReplicated, lockPrefixes);
            moveManager.doMove();
        }
    }

    @Override
    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "not started";
        }
        return TimeUtils.printDuration((double)delta);
    }

    @Override
    public long getUptimeMillis() {
        if (this.startDate == null) {
            return 0L;
        }
        return new Date().getTime() - this.startDate.getTime();
    }

    @Override
    public boolean addClientConnection(String clientId, boolean unique) {
        AtomicInteger i = this.connectedClientIds.putIfAbsent(clientId, new AtomicInteger(1));
        if (i != null) {
            if (unique && i.get() != 0) {
                return false;
            }
            if (i.incrementAndGet() > 0) {
                this.connectedClientIds.put(clientId, i);
            }
        }
        return true;
    }

    @Override
    public void removeClientConnection(String clientId) {
        AtomicInteger i = (AtomicInteger)this.connectedClientIds.get(clientId);
        if (i != null && i.decrementAndGet() == 0) {
            this.connectedClientIds.remove(clientId);
        }
    }

    private void removeExtraAddressStores() throws Exception {
        SimpleString[] storeNames = this.pagingManager.getStoreNames();
        if (storeNames != null && storeNames.length > 0) {
            for (SimpleString storeName : storeNames) {
                if (this.getAddressInfo(storeName) != null) continue;
                this.pagingManager.deletePageStore(storeName);
            }
        }
    }

    @Override
    public void reloadConfigurationFile() throws Exception {
        this.reloadConfigurationFile(this.configuration.getConfigurationUrl());
    }

    private void reloadConfigurationFile(URL uri) throws Exception {
        Configuration config = new FileConfigurationParser().parseMainConfig(uri.openStream());
        LegacyJMSConfiguration legacyJMSConfiguration = new LegacyJMSConfiguration(config);
        legacyJMSConfiguration.parseConfiguration(uri.openStream());
        this.configuration.setSecurityRoles(config.getSecurityRoles());
        this.configuration.setAddressSettings(config.getAddressSettings());
        this.configuration.setDivertConfigurations(config.getDivertConfigurations());
        this.configuration.setAddressConfigurations(config.getAddressConfigurations());
        this.configuration.setQueueConfigs(config.getQueueConfigs());
        this.configuration.setBridgeConfigurations(config.getBridgeConfigurations());
        this.configuration.setConnectorConfigurations(config.getConnectorConfigurations());
        this.configuration.setAMQPConnectionConfigurations(config.getAMQPConnection());
        this.configurationReloadDeployed.set(false);
        if (this.isActive()) {
            this.configuration.parseProperties(this.propertiesFileUrl);
            this.updateStatus("configuration", this.configuration.getStatus());
            this.deployReloadableConfigFromConfiguration();
        }
    }

    private static <T> void setDefaultIfUnset(Supplier<T> getter, Consumer<T> setter, T defaultValue) {
        if (getter.get() == null) {
            setter.accept(defaultValue);
        }
    }

    private static void setUnsetQueueParamsToDefaults(QueueConfiguration c) {
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getMaxConsumers(), arg_0 -> ((QueueConfiguration)c).setMaxConsumers(arg_0), ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getRoutingType(), arg_0 -> ((QueueConfiguration)c).setRoutingType(arg_0), ActiveMQDefaultConfiguration.getDefaultRoutingType());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).isPurgeOnNoConsumers(), arg_0 -> ((QueueConfiguration)c).setPurgeOnNoConsumers(arg_0), ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).isEnabled(), arg_0 -> ((QueueConfiguration)c).setEnabled(arg_0), ActiveMQDefaultConfiguration.getDefaultEnabled());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).isExclusive(), arg_0 -> ((QueueConfiguration)c).setExclusive(arg_0), ActiveMQDefaultConfiguration.getDefaultExclusive());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).isGroupRebalance(), arg_0 -> ((QueueConfiguration)c).setGroupRebalance(arg_0), ActiveMQDefaultConfiguration.getDefaultGroupRebalance());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getGroupBuckets(), arg_0 -> ((QueueConfiguration)c).setGroupBuckets(arg_0), ActiveMQDefaultConfiguration.getDefaultGroupBuckets());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getGroupFirstKey(), arg_0 -> ((QueueConfiguration)c).setGroupFirstKey(arg_0), ActiveMQDefaultConfiguration.getDefaultGroupFirstKey());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).isNonDestructive(), arg_0 -> ((QueueConfiguration)c).setNonDestructive(arg_0), ActiveMQDefaultConfiguration.getDefaultNonDestructive());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getConsumersBeforeDispatch(), arg_0 -> ((QueueConfiguration)c).setConsumersBeforeDispatch(arg_0), ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getDelayBeforeDispatch(), arg_0 -> ((QueueConfiguration)c).setDelayBeforeDispatch(arg_0), ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch());
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getFilterString(), arg_0 -> ((QueueConfiguration)c).setFilterString(arg_0), SimpleString.of((String)""));
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).isConfigurationManaged(), arg_0 -> ((QueueConfiguration)c).setConfigurationManaged(arg_0), false);
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getUser(), arg_0 -> ((QueueConfiguration)c).setUser(arg_0), null);
        ActiveMQServerImpl.setDefaultIfUnset(() -> ((QueueConfiguration)c).getRingSize(), arg_0 -> ((QueueConfiguration)c).setRingSize(arg_0), ActiveMQDefaultConfiguration.getDefaultRingSize());
    }

    private void deployReloadableConfigFromConfiguration() throws Exception {
        if (this.configurationReloadDeployed.compareAndSet(false, true)) {
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("security settings");
            this.securityRepository.swap(this.configuration.getSecurityRoles().entrySet());
            this.recoverStoredSecuritySettings();
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("address settings");
            this.addressSettingsRepository.swap(this.configuration.getAddressSettings().entrySet());
            this.recoverStoredAddressSettings();
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("diverts");
            Set divertsToRemove = this.postOffice.getAllBindings().filter(binding -> binding instanceof DivertBinding).map(Binding::getUniqueName).collect(Collectors.toSet());
            for (DivertConfiguration divertConfig : this.configuration.getDivertConfigurations()) {
                divertsToRemove.remove(SimpleString.of((String)divertConfig.getName()));
                SimpleString divertName = SimpleString.of((String)divertConfig.getName());
                DivertBinding divertBinding = (DivertBinding)this.postOffice.getBinding(divertName);
                if (divertBinding == null) {
                    this.deployDivert(divertConfig);
                    continue;
                }
                if (divertBinding.isExclusive() != divertConfig.isExclusive() || !divertBinding.getAddress().toString().equals(divertConfig.getAddress())) {
                    this.destroyDivert(divertName);
                    this.deployDivert(divertConfig);
                    continue;
                }
                this.updateDivert(divertConfig);
            }
            for (SimpleString divertName : divertsToRemove) {
                try {
                    this.destroyDivert(divertName);
                }
                catch (Throwable e) {
                    logger.warn("Divert {} could not be removed", (Object)divertName, (Object)e);
                }
            }
            this.recoverStoredDiverts();
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("addresses");
            this.undeployAddressesAndQueueNotInConfiguration(this.configuration);
            this.deployAddressesFromConfiguration(this.configuration);
            this.deployQueuesFromListQueueConfiguration(this.configuration.getQueueConfigs());
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("bridges");
            for (BridgeConfiguration newBridgeConfig : this.configuration.getBridgeConfigurations()) {
                String bridgeName = newBridgeConfig.getName();
                newBridgeConfig.setParentName(bridgeName);
                Bridge existingBridge = this.clusterManager.getBridges().values().stream().filter(bridge -> bridge.getConfiguration().getParentName().equals(bridgeName)).findFirst().orElse(null);
                if (existingBridge != null && existingBridge.getConfiguration().isConfigurationManaged() && !existingBridge.getConfiguration().equals(newBridgeConfig)) {
                    this.destroyBridge(bridgeName);
                    this.deployBridge(newBridgeConfig);
                    continue;
                }
                if (existingBridge != null) continue;
                this.deployBridge(newBridgeConfig);
            }
            for (Bridge existingBridge : this.clusterManager.getBridges().values()) {
                BridgeConfiguration existingBridgeConfig = existingBridge.getConfiguration();
                if (!existingBridgeConfig.isConfigurationManaged()) continue;
                String existingBridgeName = existingBridgeConfig.getParentName();
                boolean noLongerConfigured = this.configuration.getBridgeConfigurations().stream().noneMatch(bridge -> bridge.getParentName().equals(existingBridgeName));
                if (!noLongerConfigured) continue;
                this.destroyBridge(existingBridgeName);
            }
            this.recoverStoredBridges();
            this.recoverStoredConnectors();
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("protocol services");
            this.updateProtocolServices();
        }
    }

    public Set<ActivateCallback> getActivateCallbacks() {
        return this.activateCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActiveMQComponent> getExternalComponents() {
        List<ActiveMQComponent> list = this.externalComponents;
        synchronized (list) {
            return new ArrayList<ActiveMQComponent>(this.externalComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopExternalComponents(boolean shutdown) {
        List<ActiveMQComponent> list = this.externalComponents;
        synchronized (list) {
            for (ActiveMQComponent externalComponent : this.externalComponents) {
                try {
                    if (externalComponent instanceof ServiceComponent) {
                        ((ServiceComponent)externalComponent).stop(shutdown);
                        continue;
                    }
                    externalComponent.stop();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorStoppingComponent(externalComponent.getClass().getName(), e);
                }
            }
        }
    }

    @Override
    public AutoCloseable managementLock() throws Exception {
        if (!this.managementLock.tryLock(1L, TimeUnit.MINUTES)) {
            throw ActiveMQMessageBundle.BUNDLE.managementBusy();
        }
        return this.managementLock::unlock;
    }

    @Override
    public IOCriticalErrorListener getIoCriticalErrorListener() {
        return this.ioCriticalErrorListener;
    }

    private final class ActivationThread
    extends Thread {
        final Runnable runnable;

        ActivationThread(Runnable runnable, String name) {
            super(name);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            ActiveMQServerImpl.this.lockActivation();
            try {
                if (ActiveMQServerImpl.this.state != ActiveMQServer.SERVER_STATE.STOPPED && ActiveMQServerImpl.this.state != ActiveMQServer.SERVER_STATE.STOPPING) {
                    this.runnable.run();
                }
            }
            finally {
                ActiveMQServerImpl.this.unlockActivation();
            }
        }
    }

    public final class DefaultCriticalErrorListener
    implements IOCriticalErrorListener {
        private final AtomicBoolean failedAlready = new AtomicBoolean();

        public boolean isPreviouslyFailed() {
            return this.failedAlready.get();
        }

        public synchronized void onIOException(Throwable cause, String message, String file) {
            if (logger.isTraceEnabled()) {
                logger.trace("Throwing critical error {}", (Object)cause.getMessage(), (Object)new Exception("trace"));
            }
            if (!this.failedAlready.compareAndSet(false, true)) {
                return;
            }
            try {
                for (IOCriticalErrorListener listener : ActiveMQServerImpl.this.ioCriticalErrorListeners) {
                    listener.onIOException(cause, message, file);
                }
            }
            catch (Throwable ignored) {
                logger.debug("Ignored exception {}", (Object)ignored.getMessage(), (Object)ignored);
            }
            if (file == null) {
                ActiveMQServerLogger.LOGGER.ioCriticalIOError(message, "NULL", cause);
            } else {
                ActiveMQServerLogger.LOGGER.ioCriticalIOError(message, file, cause);
            }
            ActiveMQServerImpl.this.stopTheServer(true);
        }
    }
}

