/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.junit;

import java.net.URI;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedActiveMQBroker
extends ExternalResource {
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    BrokerService brokerService;

    public EmbeddedActiveMQBroker() {
        this.brokerService = new BrokerService();
        this.brokerService.setUseJmx(false);
        this.brokerService.setUseShutdownHook(false);
        this.brokerService.setPersistent(false);
        this.brokerService.setBrokerName("embedded-broker");
    }

    public EmbeddedActiveMQBroker(String configurationURI) {
        try {
            this.brokerService = BrokerFactory.createBroker((String)configurationURI);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception encountered creating embedded ActiveMQ broker from configuration URI: " + configurationURI, ex);
        }
    }

    public EmbeddedActiveMQBroker(URI configurationURI) {
        try {
            this.brokerService = BrokerFactory.createBroker((URI)configurationURI);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception encountered creating embedded ActiveMQ broker from configuration URI: " + configurationURI, ex);
        }
    }

    protected void configure() {
    }

    public void start() {
        try {
            this.configure();
            this.brokerService.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception encountered starting embedded ActiveMQ broker: {}" + this.getBrokerName(), ex);
        }
        this.brokerService.waitUntilStarted();
    }

    public void stop() {
        if (!this.brokerService.isStopped()) {
            try {
                this.brokerService.stop();
            }
            catch (Exception ex) {
                this.log.warn("Exception encountered stopping embedded ActiveMQ broker: {}" + this.getBrokerName(), (Throwable)ex);
            }
        }
        this.brokerService.waitUntilStopped();
    }

    protected void before() throws Throwable {
        this.log.info("Starting embedded ActiveMQ broker: {}", (Object)this.getBrokerName());
        this.start();
        super.before();
    }

    protected void after() {
        this.log.info("Stopping Embedded ActiveMQ Broker: {}", (Object)this.getBrokerName());
        super.after();
        this.stop();
    }

    public ActiveMQConnectionFactory createConnectionFactory() {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL(this.brokerService.getVmConnectorURI().toString());
        return connectionFactory;
    }

    public PooledConnectionFactory createPooledConnectionFactory() {
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory();
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory(connectionFactory);
        return pooledConnectionFactory;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public String getVmURL() {
        return String.format("failover:(%s?create=false)", this.brokerService.getVmConnectorURI().toString());
    }

    public String getBrokerName() {
        return this.brokerService.getBrokerName();
    }

    public void setBrokerName(String brokerName) {
        this.brokerService.setBrokerName(brokerName);
    }

    public boolean isStatisticsPluginEnabled() {
        BrokerPlugin[] plugins = this.brokerService.getPlugins();
        if (null != plugins) {
            for (BrokerPlugin plugin : plugins) {
                if (!(plugin instanceof StatisticsBrokerPlugin)) continue;
                return true;
            }
        }
        return false;
    }

    public void enableStatisticsPlugin() {
        if (!this.isStatisticsPluginEnabled()) {
            BrokerPlugin[] newPlugins;
            BrokerPlugin[] currentPlugins = this.brokerService.getPlugins();
            if (null != currentPlugins && 0 < currentPlugins.length) {
                newPlugins = new BrokerPlugin[currentPlugins.length + 1];
                System.arraycopy(currentPlugins, 0, newPlugins, 0, currentPlugins.length);
            } else {
                newPlugins = new BrokerPlugin[1];
            }
            newPlugins[newPlugins.length - 1] = new StatisticsBrokerPlugin();
            this.brokerService.setPlugins(newPlugins);
        }
    }

    public void disableStatisticsPlugin() {
        if (this.isStatisticsPluginEnabled()) {
            BrokerPlugin[] currentPlugins = this.brokerService.getPlugins();
            if (1 < currentPlugins.length) {
                BrokerPlugin[] newPlugins = new BrokerPlugin[currentPlugins.length - 1];
                int i = 0;
                for (BrokerPlugin plugin : currentPlugins) {
                    if (plugin instanceof StatisticsBrokerPlugin) continue;
                    newPlugins[i++] = plugin;
                }
                this.brokerService.setPlugins(newPlugins);
            } else {
                this.brokerService.setPlugins(null);
            }
        }
    }

    public boolean isAdvisoryForDeliveryEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForDelivery();
    }

    public void enableAdvisoryForDelivery() {
        this.getDefaultPolicyEntry().setAdvisoryForDelivery(true);
    }

    public void disableAdvisoryForDelivery() {
        this.getDefaultPolicyEntry().setAdvisoryForDelivery(false);
    }

    public boolean isAdvisoryForConsumedEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForConsumed();
    }

    public void enableAdvisoryForConsumed() {
        this.getDefaultPolicyEntry().setAdvisoryForConsumed(true);
    }

    public void disableAdvisoryForConsumed() {
        this.getDefaultPolicyEntry().setAdvisoryForConsumed(false);
    }

    public boolean isAdvisoryForDiscardingMessagesEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForDiscardingMessages();
    }

    public void enableAdvisoryForDiscardingMessages() {
        this.getDefaultPolicyEntry().setAdvisoryForDiscardingMessages(true);
    }

    public void disableAdvisoryForDiscardingMessages() {
        this.getDefaultPolicyEntry().setAdvisoryForDiscardingMessages(false);
    }

    public boolean isAdvisoryForFastProducersEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForFastProducers();
    }

    public void enableAdvisoryForFastProducers() {
        this.getDefaultPolicyEntry().setAdvisoryForFastProducers(true);
    }

    public void disableAdvisoryForFastProducers() {
        this.getDefaultPolicyEntry().setAdvisoryForFastProducers(false);
    }

    public boolean isAdvisoryForSlowConsumersEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForSlowConsumers();
    }

    public void enableAdvisoryForSlowConsumers() {
        this.getDefaultPolicyEntry().setAdvisoryForSlowConsumers(true);
    }

    public void disableAdvisoryForSlowConsumers() {
        this.getDefaultPolicyEntry().setAdvisoryForSlowConsumers(false);
    }

    public int getMessageCount(String fullDestinationName) throws Exception {
        boolean QUEUE_TYPE = true;
        int TOPIC_TYPE = 2;
        if (null == this.brokerService) {
            throw new IllegalStateException("BrokerService has not yet been created - was before() called?");
        }
        int destinationType = 1;
        String destinationName = fullDestinationName;
        if (fullDestinationName.startsWith("queue:")) {
            destinationName = fullDestinationName.substring(fullDestinationName.indexOf(58) + 1);
        } else if (fullDestinationName.startsWith("topic:")) {
            destinationType = 2;
            destinationName = fullDestinationName.substring(fullDestinationName.indexOf(58) + 1);
        }
        int messageCount = -1;
        boolean foundDestination = false;
        for (Destination destination : this.brokerService.getBroker().getDestinationMap().values()) {
            String tmpName = destination.getName();
            if (tmpName.equalsIgnoreCase(destinationName)) {
                switch (destinationType) {
                    case 1: {
                        if (!(destination instanceof Queue)) break;
                        messageCount = destination.getMessageStore().getMessageCount();
                        foundDestination = true;
                        break;
                    }
                    case 2: {
                        if (!(destination instanceof Topic)) break;
                        messageCount = destination.getMessageStore().getMessageCount();
                        foundDestination = true;
                        break;
                    }
                    default: {
                        this.log.error("Type didn't match: {}", (Object)destination.getClass().getName());
                    }
                }
            }
            if (!foundDestination) continue;
            break;
        }
        if (!foundDestination) {
            this.log.warn("Didn't find destination {} in broker {}", (Object)fullDestinationName, (Object)this.getBrokerName());
        }
        return messageCount;
    }

    private PolicyEntry getDefaultPolicyEntry() {
        PolicyEntry defaultEntry;
        PolicyMap destinationPolicy = this.brokerService.getDestinationPolicy();
        if (null == destinationPolicy) {
            destinationPolicy = new PolicyMap();
            this.brokerService.setDestinationPolicy(destinationPolicy);
        }
        if (null == (defaultEntry = destinationPolicy.getDefaultEntry())) {
            defaultEntry = new PolicyEntry();
            destinationPolicy.setDefaultEntry(defaultEntry);
        }
        return defaultEntry;
    }
}

