/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.reflect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.reflect.BeanMetadataImpl;
import org.apache.aries.blueprint.reflect.CollectionMetadataImpl;
import org.apache.aries.blueprint.reflect.IdRefMetadataImpl;
import org.apache.aries.blueprint.reflect.MapMetadataImpl;
import org.apache.aries.blueprint.reflect.PassThroughMetadataImpl;
import org.apache.aries.blueprint.reflect.PropsMetadataImpl;
import org.apache.aries.blueprint.reflect.RefMetadataImpl;
import org.apache.aries.blueprint.reflect.ReferenceListMetadataImpl;
import org.apache.aries.blueprint.reflect.ReferenceMetadataImpl;
import org.apache.aries.blueprint.reflect.ServiceMetadataImpl;
import org.apache.aries.blueprint.reflect.ValueMetadataImpl;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataUtil {
    public static final Comparator<BeanArgument> BEAN_COMPARATOR = new BeanArgumentComparator();

    public static Metadata cloneMetadata(Metadata source) {
        if (source == null) {
            return null;
        }
        if (source instanceof MapMetadata) {
            return new MapMetadataImpl((MapMetadata)source);
        }
        if (source instanceof NullMetadata) {
            return NullMetadata.NULL;
        }
        if (source instanceof PropsMetadata) {
            return new PropsMetadataImpl((PropsMetadata)source);
        }
        if (source instanceof RefMetadata) {
            return new RefMetadataImpl((RefMetadata)source);
        }
        if (source instanceof IdRefMetadata) {
            return new IdRefMetadataImpl((IdRefMetadata)source);
        }
        if (source instanceof ValueMetadata) {
            return new ValueMetadataImpl((ValueMetadata)source);
        }
        if (source instanceof BeanMetadata) {
            return new BeanMetadataImpl((BeanMetadata)source);
        }
        if (source instanceof ReferenceListMetadata) {
            return new ReferenceListMetadataImpl((ReferenceListMetadata)source);
        }
        if (source instanceof ServiceMetadata) {
            return new ServiceMetadataImpl((ServiceMetadata)source);
        }
        if (source instanceof ReferenceMetadata) {
            return new ReferenceMetadataImpl((ReferenceMetadata)source);
        }
        if (source instanceof CollectionMetadata) {
            return new CollectionMetadataImpl((CollectionMetadata)source);
        }
        if (source instanceof PassThroughMetadata) {
            return new PassThroughMetadataImpl((PassThroughMetadata)source);
        }
        throw new RuntimeException("Unknown Metadata type received: " + source.getClass().getName());
    }

    public static ComponentMetadata cloneComponentMetadata(ComponentMetadata source) {
        return (ComponentMetadata)MetadataUtil.cloneMetadata(source);
    }

    public static Target cloneTarget(Target source) {
        return (Target)MetadataUtil.cloneMetadata(source);
    }

    public static <T extends Metadata> T createMetadata(Class<T> type) {
        if (MapMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new MapMetadataImpl()));
        }
        if (NullMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(NullMetadata.NULL));
        }
        if (PropsMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new PropsMetadataImpl()));
        }
        if (RefMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new RefMetadataImpl()));
        }
        if (IdRefMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new IdRefMetadataImpl()));
        }
        if (ValueMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new ValueMetadataImpl()));
        }
        if (BeanMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new BeanMetadataImpl()));
        }
        if (ReferenceListMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new ReferenceListMetadataImpl()));
        }
        if (ServiceMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new ServiceMetadataImpl()));
        }
        if (ReferenceMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new ReferenceMetadataImpl()));
        }
        if (CollectionMetadata.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new CollectionMetadataImpl()));
        }
        if (PassThroughMetadataImpl.class.isAssignableFrom(type)) {
            return (T)((Metadata)type.cast(new PassThroughMetadataImpl()));
        }
        throw new IllegalArgumentException("Unsupport metadata type: " + (type != null ? type.getName() : null));
    }

    public static List<BeanArgument> validateBeanArguments(List<BeanArgument> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return arguments;
        }
        boolean hasIndexFirst = arguments.get(0).getIndex() > -1;
        for (int i = 1; i < arguments.size(); ++i) {
            boolean hasIndex;
            boolean bl = hasIndex = arguments.get(i).getIndex() > -1;
            if ((!hasIndexFirst || hasIndex) && (hasIndexFirst || !hasIndex)) continue;
            throw new IllegalArgumentException("Index attribute must be specified either on all or none constructor arguments");
        }
        if (hasIndexFirst) {
            ArrayList<BeanArgument> argumentsCopy = new ArrayList<BeanArgument>(arguments);
            Collections.sort(argumentsCopy, BEAN_COMPARATOR);
            arguments = argumentsCopy;
            for (int i = 0; i < arguments.size(); ++i) {
                int index = arguments.get(i).getIndex();
                if (index > i) {
                    throw new IllegalArgumentException("Missing attribute index");
                }
                if (index >= i) continue;
                throw new IllegalArgumentException("Duplicate attribute index");
            }
        }
        return arguments;
    }

    public static boolean isPrototypeScope(BeanMetadata metadata) {
        return "prototype".equals(metadata.getScope()) || metadata.getScope() == null && metadata.getId() == null;
    }

    public static boolean isSingletonScope(BeanMetadata metadata) {
        return "singleton".equals(metadata.getScope()) || metadata.getScope() == null && metadata.getId() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanArgumentComparator
    implements Comparator<BeanArgument>,
    Serializable {
        private BeanArgumentComparator() {
        }

        @Override
        public int compare(BeanArgument object1, BeanArgument object2) {
            return object1.getIndex() - object2.getIndex();
        }
    }
}

