/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.plugin.eba;

import aQute.lib.osgi.Analyzer;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.archiver.PomPropertiesUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EbaMojo
extends AbstractMojo {
    public static final String APPLICATION_MF_URI = "META-INF/APPLICATION.MF";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String MANIFEST_VERSION = "Manifest-Version";
    private static final String APPLICATION_MANIFESTVERSION = "Application-ManifestVersion";
    private static final String APPLICATION_SYMBOLICNAME = "Application-SymbolicName";
    private static final String APPLICATION_VERSION = "Application-Version";
    private static final String APPLICATION_NAME = "Application-Name";
    private static final String APPLICATION_DESCRIPTION = "Application-Description";
    private static final String APPLICATION_CONTENT = "Application-Content";
    private static final String APPLICATION_EXPORTSERVICE = "Application-ExportService";
    private static final String APPLICATION_IMPORTSERVICE = "Application-ImportService";
    private static final String APPLICATION_USEBUNDLE = "Use-Bundle";
    private Maven2OsgiConverter maven2OsgiConverter = new DefaultMaven2OsgiConverter();
    private File ebaSourceDirectory;
    private File applicationManifestFile;
    private Boolean includeJar = Boolean.TRUE;
    private File manifestFile;
    private String workDirectory;
    private String sharedResources;
    private String outputDirectory;
    private String finalName;
    private MavenProject project;
    private ZipArchiver zipArchiver;
    private boolean generateManifest;
    private Map instructions = new LinkedHashMap();
    private boolean addMavenDescriptor;
    private boolean includeEmptyDirs;
    private boolean forceCreation;
    private boolean useTransitiveDependencies;
    private String archiveContent;
    private File buildDir;

    public void execute() throws MojoExecutionException {
        File ddFile;
        this.getLog().debug((CharSequence)" ======= EbaMojo settings =======");
        this.getLog().debug((CharSequence)("ebaSourceDirectory[" + this.ebaSourceDirectory + "]"));
        this.getLog().debug((CharSequence)("manifestFile[" + this.manifestFile + "]"));
        this.getLog().debug((CharSequence)("applicationManifestFile[" + this.applicationManifestFile + "]"));
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("outputDirectory[" + this.outputDirectory + "]"));
        this.getLog().debug((CharSequence)("finalName[" + this.finalName + "]"));
        this.getLog().debug((CharSequence)("generateManifest[" + this.generateManifest + "]"));
        if (this.archiveContent == null) {
            this.archiveContent = new String("applicationContent");
        }
        this.getLog().debug((CharSequence)("archiveContent[" + this.archiveContent + "]"));
        this.getLog().info((CharSequence)("archiveContent[" + this.archiveContent + "]"));
        this.zipArchiver.setIncludeEmptyDirs(this.includeEmptyDirs);
        this.zipArchiver.setCompress(true);
        this.zipArchiver.setForced(this.forceCreation);
        try {
            File generatedJarFile;
            if (this.includeJar.booleanValue() && (generatedJarFile = new File(this.outputDirectory, this.finalName + ".jar")).exists()) {
                this.getLog().info((CharSequence)("Including generated jar file[" + generatedJarFile.getName() + "]"));
                this.zipArchiver.addFile(generatedJarFile, this.finalName + ".jar");
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding generated Jar file", (Exception)((Object)e));
        }
        try {
            Set artifacts = null;
            if (this.useTransitiveDependencies) {
                if ("none".equals(this.archiveContent)) {
                    throw new MojoExecutionException("<useTransitiveDependencies/> and <archiveContent/> incompatibly configured.  <useTransitiveDependencies/> is deprecated in favor of <archiveContent/>.");
                }
                artifacts = this.project.getArtifacts();
            } else if ("applicationContent".equals(this.archiveContent)) {
                artifacts = this.project.getDependencyArtifacts();
            } else {
                this.getLog().info((CharSequence)"archiveContent=none: application arvhive will not contain any bundles.");
            }
            if (artifacts != null) {
                for (Artifact artifact : artifacts) {
                    ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
                    if (artifact.isOptional() || !filter.include(artifact)) continue;
                    this.getLog().info((CharSequence)("Copying artifact[" + artifact.getGroupId() + ", " + artifact.getId() + ", " + artifact.getScope() + "]"));
                    this.zipArchiver.addFile(artifact.getFile(), artifact.getArtifactId() + "-" + artifact.getVersion() + "." + (artifact.getType() == null ? "jar" : artifact.getType()));
                }
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error copying EBA dependencies", (Exception)((Object)e));
        }
        try {
            File ebaSourceDir = this.ebaSourceDirectory;
            if (ebaSourceDir.exists()) {
                this.getLog().info((CharSequence)("Copy eba resources to " + this.getBuildDir().getAbsolutePath()));
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(ebaSourceDir.getAbsolutePath());
                scanner.setIncludes(DEFAULT_INCLUDES);
                scanner.addDefaultExcludes();
                scanner.scan();
                String[] dirs = scanner.getIncludedDirectories();
                for (int j = 0; j < dirs.length; ++j) {
                    new File(this.getBuildDir(), dirs[j]).mkdirs();
                }
                String[] files = scanner.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    File targetFile = new File(this.getBuildDir(), files[j]);
                    targetFile.getParentFile().mkdirs();
                    File file = new File(ebaSourceDir, files[j]);
                    FileUtils.copyFileToDirectory((File)file, (File)targetFile.getParentFile());
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying EBA resources", e);
        }
        try {
            if (!this.generateManifest) {
                this.includeCustomApplicationManifestFile();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying APPLICATION.MF file", (Exception)e);
        }
        if (this.generateManifest) {
            String fileName = new String(this.getBuildDir() + "/" + APPLICATION_MF_URI);
            File appMfFile = new File(fileName);
            try {
                if (appMfFile.exists()) {
                    FileUtils.fileDelete((String)fileName);
                }
                appMfFile.getParentFile().mkdirs();
                if (appMfFile.createNewFile()) {
                    this.writeApplicationManifest(fileName);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error generating APPLICATION.MF file: " + fileName, (Exception)e);
            }
        }
        if (!(ddFile = new File(this.getBuildDir(), APPLICATION_MF_URI)).exists()) {
            this.getLog().warn((CharSequence)("Application manifest: " + ddFile.getAbsolutePath() + " does not exist."));
        }
        try {
            File sharedResourcesDir;
            if (this.addMavenDescriptor) {
                if (this.project.getArtifact().isSnapshot()) {
                    this.project.setVersion(this.project.getArtifact().getVersion());
                }
                String groupId = this.project.getGroupId();
                String artifactId = this.project.getArtifactId();
                this.zipArchiver.addFile(this.project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
                PomPropertiesUtil pomPropertiesUtil = new PomPropertiesUtil();
                File dir = new File(this.project.getBuild().getDirectory(), "maven-zip-plugin");
                File pomPropertiesFile = new File(dir, "pom.properties");
                pomPropertiesUtil.createPomProperties(this.project, (Archiver)this.zipArchiver, pomPropertiesFile, this.forceCreation);
            }
            File ebaFile = new File(this.outputDirectory, this.finalName + ".eba");
            this.zipArchiver.setDestFile(ebaFile);
            File buildDir = this.getBuildDir();
            if (buildDir.isDirectory()) {
                this.zipArchiver.addDirectory(buildDir);
            }
            if ((sharedResourcesDir = new File(this.sharedResources)).isDirectory()) {
                this.zipArchiver.addDirectory(sharedResourcesDir);
            }
            this.zipArchiver.createArchive();
            this.project.getArtifact().setFile(ebaFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling eba", e);
        }
    }

    private void writeApplicationManifest(String fileName) throws MojoExecutionException {
        try {
            Artifact artifact;
            FileUtils.fileAppend((String)fileName, (String)"Manifest-Version: 1\n");
            FileUtils.fileAppend((String)fileName, (String)"Application-ManifestVersion: 1\n");
            FileUtils.fileAppend((String)fileName, (String)("Application-SymbolicName: " + this.getApplicationSymbolicName(this.project.getArtifact()) + "\n"));
            FileUtils.fileAppend((String)fileName, (String)("Application-Version: " + this.getApplicationVersion() + "\n"));
            FileUtils.fileAppend((String)fileName, (String)("Application-Name: " + this.project.getName() + "\n"));
            FileUtils.fileAppend((String)fileName, (String)("Application-Description: " + this.project.getDescription() + "\n"));
            Set<Object> artifacts = this.useTransitiveDependencies ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
            artifacts = this.selectArtifacts(artifacts);
            Iterator<Artifact> iter = artifacts.iterator();
            FileUtils.fileAppend((String)fileName, (String)"Application-Content: ");
            if (iter.hasNext()) {
                artifact = iter.next();
                FileUtils.fileAppend((String)fileName, (String)(this.maven2OsgiConverter.getBundleSymbolicName(artifact) + ";version=\"" + Analyzer.cleanupVersion((String)artifact.getVersion()) + "\""));
            }
            while (iter.hasNext()) {
                artifact = iter.next();
                FileUtils.fileAppend((String)fileName, (String)(",\n " + this.maven2OsgiConverter.getBundleSymbolicName(artifact) + ";version=\"" + Analyzer.cleanupVersion((String)artifact.getVersion()) + "\""));
            }
            FileUtils.fileAppend((String)fileName, (String)"\n");
            if (this.instructions.containsKey(APPLICATION_EXPORTSERVICE)) {
                FileUtils.fileAppend((String)fileName, (String)("Application-ExportService: " + this.instructions.get(APPLICATION_EXPORTSERVICE) + "\n"));
            }
            if (this.instructions.containsKey(APPLICATION_IMPORTSERVICE)) {
                FileUtils.fileAppend((String)fileName, (String)("Application-ImportService: " + this.instructions.get(APPLICATION_IMPORTSERVICE) + "\n"));
            }
            if (this.instructions.containsKey(APPLICATION_USEBUNDLE)) {
                FileUtils.fileAppend((String)fileName, (String)("Use-Bundle: " + this.instructions.get(APPLICATION_USEBUNDLE) + "\n"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error writing dependencies into APPLICATION.MF", e);
        }
    }

    private String getApplicationSymbolicName(Artifact artifact) {
        if (this.instructions.containsKey(APPLICATION_SYMBOLICNAME)) {
            return this.instructions.get(APPLICATION_SYMBOLICNAME).toString();
        }
        return artifact.getGroupId() + "." + artifact.getArtifactId();
    }

    private String getApplicationVersion() {
        if (this.instructions.containsKey(APPLICATION_VERSION)) {
            return this.instructions.get(APPLICATION_VERSION).toString();
        }
        return Analyzer.cleanupVersion((String)this.project.getVersion());
    }

    protected File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = new File(this.workDirectory);
        }
        return this.buildDir;
    }

    private void includeCustomApplicationManifestFile() throws IOException {
        if (this.applicationManifestFile == null) {
            throw new NullPointerException("Application manifest file location not set.  Use <generateManifest>true</generateManifest> if you want it to be generated.");
        }
        File appMfFile = this.applicationManifestFile;
        if (appMfFile.exists()) {
            this.getLog().info((CharSequence)("Using APPLICATION.MF " + this.applicationManifestFile));
            File metaInfDir = new File(this.getBuildDir(), "META-INF");
            FileUtils.copyFileToDirectory((File)appMfFile, (File)metaInfDir);
        }
    }

    private Set<Artifact> selectArtifacts(Set<Artifact> artifacts) {
        LinkedHashSet<Artifact> selected = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            String scope = artifact.getScope();
            if (scope != null && !"compile".equals(scope) && !"runtime".equals(scope)) continue;
            selected.add(artifact);
        }
        return selected;
    }
}

