/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.provisioning;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipInputStream;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.codec.PropertyData;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.service.provisioning.ProvisioningServiceMBean;

public class ProvisioningService
implements ProvisioningServiceMBean {
    private org.osgi.service.provisioning.ProvisioningService provisioningService;

    public ProvisioningService(org.osgi.service.provisioning.ProvisioningService provisioningService) {
        this.provisioningService = provisioningService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInformationFromZip(String zipURL) throws IOException {
        if (zipURL == null || zipURL.length() < 1) {
            throw new IOException("Argument zipURL cannot be null or empty");
        }
        InputStream is = this.createStream(zipURL);
        ZipInputStream zis = new ZipInputStream(is);
        try {
            this.provisioningService.addInformation(zis);
        }
        finally {
            zis.close();
        }
    }

    @Override
    public void addInformation(TabularData info) throws IOException {
        Dictionary<String, Object> provisioningInfo = this.extractProvisioningDictionary(info);
        this.provisioningService.addInformation(provisioningInfo);
    }

    @Override
    public TabularData listInformation() throws IOException {
        TabularDataSupport propertiesTable = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        Dictionary information = this.provisioningService.getInformation();
        if (information != null) {
            Enumeration keys = information.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                propertiesTable.put(PropertyData.newInstance(key, information.get(key)).toCompositeData());
            }
        }
        return propertiesTable;
    }

    @Override
    public void setInformation(TabularData info) throws IOException {
        Dictionary<String, Object> provisioningInfo = this.extractProvisioningDictionary(info);
        this.provisioningService.setInformation(provisioningInfo);
    }

    protected Dictionary<String, Object> extractProvisioningDictionary(TabularData info) {
        Hashtable<String, Object> provisioningInfo = new Hashtable<String, Object>();
        if (info != null) {
            Collection<?> compositeData = info.values();
            for (CompositeData row : compositeData) {
                PropertyData propertyData = PropertyData.from(row);
                ((Dictionary)provisioningInfo).put(propertyData.getKey(), propertyData.getValue());
            }
        }
        return provisioningInfo;
    }

    protected InputStream createStream(String url) throws IOException {
        return new URL(url).openStream();
    }
}

