/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import org.apache.aries.jmx.codec.BatchActionResult;
import org.apache.aries.jmx.codec.BatchInstallResult;
import org.apache.aries.jmx.codec.BatchResolveResult;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class Framework
implements FrameworkMBean {
    private StartLevel startLevel;
    private PackageAdmin packageAdmin;
    private BundleContext context;

    public Framework(BundleContext context, StartLevel startLevel, PackageAdmin packageAdmin) {
        this.context = context;
        this.startLevel = startLevel;
        this.packageAdmin = packageAdmin;
    }

    @Override
    public long[] getDependencyClosure(long[] bundles) throws IOException {
        FrameworkWiring fw = (FrameworkWiring)this.context.getBundle(0L).adapt(FrameworkWiring.class);
        ArrayList<Bundle> bl = new ArrayList<Bundle>();
        for (int i = 0; i < bundles.length; ++i) {
            bl.add(this.context.getBundle(bundles[i]));
        }
        Collection rc = fw.getDependencyClosure(bl);
        Iterator it = rc.iterator();
        long[] result = new long[rc.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Bundle)it.next()).getBundleId();
        }
        return result;
    }

    @Override
    public int getFrameworkStartLevel() throws IOException {
        return this.startLevel.getStartLevel();
    }

    @Override
    public int getInitialBundleStartLevel() throws IOException {
        return this.startLevel.getInitialBundleStartLevel();
    }

    @Override
    public String getProperty(String key) {
        return this.context.getProperty(key);
    }

    @Override
    public long[] getRemovalPendingBundles() throws IOException {
        FrameworkWiring fw = (FrameworkWiring)this.context.getBundle(0L).adapt(FrameworkWiring.class);
        Collection rc = fw.getRemovalPendingBundles();
        Iterator it = rc.iterator();
        long[] result = new long[rc.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Bundle)it.next()).getBundleId();
        }
        return result;
    }

    @Override
    public long installBundle(String location) throws IOException {
        try {
            Bundle bundle = this.context.installBundle(location);
            return bundle.getBundleId();
        }
        catch (Exception e) {
            IOException ioex = new IOException("Installation of a bundle with location " + location + " failed with the message: " + e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public long installBundleFromURL(String location, String url) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.createStream(url);
            Bundle bundle = this.context.installBundle(location, inputStream);
            long l = bundle.getBundleId();
            return l;
        }
        catch (Exception e) {
            IOException ioex = new IOException("Installation of a bundle with location " + location + " failed with the message: " + e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public InputStream createStream(String url) throws IOException {
        return new URL(url).openStream();
    }

    @Override
    public CompositeData installBundles(String[] locations) throws IOException {
        if (locations == null) {
            return new BatchInstallResult("Failed to install bundles locations can't be null").toCompositeData();
        }
        long[] ids = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try {
                long id;
                ids[i] = id = this.installBundle(locations[i]);
                continue;
            }
            catch (Throwable t) {
                long[] completed = new long[i];
                System.arraycopy(ids, 0, completed, 0, i);
                String[] remaining = new String[locations.length - i - 1];
                System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                return new BatchInstallResult(completed, t.toString(), remaining, locations[i]).toCompositeData();
            }
        }
        return new BatchInstallResult(ids).toCompositeData();
    }

    @Override
    public CompositeData installBundlesFromURL(String[] locations, String[] urls) throws IOException {
        if (locations == null || urls == null) {
            return new BatchInstallResult("Failed to install bundles arguments can't be null").toCompositeData();
        }
        if (locations.length != urls.length) {
            return new BatchInstallResult("Failed to install bundles size of arguments should be same").toCompositeData();
        }
        long[] ids = new long[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            try {
                long id;
                ids[i] = id = this.installBundleFromURL(locations[i], urls[i]);
                continue;
            }
            catch (Throwable t) {
                long[] completed = new long[i];
                System.arraycopy(ids, 0, completed, 0, i);
                String[] remaining = new String[locations.length - i - 1];
                System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                return new BatchInstallResult(completed, t.toString(), remaining, locations[i]).toCompositeData();
            }
        }
        return new BatchInstallResult(ids).toCompositeData();
    }

    @Override
    public void refreshBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        this.packageAdmin.refreshPackages(new Bundle[]{bundle});
    }

    @Override
    public boolean refreshBundleAndWait(long bundleIdentifier) throws IOException {
        Bundle[] bundleArray = new Bundle[1];
        this.refreshBundlesAndWait(new long[]{bundleIdentifier}, bundleArray);
        return this.isResolved(bundleArray[0].getState());
    }

    @Override
    public void refreshBundles(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = null;
        if (bundleIdentifiers != null) {
            bundles = new Bundle[bundleIdentifiers.length];
            for (int i = 0; i < bundleIdentifiers.length; ++i) {
                try {
                    bundles[i] = FrameworkUtils.resolveBundle(this.context, bundleIdentifiers[i]);
                    continue;
                }
                catch (Exception e) {
                    IOException ex = new IOException("Unable to find bundle with id " + bundleIdentifiers[i]);
                    ex.initCause(e);
                    throw ex;
                }
            }
        }
        this.packageAdmin.refreshPackages(bundles);
    }

    @Override
    public CompositeData refreshBundlesAndWait(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = bundleIdentifiers != null ? new Bundle[bundleIdentifiers.length] : null;
        this.refreshBundlesAndWait(bundleIdentifiers, bundles);
        return this.constructResolveResult(bundles);
    }

    private void refreshBundlesAndWait(long[] bundleIdentifiers, Bundle[] bundles) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (4 == event.getType()) {
                    latch.countDown();
                }
            }
        };
        try {
            block9: {
                this.context.addFrameworkListener(listener);
                try {
                    if (bundles != null) {
                        for (int i = 0; i < bundleIdentifiers.length; ++i) {
                            bundles[i] = FrameworkUtils.resolveBundle(this.context, bundleIdentifiers[i]);
                        }
                    }
                    this.packageAdmin.refreshPackages(bundles);
                    if (!latch.await(30L, TimeUnit.SECONDS)) break block9;
                    return;
                }
                catch (InterruptedException e) {
                    IOException ex = new IOException();
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new IOException("Refresh operation timed out");
        }
        finally {
            this.context.removeFrameworkListener(listener);
        }
    }

    private CompositeData constructResolveResult(Bundle[] bundles) {
        if (bundles == null) {
            bundles = this.context.getBundles();
        }
        boolean result = true;
        ArrayList<Long> successList = new ArrayList<Long>();
        for (Bundle bundle : bundles) {
            int state = bundle.getState();
            if (this.isResolved(state)) {
                successList.add(bundle.getBundleId());
                continue;
            }
            result = false;
        }
        return new BatchResolveResult(result, successList.toArray(new Long[0])).toCompositeData();
    }

    private boolean isResolved(int state) {
        return (state & 0x2C) > 0;
    }

    @Override
    public boolean resolveBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        return this.packageAdmin.resolveBundles(new Bundle[]{bundle});
    }

    @Override
    public boolean resolveBundles(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = null;
        if (bundleIdentifiers != null) {
            bundles = new Bundle[bundleIdentifiers.length];
        }
        return this.resolveBundles(bundleIdentifiers, bundles);
    }

    private boolean resolveBundles(long[] bundleIdentifiers, Bundle[] bundles) throws IOException {
        if (bundleIdentifiers != null) {
            for (int i = 0; i < bundleIdentifiers.length; ++i) {
                try {
                    bundles[i] = FrameworkUtils.resolveBundle(this.context, bundleIdentifiers[i]);
                    continue;
                }
                catch (Exception e) {
                    IOException ex = new IOException("Unable to find bundle with id " + bundleIdentifiers[i]);
                    ex.initCause(e);
                    throw ex;
                }
            }
        }
        return this.packageAdmin.resolveBundles(bundles);
    }

    @Override
    public CompositeData resolve(long[] bundleIdentifiers) throws IOException {
        Bundle[] bundles = null;
        if (bundleIdentifiers != null) {
            bundles = new Bundle[bundleIdentifiers.length];
        }
        this.resolveBundles(bundleIdentifiers, bundles);
        return this.constructResolveResult(bundles);
    }

    @Override
    public void restartFramework() throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, 0L);
        try {
            bundle.update();
        }
        catch (Exception be) {
            IOException ioex = new IOException("Framework restart failed with message: " + be.getMessage());
            ioex.initCause(be);
            throw ioex;
        }
    }

    @Override
    public void setBundleStartLevel(long bundleIdentifier, int newlevel) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        try {
            this.startLevel.setBundleStartLevel(bundle, newlevel);
        }
        catch (IllegalArgumentException e) {
            IOException ioex = new IOException("Setting the start level for bundle with id " + bundle.getBundleId() + " to level " + newlevel + " failed with message: " + e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public CompositeData setBundleStartLevels(long[] bundleIdentifiers, int[] newlevels) throws IOException {
        if (bundleIdentifiers == null || newlevels == null) {
            return new BatchActionResult("Failed to setBundleStartLevels arguments can't be null").toCompositeData();
        }
        if (bundleIdentifiers != null && newlevels != null && bundleIdentifiers.length != newlevels.length) {
            return new BatchActionResult("Failed to setBundleStartLevels size of arguments should be same").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.setBundleStartLevel(bundleIdentifiers[i], newlevels[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    @Override
    public void setFrameworkStartLevel(int newlevel) throws IOException {
        try {
            this.startLevel.setStartLevel(newlevel);
        }
        catch (Exception e) {
            IOException ioex = new IOException("Setting the framework start level to " + newlevel + " failed with message: " + e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public void setInitialBundleStartLevel(int newlevel) throws IOException {
        try {
            this.startLevel.setInitialBundleStartLevel(newlevel);
        }
        catch (Exception e) {
            IOException ioex = new IOException("Setting the initial start level to " + newlevel + " failed with message: " + e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public void shutdownFramework() throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, 0L);
        try {
            bundle.stop();
        }
        catch (Exception be) {
            IOException ioex = new IOException("Stopping the framework failed with message: " + be.getMessage());
            ioex.initCause(be);
            throw ioex;
        }
    }

    @Override
    public void startBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        try {
            bundle.start();
        }
        catch (Exception be) {
            IOException ioex = new IOException("Start of bundle with id " + bundleIdentifier + " failed with message: " + be.getMessage());
            ioex.initCause(be);
            throw ioex;
        }
    }

    @Override
    public CompositeData startBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed to start bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.startBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    @Override
    public void stopBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        try {
            bundle.stop();
        }
        catch (Exception e) {
            IOException ioex = new IOException("Stop of bundle with id " + bundleIdentifier + " failed with message: " + e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public CompositeData stopBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed to stop bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.stopBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    @Override
    public void uninstallBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        try {
            bundle.uninstall();
        }
        catch (Exception be) {
            IOException ioex = new IOException("Uninstall of bundle with id " + bundleIdentifier + " failed with message: " + be.getMessage());
            ioex.initCause(be);
            throw ioex;
        }
    }

    @Override
    public CompositeData uninstallBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed uninstall bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.uninstallBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    @Override
    public void updateBundle(long bundleIdentifier) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        try {
            bundle.update();
        }
        catch (Exception be) {
            IOException ioex = new IOException("Update of bundle with id " + bundleIdentifier + " failed with message: " + be.getMessage());
            ioex.initCause(be);
            throw ioex;
        }
    }

    @Override
    public void updateBundleFromURL(long bundleIdentifier, String url) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, bundleIdentifier);
        InputStream inputStream = null;
        try {
            inputStream = this.createStream(url);
            bundle.update(inputStream);
        }
        catch (Exception be) {
            IOException ioex = new IOException("Update of bundle with id " + bundleIdentifier + " from url " + url + " failed with message: " + be.getMessage());
            ioex.initCause(be);
            throw ioex;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public CompositeData updateBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            return new BatchActionResult("Failed to update bundles, bundle id's can't be null").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.updateBundle(bundleIdentifiers[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    @Override
    public CompositeData updateBundlesFromURL(long[] bundleIdentifiers, String[] urls) throws IOException {
        if (bundleIdentifiers == null || urls == null) {
            return new BatchActionResult("Failed to update bundles arguments can't be null").toCompositeData();
        }
        if (bundleIdentifiers != null && urls != null && bundleIdentifiers.length != urls.length) {
            return new BatchActionResult("Failed to update bundles size of arguments should be same").toCompositeData();
        }
        for (int i = 0; i < bundleIdentifiers.length; ++i) {
            try {
                this.updateBundleFromURL(bundleIdentifiers[i], urls[i]);
                continue;
            }
            catch (Throwable t) {
                return this.createFailedBatchActionResult(bundleIdentifiers, i, t);
            }
        }
        return new BatchActionResult(bundleIdentifiers).toCompositeData();
    }

    @Override
    public void updateFramework() throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.context, 0L);
        try {
            bundle.update();
        }
        catch (Exception be) {
            IOException ioex = new IOException("Update of framework bundle failed with message: " + be.getMessage());
            ioex.initCause(be);
            throw ioex;
        }
    }

    private CompositeData createFailedBatchActionResult(long[] bundleIdentifiers, int i, Throwable t) {
        long[] completed = new long[i];
        System.arraycopy(bundleIdentifiers, 0, completed, 0, i);
        long[] remaining = new long[bundleIdentifiers.length - i - 1];
        System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
        return new BatchActionResult(completed, t.toString(), remaining, bundleIdentifiers[i]).toCompositeData();
    }
}

