/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleHookBundleTracker<T>
extends BundleTracker {
    private final BundleContext context;
    private final int mask;
    private final BundleTrackerCustomizer customizer;
    private Tracked tracked;
    private ServiceRegistration sr;

    public BundleHookBundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        super(context, stateMask, customizer);
        this.context = context;
        this.mask = stateMask;
        this.customizer = customizer == null ? this : customizer;
    }

    public void open() {
        this.tracked = new Tracked();
        BundleEventHook hook = new BundleEventHook(this.tracked);
        this.sr = this.context.registerService(EventHook.class.getName(), (Object)hook, null);
        super.open();
    }

    public void close() {
        super.close();
        this.sr.unregister();
        this.tracked.close();
        this.tracked = null;
    }

    public Object addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        if (bundleEvent == null) {
            this.tracked.trackInitial(bundle);
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object o) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Object o) {
    }

    static {
        Class<EventHook> clazz = EventHook.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractTracked<S, T, R> {
        static final boolean DEBUG = false;
        private final Map<S, T> tracked = new HashMap<S, T>();
        private int trackingCount = 0;
        private final List<S> adding = new ArrayList<S>(6);
        volatile boolean closed = false;
        private final LinkedList<S> initial = new LinkedList();

        AbstractTracked() {
        }

        void setInitial(S[] list) {
            if (list == null) {
                return;
            }
            for (S item : list) {
                if (item == null) continue;
                this.initial.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trackInitial() {
            while (true) {
                S item;
                AbstractTracked abstractTracked = this;
                synchronized (abstractTracked) {
                    if (this.closed || this.initial.size() == 0) {
                        return;
                    }
                    item = this.initial.removeFirst();
                    if (this.tracked.get(item) != null) {
                        continue;
                    }
                    if (this.adding.contains(item)) {
                        continue;
                    }
                    this.adding.add(item);
                }
                this.trackAdding(item, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trackInitial(S item) {
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed) {
                    return;
                }
                item = this.initial.removeFirst();
                if (this.tracked.get(item) != null) {
                    return;
                }
                if (this.adding.contains(item)) {
                    return;
                }
                this.adding.add(item);
            }
            this.trackAdding(item, null);
        }

        void close() {
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void track(S item, R related) {
            T object;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed) {
                    return;
                }
                object = this.tracked.get(item);
                if (object == null) {
                    if (this.adding.contains(item)) {
                        return;
                    }
                    this.adding.add(item);
                } else {
                    this.modified();
                }
            }
            if (object == null) {
                this.trackAdding(item, related);
            } else {
                this.customizerModified(item, related, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackAdding(S item, R related) {
            T object = null;
            boolean becameUntracked = false;
            try {
                object = this.customizerAdding(item, related);
            }
            finally {
                AbstractTracked abstractTracked = this;
                synchronized (abstractTracked) {
                    if (this.adding.remove(item) && !this.closed) {
                        if (object != null) {
                            this.tracked.put(item, object);
                            this.modified();
                            this.notifyAll();
                        }
                    } else {
                        becameUntracked = true;
                    }
                }
            }
            if (becameUntracked && object != null) {
                this.customizerRemoved(item, related, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void untrack(S item, R related) {
            T object;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.initial.remove(item)) {
                    return;
                }
                if (this.adding.remove(item)) {
                    return;
                }
                object = this.tracked.remove(item);
                if (object == null) {
                    return;
                }
                this.modified();
            }
            this.customizerRemoved(item, related, object);
        }

        int size() {
            return this.tracked.size();
        }

        boolean isEmpty() {
            return this.tracked.isEmpty();
        }

        T getCustomizedObject(S item) {
            return this.tracked.get(item);
        }

        S[] copyKeys(S[] list) {
            return this.tracked.keySet().toArray(list);
        }

        void modified() {
            ++this.trackingCount;
        }

        int getTrackingCount() {
            return this.trackingCount;
        }

        <M extends Map<? super S, ? super T>> M copyEntries(M map) {
            map.putAll(this.tracked);
            return map;
        }

        abstract T customizerAdding(S var1, R var2);

        abstract void customizerModified(S var1, R var2, T var3);

        abstract void customizerRemoved(S var1, R var2, T var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Tracked
    extends AbstractTracked<Bundle, T, BundleEvent>
    implements SynchronousBundleListener {
        Tracked() {
        }

        public void bundleChanged(BundleEvent event) {
            if (this.closed) {
                return;
            }
            Bundle bundle = event.getBundle();
            int state = bundle.getState();
            if ((state & BundleHookBundleTracker.this.mask) != 0) {
                this.track(bundle, event);
            } else {
                this.untrack(bundle, event);
            }
        }

        @Override
        T customizerAdding(Bundle item, BundleEvent related) {
            return BundleHookBundleTracker.this.customizer.addingBundle(item, related);
        }

        @Override
        void customizerModified(Bundle item, BundleEvent related, T object) {
            BundleHookBundleTracker.this.customizer.modifiedBundle(item, related, object);
        }

        @Override
        void customizerRemoved(Bundle item, BundleEvent related, T object) {
            BundleHookBundleTracker.this.customizer.removedBundle(item, related, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleEventHook
    implements EventHook {
        private Tracked tracked;

        private BundleEventHook(Tracked tracked) {
            this.tracked = tracked;
        }

        public void event(BundleEvent bundleEvent, Collection<BundleContext> bundleContexts) {
            this.tracked.bundleChanged(bundleEvent);
        }
    }
}

