/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.axis2.util.WSDL20Util;

public class URLTemplatingUtil {
    public static URL appendQueryParameters(MessageContext messageContext, URL url) throws AxisFault {
        String urlString = url.toString();
        String queryParameterSeparator = (String)messageContext.getProperty("whttp:queryParameterSeparator");
        if (queryParameterSeparator == null) {
            queryParameterSeparator = WSDL20DefaultValueHolder.getDefaultValue((String)"whttp:queryParameterSeparator");
        }
        OMElement firstElement = messageContext.getEnvelope().getBody().getFirstElement();
        String params = "";
        if (firstElement != null) {
            Iterator iter = firstElement.getChildElements();
            String legalCharacters = "-._~!$'()*,;=:@/?".replaceAll(queryParameterSeparator, "");
            while (iter.hasNext()) {
                OMElement element = (OMElement)iter.next();
                try {
                    params = params + URIEncoderDecoder.quoteIllegal(element.getLocalName(), legalCharacters) + "=" + URIEncoderDecoder.quoteIllegal(element.getText(), legalCharacters) + queryParameterSeparator;
                }
                catch (UnsupportedEncodingException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
        }
        if (!"".equals(params)) {
            int index = urlString.indexOf("?");
            urlString = index == -1 ? urlString + "?" + params.substring(0, params.length() - 1) : (index == urlString.length() - 1 ? urlString + params.substring(0, params.length() - 1) : urlString + queryParameterSeparator + params.substring(0, params.length() - 1));
            try {
                return new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        return url;
    }

    public static URL getTemplatedURL(URL targetURL, MessageContext messageContext, boolean detach) throws AxisFault {
        String httpLocation = (String)messageContext.getProperty("whttp:location");
        if (httpLocation != null) {
            String replacedQuery = httpLocation;
            int separator = httpLocation.indexOf(123);
            try {
                URI appendedURI;
                if (separator > -1) {
                    replacedQuery = URIEncoderDecoder.quoteIllegal(WSDL20Util.applyURITemplating((MessageContext)messageContext, (String)httpLocation, (boolean)detach), "-._~!$&()*,;=:@?/%");
                }
                if (replacedQuery.charAt(0) == '?') {
                    appendedURI = new URI(targetURL.toString() + replacedQuery);
                } else {
                    String uriString = targetURL.toString();
                    URI targetURI = !uriString.endsWith("/") ? new URI(uriString + "/") : new URI(uriString);
                    appendedURI = targetURI.resolve(replacedQuery);
                }
                targetURL = appendedURI.toURL();
            }
            catch (MalformedURLException e) {
                throw new AxisFault("An error occured while trying to create request URL");
            }
            catch (URISyntaxException e) {
                throw new AxisFault("An error occured while trying to create request URL");
            }
            catch (UnsupportedEncodingException e) {
                throw new AxisFault("An error occured while trying to create request URL");
            }
        }
        return targetURL;
    }
}

