/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.bval.util.reflection.Reflection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class XmlUtils {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final Logger log = Logger.getLogger(XmlUtils.class.getName());
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    XmlUtils() {
    }

    static Schema loadSchema(String resource) {
        URL schemaUrl = Reflection.getClassLoader(XmlUtils.class).getResource(resource);
        try {
            return SCHEMA_FACTORY.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.log(Level.WARNING, String.format("Unable to parse schema: %s", resource), e);
            return null;
        }
    }

    static Document parse(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(in);
    }

    static <T> T unmarshal(Document document, Schema schema, Class<T> type) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{type});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setSchema(schema);
        unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        JAXBElement root = unmarshaller.unmarshal((Node)document, type);
        return (T)root.getValue();
    }
}

